---
title: Release Notes - Podman Desktop 0.11
description: Podman Desktop 0.11 has been released!
slug: podman-desktop-release-0.11
authors: [slemeur]
tags: [podman-desktop, release, kubernetes]
hide_table_of_contents: false
---

import ReactPlayer from 'react-player'

This release note covers Podman Desktop 0.11 release changes.

- **Air-Gapped Installation**: New all-in-one binaries for air-gapped installation.
- **Feedback**: Submit feedback directly from Podman Desktop.
- **Docker Compatibility Mode**: Information about the Docker compatibility mode.
- **Proxy Setting**: Toggle on/off the proxy setting.
- **Deploy to Kubernetes**: Select the namespace to deploy to Kubernetes.
- **Registry Configuration**: Simplified registry configuration for well known registries.
- **UX/UI Improvements**: View pod's container logs, better visual feedback, configurable editor font size, and more.

Podman Desktop 0.11 is now available. [Click here to download it](/downloads)!

<!--truncate-->

---

## Release Details

### Air-Gapped installation [#1104](https://github.com/containers/podman-desktop/pull/1104) [#1120](https://github.com/containers/podman-desktop/pull/1120)

For users who are not able to connect to the internet, a new all-in-one (airgap) binary that includes the Podman Desktop application and the Podman binaries is now available for both Mac and Windows. When initializing a new Podman machine using all-in-one binaries, it'll use the embedded files and not grab them from internet:

- on Mac, it embeds the qemu FCOS binaries.
- on Windows, it embeds the WSL binary.

To differentiate the air-gapped binaries from the regular ones, you can check the artifactname, they're containing 'airgap' and are bigger.
Please note, that those binaries are available only on releases and not the pre-releases.

There is also an optional way to provide a custom Podman machine image in the create machine form. By providing the path to the image you want, Podman Desktop will create a machine with that image. Leaving the field empty will use the default image (the one included in the binary).

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/210508524-45005536-ac74-4074-92c1-2b3ca51d0073.mp4' width='100%' height='100%' />

### Feedback within Podman Desktop [#1078](https://github.com/containers/podman-desktop/pull/1078)

Submitting feedback on Podman Desktop is getting easier as it is possible directly within the tool. This will help to get more information about the issues you are facing and will help us to improve the tool.

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/208938878-948a2764-d73b-4584-a80d-497c052482c1.mp4' width='100%' height='100%' />

Please feel free to submit any feedback you have, we are looking forward to hearing from you!

### Docker compatibility mode [#1047](https://github.com/containers/podman-desktop/pull/1047)

The Docker compatibility mode is a feature that allows to use Podman as a drop-in replacement for Docker. It relies on the Docker socket helper provided with Podman and automatically handle the local setup of Podman path to the Docker socket. Tools like [Testcontainers](https://www.testcontainers.com/) or others are relying on this to communicate to the container engine.

In this new version of Podman Desktop, we are now providing information to the user about the status of this compatibility mode directly on the dashboard page. The way it works is the following:

- When Docker is running: the socket is pointing to Docker.
- When Podman is starting and Docker is not running: the docker API socket will use Podman.

In case the compatibility mode is not activated, new documentation on how to activate it and how to easily switch between Docker and Podman is available here: [https://podman-desktop.io/docs/migrating-from-docker](https://podman-desktop.io/docs/migrating-from-docker).

This is a warning displayed for Windows users:
![windows-docker-compatibility](https://user-images.githubusercontent.com/436777/209305744-9056addd-f122-4f75-9e03-ad27a0109375.png)

This is the warning for Mac users:
![mac-docker-compatibility](https://user-images.githubusercontent.com/6422176/207964861-a9c1f72c-89d6-4816-beab-397af4125620.png)

### Allow to toggle on/off the proxy setting [#983](https://github.com/containers/podman-desktop/pull/983)

In some context, users need the ability to disable and re-enable the proxy configuration very quickly, without having to entirely reconfigure it. This is now possible from the Podman Desktop settings page, where a toggle to enable/disable the proxy configuration has been added.

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/205955418-670bc37c-a74f-40ef-bc60-8d9d013aa0dc.mp4' width='100%' height='100%' />

Note: extensions can read this information and then update the proxy configuration.

### Namespace selection for deploy to Kubernetes [#1008](https://github.com/containers/podman-desktop/pull/1008)

A new dropdown menu has been added to the deploy to Kubernetes screen to allow selecting the namespace to deploy to. Defaults to defaultnamespace, if unable to get any from kube_client module.

If the user have set `kubectl config set-context --current --namespace=NAMESPACE` it honors that as the chosen value.

![deploy-kubernetes-namespace](https://user-images.githubusercontent.com/7339809/206688886-095e4f15-42ae-4a0a-b1c6-ae4b547fcdfb.gif)

### Configure Podman binary path [#941](https://github.com/containers/podman-desktop/pull/941)

Users might use a custom path to the podman binary. An option within settings (Settings -> Preferences) to allow providing an additional path to Podman binary has been added.
This is useful for users who have installed Podman using a package manager and want to use the binary provided by the package manager.
See: [Unable to set custom binary path for Podman on macOS](/docs/troubleshooting/troubleshooting-podman-on-macos#unable-to-set-custom-binary-path-for-podman-on-macos)
![custom-path](https://user-images.githubusercontent.com/6422176/204832063-5858065a-2fc3-49de-8d23-3b99b7d10dbf.png)

### Provide pre-defined registries [#1201](https://github.com/containers/podman-desktop/pull/1201)

The experience of configuring a registry is getting simplified for the most popular ones. The user will be able to select a registry from a pre-defined list and will only have to provide the username and password. The following registries will be pre-defined:

- Dockerhub
- Red Hat Quay
- GitHub
- IBM Container Registry
- Google Container Registry

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/6422176/214332937-eb1d9050-0d32-4bc4-8393-49b4583b1390.mov' width='100%' height='100%' />

### UI/UX Improvements

#### View Pods logs [#1122](https://github.com/containers/podman-desktop/pull/1122)

The pods details view provides the ability to view the logs of each containers that might be running in a pod. Moreover, as it can also be hard to scan and identify which container is producing which output, we appended the container name at the beginning of each output and differentiate each container with a different color.

![pods-logs](https://user-images.githubusercontent.com/6422176/211024673-eee9bad8-1b0c-4446-b8d1-97a226282c4d.png)

#### Improved feedback when clicking on container list action icons [#1150](https://github.com/containers/podman-desktop/pull/1150) [#1161](https://github.com/containers/podman-desktop/pull/1161)

When starting/stopping or deleting a container, a spinner is now displayed. In case of error, a message indicating that the action failed will also be better indicated.

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/211531610-2347d302-4918-46ae-a5a2-c80fac0314f5.mp4' width='100%' height='100%' />

For containers that exit immediately or short-lived containers, the feedback is also improved and include report of error now provide a better feedback to the user [#1161](https://github.com/containers/podman-desktop/pull/1161).

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/211831905-ebf596d5-efc8-4f55-8cb8-3f31655388b9.mp4' width='100%' height='100%' />

#### Allows to change the default font size for the editor [#1160](https://github.com/containers/podman-desktop/pull/1160)

An editor is used in several screens of Podman Desktop, from the inspect screen to container's outputs and Kubernetes YAML. The default font size is 10 pixels. It's now possible to adjust the font size to the one the one you prefer. This setting is persisted and will be used for all the editors of Podman Desktop and available from the preferences page (Settings -> Preferences).

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/211778161-130ff733-b2ca-4306-bea3-d031196c3b29.mp4' width='100%' height='100%' />

#### Keep expanded state of pods when refreshing containers [#1042](https://github.com/containers/podman-desktop/pull/1042)

When switching from different screens of the application or simply refreshing the list of containers, the expanded state of each item in the list is now persisted and will be properly restored.

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/207864147-b68ea9bd-0ca9-42dc-882e-b8a705233749.mp4' width='100%' height='100%' />

#### Click on the Pod name redirects to the Pod details page [#1159](https://github.com/containers/podman-desktop/pull/1159)

The list of containers also displays pods, now clicking on the pod name directly redirects to the Pod details page.

<ReactPlayer playing playsinline controls url='https://user-images.githubusercontent.com/436777/211770946-2255f39f-7e2e-48ad-9ead-bcbfe6a115a7.mp4' width='100%' height='100%' />

#### Improved styles of buttons for actions [#984](https://github.com/containers/podman-desktop/pull/984)

The style of the buttons for actions on item in the list of in details pages have been improved. The background has been removed, but to make the hover state more visible, the "hover" circle is visible and the icon's color is also changing.

On lists:
![list-actions](https://user-images.githubusercontent.com/6422176/205979121-b49a0ddf-03bb-4a4d-8d12-bc8d0bd52387.png)

On details pages:
![details-actions](https://user-images.githubusercontent.com/6422176/205979123-ea420b17-e834-4029-82eb-22949889eee9.png)

#### Improved alignments in pages with lists [#1182](https://github.com/containers/podman-desktop/pull/1182)

The alignment of the items in the list of containers and pods have been improved. The header of each columns are now aligned with the text. and the actions icons are now aligned with the top of the text.

![list-actions](https://user-images.githubusercontent.com/19958075/212712580-096fd090-0beb-40a4-8dc6-b3fdc5e81e35.png)

---

## Other Notable Enhancements

- Statistics area in container details are always shown. ([#1131](https://github.com/containers/podman-desktop/pull/1131))
- Add more descriptive wording and more information to extensions. ([#985](https://github.com/containers/podman-desktop/pull/985))
- Allow to install on-the fly Podman Desktop extensions using an OCI image. ([#1187](https://github.com/containers/podman-desktop/pull/1187))
- Display correctly non-multiplexed stream in logs (when using non interactive mode). ([#1197](https://github.com/containers/podman-desktop/pull/1197))
- Font changed from white to gray for non-name sections (creation date, size). ([#1206](https://github.com/containers/podman-desktop/pull/1206))
- Add Help/about menu for macOS/Windows/Linux. ([#1207](https://github.com/containers/podman-desktop/pull/1207))

---

## Documentation

Coming with this new version of Podman Desktop, the documentation has been getting attention (with number of editorial reviews) and new content have been added.

Content for helping users to migrate from Docker to Podman has been added:

- [Using the `podman-mac-helper` tool to migrate from Docker to Podman on macOS](https://github.com/containers/podman-desktop/pull/1088)
- [better identify podman-mac-helper verification steps](https://github.com/containers/podman-desktop/pull/1129)
- [Emulating Docker CLI using Podman to migrate from Docker to Podman](https://github.com/containers/podman-desktop/pull/1143)
- [Migrating from Docker section](https://github.com/containers/podman-desktop/pull/1146)
- [Verifying that your tools are using Podman](https://github.com/containers/podman-desktop/pull/1152)
- [Importing saved containers](https://github.com/containers/podman-desktop/pull/1144)

Several of other improvements have been made to the documentation and the website:

- [Troubleshooting for Apple Silicon and brew x86_64 installs](https://github.com/containers/podman-desktop/pull/962)
- [Change text of custom binary location, add docs](https://github.com/containers/podman-desktop/pull/972)
- [Silent install option for windows](https://github.com/containers/podman-desktop/pull/974)
- [Upgrade to vite v4 and rollup v3](https://github.com/containers/podman-desktop/pull/1079)
- [Refreshing documentation on installing on Linux](https://github.com/containers/podman-desktop/pull/1118)
- [Identify the shell sessions in Installing on Linux](https://github.com/containers/podman-desktop/pull/1130)
- [Website: the linux binary is not a source, it should be promoted as a binary](https://github.com/containers/podman-desktop/pull/1133)
- [Introducing tabs for operatings systems and container engines](https://github.com/containers/podman-desktop/pull/1162)
- [website: In the landing page, update plugins and container engines lists](https://github.com/containers/podman-desktop/pull/1165)
- [Document where code is located within Podman Desktop](https://github.com/containers/podman-desktop/pull/1163)
- [(extension-api): Documentation on how to write an extension and use the api](https://github.com/containers/podman-desktop/pull/1172)

---

## Notable bug fixes

- Update to v0.3.2 Docker Desktop API for extensions - [#1070](https://github.com/containers/podman-desktop/pull/1070)
- Updated link to the Matrix room - [#1076](https://github.com/containers/podman-desktop/pull/1076)
- Report error when container name already exists - [#1142](https://github.com/containers/podman-desktop/pull/1142)
- Fixed connectivity to the Podman machine when the generated socket length is greater than 104 characters in MacOS - [#1145](https://github.com/containers/podman-desktop/pull/1145)
- Do not use long calls for external clients - [#1151](https://github.com/containers/podman-desktop/pull/1151)
- Invalid name/tag for images with registries using a different port - [#1127](https://github.com/containers/podman-desktop/pull/1127)
- Invalid badge count for images when two images have the same tag - [#1124](https://github.com/containers/podman-desktop/pull/1124)
- Fixed detection of WSL2 - [#981](https://github.com/containers/podman-desktop/pull/981)
- Handle invalid kubeconfig files instead of crashing - [#953](https://github.com/containers/podman-desktop/pull/953)
- Removed redundant actions from details pages - [#1200](https://github.com/containers/podman-desktop/pull/1200)
- Fixed registry URL not aligned with header - [#1205](https://github.com/containers/podman-desktop/pull/1205)
- Moved SVGs to reusable components - [#1211](https://github.com/containers/podman-desktop/pull/1211)

**Extensions API has also been improved in this new release:**

- (extension-api): Allows to register a factory for kubernetes connection objects (like for container connections) - [#1040](https://github.com/containers/podman-desktop/pull/1040)
- (extension-api): List or inspect containers, be notified on events - [#1041](https://github.com/containers/podman-desktop/pull/1041)
- (extension-api): Allows to get provider notification - [#1045](https://github.com/containers/podman-desktop/pull/1045)
- (dd-extension-api): Implement toast API - [#1154](https://github.com/containers/podman-desktop/pull/1154)
- (extension-api): Moved extension properties to preferences - [#948](https://github.com/containers/podman-desktop/pull/948)
- (dd-extension-api): Added open dev console on dd webview in development mode - [#1071](https://github.com/containers/podman-desktop/pull/1071)
- (extension-api): Added notes on extension and frameworks/tooling of Podman Desktop - [#1166](https://github.com/containers/podman-desktop/pull/1166)
- (extension-api): Documentation on how to write an extension and use the api - [#1172](https://github.com/containers/podman-desktop/pull/1172)
- (dd-extension-api): DD extensions should see only minimal information on containers - [#1191](https://github.com/containers/podman-desktop/pull/1191)

---

## Community Thank You

🎉 We’d like to say a big thank you to everyone who helped to make Podman Desktop 0.11 even better:

- [Emmanuel Bernard](https://github.com/emmanuelbernard) in [#962 - Troubleshooting for Apple Silicon](https://github.com/containers/podman-desktop/pull/962)
- [Michael Prankl](https://github.com/eidottermihi) in [#974 - Silent install option for windows](https://github.com/containers/podman-desktop/pull/974)
- [Endre Lervik](https://github.com/elervik) in [#1008 - Namespace selection for deploy to kubernetes](https://github.com/containers/podman-desktop/pull/1008)
- [Evan FP](https://github.com/evanfpearson) in [#1145 - fixed socket path length error](https://github.com/containers/podman-desktop/pull/1145)
- [Lokesh Mandvekar](https://github.com/lsm5) in [#956 - add repository key to package.json](https://github.com/containers/podman-desktop/pull/956)
- [Jean François Maury](https://github.com/jeffmaury) in [#1194 - Cannot create Kind cluster on Windows](https://github.com/containers/podman-desktop/pull/1194)

## Final Notes

The complete list of issues fixed in this release is available [here](https://github.com/containers/podman-desktop/issues?q=is%3Aclosed+milestone%3A0.11.0).

Get the latest release from the [Downloads](/downloads) section of the website and boost your development journey with Podman Desktop. Additionally, visit the [GitHub repository](https://github.com/containers/podman-desktop) and see how you can help us make Podman Desktop better.
