/**********************************************************************
 * Copyright (C) 2023-2024 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ***********************************************************************/

import '@testing-library/jest-dom/vitest';

import { render, screen } from '@testing-library/svelte';
import { afterEach, beforeEach, expect, test, vi } from 'vitest';

import { imagesInfos } from '/@/stores/images';
import type { ImageInfo } from '/@api/image-info';

import ManifestDetails from './ManifestDetails.svelte';

const listImagesMock = vi.fn();
beforeEach(() => {
  imagesInfos.set([]);
  (window as any).listImages = listImagesMock;
  (window as any).listContainers = vi.fn();
});

afterEach(() => {
  vi.clearAllMocks();
});

test('It should render correctly with given image information', async () => {
  const imageID = '123456';
  const engineId = 'podman';
  const myImage = {
    engineId,
    Id: imageID,
    Size: 0,
  } as unknown as ImageInfo;
  imagesInfos.set([myImage]);
  listImagesMock.mockResolvedValue([myImage]);

  render(ManifestDetails, {
    imageID,
    engineId,
    base64RepoTag: Buffer.from('<none>', 'binary').toString('base64'),
  });

  // Expect summary to render correctly
  const summaryTab = screen.getByRole('link', { name: 'Summary' });
  expect(summaryTab).toBeInTheDocument();
});
