import shutil
from splat.segtypes.segment import Segment
from pathlib import Path
from splat.util import options
import re

import pylibyaml
import yaml as yaml_loader


CHARSET_COMMON = {
    0xF7: " ",
    0xF0: "[BR]\n",
    0xF1: "[Wait]",
    0xF2: {None: lambda d: (f"[Pause {d[0]}]", 1)},
    0xF3: "[Variant0]",
    0xF4: "[Variant1]",
    0xF5: "[Variant2]",
    0xF6: "[Variant3]",
    0xFB: "[Next]\n",
    0xFC: {
        0x01: "[Style right]\n",
        0x02: "[Style left]\n",
        0x03: "[Style center]\n",
        0x04: "[Style tattle]\n",
        0x05: {
            None: lambda d: (
                f"[Style choice pos={d[0]},{d[1]} size={d[2]},{d[3]}]\n",
                4,
            )
        },
        0x06: "[Style inspect]\n",
        0x07: "[Style sign]\n",
        0x08: {None: lambda d: (f"[Style lamppost height={d[0]}]\n", 1)},
        0x09: {None: lambda d: (f"[Style postcard index={d[0]}]\n", 1)},
        0x0A: "[Style popup]\n",
        0x0B: "[Style popup2]\n",
        0x0C: {
            None: lambda d: (
                f"[Style upgrade pos={d[0]},{d[1]} size={d[2]},{d[3]}]\n",
                4,
            )
        },
        0x0D: "[Style narrate]\n",
        0x0E: "[Style epilogue]\n",
    },
    0xFF: {
        0x00: {
            0: "[Font standard]\n",
            1: "[Font menu]\n",
            2: "[Font menu2]\n",
            3: "[Font title]\n",
            4: "[Font subtitle]\n",
        },
        0x04: "[Yield]",
        0x05: {
            # 0x0A: "[color:normal]",
            # 0x20: "[color:red]",
            # 0x21: "[color:pink]",
            # 0x22: "[color:purple]",
            # 0x23: "[color:blue]",
            # 0x24: "[color:cyan]",
            # 0x25: "[color:green]",
            # 0x26: "[color:yellow]",
            # 0x00: "[color=normal ctx=diary]",
            # 0x07: "[color=red ctx=diary]",
            # 0x17: "[color=dark ctx=inspect]",
            # 0x18: "[color=normal ctx=sign]",
            # 0x19: "[color=red ctx=sign]",
            # 0x1A: "[color=blue ctx=sign]",
            # 0x1B: "[color=green ctx=sign]",
            # 0x28: "[color=red ctx=popup]",
            # 0x29: "[color=pink ctx=popup]",
            # 0x2A: "[color=purple ctx=popup]",
            # 0x2B: "[color=blue ctx=popup]",
            # 0x2C: "[color=teal ctx=popup]",
            # 0x2D: "[color=green ctx=popup]",
            # 0x2E: "[color=yellow ctx=popup]",
            # 0x2F: "[color=normal ctx=popup]",
            None: lambda d: (f"[Color 0x{d[0]:X}]", 1),
        },
        0x07: "[InputOff]\n",
        0x08: "[InputOn]\n",
        0x09: "[DelayOff]\n",
        0x0A: "[DelayOn]\n",
        0x0B: {None: lambda d: (f"[CharWidth {d[0]}]", 1)},
        0x0C: {None: lambda d: (f"[Scroll {d[0]}]", 1)},
        0x0D: {None: lambda d: (f"[Size {d[0]},{d[1]}]\n", 2)},
        0x0E: "[SizeReset]\n",
        0x0F: {None: lambda d: (f"[Speed delay={d[0]} chars={d[1]}]", 2)},
        0x10: {None: lambda d: (f"[SetPosX {(d[0] << 8) + d[1]}]", 2)},
        0x11: {None: lambda d: (f"[SetPosY {d[0]}]", 1)},
        0x12: {None: lambda d: (f"[Right {d[0]}]", 1)},
        0x13: {None: lambda d: (f"[Down {d[0]}]", 1)},
        0x14: {None: lambda d: (f"[Up {d[0]}]", 1)},
        0x15: {None: lambda d: (f"[InlineImage index={d[0]}]\n", 1)},
        0x16: {
            None: lambda d: (
                f"[AnimSprite spriteID=0x{d[0]:02X}{d[1]:02X} raster={d[2]}]\n",
                3,
            )
        },
        0x17: {None: lambda d: (f"[ItemIcon itemID=0x{d[0]:02X}{d[1]:02X}]\n", 2)},
        0x18: {
            None: lambda d: (
                f"[Image index={d[0]} pos={(d[1] << 8) + d[2]},{d[3]} hasBorder={d[4]} alpha={d[5]} fadeAmount={d[6]}]\n",
                7,
            )
        },
        0x19: {None: lambda d: (f"[HideImage fadeAmount={d[0]}]\n", 1)},
        0x1A: {None: lambda d: (f"[AnimDelay index={d[1]} delay={d[2]}]", 3)},
        0x1B: {None: lambda d: (f"[AnimLoop {d[0]} {d[1]}]", 2)},
        0x1C: {None: lambda d: (f"[AnimDone {d[0]}]", 1)},
        0x1E: {None: lambda d: (f"[Cursor {d[0]}]", 1)},
        0x1F: {None: lambda d: (f"[EndChoice {d[0]}]", 1)},
        0x20: {None: lambda d: (f"[SetCancel {d[0]}]", 1)},
        0x21: {None: lambda d: (f"[Option {d[0]}]", 1)},
        0x22: "[SavePos]",
        0x23: "[RestorePos]",
        0x24: {
            0xFF: {
                0x05: {
                    0x10: {0x98: {0xFF: {0x25: "[A]"}}},
                    0x11: {0x99: {0xFF: {0x25: "[B]"}}},
                    0x12: {0xA1: {0xFF: {0x25: "[START]"}}},
                    0x13: {
                        0x9D: {0xFF: {0x25: "[C-UP]"}},
                        0x9E: {0xFF: {0x25: "[C-DOWN]"}},
                        0x9F: {0xFF: {0x25: "[C-LEFT]"}},
                        0xA0: {0xFF: {0x25: "[C-RIGHT]"}},
                    },
                    0x14: {0x9C: {0xFF: {0x25: "[Z]"}}},
                }
            }
        },
        # 0x24: "[SaveColor]",
        # 0x25: "[RestoreColor]",
        0x26: {
            0x00: "[Shake]",
            0x01: "[Wave]",
            0x02: "[NoiseOutline]",
            0x03: {None: lambda d: (f"[Static {d[0]}]", 1)},
            0x05: {None: lambda d: (f"[Blur dir={['x', 'y', 'xy'][d[0]]}]", 1)},
            0x07: {None: lambda d: (f"[DitherFade {d[0]}]", 1)},
            0x0A: "[PrintRising]",
            0x0B: "[PrintGrowing]",
            0x0C: "[SizeJitter]",
            0x0D: "[SizeWave]",
            0x0E: "[DropShadow]",
        },
        0x27: {
            0x00: "[/Shake]",
            0x01: "[/Wave]",
            0x03: "[/Static]",
            0x05: "[/Blur]",
            0x07: "[/DitherFade]",
            0x0A: "[/PrintRising]",
            0x0B: "[/PrintGrowing]",
            0x0C: "[/SizeJitter]",
            0x0D: "[/SizeWave]",
            0x0E: "[/DropShadow]",
        },
        0x28: {None: lambda d: (f"[Var {d[0]}]", 1)},
        0x29: {None: lambda d: (f"[CenterX {d[0]}]", 1)},
        0x2B: "[EnableCDownNext]",
        0x2C: {
            None: lambda d: (
                f"[CustomVoice soundIDs=0x{d[0]:02X}{d[1]:02X}{d[2]:02X}{d[3]:02X},0x{d[4]:02X}{d[5]:02X}{d[6]:02X}{d[7]:02X}]",
                8,
            )
        },
        0x2E: {None: lambda d: (f"[Volume {d[0]}]", 1)},
        0x2F: {
            0: "[Voice normal]\n",
            1: "[Voice bowser]\n",
            2: "[Voice star]\n",
            None: lambda d: (f"[Voice {d[0]}]\n", 1),
        },
        # None: lambda d: (f"[func_{d[0]:02X}]", 1),
    },
    None: lambda d: (f"[Raw 0x{d[0]:02X}]", 1),
}

CHARSET_STANDARD = {
    **CHARSET_COMMON,
    0x00: "[NOTE]",
    0x01: "!",
    0x02: '"',
    0x03: "#",
    0x04: "$",
    0x05: "%",
    0x06: "&",
    0x07: "'",
    0x08: "(",
    0x09: ")",
    0x0A: "*",
    0x0B: "+",
    0x0C: ",",
    0x0D: "-",
    0x0E: ".",
    0x0F: "/",
    0x10: "0",
    0x11: "1",
    0x12: "2",
    0x13: "3",
    0x14: "4",
    0x15: "5",
    0x16: "6",
    0x17: "7",
    0x18: "8",
    0x19: "9",
    0x1A: ":",
    0x1B: ";",
    0x1C: "<",
    0x1D: "=",
    0x1E: ">",
    0x1F: "?",
    0x20: "@",
    0x21: "A",
    0x22: "B",
    0x23: "C",
    0x24: "D",
    0x25: "E",
    0x26: "F",
    0x27: "G",
    0x28: "H",
    0x29: "I",
    0x2A: "J",
    0x2B: "K",
    0x2C: "L",
    0x2D: "M",
    0x2E: "N",
    0x2F: "O",
    0x30: "P",
    0x31: "Q",
    0x32: "R",
    0x33: "S",
    0x34: "T",
    0x35: "U",
    0x36: "V",
    0x37: "W",
    0x38: "X",
    0x39: "Y",
    0x3A: "Z",
    0x3B: "\\[",
    0x3C: "¥",
    0x3D: "]",
    0x3E: "^",
    0x3F: "_",
    0x40: "`",
    0x41: "a",
    0x42: "b",
    0x43: "c",
    0x44: "d",
    0x45: "e",
    0x46: "f",
    0x47: "g",
    0x48: "h",
    0x49: "i",
    0x4A: "j",
    0x4B: "k",
    0x4C: "l",
    0x4D: "m",
    0x4E: "n",
    0x4F: "o",
    0x50: "p",
    0x51: "q",
    0x52: "r",
    0x53: "s",
    0x54: "t",
    0x55: "u",
    0x56: "v",
    0x57: "w",
    0x58: "x",
    0x59: "y",
    0x5A: "z",
    0x5B: "{",
    0x5C: "|",
    0x5D: "}",
    0x5E: "~",
    0x5F: "°",
    0x60: "À",
    0x61: "Á",
    0x62: "Â",
    0x63: "Ä",
    0x64: "Ç",
    0x65: "È",
    0x66: "É",
    0x67: "Ê",
    0x68: "Ë",
    0x69: "Ì",
    0x6A: "Í",
    0x6B: "Î",
    0x6C: "Ï",
    0x6D: "Ñ",
    0x6E: "Ò",
    0x6F: "Ó",
    0x70: "Ô",
    0x71: "Ö",
    0x72: "Ù",
    0x73: "Ú",
    0x74: "Û",
    0x75: "Ü",
    0x76: "ß",
    0x77: "à",
    0x78: "á",
    0x79: "â",
    0x7A: "ä",
    0x7B: "ç",
    0x7C: "è",
    0x7D: "é",
    0x7E: "ê",
    0x7F: "ë",
    0x80: "ì",
    0x81: "í",
    0x82: "î",
    0x83: "ï",
    0x84: "ñ",
    0x85: "ò",
    0x86: "ó",
    0x87: "ô",
    0x88: "ö",
    0x89: "ù",
    0x8A: "ú",
    0x8B: "û",
    0x8C: "ü",
    0x8D: "¡",
    0x8E: "¿",
    0x8F: "ª",
    0x90: "[HEART]",
    0x91: "[STAR]",
    0x92: "[UP]",
    0x93: "[DOWN]",
    0x94: "[LEFT]",
    0x95: "[RIGHT]",
    0x96: "[CIRCLE]",
    0x97: "[CROSS]",
    0x98: "[~A]",
    0x99: "[~B]",
    0x9A: "[~L]",
    0x9B: "[~R]",
    0x9C: "[~Z]",
    0x9D: "[~C-UP]",
    0x9E: "[~C-DOWN]",
    0x9F: "[~C-LEFT]",
    0xA0: "[~C-RIGHT]",
    0xA1: "[~START]",
    0xA2: "“",
    0xA3: "”",
    0xA4: "‘",
    0xA5: "’",
}

CHARSET_CREDITS = {
    **CHARSET_COMMON,
    0x00: "A",
    0x01: "B",
    0x02: "C",
    0x03: "D",
    0x04: "E",
    0x05: "F",
    0x06: "G",
    0x07: "H",
    0x08: "I",
    0x09: "J",
    0x0A: "K",
    0x0B: "L",
    0x0C: "M",
    0x0D: "N",
    0x0E: "O",
    0x0F: "P",
    0x10: "Q",
    0x11: "R",
    0x12: "S",
    0x13: "T",
    0x14: "U",
    0x15: "V",
    0x16: "W",
    0x17: "X",
    0x18: "Y",
    0x19: "Z",
    0x1A: "'",
    0x1B: ".",
    0x1C: ",",
    0x1D: "0",
    0x1E: "1",
    0x1F: "2",
    0x20: "3",
    0x21: "4",
    0x22: "5",
    0x23: "6",
    0x24: "7",
    0x25: "8",
    0x26: "9",
    0x27: "©",
    0x28: "&",
}

CHARSET_JP_COMMON = {
    **CHARSET_COMMON,
    0xF3: "[Charset Kana]",
    0xF4: "[Charset Latin]",
    0xF5: "[Charset Kanji]",
    0xF6: "[Charset Buttons]",
    0xF7: " ",
    0xF8: "　",
    0xF9: "[HALFSPACE]",
    0xFF: {
        **CHARSET_COMMON[0xFF],
        0x24: {
            0xFF: {
                0x05: {
                    0x10: {0xF6: {0x00: {0xFF: {0x25: "[A]"}}}},
                    0x11: {0xF6: {0x01: {0xFF: {0x25: "[B]"}}}},
                    0x12: {0xF6: {0x02: {0xFF: {0x25: "[START]"}}}},
                    0x13: {
                        0xF6: {
                            0x03: {0xFF: {0x25: "[C-UP]"}},
                            0x04: {0xFF: {0x25: "[C-DOWN]"}},
                            0x05: {0xFF: {0x25: "[C-LEFT]"}},
                            0x06: {0xFF: {0x25: "[C-RIGHT]"}},
                        }
                    },
                    0x14: {
                        0xF6: {
                            0x07: {0xFF: {0x25: "[Z]"}},
                            0x08: {0xFF: {0x25: "[L]"}},
                            0x09: {0xFF: {0x25: "[R]"}},
                        }
                    },
                }
            }
        },
    },
}

CHARSET_KANA = {
    **CHARSET_JP_COMMON,
    0x00: "あ",
    0x01: "い",
    0x02: "う",
    0x03: "え",
    0x04: "お",
    0x05: "か",
    0x06: "き",
    0x07: "く",
    0x08: "け",
    0x09: "こ",
    0x0A: "さ",
    0x0B: "し",
    0x0C: "す",
    0x0D: "せ",
    0x0E: "そ",
    0x0F: "た",
    0x10: "ち",
    0x11: "つ",
    0x12: "て",
    0x13: "と",
    0x14: "な",
    0x15: "に",
    0x16: "ぬ",
    0x17: "ね",
    0x18: "の",
    0x19: "は",
    0x1A: "ひ",
    0x1B: "ふ",
    0x1C: "へ",
    0x1D: "ほ",
    0x1E: "ま",
    0x1F: "み",
    0x20: "む",
    0x21: "め",
    0x22: "も",
    0x23: "や",
    0x24: "ゆ",
    0x25: "よ",
    0x26: "ら",
    0x27: "り",
    0x28: "る",
    0x29: "れ",
    0x2A: "ろ",
    0x2B: "わ",
    0x2C: "を",
    0x2D: "ん",
    0x2E: "ゔ",
    0x2F: "が",
    0x30: "ぎ",
    0x31: "ぐ",
    0x32: "げ",
    0x33: "ご",
    0x34: "ざ",
    0x35: "じ",
    0x36: "ず",
    0x37: "ぜ",
    0x38: "ぞ",
    0x39: "だ",
    0x3A: "ぢ",
    0x3B: "づ",
    0x3C: "で",
    0x3D: "ど",
    0x3E: "ば",
    0x3F: "び",
    0x40: "ぶ",
    0x41: "べ",
    0x42: "ぼ",
    0x43: "ぱ",
    0x44: "ぴ",
    0x45: "ぷ",
    0x46: "ぺ",
    0x47: "ぽ",
    0x48: "ぁ",
    0x49: "ぃ",
    0x4A: "ぅ",
    0x4B: "ぇ",
    0x4C: "ぉ",
    0x4D: "っ",
    0x4E: "ゃ",
    0x4F: "ゅ",
    0x50: "ょ",
    0x51: "ア",
    0x52: "イ",
    0x53: "ウ",
    0x54: "エ",
    0x55: "オ",
    0x56: "カ",
    0x57: "キ",
    0x58: "ク",
    0x59: "ケ",
    0x5A: "コ",
    0x5B: "サ",
    0x5C: "シ",
    0x5D: "ス",
    0x5E: "セ",
    0x5F: "ソ",
    0x60: "タ",
    0x61: "チ",
    0x62: "ツ",
    0x63: "テ",
    0x64: "ト",
    0x65: "ナ",
    0x66: "ニ",
    0x67: "ヌ",
    0x68: "ネ",
    0x69: "ノ",
    0x6A: "ハ",
    0x6B: "ヒ",
    0x6C: "フ",
    0x6D: "ヘ",
    0x6E: "ホ",
    0x6F: "マ",
    0x70: "ミ",
    0x71: "ム",
    0x72: "メ",
    0x73: "モ",
    0x74: "ヤ",
    0x75: "ユ",
    0x76: "ヨ",
    0x77: "ラ",
    0x78: "リ",
    0x79: "ル",
    0x7A: "レ",
    0x7B: "ロ",
    0x7C: "ワ",
    0x7D: "ヲ",
    0x7E: "ン",
    0x7F: "ヴ",
    0x80: "ガ",
    0x81: "ギ",
    0x82: "グ",
    0x83: "ゲ",
    0x84: "ゴ",
    0x85: "ザ",
    0x86: "ジ",
    0x87: "ズ",
    0x88: "ゼ",
    0x89: "ゾ",
    0x8A: "ダ",
    0x8B: "ヂ",
    0x8C: "ヅ",
    0x8D: "デ",
    0x8E: "ド",
    0x8F: "バ",
    0x90: "ビ",
    0x91: "ブ",
    0x92: "ベ",
    0x93: "ボ",
    0x94: "パ",
    0x95: "ピ",
    0x96: "プ",
    0x97: "ペ",
    0x98: "ポ",
    0x99: "ァ",
    0x9A: "ィ",
    0x9B: "ゥ",
    0x9C: "ェ",
    0x9D: "ォ",
    0x9E: "ッ",
    0x9F: "ャ",
    0xA0: "ュ",
    0xA1: "ョ",
    0xA2: "ー",
    0xA3: "～",
    0xA4: {0xA5: {0xA6: "[LONGDASH]"}},
    0xA7: "０",
    0xA8: "１",
    0xA9: "２",
    0xAA: "３",
    0xAB: "４",
    0xAC: "５",
    0xAD: "６",
    0xAE: "７",
    0xAF: "８",
    0xB0: "９",
    0xB1: "[UP]",
    0xB2: "[DOWN]",
    0xB3: "[LEFT]",
    0xB4: "[RIGHT]",
    0xB5: "！",
    0xB6: "？",
    0xB7: "＋",
    0xB8: "－",
    0xB9: "／",
    0xBA: "．",
    0xBB: "＆",
    0xBC: "＃",
    0xBD: "[HEART]",
    0xBE: "[STAR]",
    0xBF: "（",
    0xC0: "）",
    0xC1: "『",
    0xC2: "』",
    0xC3: "・",
    0xC4: "[HIRAGANA SmallN]",
    0xC5: "[KATAKANA SmallN]",
    # existing characters without small counterparts
    # 0xC4: "ん",
    # 0xC5: "ン",
    0xC6: "星",
    # 0xC7 is unused
}

CHARSET_LATIN = {
    **CHARSET_JP_COMMON,
    0x00: "Ａ",
    0x01: "Ｂ",
    0x02: "Ｃ",
    0x03: "Ｄ",
    0x04: "Ｅ",
    0x05: "Ｆ",
    0x06: "Ｇ",
    0x07: "Ｈ",
    0x08: "Ｉ",
    0x09: "Ｊ",
    0x0A: "Ｋ",
    0x0B: "Ｌ",
    0x0C: "Ｍ",
    0x0D: "Ｎ",
    0x0E: "Ｏ",
    0x0F: "Ｐ",
    0x10: "Ｑ",
    0x11: "Ｒ",
    0x12: "Ｓ",
    0x13: "Ｔ",
    0x14: "Ｕ",
    0x15: "Ｖ",
    0x16: "Ｗ",
    0x17: "Ｘ",
    0x18: "Ｙ",
    0x19: "Ｚ",
    0x1A: "ｚ",
}

CHARSET_KANJI = {
    **CHARSET_JP_COMMON,
    0x00: "上",
    0x01: "下",
    0x02: "左",
    0x03: "右",
    0x04: "中",
    0x05: "東",
    0x06: "西",
    0x07: "南",
    0x08: "北",
    0x09: "一",
    0x0A: "二",
    0x0B: "三",
    0x0C: "名",
    0x0D: "国",
    0x0E: "城",
    0x0F: "姫",
    0x10: "大",
    0x11: "王",
    0x12: "花",
    0x13: "世",
    0x14: "界",
    0x15: "草",
    0x16: "気",
    0x17: "間",
    0x18: "門",
    0x19: "家",
    0x1A: "地",
    0x1B: "岩",
    0x1C: "駅",
    0x1D: "山",
    0x1E: "海",
    0x1F: "火",
    0x20: "水",
    0x21: "氷",
    0x22: "日",
    0x23: "根",
    0x24: "雲",
    0x25: "口",
    0x26: "原",
    0x27: "前",
    0x28: "店",
    0x29: "天",
    0x2A: "森",
    0x2B: "木",
    0x2C: "力",
    0x2D: "空",
    0x2E: "人",
    0x2F: "島",
    0x30: "出",
    0x31: "入",
    0x32: "本",
    0x33: "石",
    0x34: "村",
    0x35: "休",
    0x36: "先",
    0x37: "見",
    0x38: "近",
    0x39: "方",
    0x3A: "法",
    0x3B: "手",
    0x3C: "紙",
    0x3D: "引",
    0x3E: "場",
    0x3F: "所",
    0x40: "使",
    0x41: "回",
    0x42: "道",
    0x43: "物",
    0x44: "弟",
    0x45: "子",
    0x46: "汽",
    0x47: "車",
    0x48: "何",
    0x49: "黒",
    0x4A: "分",
    0x4B: "時",
    0x4C: "屋",
    0x4D: "音",
    0x4E: "目",
    0x4F: "行",
    0x50: "絵",
    0x51: "月",
    0x52: "野",
    0x53: "外",
    0x54: "図",
    0x55: "部",
    0x56: "小",
    0x57: "風",
    0x58: "魔",
    0x59: "元",
    0x5A: "太",
    0x5B: "陽",
    0x5C: "実",
    0x5D: "赤",
    0x5E: "雪",
    0x5F: "谷",
    0x60: "通",
    0x61: "[CIRCLE]",
    0x62: "[CROSS]",
    0x63: "長",
    0x64: "話",
    0x65: "色",
    0x66: "光",
    0x67: "合",
    0x68: "青",
    0x69: "黄",
    0x6A: "[NOTE]",
    0x6B: "当",
    0x6C: "数",
    0x6D: "兄",
    0x6E: "用",
    0x6F: "心",
    0x70: "今",
    0x71: "正",
    0x72: "直",
    0x73: "全",
    0x74: "体",
    0x75: "夜",
    0x76: "面",
    0x77: "虫",
    0x78: "ｘ",
}

CHARSET_BUTTONS = {
    **CHARSET_JP_COMMON,
    0x00: "[~A]",
    0x01: "[~B]",
    0x02: "[~START]",
    0x03: "[~C-UP]",
    0x04: "[~C-DOWN]",
    0x05: "[~C-LEFT]",
    0x06: "[~C-RIGHT]",
    0x07: "[~Z]",
    0x08: "[~L]",
    0x09: "[~R]",
}
CHARSET_IQUE = {
    **CHARSET_COMMON,
    0x5F: {
        0x01: "栗",
        0x02: "萨",
        0x03: "带",
        0x04: "块",
        0x05: "珍",
        0x06: "美",
        0x07: "啧",
        0x08: "荣",
        0x09: "吗",
        0x0A: "前",
        0x0B: "破",
        0x0C: "孙",
        0x0D: "因",
        0x0E: "激",
        0x0F: "曾",
        0x10: "震",
        0x11: "芒",
        0x12: "峰",
        0x13: "略",
        0x14: "居",
        0x15: "课",
        0x16: "父",
        0x17: "扑",
        0x18: "数",
        0x19: "腻",
        0x1A: "吸",
        0x1B: "化",
        0x1C: "死",
        0x1D: "逸",
        0x1E: "婪",
        0x1F: "售",
        0x20: "采",
        0x21: "质",
        0x22: "积",
        0x23: "窄",
        0x24: "徘",
        0x25: "睦",
        0x26: "悉",
        0x27: "骂",
        0x28: "践",
        0x29: "益",
        0x2A: "魄",
        0x2B: "侧",
        0x2C: "辖",
        0x2D: "酱",
        0x2E: "咐",
        0x2F: "剔",
        0x30: "妇",
        0x31: "掀",
    },
    0x60: {
        0x01: "子",
        0x02: "秃",
        0x03: "长",
        0x04: "埃",
        0x05: "贵",
        0x06: "光",
        0x07: "嗯",
        0x08: "幸",
        0x09: "倒",
        0x0A: "探",
        0x0B: "坏",
        0x0C: "进",
        0x0D: "此",
        0x0E: "动",
        0x0F: "害",
        0x10: "危",
        0x11: "强",
        0x12: "雷",
        0x13: "玻",
        0x14: "企",
        0x15: "程",
        0x16: "贝",
        0x17: "鼻",
        0x18: "声",
        0x19: "莓",
        0x1A: "盾",
        0x1B: "汽",
        0x1C: "衰",
        0x1D: "魁",
        0x1E: "率",
        0x1F: "广",
        0x20: "捉",
        0x21: "埋",
        0x22: "鸦",
        0x23: "仆",
        0x24: "徊",
        0x25: "脾",
        0x26: "含",
        0x27: "蔼",
        0x28: "艳",
        0x29: "阵",
        0x2A: "宜",
        0x2B: "罕",
        0x2C: "肚",
        0x2D: "娱",
        0x2E: "妄",
        0x2F: "栅",
        0x30: "郑",
        0x31: "兼",
    },
    0x61: {
        0x01: "小",
        0x02: "鹫",
        0x03: "矛",
        0x04: "莫",
        0x05: "的",
        0x06: "就",
        0x07: "好",
        0x08: "某",
        0x09: "提",
        0x0A: "十",
        0x0B: "果",
        0x0C: "疑",
        0x0D: "忙",
        0x0E: "及",
        0x0F: "怕",
        0x10: "使",
        0x11: "烈",
        0x12: "沙",
        0x13: "尼",
        0x14: "鹅",
        0x15: "晚",
        0x16: "胆",
        0x17: "坚",
        0x18: "警",
        0x19: "搅",
        0x1A: "避",
        0x1B: "脸",
        0x1C: "淘",
        0x1D: "梧",
        0x1E: "幅",
        0x1F: "温",
        0x20: "占",
        0x21: "喝",
        0x22: "叉",
        0x23: "搞",
        0x24: "务",
        0x25: "挤",
        0x26: "欲",
        0x27: "骚",
        0x28: "驴",
        0x29: "刷",
        0x2A: "赫",
        0x2B: "刮",
        0x2C: "勃",
        0x2D: "卧",
        0x2E: "堕",
        0x2F: "睹",
        0x30: "综",
        0x31: "瞧",
    },
    0x62: {
        0x01: "刺",
        0x02: "哥",
        0x03: "毒",
        0x04: "斯",
        0x05: "星",
        0x06: "是",
        0x07: "任",
        0x08: "受",
        0x09: "醒",
        0x0A: "分",
        0x0B: "村",
        0x0C: "问",
        0x0D: "闻",
        0x0E: "迎",
        0x0F: "肯",
        0x10: "伦",
        0x11: "拥",
        0x12: "漠",
        0x13: "拓",
        0x14: "格",
        0x15: "愚",
        0x16: "接",
        0x17: "叶",
        0x18: "型",
        0x19: "拌",
        0x1A: "钧",
        0x1B: "类",
        0x1C: "捣",
        0x1D: "捡",
        0x1E: "伏",
        0x1F: "暖",
        0x20: "座",
        0x21: "肤",
        0x22: "轨",
        0x23: "右",
        0x24: "悠",
        0x25: "社",
        0x26: "圣",
        0x27: "拔",
        0x28: "犟",
        0x29: "梳",
        0x2A: "诱",
        0x2B: "池",
        0x2C: "卓",
        0x2D: "框",
        0x2E: "君",
        0x2F: "敛",
        0x30: "嫌",
        0x31: "斤",
    },
    0x63: {
        0x01: "头",
        0x02: "哈",
        0x03: "壳",
        0x04: "枯",
        0x05: "杖",
        0x06: "对",
        0x07: "何",
        0x08: "尊",
        0x09: "跟",
        0x0A: "耶",
        0x0B: "英",
        0x0C: "赛",
        0x0D: "各",
        0x0E: "渴",
        0x0F: "莉",
        0x10: "绑",
        0x11: "繁",
        0x12: "置",
        0x13: "莱",
        0x14: "细",
        0x15: "蠢",
        0x16: "剩",
        0x17: "深",
        0x18: "饰",
        0x19: "拿",
        0x1A: "良",
        0x1B: "扔",
        0x1C: "跺",
        0x1D: "嘴",
        0x1E: "坑",
        0x1F: "遭",
        0x20: "桥",
        0x21: "祖",
        0x22: "承",
        0x23: "膝",
        0x24: "赋",
        0x25: "怂",
        0x26: "凋",
        0x27: "详",
        0x28: "沟",
        0x29: "撤",
        0x2A: "攥",
        0x2B: "绳",
        0x2C: "枕",
        0x2D: "插",
        0x2E: "絞",
        0x2F: "萌",
        0x30: "亡",
        0x31: "撑",
    },
    0x64: {
        0x01: "飞",
        0x02: "金",
        0x03: "炎",
        0x04: "骨",
        0x05: "从",
        0x06: "真",
        0x07: "言",
        0x08: "敬",
        0x09: "起",
        0x0A: "交",
        0x0B: "雄",
        0x0C: "只",
        0x0D: "邪",
        0x0E: "秘",
        0x0F: "波",
        0x10: "架",
        0x11: "衷",
        0x12: "烹",
        0x13: "咒",
        0x14: "侵",
        0x15: "称",
        0x16: "余",
        0x17: "稀",
        0x18: "古",
        0x19: "洗",
        0x1A: "Ａ",
        0x1B: "式",
        0x1C: "脚",
        0x1D: "吐",
        0x1E: "建",
        0x1F: "袭",
        0x20: "修",
        0x21: "胃",
        0x22: "钮",
        0x23: "富",
        0x24: "倔",
        0x25: "恿",
        0x26: "零",
        0x27: "支",
        0x28: "岔",
        0x29: "悚",
        0x2A: "赊",
        0x2B: "枝",
        0x2C: "绅",
        0x2D: "讶",
        0x2E: "晬",
        0x2F: "绍",
        0x30: "讯",
        0x31: "订",
    },
    0x65: {
        0x01: "行",
        0x02: "面",
        0x03: "芽",
        0x04: "魔",
        0x05: "底",
        0x06: "打",
        0x07: "语",
        0x08: "家",
        0x09: "些",
        0x0A: "完",
        0x0B: "顺",
        0x0C: "玩",
        0x0D: "恶",
        0x0E: "凡",
        0x0F: "园",
        0x10: "迹",
        0x11: "题",
        0x12: "饪",
        0x13: "糕",
        0x14: "守",
        0x15: "奖",
        0x16: "抗",
        0x17: "烤",
        0x18: "娃",
        0x19: "餐",
        0x1A: "Ｄ",
        0x1B: "射",
        0x1C: "碍",
        0x1D: "棍",
        0x1E: "议",
        0x1F: "闹",
        0x20: "晴",
        0x21: "狗",
        0x22: "伸",
        0x23: "堂",
        0x24: "执",
        0x25: "途",
        0x26: "争",
        0x27: "伫",
        0x28: "脉",
        0x29: "轰",
        0x2A: "憾",
        0x2B: "茂",
        0x2C: "咆",
        0x2D: "钉",
        0x2E: "痕",
        0x2F: "屑",
        0x30: "咽",
        0x31: "驯",
    },
    0x66: {
        0x01: "红",
        0x02: "龟",
        0x03: "钳",
        0x04: "法",
        0x05: "里",
        0x06: "败",
        0x07: "无",
        0x08: "梦",
        0x09: "伙",
        0x0A: "全",
        0x0B: "消",
        0x0C: "笑",
        0x0D: "忧",
        0x0E: "智",
        0x0F: "越",
        0x10: "恩",
        0x11: "宇",
        0x12: "凯",
        0x13: "幽",
        0x14: "据",
        0x15: "励",
        0x16: "持",
        0x17: "源",
        0x18: "罐",
        0x19: "清",
        0x1A: "Ｂ",
        0x1B: "断",
        0x1C: "备",
        0x1D: "仿",
        0x1E: "赴",
        0x1F: "供",
        0x20: "朗",
        0x21: "般",
        0x22: "五",
        0x23: "璃",
        0x24: "髦",
        0x25: "疏",
        0x26: "逗",
        0x27: "猖",
        0x28: "掘",
        0x29: "释",
        0x2A: "巅",
        0x2B: "坪",
        0x2C: "哮",
        0x2D: "贺",
        0x2E: "锢",
        0x2F: "咂",
        0x30: "唐",
        0x31: "堪",
    },
    0x67: {
        0x01: "色",
        0x02: "汪",
        0x03: "朱",
        0x04: "卫",
        0x05: "感",
        0x06: "狠",
        0x07: "表",
        0x08: "朋",
        0x09: "伴",
        0x0A: "解",
        0x0B: "息",
        0x0C: "尽",
        0x0D: "虑",
        0x0E: "慧",
        0x0F: "愉",
        0x10: "客",
        0x11: "碎",
        0x12: "茜",
        0x13: "床",
        0x14: "或",
        0x15: "厉",
        0x16: "焦",
        0x17: "汁",
        0x18: "月",
        0x19: "洁",
        0x1A: "Ｅ",
        0x1B: "突",
        0x1C: "武",
        0x1D: "替",
        0x1E: "磋",
        0x1F: "妈",
        0x20: "據",
        0x21: "窝",
        0x22: "宽",
        0x23: "闭",
        0x24: "卦",
        0x25: "凑",
        0x26: "侦",
        0x27: "獗",
        0x28: "政",
        0x29: "愁",
        0x2A: "枚",
        0x2B: "褐",
        0x2C: "恰",
        0x2D: "廉",
        0x2E: "槽",
        0x2F: "妒",
        0x30: "诡",
        0x31: "摄",
    },
    0x68: {
        0x01: "蓝",
        0x02: "食",
        0x03: "盖",
        0x04: "锤",
        0x05: "会",
        0x06: "地",
        0x07: "达",
        0x08: "友",
        0x09: "怎",
        0x0A: "方",
        0x0B: "闲",
        0x0C: "情",
        0x0D: "兴",
        0x0E: "痛",
        0x0F: "既",
        0x10: "砰",
        0x11: "颜",
        0x12: "制",
        0x13: "单",
        0x14: "睬",
        0x15: "论",
        0x16: "急",
        0x17: "熟",
        0x18: "角",
        0x19: "剂",
        0x1A: "Ｃ",
        0x1B: "尚",
        0x1C: "涉",
        0x1D: "扮",
        0x1E: "犹",
        0x1F: "配",
        0x20: "研",
        0x21: "窜",
        0x22: "阔",
        0x23: "旺",
        0x24: "谣",
        0x25: "陌",
        0x26: "焉",
        0x27: "奴",
        0x28: "慌",
        0x29: "焚",
        0x2A: "秒",
        0x2B: "毯",
        0x2C: "溃",
        0x2D: "妥",
        0x2E: "仇",
        0x2F: "忌",
        0x30: "戒",
        0x31: "拾",
    },
    0x69: {
        0x01: "王",
        0x02: "人",
        0x03: "蜜",
        0x04: "巫",
        0x05: "用",
        0x06: "教",
        0x07: "所",
        0x08: "没",
        0x09: "嗨",
        0x0A: "风",
        0x0B: "荡",
        0x0C: "享",
        0x0D: "甜",
        0x0E: "苦",
        0x0F: "简",
        0x10: "姐",
        0x11: "砖",
        0x12: "柠",
        0x13: "撞",
        0x14: "私",
        0x15: "两",
        0x16: "俘",
        0x17: "瓜",
        0x18: "男",
        0x19: "烘",
        0x1A: "Ｆ",
        0x1B: "咖",
        0x1C: "驾",
        0x1D: "众",
        0x1E: "豫",
        0x1F: "饲",
        0x20: "沿",
        0x21: "且",
        0x22: "舌",
        0x23: "摔",
        0x24: "讲",
        0x25: "织",
        0x26: "卤",
        0x27: "役",
        0x28: "悲",
        0x29: "稽",
        0x2A: "辱",
        0x2B: "淡",
        0x2C: "咕",
        0x2D: "衬",
        0x2E: "弦",
        0x2F: "辑",
        0x30: "勺",
    },
    0x6A: {
        0x01: "树",
        0x02: "花",
        0x03: "蜂",
        0x04: "婆",
        0x05: "它",
        0x06: "训",
        0x07: "切",
        0x08: "什",
        0x09: "邮",
        0x0A: "把",
        0x0B: "差",
        0x0C: "咳",
        0x0D: "伤",
        0x0E: "誓",
        0x0F: "徒",
        0x10: "穿",
        0x11: "技",
        0x12: "檬",
        0x13: "椰",
        0x14: "致",
        0x15: "优",
        0x16: "虏",
        0x17: "药",
        0x18: "肖",
        0x19: "牛",
        0x1A: "注",
        0x1B: "喱",
        0x1C: "驶",
        0x1D: "喂",
        0x1E: "术",
        0x1F: "农",
        0x20: "踏",
        0x21: "桩",
        0x22: "绵",
        0x23: "氛",
        0x24: "疲",
        0x25: "统",
        0x26: "莽",
        0x27: "辜",
        0x28: "躁",
        0x29: "兔",
        0x2A: "箭",
        0x2B: "央",
        0x2C: "哝",
        0x2D: "衫",
        0x2E: "缉",
        0x2F: "箩",
        0x30: "飕",
    },
    0x6B: {
        0x01: "喏",
        0x02: "超",
        0x03: "催",
        0x04: "钱",
        0x05: "给",
        0x06: "他",
        0x07: "国",
        0x08: "介",
        0x09: "递",
        0x0A: "吹",
        0x0B: "劲",
        0x0C: "干",
        0x0D: "放",
        0x0E: "末",
        0x0F: "劳",
        0x10: "衣",
        0x11: "裤",
        0x12: "糖",
        0x13: "苹",
        0x14: "适",
        0x15: "秀",
        0x16: "惊",
        0x17: "区",
        0x18: "钥",
        0x19: "奶",
        0x1A: "踱",
        0x1B: "烦",
        0x1C: "漂",
        0x1D: "锻",
        0x1E: "惕",
        0x1F: "市",
        0x20: "拱",
        0x21: "弯",
        0x22: "滩",
        0x23: "纯",
        0x24: "惫",
        0x25: "辨",
        0x26: "播",
        0x27: "肆",
        0x28: "损",
        0x29: "臂",
        0x2A: "哭",
        0x2B: "六",
        0x2C: "诀",
        0x2D: "饶",
        0x2E: "授",
        0x2F: "勉",
        0x30: "劈",
    },
    0x6C: {
        0x01: "库",
        0x02: "级",
        0x03: "眠",
        0x04: "乌",
        0x05: "这",
        0x06: "多",
        0x07: "整",
        0x08: "意",
        0x09: "员",
        0x0A: "唷",
        0x0B: "丈",
        0x0C: "伟",
        0x0D: "然",
        0x0E: "四",
        0x0F: "冷",
        0x10: "服",
        0x11: "左",
        0x12: "除",
        0x13: "酸",
        0x14: "足",
        0x15: "未",
        0x16: "病",
        0x17: "硬",
        0x18: "匙",
        0x19: "赢",
        0x1A: "寒",
        0x1B: "软",
        0x1C: "浮",
        0x1D: "炼",
        0x1E: "泼",
        0x1F: "民",
        0x20: "墙",
        0x21: "缘",
        0x22: "炽",
        0x23: "粹",
        0x24: "聊",
        0x25: "血",
        0x26: "短",
        0x27: "虐",
        0x28: "喊",
        0x29: "牌",
        0x2A: "睁",
        0x2B: "返",
        0x2C: "碌",
        0x2D: "疼",
        0x2E: "芮",
        0x2F: "黏",
        0x30: "猫",
    },
    0x6D: {
        0x01: "啪",
        0x02: "加",
        0x03: "神",
        0x04: "电",
        0x05: "个",
        0x06: "么",
        0x07: "蘑",
        0x08: "必",
        0x09: "工",
        0x0A: "终",
        0x0B: "夫",
        0x0C: "斗",
        0x0D: "恙",
        0x0E: "奔",
        0x0F: "丢",
        0x10: "传",
        0x11: "边",
        0x12: "迷",
        0x13: "橙",
        0x14: "集",
        0x15: "职",
        0x16: "慢",
        0x17: "铃",
        0x18: "储",
        0x19: "厦",
        0x1A: "赔",
        0x1B: "敏",
        0x1C: "族",
        0x1D: "胖",
        0x1E: "袍",
        0x1F: "宅",
        0x20: "澡",
        0x21: "低",
        0x22: "蔽",
        0x23: "沉",
        0x24: "背",
        0x25: "沸",
        0x26: "尤",
        0x27: "祸",
        0x28: "掩",
        0x29: "鲁",
        0x2A: "酬",
        0x2B: "拨",
        0x2C: "篝",
        0x2D: "祥",
        0x2E: "抚",
        0x2F: "填",
        0x30: "俏",
    },
    0x6E: {
        0x01: "嗒",
        0x02: "邦",
        0x03: "奇",
        0x04: "宝",
        0x05: "世",
        0x06: "另",
        0x07: "菇",
        0x08: "须",
        0x09: "作",
        0x0A: "盛",
        0x0B: "妻",
        0x0C: "庆",
        0x0D: "三",
        0x0E: "相",
        0x0F: "累",
        0x10: "遍",
        0x11: "扇",
        0x12: "森",
        0x13: "调",
        0x14: "唉",
        0x15: "隐",
        0x16: "弱",
        0x17: "薯",
        0x18: "设",
        0x19: "港",
        0x1A: "偿",
        0x1B: "睛",
        0x1C: "坦",
        0x1D: "唠",
        0x1E: "羡",
        0x1F: "唯",
        0x20: "嘛",
        0x21: "值",
        0x22: "春",
        0x23: "疙",
        0x24: "夸",
        0x25: "腾",
        0x26: "蒜",
        0x27: "毫",
        0x28: "溢",
        0x29: "兜",
        0x2A: "贫",
        0x2B: "符",
        0x2C: "熙",
        0x2D: "毙",
        0x2E: "嘱",
        0x2F: "喀",
        0x30: "曙",
    },
    0x6F: {
        0x01: "绒",
        0x02: "图",
        0x03: "史",
        0x04: "师",
        0x05: "界",
        0x06: "难",
        0x07: "充",
        0x08: "走",
        0x09: "呢",
        0x0A: "亲",
        0x0B: "告",
        0x0C: "祝",
        0x0D: "少",
        0x0E: "耐",
        0x0F: "喔",
        0x10: "彩",
        0x11: "窗",
        0x12: "林",
        0x13: "酒",
        0x14: "耗",
        0x15: "才",
        0x16: "健",
        0x17: "效",
        0x18: "妙",
        0x19: "玛",
        0x1A: "驭",
        0x1B: "耍",
        0x1C: "仅",
        0x1D: "叨",
        0x1E: "慕",
        0x1F: "厅",
        0x20: "荒",
        0x21: "吊",
        0x22: "藤",
        0x23: "瘩",
        0x24: "宠",
        0x25: "穆",
        0x26: "撼",
        0x27: "诚",
        0x28: "验",
        0x29: "奈",
        0x2A: "穷",
        0x2B: "猪",
        0x2C: "攘",
        0x2D: "铰",
        0x2E: "裔",
        0x2F: "滞",
        0x30: "囱",
    },
    0x70: {
        0x01: "毛",
        0x02: "巴",
        0x03: "派",
        0x04: "陈",
        0x05: "重",
        0x06: "忘",
        0x07: "满",
        0x08: "非",
        0x09: "普",
        0x0A: "笔",
        0x0B: "诉",
        0x0C: "缺",
        0x0D: "旅",
        0x0E: "极",
        0x0F: "旱",
        0x10: "啸",
        0x11: "首",
        0x12: "击",
        0x13: "顽",
        0x14: "虽",
        0x15: "显",
        0x16: "康",
        0x17: "眩",
        0x18: "具",
        0x19: "归",
        0x1A: "双",
        0x1B: "仙",
        0x1C: "模",
        0x1D: "尝",
        0x1E: "肃",
        0x1F: "码",
        0x20: "芜",
        0x21: "橱",
        0x22: "泉",
        0x23: "煞",
        0x24: "慷",
        0x25: "奏",
        0x26: "攀",
        0x27: "陆",
        0x28: "惦",
        0x29: "赘",
        0x2A: "慰",
        0x2B: "屿",
        0x2C: "瘫",
        0x2D: "链",
        0x2E: "芬",
        0x2F: "肠",
        0x30: "逝",
    },
    0x71: {
        0x01: "怪",
        0x02: "布",
        0x03: "克",
        0x04: "李",
        0x05: "新",
        0x06: "量",
        0x07: "欠",
        0x08: "常",
        0x09: "通",
        0x0A: "签",
        0x0B: "出",
        0x0C: "席",
        0x0D: "早",
        0x0E: "限",
        0x0F: "落",
        0x10: "谷",
        0x11: "易",
        0x12: "乱",
        0x13: "皮",
        0x14: "影",
        0x15: "存",
        0x16: "福",
        0x17: "晕",
        0x18: "煎",
        0x19: "眼",
        0x1A: "赏",
        0x1B: "惯",
        0x1C: "威",
        0x1D: "拍",
        0x1E: "袖",
        0x1F: "凝",
        0x20: "陡",
        0x21: "董",
        0x22: "堵",
        0x23: "碾",
        0x24: "慨",
        0x25: "乞",
        0x26: "宿",
        0x27: "魅",
        0x28: "劝",
        0x29: "母",
        0x2A: "盼",
        0x2B: "洽",
        0x2C: "痪",
        0x2D: "哔",
        0x2E: "忽",
        0x2F: "畜",
        0x30: "逞",
    },
    0x72: {
        0x01: "炸",
        0x02: "路",
        0x03: "云",
        0x04: "暗",
        0x05: "来",
        0x06: "啊",
        0x07: "很",
        0x08: "直",
        0x09: "封",
        0x0A: "名",
        0x0B: "抓",
        0x0C: "培",
        0x0D: "纪",
        0x0E: "脑",
        0x0F: "向",
        0x10: "婚",
        0x11: "吉",
        0x12: "洲",
        0x13: "学",
        0x14: "联",
        0x15: "份",
        0x16: "颗",
        0x17: "汤",
        0x18: "盘",
        0x19: "镜",
        0x1A: "透",
        0x1B: "呼",
        0x1C: "佳",
        0x1D: "挣",
        0x1E: "雅",
        0x1F: "海",
        0x20: "峭",
        0x21: "昂",
        0x22: "肥",
        0x23: "炬",
        0x24: "借",
        0x25: "丐",
        0x26: "仰",
        0x27: "拆",
        0x28: "惭",
        0x29: "忆",
        0x2A: "顿",
        0x2B: "荐",
        0x2C: "伍",
        0x2D: "谬",
        0x2E: "趁",
        0x2F: "搁",
        0x30: "措",
    },
    0x73: {
        0x01: "弹",
        0x02: "之",
        0x03: "雾",
        0x04: "诺",
        0x05: "和",
        0x06: "一",
        0x07: "汀",
        0x08: "样",
        0x09: "信",
        0x0A: "太",
        0x0B: "关",
        0x0C: "理",
        0x0D: "念",
        0x0E: "筋",
        0x0F: "炫",
        0x10: "嘘",
        0x11: "聪",
        0x12: "掉",
        0x13: "者",
        0x14: "押",
        0x15: "乓",
        0x16: "七",
        0x17: "菜",
        0x18: "读",
        0x19: "异",
        0x1A: "瓶",
        0x1B: "援",
        0x1C: "衡",
        0x1D: "脱",
        0x1E: "较",
        0x1F: "输",
        0x20: "卑",
        0x21: "窥",
        0x22: "巢",
        0x23: "惑",
        0x24: "贴",
        0x25: "贩",
        0x26: "仗",
        0x27: "姑",
        0x28: "惧",
        0x29: "策",
        0x2A: "嬉",
        0x2B: "冠",
        0x2C: "泪",
        0x2D: "屈",
        0x2E: "呐",
        0x2F: "嚷",
        0x30: "拖",
    },
    0x74: {
        0x01: "兵",
        0x02: "心",
        0x03: "老",
        0x04: "灰",
        0x05: "平",
        0x06: "定",
        0x07: "说",
        0x08: "？",
        0x09: "她",
        0x0A: "棒",
        0x0B: "键",
        0x0C: "由",
        0x0D: "品",
        0x0E: "谁",
        0x0F: "遇",
        0x10: "吓",
        0x11: "栋",
        0x12: "改",
        0x13: "包",
        0x14: "求",
        0x15: "乒",
        0x16: "予",
        0x17: "茶",
        0x18: "懂",
        0x19: "聚",
        0x1A: "钻",
        0x1B: "狡",
        0x1C: "矮",
        0x1D: "悬",
        0x1E: "胁",
        0x1F: "踪",
        0x20: "鄙",
        0x21: "蜡",
        0x22: "纹",
        0x23: "索",
        0x24: "彼",
        0x25: "哒",
        0x26: "姆",
        0x27: "娘",
        0x28: "怖",
        0x29: "艇",
        0x2A: "晃",
        0x2B: "构",
        0x2C: "俯",
        0x2D: "睿",
        0x2E: "粒",
        0x2F: "辉",
        0x30: "逮",
    },
    0x75: {
        0x01: "杀",
        0x02: "嘿",
        0x03: "呜",
        0x04: "马",
        0x05: "。",
        0x06: "…",
        0x07: "灵",
        0x08: "如",
        0x09: "写",
        0x0A: "绝",
        0x0B: "速",
        0x0C: "甚",
        0x0D: "彻",
        0x0E: "便",
        0x0F: "旋",
        0x10: "唬",
        0x11: "币",
        0x12: "态",
        0x13: "裹",
        0x14: "严",
        0x15: "寻",
        0x16: "船",
        0x17: "升",
        0x18: "喷",
        0x19: "资",
        0x1A: "画",
        0x1B: "猾",
        0x1C: "粗",
        0x1D: "挂",
        0x1E: "拳",
        0x1F: "楼",
        0x20: "症",
        0x21: "烛",
        0x22: "丝",
        0x23: "俗",
        0x24: "笆",
        0x25: "咚",
        0x26: "秩",
        0x27: "嗅",
        0x28: "挺",
        0x29: "弛",
        0x2A: "熔",
        0x2B: "撕",
        0x2C: "涡",
        0x2D: "竭",
        0x2E: "蔚",
        0x2F: "妨",
        0x30: "慈",
    },
    0x76: {
        0x01: "手",
        0x02: "虎",
        0x03: "噜",
        0x04: "力",
        0x05: "现",
        0x06: "不",
        0x07: "证",
        0x08: "夺",
        0x09: "看",
        0x0A: "错",
        0x0B: "听",
        0x0C: "至",
        0x0D: "丽",
        0x0E: "久",
        0x0F: "转",
        0x10: "岸",
        0x11: "预",
        0x12: "第",
        0x13: "艺",
        0x14: "哎",
        0x15: "围",
        0x16: "艘",
        0x17: "控",
        0x18: "豆",
        0x19: "料",
        0x1A: "沃",
        0x1B: "携",
        0x1C: "牺",
        0x1D: "幻",
        0x1E: "残",
        0x1F: "究",
        0x20: "畏",
        0x21: "壶",
        0x22: "察",
        0x23: "囚",
        0x24: "剧",
        0x25: "揭",
        0x26: "操",
        0x27: "恼",
        0x28: "列",
        0x29: "绷",
        0x2A: "您",
        0x2B: "页",
        0x2C: "腹",
        0x2D: "乖",
        0x2E: "耳",
        0x2F: "嗜",
        0x30: "眨",
    },
    0x77: {
        0x01: "大",
        0x02: "舞",
        0x03: "妖",
        0x04: "机",
        0x05: "在",
        0x06: "做",
        0x07: "明",
        0x08: "似",
        0x09: "送",
        0x0A: "过",
        0x0B: "外",
        0x0C: "假",
        0x0D: "奥",
        0x0E: "连",
        0x0F: "屋",
        0x10: "物",
        0x11: "示",
        0x12: "试",
        0x13: "垂",
        0x14: "匆",
        0x15: "内",
        0x16: "燃",
        0x17: "排",
        0x18: "颤",
        0x19: "壁",
        0x1A: "谱",
        0x1B: "款",
        0x1C: "牲",
        0x1D: "烫",
        0x1E: "案",
        0x1F: "廊",
        0x20: "痒",
        0x21: "褪",
        0x22: "窟",
        0x23: "杂",
        0x24: "势",
        0x25: "免",
        0x26: "立",
        0x27: "罪",
        0x28: "蕾",
        0x29: "逼",
        0x2A: "幕",
        0x2B: "估",
        0x2C: "罩",
        0x2D: "霍",
        0x2E: "泣",
        0x2F: "淌",
        0x30: "谓",
    },
    0x78: {
        0x01: "炮",
        0x02: "步",
        0x03: "冰",
        0x04: "（",
        0x05: "又",
        0x06: "努",
        0x07: "自",
        0x08: "书",
        0x09: "吧",
        0x0A: "次",
        0x0B: "下",
        0x0C: "令",
        0x0D: "够",
        0x0E: "门",
        0x0F: "顶",
        0x10: "拜",
        0x11: "运",
        0x12: "暴",
        0x13: "钓",
        0x14: "捎",
        0x15: "弃",
        0x16: "烧",
        0x17: "丧",
        0x18: "抖",
        0x19: "垒",
        0x1A: "仓",
        0x1B: "素",
        0x1C: "逐",
        0x1D: "抵",
        0x1E: "肿",
        0x1F: "厨",
        0x20: "划",
        0x21: "椅",
        0x22: "勘",
        0x23: "臊",
        0x24: "导",
        0x25: "响",
        0x26: "臣",
        0x27: "饱",
        0x28: "寐",
        0x29: "杳",
        0x2A: "馨",
        0x2B: "稿",
        0x2C: "飓",
        0x2D: "跨",
        0x2E: "狈",
        0x2F: "涌",
        0x30: "蜗",
    },
    0x79: {
        0x01: "酷",
        0x02: "间",
        0x03: "冻",
        0x04: "开",
        0x05: "可",
        0x06: "那",
        0x07: "己",
        0x08: "疯",
        0x09: "计",
        0x0A: "停",
        0x0B: "猜",
        0x0C: "忍",
        0x0D: "更",
        0x0E: "隆",
        0x0F: "房",
        0x10: "访",
        0x11: "露",
        0x12: "同",
        0x13: "街",
        0x14: "范",
        0x15: "视",
        0x16: "：",
        0x17: "防",
        0x18: "污",
        0x19: "文",
        0x1A: "抒",
        0x1B: "阴",
        0x1C: "渐",
        0x1D: "遗",
        0x1E: "奋",
        0x1F: "肴",
        0x20: "倦",
        0x21: "盹",
        0x22: "渊",
        0x23: "南",
        0x24: "饵",
        0x25: "衔",
        0x26: "惩",
        0x27: "址",
        0x28: "栽",
        0x29: "嘟",
        0x2A: "雀",
        0x2B: "延",
        0x2C: "陛",
        0x2D: "欺",
        0x2E: "吻",
        0x2F: "评",
        0x30: "瞄",
    },
    0x7A: {
        0x01: "霸",
        0x02: "谍",
        0x03: "白",
        0x04: "始",
        0x05: "以",
        0x06: "困",
        0x07: "位",
        0x08: "狂",
        0x09: "上",
        0x0A: "止",
        0x0B: "并",
        0x0C: "苛",
        0x0D: "追",
        0x0E: "卖",
        0x0F: "啦",
        0x10: "山",
        0x11: "塞",
        0x12: "种",
        0x13: "喇",
        0x14: "选",
        0x15: "糟",
        0x16: "压",
        0x17: "御",
        0x18: "染",
        0x19: "涸",
        0x1A: "律",
        0x1B: "蝙",
        0x1C: "劣",
        0x1D: "骸",
        0x1E: "周",
        0x1F: "抽",
        0x20: "炭",
        0x21: "昼",
        0x22: "泳",
        0x23: "北",
        0x24: "沛",
        0x25: "垄",
        0x26: "罚",
        0x27: "纵",
        0x28: "盆",
        0x29: "囔",
        0x2A: "羽",
        0x2B: "挫",
        0x2C: "杞",
        0x2D: "凌",
        0x2E: "项",
        0x2F: "茁",
        0x30: "捷",
    },
    0x7B: {
        0x01: "黑",
        0x02: "火",
        0x03: "霹",
        0x04: "）",
        0x05: "实",
        0x06: "永",
        0x07: "年",
        0x08: "冒",
        0x09: "中",
        0x0A: "答",
        0x0B: "与",
        0x0C: "刻",
        0x0D: "随",
        0x0E: "勋",
        0x0F: "咪",
        0x10: "岛",
        0x11: "入",
        0x12: "丛",
        0x13: "叭",
        0x14: "择",
        0x15: "退",
        0x16: "雪",
        0x17: "捶",
        0x18: "土",
        0x19: "毁",
        0x1A: "誉",
        0x1B: "蝠",
        0x1C: "甩",
        0x1D: "爬",
        0x1E: "推",
        0x1F: "屉",
        0x20: "陷",
        0x21: "塌",
        0x22: "层",
        0x23: "痴",
        0x24: "枪",
        0x25: "靴",
        0x26: "氓",
        0x27: "劫",
        0x28: "幢",
        0x29: "拘",
        0x2A: "嘭",
        0x2B: "额",
        0x2C: "漏",
        0x2D: "咯",
        0x2E: "概",
        0x2F: "厄",
        0x30: "径",
    },
    0x7C: {
        0x01: "黄",
        0x02: "焰",
        0x03: "雳",
        0x04: "结",
        0x05: "每",
        0x06: "远",
        0x07: "噢",
        0x08: "险",
        0x09: "让",
        0x0A: "应",
        0x0B: "着",
        0x0C: "乐",
        0x0D: "折",
        0x0E: "章",
        0x0F: "ー",
        0x10: "附",
        0x11: "救",
        0x12: "爆",
        0x13: "钟",
        0x14: "攻",
        0x15: "临",
        0x16: "尘",
        0x17: "板",
        0x18: "壤",
        0x19: "灭",
        0x1A: "银",
        0x1B: "栖",
        0x1C: "戚",
        0x1D: "烬",
        0x1E: "垫",
        0x1F: "螺",
        0x20: "展",
        0x21: "倾",
        0x22: "遮",
        0x23: "醉",
        0x24: "庞",
        0x25: "偏",
        0x26: "囊",
        0x27: "弓",
        0x28: "匿",
        0x29: "航",
        0x2A: "扯",
        0x2B: "扭",
        0x2C: "炉",
        0x2D: "鞋",
        0x2E: "峡",
        0x2F: "厚",
        0x30: "括",
    },
    0x7D: {
        0x01: "绿",
        0x02: "气",
        0x03: "女",
        0x04: "束",
        0x05: "愿",
        0x06: "记",
        0x07: "继",
        0x08: "经",
        0x09: "妹",
        0x0A: "查",
        0x0B: "抱",
        0x0C: "游",
        0x0D: "磨",
        0x0E: "赚",
        0x0F: "否",
        0x10: "近",
        0x11: "魂",
        0x12: "裂",
        0x13: "形",
        0x14: "敌",
        0x15: "柜",
        0x16: "旧",
        0x17: "轻",
        0x18: "凉",
        0x19: "帽",
        0x1A: "磁",
        0x1B: "鸟",
        0x1C: "留",
        0x1D: "锐",
        0x1E: "检",
        0x1F: "梯",
        0x20: "雨",
        0x21: "斜",
        0x22: "怜",
        0x23: "协",
        0x24: "印",
        0x25: "僻",
        0x26: "译",
        0x27: "恭",
        0x28: "托",
        0x29: "恒",
        0x2A: "苗",
        0x2B: "窃",
        0x2C: "悄",
        0x2D: "尾",
        0x2E: "拐",
        0x2F: "隙",
        0x30: "崎",
    },
    0x7E: {
        0x01: "兄",
        0x02: "医",
        0x03: "孩",
        0x04: "哇",
        0x05: "望",
        0x06: "希",
        0x07: "续",
        0x08: "历",
        0x09: "天",
        0x0A: "尔",
        0x0B: "歉",
        0x0C: "找",
        0x0D: "却",
        0x0E: "别",
        0x0F: "唱",
        0x10: "故",
        0x11: "指",
        0x12: "植",
        0x13: "粉",
        0x14: "旦",
        0x15: "台",
        0x16: "投",
        0x17: "缓",
        0x18: "爽",
        0x19: "臭",
        0x1A: "际",
        0x1B: "锋",
        0x1C: "肮",
        0x1D: "丑",
        0x1E: "标",
        0x1F: "绕",
        0x20: "荫",
        0x21: "坡",
        0x22: "篱",
        0x23: "辛",
        0x24: "夏",
        0x25: "帅",
        0x26: "询",
        0x27: "阶",
        0x28: "娇",
        0x29: "司",
        0x2A: "约",
        0x2B: "财",
        0x2C: "挠",
        0x2D: "嗖",
        0x2E: "铭",
        0x2F: "趾",
        0x30: "岖",
    },
    0x7F: {
        0x01: "弟",
        0x02: "疗",
        0x03: "卡",
        0x04: "咔",
        0x05: "都",
        0x06: "件",
        0x07: "想",
        0x08: "城",
        0x09: "呀",
        0x0A: "博",
        0x0B: "密",
        0x0C: "今",
        0x0D: "松",
        0x0E: "迫",
        0x0F: "歌",
        0x10: "浪",
        0x11: "跑",
        0x12: "几",
        0x13: "懒",
        0x14: "踩",
        0x15: "固",
        0x16: "掷",
        0x17: "节",
        0x18: "阳",
        0x19: "篮",
        0x1A: "敲",
        0x1B: "爪",
        0x1C: "脏",
        0x1D: "陋",
        0x1E: "缝",
        0x1F: "圈",
        0x20: "垠",
        0x21: "崩",
        0x22: "善",
        0x23: "侍",
        0x24: "籁",
        0x25: "丰",
        0x26: "育",
        0x27: "亏",
        0x28: "谚",
        0x29: "渡",
        0x2A: "叛",
        0x2B: "拯",
        0x2C: "闯",
        0x2D: "诅",
        0x2E: "矫",
        0x2F: "扬",
        0x30: "脊",
    },
    0x80: {
        0x01: "蛋",
        0x02: "灯",
        0x03: "米",
        0x04: "战",
        0x05: "要",
        0x06: "事",
        0x07: "候",
        0x08: "堡",
        0x09: "邀",
        0x0A: "士",
        0x0B: "爱",
        0x0C: "练",
        0x0D: "口",
        0x0E: "典",
        0x0F: "怯",
        0x10: "漫",
        0x11: "腿",
        0x12: "描",
        0x13: "散",
        0x14: "准",
        0x15: "孪",
        0x16: "造",
        0x17: "省",
        0x18: "灿",
        0x19: "静",
        0x1A: "万",
        0x1B: "孵",
        0x1C: "巨",
        0x1D: "拼",
        0x1E: "箱",
        0x1F: "组",
        0x20: "扎",
        0x21: "尺",
        0x22: "橘",
        0x23: "挑",
        0x24: "萦",
        0x25: "肌",
        0x26: "悍",
        0x27: "号",
        0x28: "润",
        0x29: "拂",
        0x2A: "谅",
        0x2B: "锅",
        0x2C: "呸",
        0x2D: "爵",
        0x2E: "寂",
        0x2F: "泽",
        0x30: "矗",
    },
    0x81: {
        0x01: "仔",
        0x02: "笼",
        0x03: "欧",
        0x04: "车",
        0x05: "当",
        0x06: "得",
        0x07: "有",
        0x08: "恢",
        0x09: "请",
        0x0A: "待",
        0x0B: "爷",
        0x0C: "嚯",
        0x0D: "毕",
        0x0E: "段",
        0x0F: "场",
        0x10: "壮",
        0x11: "监",
        0x12: "述",
        0x13: "专",
        0x14: "按",
        0x15: "巷",
        0x16: "圆",
        0x17: "频",
        0x18: "烂",
        0x19: "恐",
        0x1A: "麻",
        0x1B: "召",
        0x1C: "朵",
        0x1D: "猛",
        0x1E: "盒",
        0x1F: "筑",
        0x20: "儿",
        0x21: "寸",
        0x22: "竞",
        0x23: "贸",
        0x24: "招",
        0x25: "肉",
        0x26: "哧",
        0x27: "虔",
        0x28: "沐",
        0x29: "涯",
        0x2A: "擦",
        0x2B: "冬",
        0x2C: "扼",
        0x2D: "灾",
        0x2E: "寞",
        0x2F: "垮",
        0x30: "纠",
    },
    0x82: {
        0x01: "鼹",
        0x02: "鬼",
        0x03: "苏",
        0x04: "泡",
        0x05: "遥",
        0x06: "到",
        0x07: "等",
        0x08: "复",
        0x09: "举",
        0x0A: "废",
        0x0B: "欣",
        0x0C: "商",
        0x0D: "竟",
        0x0E: "趣",
        0x0F: "担",
        0x10: "观",
        0x11: "狱",
        0x12: "戴",
        0x13: "横",
        0x14: "味",
        0x15: "惜",
        0x16: "暂",
        0x17: "偶",
        0x18: "算",
        0x19: "胶",
        0x1A: "痹",
        0x1B: "唤",
        0x1C: "棵",
        0x1D: "怀",
        0x1E: "摆",
        0x1F: "滴",
        0x20: "嗬",
        0x21: "蜘",
        0x22: "革",
        0x23: "捏",
        0x24: "裁",
        0x25: "梭",
        0x26: "敞",
        0x27: "哼",
        0x28: "互",
        0x29: "钩",
        0x2A: "铺",
        0x2B: "季",
        0x2C: "嘎",
        0x2D: "权",
        0x2E: "茬",
        0x2F: "俊",
        0x30: "僧",
    },
    0x83: {
        0x01: "鼠",
        0x02: "将",
        0x03: "莎",
        0x04: "队",
        0x05: "夜",
        0x06: "也",
        0x07: "去",
        0x08: "原",
        0x09: "办",
        0x0A: "话",
        0x0B: "喜",
        0x0C: "店",
        0x0D: "变",
        0x0E: "哟",
        0x0F: "皱",
        0x10: "❝",
        0x11: "身",
        0x12: "胸",
        0x13: "乏",
        0x14: "瞬",
        0x15: "遵",
        0x16: "降",
        0x17: "半",
        0x18: "器",
        0x19: "皇",
        0x1A: "翅",
        0x1B: "忠",
        0x1C: "仍",
        0x1D: "绚",
        0x1E: "脆",
        0x1F: "湿",
        0x20: "丘",
        0x21: "蛛",
        0x22: "紫",
        0x23: "艰",
        0x24: "判",
        0x25: "属",
        0x26: "懦",
        0x27: "撒",
        0x28: "稳",
        0x29: "辈",
        0x2A: "栏",
        0x2B: "册",
        0x2C: "吱",
        0x2D: "祈",
        0x2E: "咙",
        0x2F: "孔",
        0x30: "漆",
    },
    0x84: {
        0x01: "岩",
        0x02: "军",
        0x03: "阿",
        0x04: "洞",
        0x05: "空",
        0x06: "许",
        0x07: "该",
        0x08: "貌",
        0x09: "被",
        0x0A: "胡",
        0x0B: "若",
        0x0C: "营",
        0x0D: "孤",
        0x0E: "特",
        0x0F: "眉",
        0x10: "纸",
        0x11: "站",
        0x12: "针",
        0x13: "二",
        0x14: "减",
        0x15: "价",
        0x16: "燥",
        0x17: "抢",
        0x18: "翡",
        0x19: "腌",
        0x1A: "膀",
        0x1B: "根",
        0x1C: "乘",
        0x1D: "盯",
        0x1E: "铙",
        0x1F: "河",
        0x20: "晒",
        0x21: "网",
        0x22: "序",
        0x23: "掠",
        0x24: "赖",
        0x25: "骗",
        0x26: "呵",
        0x27: "兆",
        0x28: "柱",
        0x29: "讽",
        0x2A: "迄",
        0x2B: "驱",
        0x2C: "校",
        0x2D: "祷",
        0x2E: "亚",
        0x2F: "溉",
        0x30: "启",
    },
    0x85: {
        0x01: "石",
        0x02: "团",
        0x03: "姨",
        0x04: "哦",
        0x05: "时",
        0x06: "规",
        0x07: "再",
        0x08: "安",
        0x09: "参",
        0x0A: "八",
        0x0B: "哪",
        0x0C: "业",
        0x0D: "独",
        0x0E: "鲜",
        0x0F: "识",
        0x10: "片",
        0x11: "目",
        0x12: "戏",
        0x13: "百",
        0x14: "巧",
        0x15: "著",
        0x16: "滋",
        0x17: "昏",
        0x18: "翠",
        0x19: "豪",
        0x1A: "狼",
        0x1B: "怨",
        0x1C: "尖",
        0x1D: "副",
        0x1E: "钹",
        0x1F: "环",
        0x20: "郁",
        0x21: "巡",
        0x22: "淹",
        0x23: "奉",
        0x24: "货",
        0x25: "骑",
        0x26: "愤",
        0x27: "嚓",
        0x28: "轮",
        0x29: "嗓",
        0x2A: "腰",
        0x2B: "档",
        0x2C: "碗",
        0x2D: "氧",
        0x2E: "卟",
        0x2F: "谋",
        0x30: "捕",
    },
    0x86: {
        0x01: "球",
        0x02: "叠",
        0x03: "比",
        0x04: "，",
        0x05: "知",
        0x06: "矩",
        0x07: "见",
        0x08: "最",
        0x09: "于",
        0x0A: "犯",
        0x0B: "呆",
        0x0C: "总",
        0x0D: "爸",
        0x0E: "殊",
        0x0F: "潮",
        0x10: "❞",
        0x11: "录",
        0x12: "室",
        0x13: "合",
        0x14: "依",
        0x15: "收",
        0x16: "补",
        0x17: "冲",
        0x18: "雕",
        0x19: "华",
        0x1A: "籍",
        0x1B: "恨",
        0x1C: "卷",
        0x1D: "景",
        0x1E: "肩",
        0x1F: "境",
        0x20: "葱",
        0x21: "逻",
        0x22: "啰",
        0x23: "句",
        0x24: "宾",
        0x25: "童",
        0x26: "怒",
        0x27: "卿",
        0x28: "嘶",
        0x29: "蒙",
        0x2A: "扛",
        0x2B: "官",
        0x2C: "骤",
        0x2D: "嘲",
        0x2E: "炙",
        0x2F: "纱",
        0x30: "峻",
    },
    0x87: {
        0x01: "盗",
        0x02: "罗",
        0x03: "帕",
        0x04: "！",
        0x05: "道",
        0x06: "点",
        0x07: "亮",
        0x08: "后",
        0x09: "先",
        0x0A: "傻",
        0x0B: "住",
        0x0C: "买",
        0x0D: "讨",
        0x0E: "期",
        0x0F: "、",
        0x10: "认",
        0x11: "音",
        0x12: "管",
        0x13: "玫",
        0x14: "靠",
        0x15: "换",
        0x16: "治",
        0x17: "距",
        0x18: "桶",
        0x19: "浓",
        0x1A: "阻",
        0x1B: "咄",
        0x1C: "饿",
        0x1D: "佩",
        0x1E: "瓣",
        0x1F: "呕",
        0x20: "澈",
        0x21: "饭",
        0x22: "砍",
        0x23: "购",
        0x24: "浴",
        0x25: "悔",
        0x26: "杰",
        0x27: "惨",
        0x28: "鸣",
        0x29: "词",
        0x2A: "崖",
        0x2B: "遣",
        0x2C: "届",
        0x2D: "晰",
        0x2E: "泄",
        0x2F: "浸",
        0x30: "媲",
    },
    0x88: {
        0x01: "贼",
        0x02: "汉",
        0x03: "瑞",
        0x04: "谢",
        0x05: "闪",
        0x06: "但",
        0x07: "照",
        0x08: "胜",
        0x09: "测",
        0x0A: "拒",
        0x0B: "紧",
        0x0C: "东",
        0x0D: "厌",
        0x0E: "局",
        0x0F: "即",
        0x10: "锁",
        0x11: "崇",
        0x12: "俱",
        0x13: "瑰",
        0x14: "摇",
        0x15: "产",
        0x16: "愈",
        0x17: "离",
        0x18: "巾",
        0x19: "饼",
        0x1A: "虚",
        0x1B: "牙",
        0x1C: "蛰",
        0x1D: "献",
        0x1E: "僵",
        0x1F: "舒",
        0x20: "岁",
        0x21: "帘",
        0x22: "惹",
        0x23: "寄",
        0x24: "报",
        0x25: "茸",
        0x26: "宁",
        0x27: "昨",
        0x28: "烟",
        0x29: "灌",
        0x2A: "葡",
        0x2B: "踢",
        0x2C: "翰",
        0x2D: "科",
        0x2E: "饥",
        0x2F: "洪",
        0x30: "拦",
    },
    0x89: {
        0x01: "木",
        0x02: "高",
        0x03: "塔",
        0x04: "你",
        0x05: "耀",
        0x06: "发",
        0x07: "还",
        0x08: "利",
        0x09: "宫",
        0x0A: "失",
        0x0B: "张",
        0x0C: "西",
        0x0D: "保",
        0x0E: "顾",
        0x0F: "跳",
        0x10: "牢",
        0x11: "擅",
        0x12: "部",
        0x13: "莲",
        0x14: "杆",
        0x15: "反",
        0x16: "萎",
        0x17: "则",
        0x18: "伞",
        0x19: "荷",
        0x1A: "思",
        0x1B: "齿",
        0x1C: "迈",
        0x1D: "端",
        0x1E: "咀",
        0x1F: "振",
        0x20: "暑",
        0x21: "桌",
        0x22: "覆",
        0x23: "癫",
        0x24: "吝",
        0x25: "浑",
        0x26: "陪",
        0x27: "棕",
        0x28: "兽",
        0x29: "铅",
        0x2A: "萄",
        0x2B: "涨",
        0x2C: "九",
        0x2D: "呻",
        0x2E: "咦",
        0x2F: "恕",
        0x30: "浇",
    },
    0x8A: {
        0x01: "乃",
        0x02: "跷",
        0x03: "妞",
        0x04: "成",
        0x05: "正",
        0x06: "生",
        0x07: "桃",
        0x08: "象",
        0x09: "殿",
        0x0A: "礼",
        0x0B: "刚",
        0x0C: "宴",
        0x0D: "护",
        0x0E: "糊",
        0x0F: "饮",
        0x10: "噩",
        0x11: "躲",
        0x12: "系",
        0x13: "菟",
        0x14: "移",
        0x15: "增",
        0x16: "缩",
        0x17: "伐",
        0x18: "诗",
        0x19: "拉",
        0x1A: "付",
        0x1B: "咬",
        0x1C: "创",
        0x1D: "凶",
        0x1E: "嚼",
        0x1F: "熬",
        0x20: "德",
        0x21: "井",
        0x22: "湖",
        0x23: "宣",
        0x24: "啬",
        0x25: "呱",
        0x26: "闷",
        0x27: "榈",
        0x28: "叔",
        0x29: "旷",
        0x2A: "妆",
        0x2B: "烁",
        0x2C: "嘉",
        0x2D: "吟",
        0x2E: "腥",
        0x2F: "逆",
        0x30: "缭",
    },
    0x8B: {
        0x01: "伊",
        0x02: "噬",
        0x03: "咻",
        0x04: "功",
        0x05: "为",
        0x06: "能",
        0x07: "公",
        0x08: "已",
        0x09: "霜",
        0x0A: "千",
        0x0B: "镇",
        0x0C: "欢",
        0x0D: "叫",
        0x0E: "涂",
        0x0F: "命",
        0x10: "决",
        0x11: "藏",
        0x12: "诞",
        0x13: "弗",
        0x14: "况",
        0x15: "基",
        0x16: "浆",
        0x17: "碰",
        0x18: "盐",
        0x19: "仁",
        0x1A: "班",
        0x1B: "朝",
        0x1C: "铁",
        0x1D: "呃",
        0x1E: "缠",
        0x1F: "垃",
        0x20: "阱",
        0x21: "摸",
        0x22: "溜",
        0x23: "恋",
        0x24: "例",
        0x25: "馆",
        0x26: "庭",
        0x27: "袋",
        0x28: "皙",
        0x29: "怡",
        0x2A: "匣",
        0x2B: "施",
        0x2C: "岗",
        0x2D: "初",
        0x2E: "祟",
        0x2F: "贯",
        0x30: "徽",
    },
    0x8C: {
        0x01: "钢",
        0x02: "草",
        0x03: "像",
        0x04: "了",
        0x05: "勇",
        0x06: "性",
        0x07: "主",
        0x08: "往",
        0x09: "度",
        0x0A: "载",
        0x0B: "稍",
        0x0C: "处",
        0x0D: "滚",
        0x0E: "午",
        0x0F: "条",
        0x10: "坐",
        0x11: "墟",
        0x12: "共",
        0x13: "蹈",
        0x14: "习",
        0x15: "本",
        0x16: "枫",
        0x17: "触",
        0x18: "鸡",
        0x19: "煮",
        0x1A: "翻",
        0x1B: "洋",
        0x1C: "吞",
        0x1D: "线",
        0x1E: "懈",
        0x1F: "圾",
        0x20: "谜",
        0x21: "净",
        0x22: "融",
        0x23: "耻",
        0x24: "义",
        0x25: "柔",
        0x26: "济",
        0x27: "阁",
        0x28: "斑",
        0x29: "哀",
        0x2A: "障",
        0x2B: "苍",
        0x2C: "谨",
        0x2D: "趟",
        0x2E: "汗",
        0x2F: "薄",
        0x30: "删",
    },
    0x8D: {
        0x01: "盔",
        0x02: "伪",
        0x03: "嗦",
        0x04: "回",
        0x05: "敢",
        0x06: "微",
        0x07: "需",
        0x08: "日",
        0x09: "负",
        0x0A: "逢",
        0x0B: "休",
        0x0C: "谈",
        0x0D: "扰",
        0x0E: "代",
        0x0F: "鲸",
        0x10: "吃",
        0x11: "棺",
        0x12: "跃",
        0x13: "曲",
        0x14: "掌",
        0x15: "混",
        0x16: "养",
        0x17: "倍",
        0x18: "乳",
        0x19: "蓄",
        0x1A: "容",
        0x1B: "叮",
        0x1C: "飘",
        0x1D: "费",
        0x1E: "域",
        0x1F: "脖",
        0x20: "喻",
        0x21: "维",
        0x22: "堆",
        0x23: "羞",
        0x24: "嘈",
        0x25: "茎",
        0x26: "逛",
        0x27: "迟",
        0x28: "允",
        0x29: "默",
        0x2A: "秋",
        0x2B: "傲",
        0x2C: "慎",
        0x2D: "噗",
        0x2E: "辆",
        0x2F: "揍",
        0x30: "・",
    },
    0x8E: {
        0x01: "甲",
        0x02: "装",
        0x03: "水",
        0x04: "我",
        0x05: "而",
        0x06: "乎",
        0x07: "帮",
        0x08: "活",
        0x09: "责",
        0x0A: "赶",
        0x0B: "觉",
        0x0C: "确",
        0x0D: "耽",
        0x0E: "野",
        0x0F: "鱼",
        0x10: "刨",
        0x11: "材",
        0x12: "扫",
        0x13: "演",
        0x14: "握",
        0x15: "弄",
        0x16: "芳",
        0x17: "逃",
        0x18: "酪",
        0x19: "群",
        0x1A: "迅",
        0x1B: "蛮",
        0x1C: "考",
        0x1D: "笨",
        0x1E: "征",
        0x1F: "塘",
        0x20: "户",
        0x21: "挖",
        0x22: "滑",
        0x23: "引",
        0x24: "志",
        0x25: "猎",
        0x26: "挡",
        0x27: "帐",
        0x28: "隔",
        0x29: "穴",
        0x2A: "喉",
        0x2B: "销",
        0x2C: "鼓",
        0x2D: "嗤",
        0x2E: "搭",
        0x2F: "尸",
        0x30: "登",
    },
    0x8F: {
        0x01: "虫",
        0x02: "热",
        0x03: "晶",
        0x04: "们",
        0x05: "赞",
        0x06: "其",
        0x07: "助",
        0x08: "赌",
        0x09: "领",
        0x0A: "快",
        0x0B: "精",
        0x0C: "状",
        0x0D: "误",
        0x0E: "睡",
        0x0F: "取",
        0x10: "偷",
        0x11: "流",
        0x12: "潜",
        0x13: "邻",
        0x14: "愧",
        0x15: "勒",
        0x16: "香",
        0x17: "获",
        0x18: "油",
        0x19: "体",
        0x1A: "绪",
        0x1B: "吵",
        0x1C: "楚",
        0x1D: "贪",
        0x1E: "乡",
        0x1F: "旁",
        0x20: "晓",
        0x21: "躺",
        0x22: "狭",
        0x23: "审",
        0x24: "禁",
        0x25: "谎",
        0x26: "挨",
        0x27: "泥",
        0x28: "沮",
        0x29: "嘻",
        0x2A: "擔",
        0x2B: "靓",
        0x2C: "丫",
        0x2D: "吩",
        0x2E: "杠",
        0x2F: "杯",
        0x30: "屏",
    },
}


class N64SegPm_msg(Segment):
    def __init__(
        self,
        rom_start,
        rom_end,
        type,
        name,
        vram_start,
        args,
        yaml,
    ):
        super().__init__(
            rom_start,
            rom_end,
            type,
            name,
            vram_start,
            args=args,
            yaml=yaml,
        )

        self.files = yaml.get("files", []) if isinstance(yaml, dict) else []
        self.generate_header = yaml.get("generate_header", True)
        toc_file = yaml.get("toc", self.name) + ".yaml"

        with (Path(__file__).parent / toc_file).open("r") as f:
            self.msg_names = yaml_loader.load(f.read(), Loader=yaml_loader.SafeLoader)

    def split(self, rom_bytes):
        data = bytearray(rom_bytes[self.rom_start : self.rom_end])

        section_offsets = []
        pos = 0
        while True:
            offset = int.from_bytes(data[pos : pos + 4], byteorder="big")

            if offset == 0:
                break

            section_offsets.append(offset)
            pos += 4

        msg_dir = options.opts.asset_path / self.name
        msg_dir.mkdir(parents=True, exist_ok=True)

        for i, section_offset in enumerate(section_offsets):
            name = f"{i:02X}"
            if len(self.files) >= i:
                name = self.files[i]

            msg_offsets = []
            pos = section_offset
            while True:
                offset = int.from_bytes(data[pos : pos + 4], byteorder="big")

                if offset == section_offset:
                    break

                msg_offsets.append(offset)
                pos += 4

            # self.log(f"Reading {len(msg_offsets)} messages in section {name} (0x{i:02X})")

            path = msg_dir / Path(name + ".msg")

            with open(path, "w") as self.f:
                for j, msg_offset in enumerate(msg_offsets):
                    if j != 0:
                        self.f.write("\n")

                    msg_name = None
                    for d in self.msg_names:
                        section, index, goodname = d[:3]

                        if i == section and j == index:
                            msg_name = goodname
                            break

                    if msg_name is None:
                        self.f.write(f"#message:{i:02X}:{j:03X} {{\n\t")
                    else:
                        self.f.write(f"#message:{i:02X}:({msg_name}) {{\n\t")
                    self.write_message_markup(data[msg_offset:])
                    self.f.write("\n}\n")

    def get_linker_entries(self):
        from splat.segtypes.linker_entry import LinkerEntry

        base_path = options.opts.asset_path / f"{self.name}"
        out_paths = [base_path / Path(f + ".msg") for f in self.files]

        return [LinkerEntry(self, out_paths, base_path, ".data", ".data")]

    @staticmethod
    def get_default_name(addr):
        return "msg"

    def write_message_markup(self, data):
        pos = 0
        if "ver/jp" in str(options.opts.target_path):
            self.root_charset = CHARSET_KANA
        elif "ver/ique" in str(options.opts.target_path):
            self.root_charset = CHARSET_IQUE
        else:
            self.root_charset = CHARSET_STANDARD

        while data[pos] != 0xFD:
            self.charset = self.root_charset

            while True:
                char = data[pos]

                if char in self.charset:
                    value = self.charset[char]
                elif None in self.charset:
                    value = self.charset[None]

                if value is None:
                    value = fallback

                if isinstance(value, str):
                    self.write_markup(value)
                    pos += 1
                    break
                elif callable(value):
                    markup, delta = value(data[pos:])
                    self.write_markup(markup)
                    pos += delta
                    break
                elif isinstance(value, dict):
                    if None in self.charset:
                        fallback = self.charset[None]
                    self.charset = value
                    pos += 1
                else:
                    raise ValueError(value)

        self.write_markup("[End]")

    def write_markup(self, markup):
        self.f.write(re.sub("\n", "\n\t", markup))

        markup_lower = markup.lower()

        if markup_lower == "[font title]\n" or markup_lower == "[font subtitle]\n":
            self.root_charset = CHARSET_CREDITS
        elif markup_lower == "[font standard]":
            self.root_charset = CHARSET_STANDARD
        elif "ver/jp" in str(options.opts.target_path):
            if markup_lower == "[charset kana]":
                self.root_charset = CHARSET_KANA
            elif markup_lower == "[charset latin]":
                self.root_charset = CHARSET_LATIN
            elif markup_lower == "[charset kanji]":
                self.root_charset = CHARSET_KANJI
            elif markup_lower == "[charset buttons]":
                self.root_charset = CHARSET_BUTTONS

    def cache(self):
        return (self.yaml, self.rom_end, self.msg_names)
