#include "trd_03.h"

#define FLOOR_RETRACT_LENGTH -95
#define WALL_RETRACT_LENGTH -145

API_CALLABLE(N(GetLeftRightPoints)) {
    Bytecode* args = script->ptrReadPos;
    s32 switchPosX = evt_get_variable(script, *args++);
    s32 switchPosZ = evt_get_variable(script, *args++);
    f32 dist = evt_get_variable(script, *args++);

    script->varTable[0] = switchPosX + (sin_deg(gCameras[CAM_DEFAULT].curYaw + 270.0f + dist) * 100.0f);
    script->varTable[1] = switchPosZ - (cos_deg(gCameras[CAM_DEFAULT].curYaw + 270.0f + dist) * 100.0f);
    script->varTable[2] = switchPosX + (sin_deg(gCameras[CAM_DEFAULT].curYaw + 90.0f + dist) * 100.0f);
    script->varTable[3] = switchPosZ - (cos_deg(gCameras[CAM_DEFAULT].curYaw + 90.0f + dist) * 100.0f);
    return ApiStatus_DONE2;
}

EvtScript N(EVS_InitializePlatforms) = {
    Call(TranslateModel, MODEL_1, 0, 0, FLOOR_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_2, 0, 0, FLOOR_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_3, 0, 0, FLOOR_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_4, 0, 0, FLOOR_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_5, 0, 0, WALL_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_6, 0, 0, WALL_RETRACT_LENGTH)
    Call(TranslateModel, MODEL_7, 0, 0, WALL_RETRACT_LENGTH)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_1, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_2, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_3, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_4, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_o75, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_o74, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_o73, COLLIDER_FLAGS_UPPER_MASK)
    Set(MV_PlatformsExtended, FALSE)
    Return
    End
};

EvtScript N(EVS_RetractPlatform) = {
    Call(MakeLerp, 0, LVar8, 7, EASING_CUBIC_IN)
    Label(0)
        Call(UpdateLerp)
        Call(TranslateModel, LVar9, 0, 0, LVar0)
        Wait(1)
        IfEq(LVar1, 1)
            Goto(0)
        EndIf
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, LVar7, COLLIDER_FLAGS_UPPER_MASK)
    Call(PlaySound, SOUND_TRD_PUZZLE_PLATFORM_THUD)
    Call(ShakeCam, CAM_DEFAULT, 0, 2, Float(0.3))
    Return
    End
};

EvtScript N(EVS_ExtendPlatform) = {
    Call(MakeLerp, LVar8, 0, 7, EASING_CUBIC_IN)
    Label(0)
        Call(UpdateLerp)
        Call(TranslateModel, LVar9, 0, 0, LVar0)
        Wait(1)
        IfEq(LVar1, 1)
            Goto(0)
        EndIf
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_CLEAR_BITS, LVar7, COLLIDER_FLAGS_UPPER_MASK)
    Call(PlaySound, SOUND_TRD_PUZZLE_PLATFORM_THUD)
    Call(ShakeCam, CAM_DEFAULT, 0, 2, Float(0.3))
    Return
    End
};

EvtScript N(EVS_TogglePlatforms_LeftSwitch) = {
    Call(DisablePlayerInput, TRUE)
    Label(123)
    Call(GetPlayerActionState, LVar0)
    Wait(1)
    IfNe(LVar0, ACTION_STATE_IDLE)
        Goto(123)
    EndIf
    Call(UseSettingsFrom, CAM_DEFAULT, 0, 0, 0)
    Call(SetPanTarget, CAM_DEFAULT, -315, 120, -50)
    Call(N(GetLeftRightPoints), -315, -100, 60)
    Call(SetCamPosA, CAM_DEFAULT, LVar0, LVar1)
    Call(SetCamPosB, CAM_DEFAULT, LVar2, LVar3)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.5 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(15 * DT)
    IfEq(MV_PlatformsExtended, FALSE)
        Set(LVar7, COLLIDER_o73)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_7)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_4)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_4)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_3)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_3)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o74)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_6)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_2)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_2)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_1)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_1)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o75)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_5)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(MV_PlatformsExtended, TRUE)
    Else
        Set(LVar7, COLLIDER_o75)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_5)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_1)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_1)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_2)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_2)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o74)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_6)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_3)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_3)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_4)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_4)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o73)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_7)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(MV_PlatformsExtended, FALSE)
    EndIf
    Wait(10)
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.5 / DT))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
    Call(DisablePlayerInput, FALSE)
    Return
    End
};

EvtScript N(EVS_TogglePlatforms_RightSwitch) = {
    Call(DisablePlayerInput, TRUE)
    Label(123)
    Call(GetPlayerActionState, LVar0)
    Wait(1)
    IfNe(LVar0, ACTION_STATE_IDLE)
        Goto(123)
    EndIf
    Call(UseSettingsFrom, CAM_DEFAULT, 0, 0, 0)
    Call(SetPanTarget, CAM_DEFAULT, 210, 120, -50)
    Call(N(GetLeftRightPoints), 210, -100, -60)
    Call(SetCamPosA, CAM_DEFAULT, LVar0, LVar1)
    Call(SetCamPosB, CAM_DEFAULT, LVar2, LVar3)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.5 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(15 * DT)
    IfEq(MV_PlatformsExtended, FALSE)
        Set(LVar7, COLLIDER_o75)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_5)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_1)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_1)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_2)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_2)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o74)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_6)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_3)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_3)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_4)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_4)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o73)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_7)
        Exec(N(EVS_ExtendPlatform))
        Wait(9 * DT)
        Set(MV_PlatformsExtended, TRUE)
    Else
        Set(LVar7, COLLIDER_o73)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_7)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_4)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_4)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_3)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_3)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o74)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_6)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_2)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_2)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_1)
        Set(LVar8, FLOOR_RETRACT_LENGTH)
        Set(LVar9, MODEL_1)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(LVar7, COLLIDER_o75)
        Set(LVar8, WALL_RETRACT_LENGTH)
        Set(LVar9, MODEL_5)
        Exec(N(EVS_RetractPlatform))
        Wait(9 * DT)
        Set(MV_PlatformsExtended, FALSE)
    EndIf
    Wait(10)
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.5 / DT))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
    Call(DisablePlayerInput, FALSE)
    Return
    End
};
