#include "sam_08.h"

#include "world/common/todo/PlayBigSmokePuff.inc.c"

API_CALLABLE(N(AdjustFightingSoundsPos)) {
    Bytecode* args = script->ptrReadPos;
    s32 x = evt_get_variable(script, *args++);
    s32 y = evt_get_variable(script, *args++);
    s32 z = evt_get_variable(script, *args++);

    /// @bug need to use real sound id, not environmental sound id
    sfx_adjust_env_sound_pos(SOUND_LOOP_FIGHTING, SOUND_SPACE_DEFAULT, x, y, z);

    return ApiStatus_DONE2;
}

API_CALLABLE(N(StartFightingRumble)) {
    Bytecode* args = script->ptrReadPos;
    s32 rumbleFreq = evt_get_variable(script, *args++);
    s32 rumbleTime = evt_get_variable(script, *args++);

    start_rumble(rumbleFreq & 0xFF, rumbleTime & 0xFFFF);

    return ApiStatus_DONE2;
}

EvtScript N(EVS_TwoKoopesFightingFX) = {
    Call(PlaySoundAtNpc, NPC_Kooper_01A, SOUND_LOOP_FIGHTING, SOUND_SPACE_DEFAULT)
    Loop(0)
        Call(N(StartFightingRumble), 80, 10)
        Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Call(N(AdjustFightingSoundsPos), LVar0, LVar1, LVar2)
        Wait(6 * DT)
    EndLoop
    Return
    End
};

EvtScript N(EVS_Scene_ImposterAppears) = {
    Call(DisablePlayerInput, TRUE)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_CLEAR_BITS, COLLIDER_o47, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_o47, COLLIDER_FLAG_IGNORE_SHELL)
    Thread
        Call(EnableModel, MODEL_m1_kabe, TRUE)
        Call(PlaySoundAtCollider, COLLIDER_m1_kabe, SOUND_SAM08_RAISE_FLOOR, 0)
        Call(MakeLerp, -120, 0, 60 * DT, EASING_COS_IN_OUT)
        Label(0)
        Call(UpdateLerp)
        Call(TranslateGroup, MODEL_move1, 0, LVar0, 0)
        Call(UpdateColliderTransform, COLLIDER_m1_kabe)
        Wait(1)
        IfEq(LVar1, 1)
            Goto(0)
        EndIf
    EndThread
    Call(SetNpcFlagBits, NPC_PARTNER, NPC_FLAG_INVISIBLE, TRUE)
    Call(SetNpcFlagBits, NPC_Kooper_01A, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetNpcFlagBits, NPC_Kooper_02A, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(EnableNpcShadow, NPC_PARTNER, FALSE)
    Call(GetNpcPos, NPC_PARTNER, LVar2, LVar3, LVar4)
    Call(GetPlayerPos, LVar5, LVar6, LVar7)
    Thread
        Call(SetNpcPos, NPC_Kooper_01A, LVar2, LVar3, LVar4)
        Sub(LVar5, 30)
        Call(MakeLerp, LVar2, LVar5, 20 * DT, EASING_QUADRATIC_OUT)
        Label(1)
        Call(UpdateLerp)
        Call(SetNpcPos, NPC_Kooper_01A, LVar0, LVar3, LVar4)
        Wait(1)
        IfEq(LVar1, 1)
            Goto(1)
        EndIf
    EndThread
    Call(SetNpcPos, NPC_Kooper_02A, LVar2, LVar3, LVar4)
    Sub(LVar5, 60)
    Call(MakeLerp, LVar2, LVar5, 20 * DT, EASING_QUADRATIC_OUT)
    Label(2)
    Call(UpdateLerp)
    Call(SetNpcPos, NPC_Kooper_02A, LVar0, LVar3, LVar4)
    Wait(1)
    IfEq(LVar1, 1)
        Goto(2)
    EndIf
    Call(InterpPlayerYaw, 270, 0)
    Wait(70 * DT)
    Call(DisablePartnerAI, 0)
    Call(SetNpcPos, NPC_PARTNER, NPC_DISPOSE_LOCATION)
    Call(SetNpcFlagBits, NPC_PARTNER, NPC_FLAG_INACTIVE, TRUE)
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Idle)
    Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Idle)
    Call(InterpNpcYaw, NPC_Kooper_01A, 270, 0)
    Call(InterpNpcYaw, NPC_Kooper_02A, 90, 0)
    Wait(15 * DT)
    Call(PlaySoundAtNpc, NPC_Kooper_02A, SOUND_EMOTE_QUESTION, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, NPC_Kooper_02A, EMOTE_QUESTION, 45, 20, EMOTER_NPC, 0, 0, 0, 0)
    Wait(15 * DT)
    Call(PlaySoundAtNpc, NPC_Kooper_01A, SOUND_EMOTE_QUESTION, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, NPC_Kooper_01A, EMOTE_QUESTION, 0, 20, EMOTER_NPC, 0, 0, 0, 0)
    Wait(15 * DT)
    Call(PlaySoundAtPlayer, SOUND_EMOTE_QUESTION, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, 0, EMOTE_QUESTION, -45, 20, EMOTER_PLAYER, 0, 0, 0, 0)
    Wait(15 * DT)
    Call(PlaySoundAtNpc, NPC_Kooper_02A, SOUND_EMOTE_QUESTION, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, NPC_Kooper_02A, EMOTE_QUESTION, 45, 20, EMOTER_NPC, 0, 0, 0, 0)
    Wait(15 * DT)
    Call(PlaySoundAtNpc, NPC_Kooper_01A, SOUND_EMOTE_QUESTION, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, NPC_Kooper_01A, EMOTE_QUESTION, 0, 20, EMOTER_NPC, 0, 0, 0, 0)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Idle, ANIM_WorldKooper_Idle, 5, MSG_CH7_011F)
    Thread
        Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Jump)
        Call(SetNpcJumpscale, NPC_Kooper_01A, Float(1.0))
        Call(NpcJump1, NPC_Kooper_01A, -1062, -120, -37, 15 * DT)
        Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Idle)
    EndThread
    Thread
        Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Jump)
        Call(SetNpcJumpscale, NPC_Kooper_02A, Float(1.0))
        Call(NpcJump1, NPC_Kooper_02A, -1172, -120, -37, 15 * DT)
        Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Idle)
    EndThread
    Wait(5 * DT)
    Call(ShowMessageAtScreenPos, MSG_CH7_0120, 160, 40)
    Wait(20 * DT)
    Call(SetCamLeadPlayer, CAM_DEFAULT, FALSE)
    Call(GetNpcPos, NPC_Kooper_01A, LVar1, LVar2, LVar3)
    Call(GetPlayerPos, LVar4, LVar5, LVar6)
    Add(LVar1, LVar4)
    Add(LVar2, LVar5)
    Add(LVar3, LVar6)
    DivF(LVar1, Float(2.0))
    DivF(LVar2, Float(2.0))
    DivF(LVar3, Float(2.0))
    Call(UseSettingsFrom, CAM_DEFAULT, LVar1, LVar2, LVar3)
    Call(SetPanTarget, CAM_DEFAULT, LVar1, LVar2, LVar3)
    Call(SetCamDistance, CAM_DEFAULT, Float(250.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-8.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0121)
    Call(GetNpcPos, NPC_Kooper_02A, LVar7, LVar8, LVar9)
    Add(LVar7, LVar4)
    Add(LVar8, LVar5)
    Add(LVar9, LVar6)
    DivF(LVar7, Float(2.0))
    DivF(LVar8, Float(2.0))
    DivF(LVar9, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, LVar7, LVar8, LVar9)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.5 / DT))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0122)
    Call(SetPanTarget, CAM_DEFAULT, LVar1, LVar2, LVar3)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0123)
    Call(SetPanTarget, CAM_DEFAULT, LVar7, LVar8, LVar9)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0124)
    Call(SetPanTarget, CAM_DEFAULT, LVar1, LVar2, LVar3)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0125)
    Call(SetPanTarget, CAM_DEFAULT, LVar7, LVar8, LVar9)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0126)
    Call(SetPanTarget, CAM_DEFAULT, LVar1, LVar2, LVar3)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0127)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0128)
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_0129)
    Call(SetNpcFlagBits, NPC_Kooper_01A, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(SetNpcFlagBits, NPC_Kooper_02A, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(DisablePlayerInput, FALSE)
    Call(SetPlayerFlagBits, PS_FLAG_NO_CHANGE_PARTNER | PS_FLAG_NO_PARTNER_USAGE, TRUE)
    Unbind
    Return
    End
};

EvtScript N(EVS_Scene_HitTrueKooper) = {
    Call(DisablePlayerInput, TRUE)
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Hurt)
    Wait(20 * DT)
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Idle)
    Call(GetNpcPos, NPC_Kooper_02A, LVar0, LVar1, LVar2)
    Call(GetNpcPos, NPC_Kooper_01A, LVar3, LVar4, LVar5)
    AddF(LVar0, LVar3)
    AddF(LVar1, LVar4)
    AddF(LVar2, LVar5)
    DivF(LVar0, 2)
    DivF(LVar1, 2)
    DivF(LVar2, 2)
    SetF(LVar6, LVar0)
    SetF(LVar7, LVar1)
    SetF(LVar8, LVar2)
    AddF(LVar0, LVar3)
    AddF(LVar1, LVar4)
    AddF(LVar2, LVar5)
    DivF(LVar0, Float(2.0))
    DivF(LVar1, Float(2.0))
    DivF(LVar2, Float(2.0))
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(250.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-8.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(3.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkSad, ANIM_WorldKooper_StillSad, 0, MSG_CH7_012C)
    Call(GetNpcPos, NPC_Kooper_02A, LVar0, LVar1, LVar2)
    SetF(LVar3, LVar6)
    SetF(LVar4, LVar7)
    SetF(LVar5, LVar8)
    AddF(LVar3, LVar0)
    AddF(LVar4, LVar1)
    AddF(LVar5, LVar2)
    DivF(LVar3, Float(2.0))
    DivF(LVar4, Float(2.0))
    DivF(LVar5, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.5 / DT))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_CelebrateLoop, ANIM_WorldKooper_Idle, 0, MSG_CH7_012D)
    Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
    SetF(LVar3, LVar6)
    SetF(LVar4, LVar7)
    SetF(LVar5, LVar8)
    AddF(LVar3, LVar0)
    AddF(LVar4, LVar1)
    AddF(LVar5, LVar2)
    DivF(LVar3, Float(2.0))
    DivF(LVar4, Float(2.0))
    DivF(LVar5, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_TalkSad, ANIM_WorldKooper_StillSad, 0, MSG_CH7_012E)
    Call(GetNpcPos, NPC_Kooper_02A, LVar0, LVar1, LVar2)
    SetF(LVar3, LVar6)
    SetF(LVar4, LVar7)
    SetF(LVar5, LVar8)
    AddF(LVar3, LVar0)
    AddF(LVar4, LVar1)
    AddF(LVar5, LVar2)
    DivF(LVar3, Float(2.0))
    DivF(LVar4, Float(2.0))
    DivF(LVar5, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.5 / DT))
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_TalkHappy, ANIM_WorldKooper_Idle, 0, MSG_CH7_012F)
    Call(SetNpcFlagBits, NPC_Kooper_01A, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetNpcFlagBits, NPC_Kooper_02A, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
    Call(GetNpcPos, NPC_Kooper_02A, LVar3, LVar4, LVar5)
    Call(GetAngleBetweenNPCs, NPC_Kooper_01A, NPC_Kooper_02A, LVar9)
    Call(GetDist2D, LVarA, LVar0, LVar2, LVar3, LVar5)
    MulF(LVarA, Float(0.6))
    Call(AddVectorPolar, LVar0, LVar2, LVarA, LVar9)
    Call(SetNpcJumpscale, NPC_Kooper_01A, Float(1.0))
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Jump)
    Call(NpcJump0, NPC_Kooper_01A, LVar0, LVar1, LVar2, 20 * DT)
    Call(NpcJump0, NPC_Kooper_01A, LVar3, LVar4, LVar5, 10 * DT)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    ExecGetTID(N(EVS_TwoKoopesFightingFX), MV_KoopersFightingScript)
    Thread
        Call(SetPlayerSpeed, Float(3.0 / DT))
        Call(PlayerMoveTo, LVar6, LVar8, 0)
    EndThread
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Run)
    Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Run)
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Loop(3)
        Call(GetNpcYaw, NPC_Kooper_01A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_01A, LVar0, 0)
        Call(GetNpcYaw, NPC_Kooper_02A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_02A, LVar0, 0)
        Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Wait(5 * DT)
    EndLoop
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Add(LVar2, -30)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Thread
        Call(SetNpcJumpscale, NPC_Kooper_01A, Float(1.0))
        Call(NpcJump1, NPC_Kooper_01A, LVar0, LVar1, LVar2, 20 * DT)
    EndThread
    Call(SetNpcJumpscale, NPC_Kooper_02A, Float(1.0))
    Call(NpcJump1, NPC_Kooper_02A, LVar0, LVar1, LVar2, 20 * DT)
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Loop(3)
        Call(GetNpcYaw, NPC_Kooper_01A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_01A, LVar0, 0)
        Call(GetNpcYaw, NPC_Kooper_02A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_02A, LVar0, 0)
        Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Wait(5 * DT)
    EndLoop
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Add(LVar0, 55)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Thread
        Call(SetNpcJumpscale, NPC_Kooper_01A, Float(0.0))
        Call(NpcJump1, NPC_Kooper_01A, LVar0, LVar1, LVar2, 20 * DT)
    EndThread
    Call(SetNpcJumpscale, NPC_Kooper_02A, Float(0.0))
    Call(NpcJump1, NPC_Kooper_02A, LVar0, LVar1, LVar2, 20 * DT)
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Loop(5)
        Call(GetNpcYaw, NPC_Kooper_01A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_01A, LVar0, 0)
        Call(GetNpcYaw, NPC_Kooper_02A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_02A, LVar0, 0)
        Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Wait(4 * DT)
    EndLoop
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
    Add(LVar2, 30)
    Thread
        Call(SetNpcJumpscale, NPC_Kooper_01A, Float(1.0))
        Call(NpcJump1, NPC_Kooper_01A, LVar0, LVar1, LVar2, 20 * DT)
    EndThread
    Call(SetNpcJumpscale, NPC_Kooper_02A, Float(1.0))
    Call(NpcJump1, NPC_Kooper_02A, LVar0, LVar1, LVar2, 20 * DT)
    Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
    Loop(6)
        Call(GetNpcYaw, NPC_Kooper_01A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_01A, LVar0, 0)
        Call(GetNpcYaw, NPC_Kooper_02A, LVar0)
        Add(LVar0, 180)
        Call(InterpNpcYaw, NPC_Kooper_02A, LVar0, 0)
        Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Wait(6 * DT)
    EndLoop
    Call(StopSound, SOUND_LOOP_FIGHTING)
    KillThread(MV_KoopersFightingScript)
    Call(RandInt, 100, LVar0)
    IfGt(LVar0, 50)
        Thread
            Call(InterpNpcYaw, NPC_Kooper_01A, 270, 0)
            Call(SetNpcJumpscale, NPC_Kooper_01A, Float(2.0))
            Call(NpcJump1, NPC_Kooper_01A, -1062, -120, -37, 15 * DT)
        EndThread
        Thread
            Call(InterpNpcYaw, NPC_Kooper_02A, 90, 0)
            Call(SetNpcJumpscale, NPC_Kooper_02A, Float(2.0))
            Call(NpcJump1, NPC_Kooper_02A, -1172, -120, -37, 15 * DT)
        EndThread
    Else
        Call(GetPlayerPos, LVar0, LVar1, LVar2)
        Thread
            Call(InterpNpcYaw, NPC_Kooper_01A, 90, 0)
            Call(SetNpcJumpscale, NPC_Kooper_01A, Float(2.0))
            Call(NpcJump1, NPC_Kooper_01A, -1172, -120, -37, 15 * DT)
        EndThread
        Thread
            Call(InterpNpcYaw, NPC_Kooper_02A, 270, 0)
            Call(SetNpcJumpscale, NPC_Kooper_02A, Float(2.0))
            Call(NpcJump1, NPC_Kooper_02A, -1062, -120, -37, 15 * DT)
        EndThread
    EndIf
    Wait(30 * DT)
    Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Idle)
    Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Idle)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(GetNpcPos, NPC_Kooper_01A, LVar3, LVar4, LVar5)
    AddF(LVar3, LVar0)
    AddF(LVar4, LVar1)
    AddF(LVar5, LVar2)
    DivF(LVar3, Float(2.0))
    DivF(LVar4, Float(2.0))
    DivF(LVar5, Float(2.0))
    Call(GetNpcPos, NPC_Kooper_02A, LVar6, LVar7, LVar8)
    AddF(LVar6, LVar0)
    AddF(LVar7, LVar1)
    AddF(LVar8, LVar2)
    DivF(LVar6, Float(2.0))
    DivF(LVar7, Float(2.0))
    DivF(LVar8, Float(2.0))
    Call(RandInt, 100, LVar0)
    IfGt(LVar0, 50)
        Call(UseSettingsFrom, CAM_DEFAULT, LVar3, LVar4, LVar5)
        Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
        Call(SetCamDistance, CAM_DEFAULT, Float(205.0))
        Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-9.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0125)
        Call(SetPanTarget, CAM_DEFAULT, LVar6, LVar7, LVar8)
        Call(SetCamSpeed, CAM_DEFAULT, Float(1.5 / DT))
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0124)
        Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0127)
        Call(SetPanTarget, CAM_DEFAULT, LVar6, LVar7, LVar8)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0126)
        Call(GetPlayerPos, LVar0, LVar1, LVar2)
        Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0129)
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0128)
    Else
        Call(UseSettingsFrom, CAM_DEFAULT, LVar6, LVar7, LVar8)
        Call(SetPanTarget, CAM_DEFAULT, LVar6, LVar7, LVar8)
        Call(SetCamDistance, CAM_DEFAULT, Float(205.0))
        Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-9.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0124)
        Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
        Call(SetCamSpeed, CAM_DEFAULT, Float(1.0 / DT))
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0125)
        Call(SetPanTarget, CAM_DEFAULT, LVar6, LVar7, LVar8)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0126)
        Call(SetPanTarget, CAM_DEFAULT, LVar3, LVar4, LVar5)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0127)
        Call(GetPlayerPos, LVar0, LVar1, LVar2)
        Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(PlayerFaceNpc, NPC_Kooper_02A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_02A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0128)
        Call(PlayerFaceNpc, NPC_Kooper_01A, FALSE)
        Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, MSG_CH7_0129)
    EndIf
    Call(SetNpcFlagBits, NPC_Kooper_01A, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(SetNpcFlagBits, NPC_Kooper_02A, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(DisablePlayerInput, FALSE)
    Call(SetPlayerFlagBits, PS_FLAG_NO_CHANGE_PARTNER | PS_FLAG_NO_PARTNER_USAGE, TRUE)
    Return
    End
};

EvtScript N(EVS_Scene_HitFakeKooper) = {
    Call(DisablePlayerInput, TRUE)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(250.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-8.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(SetNpcAnimation, NPC_Kooper_02A, ANIM_WorldKooper_Hurt)
    Wait(20 * DT)
    Call(PlaySoundAtNpc, NPC_Kooper_02A, SOUND_GHOST_TRANSFORM, SOUND_SPACE_DEFAULT)
    Loop(10)
        Call(GetNpcPos, NPC_Kooper_02A, LVar0, LVar1, LVar2)
        Add(LVar2, 3)
        Call(N(PlayBigSmokePuff), LVar0, LVar1, LVar2)
        Wait(5 * DT)
    EndLoop
    Call(PlaySoundAtNpc, NPC_Kooper_02A, SOUND_SMOKE_BURST, SOUND_SPACE_DEFAULT)
    Call(SetNpcPos, NPC_Kooper_02A, NPC_DISPOSE_LOCATION)
    Call(EnableNpcShadow, NPC_Kooper_02A, FALSE)
    Call(SetNpcPos, NPC_Duplighost, LVar0, LVar1, LVar2)
    Call(MakeLerp, 0, 2880, 40 * DT, EASING_QUADRATIC_OUT)
    Label(1)
    Call(UpdateLerp)
    Call(SetNpcRotation, NPC_Duplighost, 0, LVar0, 0)
    Wait(1)
    IfEq(LVar1, 1)
        Goto(1)
    EndIf
    Call(GetAngleToPlayer, NPC_Duplighost, LVar0)
    Call(InterpNpcYaw, NPC_Duplighost, LVar0, 0)
    Thread
        Set(MF_KooperDoneMoving, FALSE)
        Call(GetAngleToNPC, NPC_Kooper_01A, LVar0)
        Call(GetPlayerPos, LVar1, LVar2, LVar3)
        Call(AddVectorPolar, LVar1, LVar3, Float(40.0), LVar0)
        Call(SetNpcSpeed, NPC_Kooper_01A, Float(3.0 / DT))
        Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Run)
        Call(SetNpcFlagBits, NPC_Kooper_01A, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
        Call(NpcMoveTo, NPC_Kooper_01A, LVar1, LVar3, 0)
        Call(SetNpcAnimation, NPC_Kooper_01A, ANIM_WorldKooper_Idle)
        Set(MF_KooperDoneMoving, TRUE)
    EndThread
    Call(PlayerFaceNpc, NPC_Duplighost, FALSE)
    Call(SpeakToPlayer, NPC_Duplighost, ANIM_Duplighost_Anim05, ANIM_Duplighost_Anim02, 0, MSG_CH7_0130)
    Label(0)
    IfEq(MF_KooperDoneMoving, FALSE)
        Wait(1)
        Goto(0)
    EndIf
    Call(SpeakToPlayer, NPC_Kooper_01A, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 5, MSG_CH7_0131)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Duplighost, ANIM_Duplighost_Anim05, ANIM_Duplighost_Anim02, 0, MSG_CH7_0132)
    Call(SetNpcAnimation, NPC_Duplighost, ANIM_Duplighost_Anim06)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(GetNpcPos, NPC_Kooper_01A, LVar0, LVar1, LVar2)
    Call(SetNpcPos, NPC_Kooper_01A, NPC_DISPOSE_LOCATION)
    Call(EnableNpcShadow, NPC_Kooper_01A, FALSE)
    Call(SetNpcPos, NPC_PARTNER, LVar0, LVar1, LVar2)
    Call(GetNpcYaw, NPC_Kooper_01A, LVar0)
    Call(SetNpcYaw, NPC_PARTNER, LVar0)
    Call(SetNpcFlagBits, NPC_PARTNER, NPC_FLAG_INVISIBLE | NPC_FLAG_INACTIVE, FALSE)
    Call(EnableNpcShadow, NPC_PARTNER, TRUE)
    Call(EnablePartnerAI)
    Call(SetNpcVar, NPC_Duplighost, 0, 1)
    Return
    End
};

EvtScript N(EVS_SetupBridge) = {
    Call(ParentColliderToModel, COLLIDER_m1_kabe, MODEL_m1_kabe)
    IfLt(GB_StoryProgress, STORY_CH7_DEFEATED_FIRST_DUPLIGHOST)
        Call(TranslateGroup, MODEL_move1, 0, -120, 0)
        Call(UpdateColliderTransform, COLLIDER_m1_kabe)
        Call(EnableModel, MODEL_m1_kabe, FALSE)
        BindTrigger(Ref(N(EVS_Scene_ImposterAppears)), TRIGGER_AREA_FLAG_SET, AF_SAM_06, 1, 0)
    EndIf
    Return
    End
};
