#include "sam_01.h"
#include "sprite/player.h"

#include "common/GetItemEntityPosition.inc.c"
#include "world/common/todo/GetLeftRightPoints.inc.c"

EvtScript N(EVS_MayorCarryGift) = {
    Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Call(GetNpcPos, NPC_Penguin_09, LVar3, LVar4, LVar5)
    Sub(LVar3, LVar0)
    Sub(LVar4, LVar1)
    Sub(LVar5, LVar2)
    Add(LVar3, 3)
    Add(LVar5, 5)
    Label(0)
        Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
        Add(LVar0, LVar3)
        Add(LVar1, LVar4)
        Add(LVar2, LVar5)
        Call(SetNpcPos, NPC_Penguin_09, LVar0, LVar1, LVar2)
        Set(LVar6, LVar0)
        Sub(LVar6, 10)
        Call(SetItemPos, MV_PresentItemID, LVar6, LVar1, LVar2)
        Wait(1)
        Goto(0)
    Return
    End
};

EvtScript N(EVS_HerringwayCarryPresent) = {
    Call(N(GetItemEntityPosition), MV_PresentItemID, LVarA, LVarB, LVarC)
    Loop(6)
        Call(SetItemPos, MV_PresentItemID, LVarA, LVarB, LVarC)
        Add(LVarC, 10)
        Wait(1)
    EndLoop
    Loop(0)
        Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
        Add(LVar2, 20)
        Call(SetItemPos, MV_PresentItemID, LVar0, LVarB, LVar2)
        Wait(1)
    EndLoop
    Return
    End
};

EvtScript N(EVS_OpenMayorsOfficeDoor) = {
    Call(PlaySoundAtCollider, COLLIDER_ttsn, SOUND_BASIC_DOOR_OPEN, 0)
    Call(MakeLerp, 0, 80, 20, EASING_COS_IN_OUT)
    Loop(0)
        Call(UpdateLerp)
        Call(RotateModel, MODEL_o236, LVar0, 0, -1, 0)
        IfEq(LVar1, 0)
            BreakLoop
        EndIf
        Wait(1)
    EndLoop
    Return
    End
};

EvtScript N(EVS_CloseMayorsOfficeDoor) = {
    Call(MakeLerp, 80, 0, 20, EASING_COS_IN_OUT)
    Loop(0)
        Call(UpdateLerp)
        Call(RotateModel, MODEL_o236, LVar0, 0, -1, 0)
        IfEq(LVar1, 0)
            BreakLoop
        EndIf
        Wait(1)
    EndLoop
    Call(PlaySoundAtCollider, COLLIDER_ttsn, SOUND_BASIC_DOOR_CLOSE, 0)
    Return
    End
};

EvtScript N(EVS_Scene_MysteryBegins) = {
    Call(InterruptUsePartner)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetNpcFlagBits, NPC_MayorPenguinWife, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(SetNpcAnimation, NPC_PARTNER, PARTNER_ANIM_IDLE)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, Float(-236.1), Float(0.0), Float(-45.6))
    Call(SetCamPosA, CAM_DEFAULT, Float(-300.0), Float(-53.7))
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(20 * DT)
    ExecWait(N(EVS_OpenMayorsOfficeDoor))
    Thread
        Wait(20 * DT)
        ExecWait(N(EVS_CloseMayorsOfficeDoor))
    EndThread
    Call(SetNpcFlagBits, NPC_MayorPenguinWife, NPC_FLAG_IGNORE_WORLD_COLLISION, TRUE)
    Call(SetNpcPos, NPC_MayorPenguinWife, -255, 0, 28)
    Call(SetNpcSpeed, NPC_MayorPenguinWife, Float(2.0 / DT))
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Walk)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -30, 0)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Idle)
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Talk, ANIM_MayorPenguinWife_Idle, 0, MSG_CH7_0005)
    Call(SetPanTarget, CAM_DEFAULT, -255, 0, -150)
    Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.4 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(DisablePartnerAI, 0)
    Call(SetPlayerPos, -284, 0, -165)
    Call(InterpPlayerYaw, 180, 0)
    Call(SetNpcPos, NPC_PARTNER, -320, 0, -190)
    Call(InterpNpcYaw, NPC_PARTNER, 180, 0)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Walk)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -40, 0)
    Call(SetPlayerAnimation, ANIM_MarioW2_SpeakUp)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -165, 0)
    Call(InterpPlayerYaw, 0, 0)
    Call(InterpNpcYaw, NPC_PARTNER, 0, 0)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -185, 0)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Idle)
    Call(PlaySoundAtNpc, NPC_MayorPenguinWife, SOUND_EMOTE_IDEA, SOUND_SPACE_DEFAULT)
    Call(ShowEmote, NPC_MayorPenguinWife, EMOTE_EXCLAMATION, 0, 30, EMOTER_NPC, 0, 0, 0, 0)
    Wait(30 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Walk)
    Call(SetNpcSpeed, NPC_MayorPenguinWife, Float(0.5 / DT))
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -200, 0)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Inspect)
    Wait(35 * DT)
    Thread
        Call(SetMusicTrack, 0, SONG_PENGUIN_WHODUNIT, 0, 8)
        Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Horror)
        Set(MF_ContinueScene, FALSE)
        Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Horror, ANIM_MayorPenguinWife_Horror, 0, MSG_CH7_0006)
        Set(MF_ContinueScene, TRUE)
    EndThread
    Call(SetMotionBlurParams, 0, 0, 0, 320, 240, 128, 10)
    Loop(5)
        Call(GetNpcPos, NPC_MayorPenguinWife, LVar0, LVar1, LVar2)
        Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetCamDistance, CAM_DEFAULT, Float(210.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(10.0 / DT))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
        Call(GetNpcPos, NPC_MayorPenguinWife, LVar0, LVar1, LVar2)
        Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
        Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
        Call(SetCamSpeed, CAM_DEFAULT, Float(10.0 / DT))
        Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
        Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    EndLoop
    Call(SetMotionBlurParams, 0, 0, 0, 320, 240, 0, 10)
    Label(2)
        IfEq(MF_ContinueScene, FALSE)
            Wait(1)
            Goto(2)
        EndIf
    Wait(20 * DT)
    Call(SetNpcSpeed, NPC_MayorPenguinWife, Float(6.0 / DT))
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Panic)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, 0, 0)
    Call(SetNpcPos, NPC_MayorPenguinWife, -255, 0, 60)
    Wait(30 * DT)
    Set(MF_ContinueScene, FALSE)
    Thread
        Wait(20 * DT)
        Call(SetPlayerAnimation, ANIM_Mario1_Flail)
        Wait(60 * DT)
        Set(MF_ContinueScene, TRUE)
    EndThread
    Call(ShowMessageAtScreenPos, MSG_CH7_0007, 160, 40)
    Label(100)
        IfEq(MF_ContinueScene, FALSE)
            Wait(1)
            Goto(100)
        EndIf
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(SetCamDistance, CAM_DEFAULT, Float(600.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-8.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(0.6 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(InterpPlayerYaw, 180, 5)
    Wait(20 * DT)
    Call(InterpPlayerYaw, 0, 5)
    Wait(90 * DT)
    Thread
        Wait(10 * DT)
        Call(InterpPlayerYaw, 180, 5)
    EndThread
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, Float(-236.1), Float(0.0), Float(-45.6))
    Call(SetCamPosA, CAM_DEFAULT, Float(-300.0), Float(-53.7))
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetNpcPos, NPC_PARTNER, -306, 0, -116)
    Call(SetNpcYaw, NPC_PARTNER, 0)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(30 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Horror, ANIM_MayorPenguinWife_Horror, 5, MSG_CH7_0008)
    Wait(20 * DT)
    ExecWait(N(EVS_OpenMayorsOfficeDoor))
    Thread
        Wait(30 * DT)
        ExecWait(N(EVS_CloseMayorsOfficeDoor))
    EndThread
    Thread
        Set(MF_ContinueScene, FALSE)
        Call(SetNpcPos, NPC_PenguinPatrol, -255, 0, 50)
        Call(SetNpcSpeed, NPC_PenguinPatrol, Float(2.0 / DT))
        Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
        Call(NpcMoveTo, NPC_PenguinPatrol, -255, -75, 0)
        Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
        Set(MF_ContinueScene, TRUE)
    EndThread
    Call(SetNpcPos, NPC_MayorPenguinWife, -255, 0, 80)
    Call(SetNpcSpeed, NPC_MayorPenguinWife, Float(2.0 / DT))
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Walk)
    Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -20, 0)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Idle)
    Label(5)
        IfEq(MF_ContinueScene, FALSE)
            Wait(1)
            Goto(5)
        EndIf
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_PointTalk, ANIM_MayorPenguinWife_Point, 0, MSG_CH7_0009)
    Call(InterpNpcYaw, NPC_PenguinPatrol, 180, 0)
    Wait(30 * DT)
    Call(InterpNpcYaw, NPC_PenguinPatrol, 0, 0)
    Call(SetPanTarget, CAM_DEFAULT, -255, 0, -150)
    Call(SetCamDistance, CAM_DEFAULT, Float(400.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(1.4 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Thread
        Wait(30 * DT)
        Call(PlayerMoveTo, -315, -150, 20 * DT)
        Call(InterpPlayerYaw, 0, 0)
    EndThread
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
    Call(NpcMoveTo, NPC_PenguinPatrol, -255, -180, 0)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Wait(20 * DT)
    Thread
        Set(MF_ContinueScene, FALSE)
        Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Walk)
        Call(NpcMoveTo, NPC_MayorPenguinWife, -255, -70, 0)
        Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Idle)
        Set(MF_ContinueScene, TRUE)
    EndThread
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Inspect)
    Wait(30 * DT)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_000A)
    Label(6)
        IfEq(MF_ContinueScene, FALSE)
            Wait(1)
            Goto(6)
        EndIf
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_PointTalk, ANIM_MayorPenguinWife_Point, 0, MSG_CH7_000B)
    Wait(20 * DT)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, Float(-340.5), Float(0.0), Float(-180.7))
    Call(SetCamPosA, CAM_DEFAULT, Float(-463.0), Float(180.0))
    Call(SetCamPosB, CAM_DEFAULT, Float(-215.0), Float(-175.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(17.5), Float(-8.0))
    Call(SetCamDistance, CAM_DEFAULT, Float(250.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(GetAngleToPlayer, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
    Wait(13 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_000C)
    Call(SetPlayerAnimation, ANIM_MarioW3_ShakeHead)
    Wait(35 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_000D)
    Wait(30 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_PointTalk, ANIM_MayorPenguinWife_Point, 0, MSG_CH7_000E)
    Call(SetPlayerAnimation, ANIM_MarioW3_ShakeHead)
    Wait(20 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_000F)
    Call(SetPlayerAnimation, ANIM_Mario1_NodYes)
    Wait(20 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(GetCurrentPartnerID, LVar0)
    Switch(LVar0)
        CaseEq(PARTNER_GOOMBARIO)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldGoombario_Talk, ANIM_WorldGoombario_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0010)
        CaseEq(PARTNER_KOOPER)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldKooper_Talk, ANIM_WorldKooper_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0011)
        CaseEq(PARTNER_BOMBETTE)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldBombette_Talk, ANIM_WorldBombette_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0012)
        CaseEq(PARTNER_PARAKARRY)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldParakarry_Talk, ANIM_WorldParakarry_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0013)
        CaseEq(PARTNER_BOW)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0014)
        CaseEq(PARTNER_WATT)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldWatt_Talk, ANIM_WorldWatt_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0015)
        CaseEq(PARTNER_SUSHIE)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldSushie_Talk, ANIM_WorldSushie_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0016)
        CaseEq(PARTNER_LAKILESTER)
            Call(SpeakToNpc, NPC_PARTNER, ANIM_WorldLakilester_Talk, ANIM_WorldLakilester_Idle, 0, NPC_PenguinPatrol, MSG_CH7_0017)
    EndSwitch
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_0018)
    Call(SetPlayerAnimation, ANIM_Mario1_NodYes)
    Wait(20 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_TalkThink, ANIM_PenguinPatrol_StillThink, 0, MSG_CH7_0019)
    Call(SetPlayerAnimation, ANIM_Mario1_NodYes)
    Wait(20 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_001A)
    Call(SetNpcPos, NPC_Penguin_05, -150, 0, 0)
    Call(InterpNpcYaw, NPC_Penguin_05, 90, 0)
    Call(SetNpcPos, NPC_Penguin_06, -90, 0, 0)
    Call(InterpNpcYaw, NPC_Penguin_06, 270, 0)
    Call(SetNpcPos, NPC_Penguin_07, -120, 0, -30)
    Call(InterpNpcYaw, NPC_Penguin_07, 180, 0)
    Call(SetNpcPos, NPC_Penguin_08, -120, 0, 30)
    Call(InterpNpcYaw, NPC_Penguin_08, 0, 0)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(SetNpcFlagBits, NPC_MayorPenguinWife, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(EnablePartnerAI)
    Set(GB_StoryProgress, STORY_CH7_MAYOR_MURDER_MYSTERY)
    Set(GB_SAM11_FrozenPondDamage, 0)
    Set(MV_DialogueState_Penguin1, 0)
    Set(MV_DialogueState_Penguin2, 0)
    Set(MV_DialogueState_Penguin3, 0)
    Set(MV_DialogueState_Penguin4, 0)
    Return
    End
};

EvtScript N(EVS_Scene_MysterySolved) = {
    Call(DisablePlayerInput, TRUE)
    Call(GetPartnerInUse, LVar0)
    IfNe(LVar0, PARTNER_NONE)
        Call(InterruptUsePartner)
        Wait(20)
    EndIf
    Thread
        Call(DisablePartnerAI, 0)
        Call(SetNpcAnimation, NPC_PARTNER, PARTNER_ANIM_WALK)
        Call(SetNpcSpeed, NPC_PARTNER, Float(3.0 / DT))
        Call(NpcMoveTo, NPC_PARTNER, -262, -103, 0)
        Call(SetNpcAnimation, NPC_PARTNER, PARTNER_ANIM_IDLE)
    EndThread
    Call(GetAngleToPlayer, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_001D)
    Call(SetPlayerAnimation, ANIM_MarioW2_SpeakUp)
    Wait(40 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Call(GetNpcPos, NPC_PenguinPatrol, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(SetPlayerPos, -255, 0, -135)
    Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_001E)
    Call(GetNpcPos, NPC_PenguinPatrol, LVar0, LVar1, LVar2)
    Sub(LVar2, 10)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
    Call(SetNpcSpeed, NPC_PenguinPatrol, Float(2.0 / DT))
    Call(NpcMoveTo, NPC_PenguinPatrol, LVar0, LVar2, 0)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Wait(20 * DT)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Inspect)
    Wait(30 * DT)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 5, MSG_CH7_001F)
    Call(GetAngleToPlayer, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(SetPlayerAnimation, ANIM_Mario1_NodYes)
    Wait(20 * DT)
    Thread
        Call(GetPlayerPos, LVar0, LVar1, LVar2)
        Sub(LVar0, 20)
        Call(PlayerMoveTo, LVar0, LVar2, 20 * DT)
        Call(PlayerFaceNpc, NPC_Herringway, FALSE)
    EndThread
    Thread
        Call(SetNpcAnimation, NPC_PARTNER, PARTNER_ANIM_WALK)
        Call(NpcMoveTo, NPC_PARTNER, -306, -116, 10 * DT)
        Call(SetNpcAnimation, NPC_PARTNER, PARTNER_ANIM_IDLE)
        Call(NpcFaceNpc, NPC_PARTNER, NPC_Herringway, 0)
    EndThread
    Call(GetNpcPos, NPC_PenguinPatrol, LVar0, LVar1, LVar2)
    Add(LVar2, 20)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
    Call(SetNpcSpeed, NPC_PenguinPatrol, Float(2.0 / DT))
    Call(NpcMoveTo, NPC_PenguinPatrol, LVar0, LVar2, 0)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_0020)
    Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
    Call(GetNpcPos, NPC_PenguinPatrol, LVar3, LVar4, LVar5)
    AddF(LVar0, LVar3)
    AddF(LVar1, LVar4)
    AddF(LVar2, LVar5)
    DivF(LVar0, Float(2.0))
    DivF(LVar1, Float(2.0))
    DivF(LVar2, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Herringway, ANIM_Herringway_Talk, ANIM_Herringway_Idle, 0, MSG_CH7_0021)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Wait(1)
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_Herringway, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_Herringway, LVar0, 0)
    Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
    Wait(1)
    Call(NpcFaceNpc, NPC_PARTNER, NPC_PenguinPatrol, 0)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_TalkThink, ANIM_PenguinPatrol_StillThink, 0, MSG_CH7_0022)
    Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_Herringway, LVar0)
    Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_PenguinPatrol, NPC_Herringway, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(PlayerFaceNpc, NPC_Herringway, FALSE)
    Wait(1)
    Call(NpcFaceNpc, NPC_PARTNER, NPC_Herringway, 0)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Herringway, ANIM_Herringway_Talk, ANIM_Herringway_Idle, 0, MSG_CH7_0023)
    Call(GetAngleBetweenNPCs, NPC_Herringway, NPC_MayorPenguinWife, LVar0)
    Call(InterpNpcYaw, NPC_Herringway, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_PenguinPatrol, NPC_MayorPenguinWife, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(PlayerFaceNpc, NPC_MayorPenguinWife, FALSE)
    Wait(1)
    Call(NpcFaceNpc, NPC_PARTNER, NPC_MayorPenguinWife, 0)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_PointTalk, ANIM_MayorPenguinWife_Point, 0, MSG_CH7_0024)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(17.5), Float(-6.5))
    Call(N(GetLeftRightPoints), LVar0, LVar2, 45)
    Call(SetCamPosA, CAM_DEFAULT, LVar0, LVar1)
    Call(SetCamPosB, CAM_DEFAULT, LVar2, LVar3)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_Herringway, NPC_PenguinPatrol, LVar0)
    Call(InterpNpcYaw, NPC_Herringway, LVar0, 0)
    Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
    Wait(1)
    Call(NpcFaceNpc, NPC_PARTNER, NPC_PenguinPatrol, 0)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_TalkThink, ANIM_PenguinPatrol_StillThink, 0, MSG_CH7_0025)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch)
    Wait(30 * DT)
    Call(PlaySoundAtNpc, NPC_MayorPenguin, SOUND_ACTOR_TWITCH, SOUND_SPACE_DEFAULT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Dead)
    Wait(2 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch)
    Wait(20 * DT)
    Call(PlaySoundAtNpc, NPC_MayorPenguin, SOUND_ACTOR_TWITCH, SOUND_SPACE_DEFAULT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Dead)
    Wait(2 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch)
    Wait(20 * DT)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(N(GetLeftRightPoints), LVar0, LVar2, -95)
    Call(SetCamPosA, CAM_DEFAULT, LVar0, LVar1)
    Call(SetCamPosB, CAM_DEFAULT, LVar2, LVar3)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(FadeOutMusic, 0, 500)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch, ANIM_MayorPenguin_Twitch, 0, MSG_CH7_0026)
    Call(GetAngleBetweenNPCs, NPC_PenguinPatrol, NPC_MayorPenguin, LVar0)
    Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_MayorPenguin, LVar0)
    Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
    Call(GetAngleBetweenNPCs, NPC_Herringway, NPC_MayorPenguin, LVar0)
    Call(InterpNpcYaw, NPC_Herringway, LVar0, 0)
    Call(PlayerFaceNpc, NPC_MayorPenguin, FALSE)
    Call(NpcFaceNpc, NPC_PARTNER, NPC_MayorPenguin, 0)
    Call(PlaySoundAtNpc, NPC_MayorPenguin, SOUND_ACTOR_TWITCH, SOUND_SPACE_DEFAULT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Dead)
    Wait(2 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch)
    Wait(20 * DT)
    Call(PlaySoundAtNpc, NPC_MayorPenguin, SOUND_ACTOR_TWITCH, SOUND_SPACE_DEFAULT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Dead)
    Wait(2 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Twitch)
    Wait(20 * DT)
    Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Add(LVar0, 11)
    Add(LVar2, 10)
    Call(SetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Call(EnableNpcShadow, NPC_MayorPenguin, FALSE)
    Call(SetNpcPos, NPC_MayorDummy, -270, 0, -205)
    Thread
        Wait(30 * DT)
        Call(SetNpcPos, NPC_MayorDummy, NPC_DISPOSE_LOCATION)
        Call(EnableNpcShadow, NPC_MayorPenguin, TRUE)
    EndThread
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_WakeUp)
    Wait(30 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Idle)
    Call(PlaySoundAtNpc, NPC_MayorPenguin, SOUND_NPC_JUMP, SOUND_SPACE_DEFAULT)
    Call(SetNpcJumpscale, NPC_MayorPenguin, Float(1.0))
    Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Call(NpcJump0, NPC_MayorPenguin, LVar0, 0, LVar2, 10 * DT)
    Call(SetMusicTrack, 0, SONG_PENGUIN_WAKES_UP, 0, 8)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_0027)
    Call(InterpNpcYaw, NPC_MayorPenguin, 0, 0)
    Wait(20 * DT)
    Call(InterpNpcYaw, NPC_MayorPenguin, 180, 0)
    Wait(20 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Surprise)
    Call(SetNpcJumpscale, NPC_MayorPenguinWife, Float(1.0))
    Call(GetNpcPos, NPC_MayorPenguinWife, LVar0, LVar1, LVar2)
    Call(NpcJump0, NPC_MayorPenguinWife, LVar0, LVar1, LVar2, 20 * DT)
    Call(SetNpcAnimation, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Idle)
    Call(SpeakToPlayer, NPC_MayorPenguinWife, ANIM_MayorPenguinWife_Talk, ANIM_MayorPenguinWife_Idle, 0, MSG_CH7_0028)
    Wait(30 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_0029)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Wait(1)
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(SpeakToNpc, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, NPC_MayorPenguin, MSG_CH7_002A)
    Wait(10 * DT)
    Call(SpeakToNpc, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, NPC_PenguinPatrol, MSG_CH7_002B)
    Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(280.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_CarryTalk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_002C)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Thread
        Loop(200)
            Call(GetAngleBetweenNPCs, NPC_PenguinPatrol, NPC_MayorPenguin, LVar0)
            Call(InterpNpcYaw, NPC_PenguinPatrol, LVar0, 0)
            Call(GetAngleBetweenNPCs, NPC_Herringway, NPC_MayorPenguin, LVar0)
            Call(InterpNpcYaw, NPC_Herringway, LVar0, 0)
            Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_MayorPenguin, LVar0)
            Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
            Wait(1)
        EndLoop
    EndThread
    Call(SetNpcFlagBits, NPC_Penguin_09, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetNpcSpeed, NPC_MayorPenguin, Float(3.0 / DT))
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Walk)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(NpcMoveTo, NPC_MayorPenguin, -320, -258, 0)
    Call(InterpNpcYaw, NPC_MayorPenguin, 180, 0)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Idle)
    Wait(30 * DT)
    Thread
        Wait(25 * DT)
        Call(GetPlayerPos, LVar0, LVar1, LVar2)
        Sub(LVar0, 30)
        Call(PlayerMoveTo, LVar0, LVar2, 20 * DT)
        Call(PlayerFaceNpc, NPC_MayorPenguin, FALSE)
        Call(NpcFaceNpc, NPC_PARTNER, NPC_MayorPenguin, 0)
        Wait(50 * DT)
        Call(PlayerFaceNpc, NPC_MayorPenguin, FALSE)
        Call(NpcFaceNpc, NPC_PARTNER, NPC_MayorPenguin, 0)
    EndThread
    Thread
        Wait(10 * DT)
        Set(LVar0, 0)
        Loop(8)
            Call(GetNpcPos, NPC_Penguin_09, LVar0, LVar1, LVar2)
            AddF(LVar1, Float(1.25))
            Call(SetNpcPos, NPC_Penguin_09, LVar0, LVar1, LVar2)
            Wait(1)
        EndLoop
    EndThread
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_PickUp)
    Wait(30 * DT)
    ExecGetTID(N(EVS_MayorCarryGift), LVarA)
    Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
    Add(LVar2, -25)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamPosA, CAM_DEFAULT, Float(-300.0), Float(0.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(0.3 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Carry)
    Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
    Add(LVar2, -35)
    Call(NpcMoveTo, NPC_MayorPenguin, LVar0, LVar2, 0)
    KillThread(LVarA)
    Wait(10 * DT)
    Thread
        Wait(10 * DT)
        Loop(7)
            Call(GetNpcPos, NPC_Penguin_09, LVar0, LVar1, LVar2)
            Add(LVar2, 1)
            Call(SetNpcPos, NPC_Penguin_09, LVar0, LVar1, LVar2)
            Wait(1)
        EndLoop
    EndThread
    Wait(30 * DT)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SpeakToNpc, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, NPC_Herringway, MSG_CH7_002D)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Give)
    Wait(60 * DT)
    Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
    Add(LVar2, -5)
    Call(NpcMoveTo, NPC_Herringway, LVar0, LVar2, 0)
    Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Idle)
    Call(SetNpcAnimation, NPC_Herringway, ANIM_Herringway_Recieve)
    Call(SpeakToNpc, NPC_Herringway, ANIM_Herringway_TalkCarry, ANIM_Herringway_IdleCarry, 0, NPC_MayorPenguin, MSG_CH7_002E)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(20 * DT)
    Call(InterpNpcYaw, NPC_MayorPenguin, 0, 0)
    Call(InterpNpcYaw, NPC_MayorPenguinWife, 0, 0)
    Call(InterpNpcYaw, NPC_Herringway, 0, 0)
    Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
    Call(SpeakToPlayer, NPC_PenguinPatrol, ANIM_PenguinPatrol_Talk, ANIM_PenguinPatrol_Idle, 0, MSG_CH7_002F)
    Call(GetNpcPos, NPC_Herringway, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamSpeed, CAM_DEFAULT, Float(0.3 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Thread
        Wait(10 * DT)
        Call(SetNpcSpeed, NPC_MayorPenguin, Float(3.0 / DT))
        Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
        Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Walk)
        Call(NpcMoveTo, NPC_MayorPenguin, -249, -109, 0)
        Call(SetNpcAnimation, NPC_MayorPenguin, ANIM_MayorPenguin_Idle)
        Loop(100)
            Call(GetAngleBetweenNPCs, NPC_MayorPenguin, NPC_PenguinPatrol, LVar0)
            Call(InterpNpcYaw, NPC_MayorPenguin, LVar0, 0)
            Wait(1)
        EndLoop
    EndThread
    Thread
        Loop(100)
            Call(GetAngleBetweenNPCs, NPC_MayorPenguinWife, NPC_PenguinPatrol, LVar0)
            Call(InterpNpcYaw, NPC_MayorPenguinWife, LVar0, 0)
            Call(PlayerFaceNpc, NPC_PenguinPatrol, FALSE)
            Wait(1)
        EndLoop
    EndThread
    Call(SetNpcFlagBits, NPC_PenguinPatrol, NPC_FLAG_IGNORE_PLAYER_COLLISION, TRUE)
    Call(SetNpcSpeed, NPC_PenguinPatrol, Float(3.0 / DT))
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
    Call(NpcMoveTo, NPC_PenguinPatrol, -210, -80, 0)
    Call(NpcMoveTo, NPC_PenguinPatrol, -250, -10, 0)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Call(SetNpcFlagBits, NPC_PenguinPatrol, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    ExecWait(N(EVS_OpenMayorsOfficeDoor))
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Walk)
    Call(NpcMoveTo, NPC_PenguinPatrol, -250, 50, 0)
    Call(SetNpcAnimation, NPC_PenguinPatrol, ANIM_PenguinPatrol_Idle)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_0030)
    Call(SpeakToPlayer, NPC_Herringway, ANIM_Herringway_TalkCarry, ANIM_Herringway_IdleCarry, 0, MSG_CH7_0031)
    ExecGetTID(N(EVS_HerringwayCarryPresent), LVarA)
    Call(SetNpcSpeed, NPC_Herringway, Float(3.0 / DT))
    Call(SetNpcAnimation, NPC_Herringway, ANIM_Herringway_WalkCarry)
    Call(NpcMoveTo, NPC_Herringway, -250, 50, 0)
    Call(SetNpcAnimation, NPC_Herringway, ANIM_Herringway_IdleCarry)
    KillThread(LVarA)
    Call(RemoveItemEntity, MV_PresentItemID)
    ExecWait(N(EVS_CloseMayorsOfficeDoor))
    Set(GB_StoryProgress, STORY_CH7_MAYOR_MURDER_SOLVED)
    Exec(N(EVS_SetupMusic))
    Wait(30 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 5, MSG_CH7_0032)
    Call(GetNpcPos, NPC_MayorPenguin, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetCamDistance, CAM_DEFAULT, Float(250.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(3.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(30 * DT)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_0033)
    Call(SetPlayerAnimation, ANIM_MarioW2_SpeakUp)
    Wait(20 * DT)
    Call(SetPlayerAnimation, ANIM_Mario1_Idle)
    Wait(1)
    Call(SpeakToPlayer, NPC_MayorPenguin, ANIM_MayorPenguin_Talk, ANIM_MayorPenguin_Idle, 0, MSG_CH7_0034)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_PLAYER_COLLISION, FALSE)
    Call(SetNpcPos, NPC_PenguinPatrol, NPC_DISPOSE_LOCATION)
    Call(SetNpcPos, NPC_Herringway, NPC_DISPOSE_LOCATION)
    Call(SetNpcFlagBits, NPC_Herringway, NPC_FLAG_INACTIVE, TRUE)
    Call(EnableNpcShadow, NPC_Herringway, FALSE)
    Call(ResetCam, CAM_DEFAULT, Float(4.0))
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Set(MV_DialogueState_Penguin1, 0)
    Set(MV_DialogueState_Penguin2, 0)
    Set(MV_DialogueState_Penguin3, 0)
    Set(MV_DialogueState_Penguin4, 0)
    Call(SetNpcFlagBits, NPC_MayorPenguin, NPC_FLAG_IGNORE_WORLD_COLLISION, FALSE)
    Call(SetNpcFlagBits, NPC_MayorPenguinWife, NPC_FLAG_IGNORE_WORLD_COLLISION, FALSE)
    Call(SetNpcPos, NPC_Penguin_09, NPC_DISPOSE_LOCATION)
    Call(EnablePartnerAI)
    Call(DisablePlayerInput, FALSE)
    Return
    End
};
