#include "obk_09.h"
#include "sprite.h"
#include "sprite/player.h"

#include "world/common/util/ChangeNpcToPartner.inc.c"

EvtScript N(EVS_Scene_MeetBow) = {
    IfGe(GB_StoryProgress, STORY_CH3_BOW_JOINED_PARTY)
        Return
    EndIf
    Set(GB_StoryProgress, STORY_CH3_BOW_JOINED_PARTY)
    Call(DisablePlayerInput, TRUE)
    Call(SetMusicTrack, 0, SONG_CHEERFUL_BOOS_MANSION, 0, 8)
    Thread
        Wait(10 * DT)
        Call(SetPlayerPos, -180, 0, 344)
        Call(SetNpcPos, NPC_PARTNER, -180, 20, 344)
        Call(PlayerMoveTo, 0, 190, 60 * DT)
        Call(SetPlayerAnimation, ANIM_MarioW2_JoltAwake)
    EndThread
    Wait(10 * DT)
    Call(SetCamType, CAM_DEFAULT, 4, TRUE)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(5.0), Float(-9.0))
    Call(SetCamDistance, CAM_DEFAULT, 500)
    Call(SetCamPosA, CAM_DEFAULT, 200, 280)
    Call(SetCamPosB, CAM_DEFAULT, 0, 110)
    Call(SetCamPosC, CAM_DEFAULT, 0, 0)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(48 * DT)
    Call(ShowMessageAtScreenPos, MSG_CH3_0042, 160, 40)
    KillThread(LVarA)
    Call(InterpPlayerYaw, 40, 0)
    Call(SetPlayerAnimation, SPRITE_ID_BACK_FACING | ANIM_Mario1_Idle)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0 / DT))
    Call(SetCamPitch, CAM_DEFAULT, Float(4.0), Float(-9.0))
    Call(SetCamDistance, CAM_DEFAULT, 400)
    Call(SetCamPosA, CAM_DEFAULT, 200, 300)
    Call(SetCamPosB, CAM_DEFAULT, -20, 10)
    Call(SetCamPosC, CAM_DEFAULT, 0, 60)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Wait(20 * DT)
    Call(SetNpcPos, NPC_Bow, -10, 80, -35)
    Call(SetNpcPos, NPC_Bootler, 30, 70, -75)
    Call(SetNpcYaw, NPC_Bow, 270)
    Call(SetNpcYaw, NPC_Bootler, 270)
    Call(PlaySoundAtNpc, NPC_Bow, SOUND_BOO_VANISH_A, SOUND_SPACE_DEFAULT)
    SetF(LVar0, Float(0.0))
    Loop(20 * DT)
        AddF(LVar0, Float(240.0 / (s32)(20 * DT)))
        Call(SetNpcImgFXParams, NPC_Bow, IMGFX_SET_ALPHA, LVar0, 0, 0, 0)
        Call(SetNpcImgFXParams, NPC_Bootler, IMGFX_SET_ALPHA, LVar0, 0, 0, 0)
        Wait(1)
    EndLoop
    Wait(40 * DT)
    Call(UseSettingsFrom, CAM_DEFAULT, 0, 50, -70)
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(3.0), Float(-10.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetPanTarget, CAM_DEFAULT, 0, 50, -70)
    Wait(20 * DT)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, MSG_CH3_0043)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Talk, ANIM_Bootler_Idle, 0, MSG_CH3_0044)
    Wait(10)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, MSG_CH3_0045)
    Wait(20)
    Call(InterpNpcYaw, NPC_Bow, 225, 0)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Talk, ANIM_Bootler_Idle, 0, MSG_CH3_0046)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, 20, 50, -70)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Talk, ANIM_Bootler_Idle, 0, MSG_CH3_0047)
    Call(SetCamType, CAM_DEFAULT, 4, TRUE)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.5), Float(-9.5))
    Call(SetCamDistance, CAM_DEFAULT, 550)
    Call(SetCamPosA, CAM_DEFAULT, 200, 300)
    Call(SetCamPosB, CAM_DEFAULT, 0, 80)
    Call(SetCamPosC, CAM_DEFAULT, 0, 0)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Dejected, ANIM_Bootler_Quaver, 0, MSG_CH3_0048)
    Call(UseSettingsFrom, CAM_DEFAULT, 0, 50, -70)
    Call(SetCamDistance, CAM_DEFAULT, 300)
    Call(SetCamPitch, CAM_DEFAULT, Float(3.0), Float(-10.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetPanTarget, CAM_DEFAULT, 20, 50, -70)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Talk, ANIM_Bootler_Idle, 0, MSG_CH3_0049)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0))
    Call(SetPanTarget, CAM_DEFAULT, 0, 50, -70)
    Wait(10 * DT)
    Call(InterpNpcYaw, NPC_Bow, 270, 0)
    Wait(10 * DT)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 5, MSG_CH3_004A)
    Call(InterpNpcYaw, NPC_Bow, 90, 0)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 5, MSG_CH3_004B)
    Call(SetCamDistance, CAM_DEFAULT, 550)
    Call(SetCamPitch, CAM_DEFAULT, Float(3.0), Float(-12.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(10 * DT)
    Call(EnableGroup, MODEL_ori, TRUE)
    Call(SetNpcPos, NPC_Skolar, 1, 650, 80)
    Call(EnableNpcShadow, NPC_Skolar, FALSE)
    Call(PlaySoundAtNpc, NPC_Skolar, SOUND_LOOP_OBK_LOWER_CHAIN, SOUND_SPACE_DEFAULT)
    Call(MakeLerp, -280, -480, 100 * DT, EASING_QUADRATIC_IN)
    Loop(0)
        Call(UpdateLerp)
        Call(TranslateGroup, MODEL_ori, 0, LVar0, 0)
        Add(LVar0, 650)
        Call(SetNpcPos, NPC_Skolar, 1, LVar0, 80)
        Wait(1)
        IfEq(LVar1, 0)
            BreakLoop
        EndIf
    EndLoop
    Call(StopSound, SOUND_LOOP_OBK_LOWER_CHAIN)
    Call(PlaySoundAtNpc, NPC_Skolar, SOUND_OBK_CAGE_SLAM, SOUND_SPACE_DEFAULT)
    Call(ShakeCam, CAM_DEFAULT, 0, 15, Float(0.2))
    Wait(40 * DT)
    Call(SetCamType, CAM_DEFAULT, 4, TRUE)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(30.0), Float(-18.0))
    Call(SetCamDistance, CAM_DEFAULT, 500)
    Call(SetCamPosA, CAM_DEFAULT, 0, 350)
    Call(SetCamPosB, CAM_DEFAULT, 0, 0)
    Call(SetCamPosC, CAM_DEFAULT, 0, 0)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(20 * DT)
    Call(SpeakToPlayer, NPC_Skolar, ANIM_WorldSkolar_TalkRelaxed, ANIM_WorldSkolar_IdleSad, 0, MSG_CH3_004C)
    Call(UseSettingsFrom, CAM_DEFAULT, 0, 50, -70)
    Call(SetCamDistance, CAM_DEFAULT, 300)
    Call(SetCamPitch, CAM_DEFAULT, Float(3.0), Float(-10.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(SetPanTarget, CAM_DEFAULT, 0, 50, -70)
    Wait(20 * DT)
    Thread
        Wait(30 * DT)
        Call(SetNpcPos, NPC_Skolar, 1, 620, 80)
        Call(EnableNpcShadow, NPC_Skolar, FALSE)
        Call(PlaySoundAtNpc, NPC_Skolar, SOUND_LOOP_OBK_LOWER_CHAIN, SOUND_SPACE_DEFAULT)
        Call(MakeLerp, -480, -280, 100 * DT, EASING_QUADRATIC_IN)
        Loop(0)
            Call(UpdateLerp)
            Call(TranslateGroup, MODEL_ori, 0, LVar0, 0)
            Add(LVar0, 640)
            Call(SetNpcPos, NPC_Skolar, 1, LVar0, 80)
            Wait(1)
            IfEq(LVar1, 0)
                BreakLoop
            EndIf
        EndLoop
        Call(StopSound, SOUND_LOOP_OBK_LOWER_CHAIN)
        Call(EnableGroup, MODEL_ori, FALSE)
    EndThread
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, MSG_CH3_004D)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Panic, ANIM_Bootler_Shock, 0, MSG_CH3_004E)
    Call(SpeakToNpc, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, NPC_Bootler, MSG_CH3_004F)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Flail, ANIM_Bootler_Quaver, 0, MSG_CH3_0050)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_SpookLoop, ANIM_WorldBow_Idle, 0, MSG_CH3_0051)
    Call(SpeakToPlayer, NPC_Bootler, ANIM_Bootler_Dejected, ANIM_Bootler_Quaver, 0, MSG_CH3_0052)
    Call(SetCamSpeed, CAM_DEFAULT, Float(2.0 / DT))
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(UseSettingsFrom, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(SetPanTarget, CAM_DEFAULT, LVar0, LVar1, LVar2)
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(PanToTarget, CAM_DEFAULT, 0, FALSE)
    Call(SetNpcJumpscale, NPC_Bow, 0)
    Call(GetNpcPos, NPC_Bow, LVar0, LVar1, LVar2)
    Sub(LVar1, 40)
    Add(LVar2, 150)
    Call(NpcJump0, NPC_Bow, LVar0, LVar1, LVar2, 25 * DT)
    Call(SpeakToPlayer, NPC_Bow, ANIM_WorldBow_Talk, ANIM_WorldBow_Idle, 0, MSG_CH3_0053)
    Call(N(ChangeNpcToPartner), 0, 9)
    Call(N(LoadPartyImage))
    Exec(N(EVS_PlayNewPartnerSong))
    Wait(15 * DT)
    Call(ShowMessageAtScreenPos, MSG_Menus_018D, 160, 40)
    Exec(N(EVS_ResetMusic))
    Wait(10 * DT)
    Wait(10 * DT)
    Call(DisablePartnerAI, 0)
    Call(SpeakToPlayer, NPC_PARTNER, ANIM_WorldBow_Celebrate, ANIM_WorldBow_Celebrate, 0, MSG_CH3_0054)
    Call(EnablePartnerAI)
    Call(DisablePlayerInput, FALSE)
    Return
    End
};
