#include "nok_12.h"

#include "world/common/DisableCameraLeadingPlayer.inc.c"
#include "world/common/EnableCameraLeadingPlayer.inc.c"

EvtScript N(EVS_Scene_BuildBridge) = {
    Call(DisablePlayerInput, TRUE)
    Wait(20)
    Call(DisablePlayerPhysics, TRUE)
    SetGroup(EVT_GROUP_NEVER_PAUSE)
    Call(SetTimeFreezeMode, TIME_FREEZE_PARTIAL)
    Call(N(DisableCameraLeadingPlayer))
    Call(InterpCamTargetPos, CAM_DEFAULT, 1, -272, 0, -56, 20)
    Wait(15)
    Call(PlaySoundAt, SOUND_NOK_BRIDGE_THUD_1, SOUND_SPACE_DEFAULT, -275, 0, -39)
    Call(MakeLerp, -320, 0, 15, EASING_QUADRATIC_IN)
    Label(10)
    Call(UpdateLerp)
    Call(TranslateGroup, MODEL_hashi, 0, LVar0, 0)
    Wait(1)
    IfNe(LVar1, 0)
        Goto(10)
    EndIf
    Loop(6)
        Call(TranslateGroup, MODEL_hashi, 0, 3, 0)
        Wait(1)
        Call(TranslateGroup, MODEL_hashi, 0, 0, 0)
        Wait(1)
    EndLoop
    Wait(15)
    Call(PlaySoundAt, SOUND_NOK_BRIDGE_THUD_2, SOUND_SPACE_DEFAULT, -275, 0, -39)
    Call(MakeLerp, 0, 90, 10, EASING_QUADRATIC_IN)
    Label(20)
    Call(UpdateLerp)
    Call(RotateModel, MODEL_o97, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o95, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o94, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o96, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o93, LVar0, -1, 0, 0)
    Call(TranslateModel, MODEL_o91, 0, -80, 0)
    Call(TranslateModel, MODEL_o101, 0, -80, 0)
    Call(TranslateModel, MODEL_o92, 0, -80, 0)
    Call(TranslateModel, MODEL_o99, 0, -80, 0)
    Call(TranslateModel, MODEL_o100, 0, -80, 0)
    Call(RotateModel, MODEL_o91, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o101, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o92, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o99, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o100, LVar0, -1, 0, 0)
    Call(TranslateModel, MODEL_o91, 0, 80, 0)
    Call(TranslateModel, MODEL_o101, 0, 80, 0)
    Call(TranslateModel, MODEL_o92, 0, 80, 0)
    Call(TranslateModel, MODEL_o99, 0, 80, 0)
    Call(TranslateModel, MODEL_o100, 0, 80, 0)
    Wait(1)
    IfNe(LVar1, 0)
        Goto(20)
    EndIf
    Wait(10)
    Call(PlaySoundAt, SOUND_NOK_BRIDGE_THUD_3, SOUND_SPACE_DEFAULT, -275, 0, -39)
    Call(MakeLerp, 0, 90, 10, EASING_QUADRATIC_IN)
    Label(30)
    Call(UpdateLerp)
    Call(TranslateModel, MODEL_o91, 0, -80, 0)
    Call(TranslateModel, MODEL_o101, 0, -80, 0)
    Call(TranslateModel, MODEL_o92, 0, -80, 0)
    Call(TranslateModel, MODEL_o99, 0, -80, 0)
    Call(TranslateModel, MODEL_o100, 0, -80, 0)
    Call(RotateModel, MODEL_o91, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o101, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o92, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o99, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o100, 90, -1, 0, 0)
    Call(TranslateModel, MODEL_o91, 0, 80, 0)
    Call(TranslateModel, MODEL_o101, 0, 80, 0)
    Call(TranslateModel, MODEL_o92, 0, 80, 0)
    Call(TranslateModel, MODEL_o99, 0, 80, 0)
    Call(TranslateModel, MODEL_o100, 0, 80, 0)
    Call(RotateModel, MODEL_o91, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o101, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o92, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o99, LVar0, -1, 0, 0)
    Call(RotateModel, MODEL_o100, LVar0, -1, 0, 0)
    Wait(1)
    IfNe(LVar1, 0)
        Goto(30)
    EndIf
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_CLEAR_BITS, COLLIDER_o204, COLLIDER_FLAGS_UPPER_MASK)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_tt1, COLLIDER_FLAGS_UPPER_MASK)
    Wait(10)
    Call(GetPlayerPos, LVar0, LVar1, LVar2)
    Call(InterpCamTargetPos, CAM_DEFAULT, 1, LVar0, LVar1, LVar2, 10)
    Call(N(EnableCameraLeadingPlayer))
    Call(SetTimeFreezeMode, TIME_FREEZE_NONE)
    Call(DisablePlayerPhysics, FALSE)
    Call(DisablePlayerInput, FALSE)
    Set(GB_StoryProgress, STORY_CH1_MADE_FIRST_BRIDGE)
    Call(SetGroupVisibility, MODEL_off, MODEL_GROUP_HIDDEN)
    Unbind
    Return
    End
};

EvtScript N(EVS_SetupBridge) = {
    IfLt(GB_StoryProgress, STORY_CH1_MADE_FIRST_BRIDGE)
        BindTrigger(Ref(N(EVS_Scene_BuildBridge)), TRIGGER_AREA_FLAG_SET, AF_NOK12_HitSwitch, 1, 0)
        Call(TranslateGroup, MODEL_hashi, 0, -320, 0)
        Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_o204, COLLIDER_FLAGS_UPPER_MASK)
        Return
    EndIf
    Call(SetGroupVisibility, MODEL_off, MODEL_GROUP_HIDDEN)
    Call(RotateModel, MODEL_o97, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o95, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o94, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o96, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o93, 90, -1, 0, 0)
    Call(TranslateModel, MODEL_o91, 0, -80, 0)
    Call(TranslateModel, MODEL_o101, 0, -80, 0)
    Call(TranslateModel, MODEL_o92, 0, -80, 0)
    Call(TranslateModel, MODEL_o99, 0, -80, 0)
    Call(TranslateModel, MODEL_o100, 0, -80, 0)
    Call(RotateModel, MODEL_o91, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o101, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o92, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o99, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o100, 90, -1, 0, 0)
    Call(TranslateModel, MODEL_o91, 0, 80, 0)
    Call(TranslateModel, MODEL_o101, 0, 80, 0)
    Call(TranslateModel, MODEL_o92, 0, 80, 0)
    Call(TranslateModel, MODEL_o99, 0, 80, 0)
    Call(TranslateModel, MODEL_o100, 0, 80, 0)
    Call(RotateModel, MODEL_o91, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o101, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o92, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o99, 90, -1, 0, 0)
    Call(RotateModel, MODEL_o100, 90, -1, 0, 0)
    Call(ModifyColliderFlags, MODIFY_COLLIDER_FLAGS_SET_BITS, COLLIDER_tt1, COLLIDER_FLAGS_UPPER_MASK)
    Return
    End
};
