#include "kkj_26.h"
#include "sprite/player.h"

EvtScript N(EVS_Scene_WhereIsMario) = {
    Call(DisablePlayerInput, TRUE)
    Call(DisablePlayerPhysics, TRUE)
    Call(SetMusicTrack, 0, SONG_PRISONER_PEACH_THEME, 1, 8)
    Call(DisablePartnerAI, 0)
    Call(SetNpcPos, NPC_PARTNER, 0, -500, 0)
    Call(RotateModel, MODEL_o85, 80, 0, -1, 0)
    Call(RotateModel, MODEL_o83, 80, 0, 1, 0)
    Call(RotateModel, MODEL_o86, 80, 0, -1, 0)
    Call(RotateModel, MODEL_o84, 80, 0, 1, 0)
    Call(UseSettingsFrom, CAM_DEFAULT, 550, 30, -20)
    Call(SetCamDistance, CAM_DEFAULT, Float(200.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(17.5), Float(-10.0))
    Call(SetCamPosB, CAM_DEFAULT, Float(570.0), 0)
    Call(SetCamSpeed, CAM_DEFAULT, Float(90.0))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Wait(50)
    Call(func_802D1270, 550, -20, Float(2.0))
    Wait(30)
    Call(SetPlayerAnimation, ANIM_Peach2_RaiseArms)
    Wait(10)
    Call(SetPlayerAnimation, ANIM_Peach2_TalkIdle)
    Call(SpeakToPlayer, NPC_PLAYER, ANIM_Peach2_Talk, ANIM_Peach2_TalkIdle, 5, MSG_Peach_0032)
    Call(FadeOutMusic, 0, 4000)
    Call(ResetCam, CAM_DEFAULT, Float(1.0))
    ExecWait(N(EVS_GotoMap_hos_00_1))
    Call(EnablePartnerAI)
    Call(DisablePlayerPhysics, FALSE)
    Call(DisablePlayerInput, FALSE)
    Return
    End
};

EvtScript N(EVS_Scene_AfterAllSpiritsRescued) = {
    Call(DisablePlayerInput, TRUE)
    Call(DisablePartnerAI, 0)
    Call(SetMusicTrack, 0, SONG_PRISONER_PEACH_THEME, 1, 8)
    Call(InterpPlayerYaw, 90, 0)
    Call(SetNpcPos, NPC_PARTNER, 500, 50, 0)
    Call(SetNpcYaw, NPC_PARTNER, 90)
    Wait(30 * DT)
    Call(UseSettingsFrom, CAM_DEFAULT, 500, 30, -20)
    Call(SetCamDistance, CAM_DEFAULT, Float(300.0))
    Call(SetCamPitch, CAM_DEFAULT, Float(15.0), Float(-7.0))
    Call(SetCamSpeed, CAM_DEFAULT, Float(3.0 / DT))
    Call(PanToTarget, CAM_DEFAULT, 0, TRUE)
    Call(WaitForCam, CAM_DEFAULT, Float(1.0))
    Call(SetPlayerAnimation, ANIM_Peach2_RaiseArms)
    Wait(10 * DT)
    Call(SetPlayerAnimation, ANIM_Peach2_TalkIdle)
    Call(SpeakToPlayer, NPC_PLAYER, ANIM_Peach2_Talk, ANIM_Peach2_TalkIdle, 5, MSG_Peach_015E)
    Call(SetPlayerAnimation, ANIM_Peach2_LowerArms)
    Wait(10 * DT)
    Call(SetPlayerAnimation, ANIM_Peach1_Idle)
    Call(SpeakToPlayer, NPC_PARTNER, ANIM_Twink_Talk, ANIM_Twink_Idle, 5, MSG_Peach_015F)
    Call(PlayerFaceNpc, NPC_PARTNER, 5)
    Call(SpeakToPlayer, NPC_PLAYER, ANIM_Peach3_InformalTalk, ANIM_Peach1_Idle, 5, MSG_Peach_0160)
    Wait(10 * DT)
    Call(EnablePartnerAI)
    Call(func_802D1270, 480, -20, Float(2.0 / DT))
    Call(SetPlayerAnimation, ANIM_Peach2_OpenDoors)
    Set(LVar0, kkj_26_ENTRY_0)
    Set(LVar1, COLLIDER_ttw)
    Set(LVar2, MODEL_o85)
    Set(LVar3, MODEL_o83)
    Set(LVar4, MODEL_o86)
    Set(LVar5, MODEL_o84)
    Exec(ExitSplitDoubleDoor)
    Wait(17 * DT)
    Call(GotoMap, Ref("kkj_14"), kkj_14_ENTRY_A)
    Wait(100)
    Call(DisablePlayerInput, FALSE)
    Return
    End
};
