#include "common.h"
#include "ld_addrs.h"
#include "charset/charset.h"

extern IMG_BIN MsgCharImgTitle[];
extern IMG_BIN MsgCharImgSubtitle[];
extern IMG_BIN MsgCharImgNormal[];
extern IMG_BIN MsgCharImgMenuLatin[];
extern IMG_BIN MsgCharImgMenuKana[];
extern IMG_BIN MsgCharImgKana[];
extern IMG_BIN MsgCharImgLatin[];

#if VERSION_JP
u8 MsgCharWidthKana[] = {
    [MSG_CHAR_HIRAGANA_A]          11,
    [MSG_CHAR_HIRAGANA_I]          11,
    [MSG_CHAR_HIRAGANA_U]          10,
    [MSG_CHAR_HIRAGANA_E]          10,
    [MSG_CHAR_HIRAGANA_O]          11,
    [MSG_CHAR_HIRAGANA_KA]         11,
    [MSG_CHAR_HIRAGANA_KI]          9,
    [MSG_CHAR_HIRAGANA_KU]          9,
    [MSG_CHAR_HIRAGANA_KE]         11,
    [MSG_CHAR_HIRAGANA_KO]         10,
    [MSG_CHAR_HIRAGANA_SA]         10,
    [MSG_CHAR_HIRAGANA_SI]          9,
    [MSG_CHAR_HIRAGANA_SU]         11,
    [MSG_CHAR_HIRAGANA_SE]         11,
    [MSG_CHAR_HIRAGANA_SO]         10,
    [MSG_CHAR_HIRAGANA_TA]         11,
    [MSG_CHAR_HIRAGANA_TI]         11,
    [MSG_CHAR_HIRAGANA_TU]         11,
    [MSG_CHAR_HIRAGANA_TE]         11,
    [MSG_CHAR_HIRAGANA_TO]         10,
    [MSG_CHAR_HIRAGANA_NA]         11,
    [MSG_CHAR_HIRAGANA_NI]         11,
    [MSG_CHAR_HIRAGANA_NU]         11,
    [MSG_CHAR_HIRAGANA_NE]         11,
    [MSG_CHAR_HIRAGANA_NO]         11,
    [MSG_CHAR_HIRAGANA_HA]         11,
    [MSG_CHAR_HIRAGANA_HI]         11,
    [MSG_CHAR_HIRAGANA_HU]         11,
    [MSG_CHAR_HIRAGANA_HE]         11,
    [MSG_CHAR_HIRAGANA_HO]         11,
    [MSG_CHAR_HIRAGANA_MA]          9,
    [MSG_CHAR_HIRAGANA_MI]         11,
    [MSG_CHAR_HIRAGANA_MU]         11,
    [MSG_CHAR_HIRAGANA_ME]         11,
    [MSG_CHAR_HIRAGANA_MO]         11,
    [MSG_CHAR_HIRAGANA_YA]         11,
    [MSG_CHAR_HIRAGANA_YU]         11,
    [MSG_CHAR_HIRAGANA_YO]         11,
    [MSG_CHAR_HIRAGANA_RA]         11,
    [MSG_CHAR_HIRAGANA_RI]         11,
    [MSG_CHAR_HIRAGANA_RU]         11,
    [MSG_CHAR_HIRAGANA_RE]         11,
    [MSG_CHAR_HIRAGANA_RO]         11,
    [MSG_CHAR_HIRAGANA_WA]         11,
    [MSG_CHAR_HIRAGANA_WO]         11,
    [MSG_CHAR_HIRAGANA_N]          11,
    [MSG_CHAR_HIRAGANA_VU]         11,
    [MSG_CHAR_HIRAGANA_GA]         11,
    [MSG_CHAR_HIRAGANA_GI]         11,
    [MSG_CHAR_HIRAGANA_GU]         11,
    [MSG_CHAR_HIRAGANA_GE]         11,
    [MSG_CHAR_HIRAGANA_GO]         12,
    [MSG_CHAR_HIRAGANA_ZA]         11,
    [MSG_CHAR_HIRAGANA_ZI]         10,
    [MSG_CHAR_HIRAGANA_ZU]         11,
    [MSG_CHAR_HIRAGANA_ZE]         11,
    [MSG_CHAR_HIRAGANA_ZO]         11,
    [MSG_CHAR_HIRAGANA_DA]         11,
    [MSG_CHAR_HIRAGANA_DI]         11,
    [MSG_CHAR_HIRAGANA_DU]         11,
    [MSG_CHAR_HIRAGANA_DE]         11,
    [MSG_CHAR_HIRAGANA_DO]         11,
    [MSG_CHAR_HIRAGANA_BA]         12,
    [MSG_CHAR_HIRAGANA_BI]         11,
    [MSG_CHAR_HIRAGANA_BU]         11,
    [MSG_CHAR_HIRAGANA_BE]         11,
    [MSG_CHAR_HIRAGANA_BO]         11,
    [MSG_CHAR_HIRAGANA_PA]         12,
    [MSG_CHAR_HIRAGANA_PI]         11,
    [MSG_CHAR_HIRAGANA_PU]         11,
    [MSG_CHAR_HIRAGANA_PE]         11,
    [MSG_CHAR_HIRAGANA_PO]         11,
    [MSG_CHAR_HIRAGANA_SMALL_A]     9,
    [MSG_CHAR_HIRAGANA_SMALL_I]     8,
    [MSG_CHAR_HIRAGANA_SMALL_U]     8,
    [MSG_CHAR_HIRAGANA_SMALL_E]     8,
    [MSG_CHAR_HIRAGANA_SMALL_O]     9,
    [MSG_CHAR_HIRAGANA_SMALL_TU]    9,
    [MSG_CHAR_HIRAGANA_SMALL_YA]    9,
    [MSG_CHAR_HIRAGANA_SMALL_YU]    9,
    [MSG_CHAR_HIRAGANA_SMALL_YO]    8,
    [MSG_CHAR_KATAKANA_A]          11,
    [MSG_CHAR_KATAKANA_I]          10,
    [MSG_CHAR_KATAKANA_U]          10,
    [MSG_CHAR_KATAKANA_E]          11,
    [MSG_CHAR_KATAKANA_O]          11,
    [MSG_CHAR_KATAKANA_KA]         11,
    [MSG_CHAR_KATAKANA_KI]         11,
    [MSG_CHAR_KATAKANA_KU]         10,
    [MSG_CHAR_KATAKANA_KE]         11,
    [MSG_CHAR_KATAKANA_KO]         11,
    [MSG_CHAR_KATAKANA_SA]         11,
    [MSG_CHAR_KATAKANA_SI]         11,
    [MSG_CHAR_KATAKANA_SU]         11,
    [MSG_CHAR_KATAKANA_SE]         11,
    [MSG_CHAR_KATAKANA_SO]         11,
    [MSG_CHAR_KATAKANA_TA]         11,
    [MSG_CHAR_KATAKANA_TI]         11,
    [MSG_CHAR_KATAKANA_TU]         11,
    [MSG_CHAR_KATAKANA_TE]         11,
    [MSG_CHAR_KATAKANA_TO]          8,
    [MSG_CHAR_KATAKANA_NA]         11,
    [MSG_CHAR_KATAKANA_NI]          9,
    [MSG_CHAR_KATAKANA_NU]         11,
    [MSG_CHAR_KATAKANA_NE]         10,
    [MSG_CHAR_KATAKANA_NO]         11,
    [MSG_CHAR_KATAKANA_HA]         11,
    [MSG_CHAR_KATAKANA_HI]         11,
    [MSG_CHAR_KATAKANA_HU]         11,
    [MSG_CHAR_KATAKANA_HE]         11,
    [MSG_CHAR_KATAKANA_HO]         11,
    [MSG_CHAR_KATAKANA_MA]         11,
    [MSG_CHAR_KATAKANA_MI]         10,
    [MSG_CHAR_KATAKANA_MU]         11,
    [MSG_CHAR_KATAKANA_ME]         10,
    [MSG_CHAR_KATAKANA_MO]         11,
    [MSG_CHAR_KATAKANA_YA]         11,
    [MSG_CHAR_KATAKANA_YU]         11,
    [MSG_CHAR_KATAKANA_YO]         10,
    [MSG_CHAR_KATAKANA_RA]         11,
    [MSG_CHAR_KATAKANA_RI]         10,
    [MSG_CHAR_KATAKANA_RU]         11,
    [MSG_CHAR_KATAKANA_RE]         10,
    [MSG_CHAR_KATAKANA_RO]         10,
    [MSG_CHAR_KATAKANA_WA]         10,
    [MSG_CHAR_KATAKANA_WO]         10,
    [MSG_CHAR_KATAKANA_N]          11,
    [MSG_CHAR_KATAKANA_VU]         11,
    [MSG_CHAR_KATAKANA_GA]         11,
    [MSG_CHAR_KATAKANA_GI]         11,
    [MSG_CHAR_KATAKANA_GU]         11,
    [MSG_CHAR_KATAKANA_GE]         11,
    [MSG_CHAR_KATAKANA_GO]         11,
    [MSG_CHAR_KATAKANA_ZA]         11,
    [MSG_CHAR_KATAKANA_ZI]         11,
    [MSG_CHAR_KATAKANA_ZU]         11,
    [MSG_CHAR_KATAKANA_ZE]         11,
    [MSG_CHAR_KATAKANA_ZO]         11,
    [MSG_CHAR_KATAKANA_DA]         11,
    [MSG_CHAR_KATAKANA_DI]         11,
    [MSG_CHAR_KATAKANA_DU]          9,
    [MSG_CHAR_KATAKANA_DE]         11,
    [MSG_CHAR_KATAKANA_DO]         11,
    [MSG_CHAR_KATAKANA_BA]         11,
    [MSG_CHAR_KATAKANA_BI]         11,
    [MSG_CHAR_KATAKANA_BU]         11,
    [MSG_CHAR_KATAKANA_BE]         11,
    [MSG_CHAR_KATAKANA_BO]         11,
    [MSG_CHAR_KATAKANA_PA]         11,
    [MSG_CHAR_KATAKANA_PI]         11,
    [MSG_CHAR_KATAKANA_PU]         11,
    [MSG_CHAR_KATAKANA_PE]         11,
    [MSG_CHAR_KATAKANA_PO]         11,
    [MSG_CHAR_KATAKANA_SMALL_A]     9,
    [MSG_CHAR_KATAKANA_SMALL_I]     8,
    [MSG_CHAR_KATAKANA_SMALL_U]     8,
    [MSG_CHAR_KATAKANA_SMALL_E]     9,
    [MSG_CHAR_KATAKANA_SMALL_O]     9,
    [MSG_CHAR_KATAKANA_SMALL_TU]    9,
    [MSG_CHAR_KATAKANA_SMALL_YA]    9,
    [MSG_CHAR_KATAKANA_SMALL_YU]    9,
    [MSG_CHAR_KATAKANA_SMALL_YO]    8,
    [MSG_CHAR_PROLONGED_SOUND]     11,
    [MSG_CHAR_TILDE]               11,
    [MSG_CHAR_LONGDASH_0]          12,
    [MSG_CHAR_LONGDASH_1]          12,
    [MSG_CHAR_LONGDASH_2]          11,
    [MSG_CHAR_DIGIT_0]             11,
    [MSG_CHAR_DIGIT_1]              8,
    [MSG_CHAR_DIGIT_2]             10,
    [MSG_CHAR_DIGIT_3]             11,
    [MSG_CHAR_DIGIT_4]             11,
    [MSG_CHAR_DIGIT_5]             10,
    [MSG_CHAR_DIGIT_6]             11,
    [MSG_CHAR_DIGIT_7]             11,
    [MSG_CHAR_DIGIT_8]             11,
    [MSG_CHAR_DIGIT_9]             11,
    [MSG_CHAR_UP]                  11,
    [MSG_CHAR_DOWN]                11,
    [MSG_CHAR_LEFT]                12,
    [MSG_CHAR_RIGHT]               12,
    [MSG_CHAR_EXCLAMATION]         11,
    [MSG_CHAR_QUESTION]            10,
    [MSG_CHAR_PLUS]                 9,
    [MSG_CHAR_MINUS]                9,
    [MSG_CHAR_FORWARDSLASH]        11,
    [MSG_CHAR_PERIOD]               8,
    [MSG_CHAR_AND]                 10,
    [MSG_CHAR_HASH]                11,
    [MSG_CHAR_HEART]               11,
    [MSG_CHAR_STAR]                11,
    [MSG_CHAR_LPAREN]               9,
    [MSG_CHAR_RPAREN]               9,
    [MSG_CHAR_TLBRACKET]           11,
    [MSG_CHAR_BRBRACKET]           11,
    [MSG_CHAR_MIDDLE_DOT]           8,
    [MSG_CHAR_HIRAGANA_SMALL_N]     9,
    [MSG_CHAR_KATAKANA_SMALL_N]     9,
    [MSG_CHAR_KANJI_C6]            11,
};

u8 MsgCharWidthLatin[] = {
    [MSG_CHAR_UPPER_A]             11,
    [MSG_CHAR_UPPER_B]             10,
    [MSG_CHAR_UPPER_C]             10,
    [MSG_CHAR_UPPER_D]             10,
    [MSG_CHAR_UPPER_E]             11,
    [MSG_CHAR_UPPER_F]             10,
    [MSG_CHAR_UPPER_G]             11,
    [MSG_CHAR_UPPER_H]             10,
    [MSG_CHAR_UPPER_I]              8,
    [MSG_CHAR_UPPER_J]              9,
    [MSG_CHAR_UPPER_K]             10,
    [MSG_CHAR_UPPER_L]             11,
    [MSG_CHAR_UPPER_M]             11,
    [MSG_CHAR_UPPER_N]             11,
    [MSG_CHAR_UPPER_O]             11,
    [MSG_CHAR_UPPER_P]             11,
    [MSG_CHAR_UPPER_Q]             11,
    [MSG_CHAR_UPPER_R]             10,
    [MSG_CHAR_UPPER_S]             11,
    [MSG_CHAR_UPPER_T]             11,
    [MSG_CHAR_UPPER_U]             11,
    [MSG_CHAR_UPPER_V]             11,
    [MSG_CHAR_UPPER_W]             11,
    [MSG_CHAR_UPPER_X]             11,
    [MSG_CHAR_UPPER_Y]             11,
    [MSG_CHAR_UPPER_Z]             10,
    [MSG_CHAR_LOWER_Z]              9,
};

u8 MsgCharWidthKanji[] = {
    [MSG_CHAR_KANJI_00 ... MSG_CHAR_KANJI_77] = 11,
    [MSG_CHAR_LOWER_X]              7,
};

u8 MsgCharWidthButtons[] = {
    [MSG_CHAR_BUTTON_A]            13,
    [MSG_CHAR_BUTTON_B]            13,
    [MSG_CHAR_BUTTON_START]        16,
    [MSG_CHAR_BUTTON_C_UP]         13,
    [MSG_CHAR_BUTTON_C_DOWN]       13,
    [MSG_CHAR_BUTTON_C_LEFT]       13,
    [MSG_CHAR_BUTTON_C_RIGHT]      13,
    [MSG_CHAR_BUTTON_Z]            12,
    [MSG_CHAR_BUTTON_L]            14,
    [MSG_CHAR_BUTTON_R]            14,
};

u8 MsgCharWidthMenuKana[] = {
    [MSG_CHAR_HIRAGANA_A]           9,
    [MSG_CHAR_HIRAGANA_I]           9,
    [MSG_CHAR_HIRAGANA_U]           9,
    [MSG_CHAR_HIRAGANA_E]           9,
    [MSG_CHAR_HIRAGANA_O]           9,
    [MSG_CHAR_HIRAGANA_KA]          9,
    [MSG_CHAR_HIRAGANA_KI]          9,
    [MSG_CHAR_HIRAGANA_KU]          9,
    [MSG_CHAR_HIRAGANA_KE]          9,
    [MSG_CHAR_HIRAGANA_KO]          9,
    [MSG_CHAR_HIRAGANA_SA]          9,
    [MSG_CHAR_HIRAGANA_SI]          9,
    [MSG_CHAR_HIRAGANA_SU]          9,
    [MSG_CHAR_HIRAGANA_SE]          9,
    [MSG_CHAR_HIRAGANA_SO]          9,
    [MSG_CHAR_HIRAGANA_TA]          9,
    [MSG_CHAR_HIRAGANA_TI]          9,
    [MSG_CHAR_HIRAGANA_TU]          9,
    [MSG_CHAR_HIRAGANA_TE]          9,
    [MSG_CHAR_HIRAGANA_TO]          9,
    [MSG_CHAR_HIRAGANA_NA]          9,
    [MSG_CHAR_HIRAGANA_NI]          9,
    [MSG_CHAR_HIRAGANA_NU]          9,
    [MSG_CHAR_HIRAGANA_NE]          9,
    [MSG_CHAR_HIRAGANA_NO]          9,
    [MSG_CHAR_HIRAGANA_HA]          9,
    [MSG_CHAR_HIRAGANA_HI]          9,
    [MSG_CHAR_HIRAGANA_HU]          9,
    [MSG_CHAR_HIRAGANA_HE]          9,
    [MSG_CHAR_HIRAGANA_HO]          9,
    [MSG_CHAR_HIRAGANA_MA]          9,
    [MSG_CHAR_HIRAGANA_MI]          9,
    [MSG_CHAR_HIRAGANA_MU]          9,
    [MSG_CHAR_HIRAGANA_ME]          9,
    [MSG_CHAR_HIRAGANA_MO]          9,
    [MSG_CHAR_HIRAGANA_YA]          9,
    [MSG_CHAR_HIRAGANA_YU]          9,
    [MSG_CHAR_HIRAGANA_YO]          9,
    [MSG_CHAR_HIRAGANA_RA]          9,
    [MSG_CHAR_HIRAGANA_RI]          9,
    [MSG_CHAR_HIRAGANA_RU]          9,
    [MSG_CHAR_HIRAGANA_RE]          9,
    [MSG_CHAR_HIRAGANA_RO]          9,
    [MSG_CHAR_HIRAGANA_WA]          9,
    [MSG_CHAR_HIRAGANA_WO]          9,
    [MSG_CHAR_HIRAGANA_N]           9,
    [MSG_CHAR_HIRAGANA_VU]          9,
    [MSG_CHAR_HIRAGANA_GA]          9,
    [MSG_CHAR_HIRAGANA_GI]          9,
    [MSG_CHAR_HIRAGANA_GU]          9,
    [MSG_CHAR_HIRAGANA_GE]          9,
    [MSG_CHAR_HIRAGANA_GO]          9,
    [MSG_CHAR_HIRAGANA_ZA]          9,
    [MSG_CHAR_HIRAGANA_ZI]          9,
    [MSG_CHAR_HIRAGANA_ZU]          9,
    [MSG_CHAR_HIRAGANA_ZE]          9,
    [MSG_CHAR_HIRAGANA_ZO]          9,
    [MSG_CHAR_HIRAGANA_DA]          9,
    [MSG_CHAR_HIRAGANA_DI]          9,
    [MSG_CHAR_HIRAGANA_DU]          9,
    [MSG_CHAR_HIRAGANA_DE]          9,
    [MSG_CHAR_HIRAGANA_DO]          9,
    [MSG_CHAR_HIRAGANA_BA]          9,
    [MSG_CHAR_HIRAGANA_BI]          9,
    [MSG_CHAR_HIRAGANA_BU]          9,
    [MSG_CHAR_HIRAGANA_BE]          9,
    [MSG_CHAR_HIRAGANA_BO]          9,
    [MSG_CHAR_HIRAGANA_PA]          9,
    [MSG_CHAR_HIRAGANA_PI]          9,
    [MSG_CHAR_HIRAGANA_PU]          9,
    [MSG_CHAR_HIRAGANA_PE]          9,
    [MSG_CHAR_HIRAGANA_PO]          9,
    [MSG_CHAR_HIRAGANA_SMALL_A]     9,
    [MSG_CHAR_HIRAGANA_SMALL_I]     8,
    [MSG_CHAR_HIRAGANA_SMALL_U]     8,
    [MSG_CHAR_HIRAGANA_SMALL_E]     8,
    [MSG_CHAR_HIRAGANA_SMALL_O]     8,
    [MSG_CHAR_HIRAGANA_SMALL_TU]    8,
    [MSG_CHAR_HIRAGANA_SMALL_YA]    8,
    [MSG_CHAR_HIRAGANA_SMALL_YU]    8,
    [MSG_CHAR_HIRAGANA_SMALL_YO]    8,
    [MSG_CHAR_KATAKANA_A]           9,
    [MSG_CHAR_KATAKANA_I]           8,
    [MSG_CHAR_KATAKANA_U]           9,
    [MSG_CHAR_KATAKANA_E]           9,
    [MSG_CHAR_KATAKANA_O]           9,
    [MSG_CHAR_KATAKANA_KA]          9,
    [MSG_CHAR_KATAKANA_KI]          9,
    [MSG_CHAR_KATAKANA_KU]          9,
    [MSG_CHAR_KATAKANA_KE]          9,
    [MSG_CHAR_KATAKANA_KO]          9,
    [MSG_CHAR_KATAKANA_SA]          9,
    [MSG_CHAR_KATAKANA_SI]          9,
    [MSG_CHAR_KATAKANA_SU]          9,
    [MSG_CHAR_KATAKANA_SE]          9,
    [MSG_CHAR_KATAKANA_SO]          9,
    [MSG_CHAR_KATAKANA_TA]          9,
    [MSG_CHAR_KATAKANA_TI]          9,
    [MSG_CHAR_KATAKANA_TU]          9,
    [MSG_CHAR_KATAKANA_TE]          9,
    [MSG_CHAR_KATAKANA_TO]          9,
    [MSG_CHAR_KATAKANA_NA]          9,
    [MSG_CHAR_KATAKANA_NI]          9,
    [MSG_CHAR_KATAKANA_NU]          9,
    [MSG_CHAR_KATAKANA_NE]          9,
    [MSG_CHAR_KATAKANA_NO]          9,
    [MSG_CHAR_KATAKANA_HA]          9,
    [MSG_CHAR_KATAKANA_HI]          9,
    [MSG_CHAR_KATAKANA_HU]          9,
    [MSG_CHAR_KATAKANA_HE]          9,
    [MSG_CHAR_KATAKANA_HO]          9,
    [MSG_CHAR_KATAKANA_MA]          9,
    [MSG_CHAR_KATAKANA_MI]          9,
    [MSG_CHAR_KATAKANA_MU]          9,
    [MSG_CHAR_KATAKANA_ME]          9,
    [MSG_CHAR_KATAKANA_MO]          9,
    [MSG_CHAR_KATAKANA_YA]          9,
    [MSG_CHAR_KATAKANA_YU]          9,
    [MSG_CHAR_KATAKANA_YO]          9,
    [MSG_CHAR_KATAKANA_RA]          9,
    [MSG_CHAR_KATAKANA_RI]          9,
    [MSG_CHAR_KATAKANA_RU]          9,
    [MSG_CHAR_KATAKANA_RE]          9,
    [MSG_CHAR_KATAKANA_RO]          9,
    [MSG_CHAR_KATAKANA_WA]          9,
    [MSG_CHAR_KATAKANA_WO]          9,
    [MSG_CHAR_KATAKANA_N]           9,
    [MSG_CHAR_KATAKANA_VU]          9,
    [MSG_CHAR_KATAKANA_GA]          9,
    [MSG_CHAR_KATAKANA_GI]          9,
    [MSG_CHAR_KATAKANA_GU]          9,
    [MSG_CHAR_KATAKANA_GE]          9,
    [MSG_CHAR_KATAKANA_GO]          9,
    [MSG_CHAR_KATAKANA_ZA]          9,
    [MSG_CHAR_KATAKANA_ZI]          9,
    [MSG_CHAR_KATAKANA_ZU]          9,
    [MSG_CHAR_KATAKANA_ZE]          9,
    [MSG_CHAR_KATAKANA_ZO]          9,
    [MSG_CHAR_KATAKANA_DA]          9,
    [MSG_CHAR_KATAKANA_DI]          9,
    [MSG_CHAR_KATAKANA_DU]          9,
    [MSG_CHAR_KATAKANA_DE]          9,
    [MSG_CHAR_KATAKANA_DO]          9,
    [MSG_CHAR_KATAKANA_BA]          9,
    [MSG_CHAR_KATAKANA_BI]          9,
    [MSG_CHAR_KATAKANA_BU]          9,
    [MSG_CHAR_KATAKANA_BE]          9,
    [MSG_CHAR_KATAKANA_BO]          9,
    [MSG_CHAR_KATAKANA_PA]          9,
    [MSG_CHAR_KATAKANA_PI]          9,
    [MSG_CHAR_KATAKANA_PU]          9,
    [MSG_CHAR_KATAKANA_PE]          9,
    [MSG_CHAR_KATAKANA_PO]          9,
    [MSG_CHAR_KATAKANA_SMALL_A]     8,
    [MSG_CHAR_KATAKANA_SMALL_I]     8,
    [MSG_CHAR_KATAKANA_SMALL_U]     8,
    [MSG_CHAR_KATAKANA_SMALL_E]     8,
    [MSG_CHAR_KATAKANA_SMALL_O]     8,
    [MSG_CHAR_KATAKANA_SMALL_TU]    8,
    [MSG_CHAR_KATAKANA_SMALL_YA]    8,
    [MSG_CHAR_KATAKANA_SMALL_YU]    8,
    [MSG_CHAR_KATAKANA_SMALL_YO]    8,
    [MSG_CHAR_PROLONGED_SOUND]      9,
    [MSG_CHAR_TILDE]                9,
    [MSG_CHAR_LONGDASH_0]           9,
    [MSG_CHAR_LONGDASH_1]           9,
    [MSG_CHAR_LONGDASH_2]          11,
    [MSG_CHAR_DIGIT_0]              9,
    [MSG_CHAR_DIGIT_1]              8,
    [MSG_CHAR_DIGIT_2]              9,
    [MSG_CHAR_DIGIT_3]              9,
    [MSG_CHAR_DIGIT_4]              9,
    [MSG_CHAR_DIGIT_5]              9,
    [MSG_CHAR_DIGIT_6]              9,
    [MSG_CHAR_DIGIT_7]              9,
    [MSG_CHAR_DIGIT_8]              9,
    [MSG_CHAR_DIGIT_9]              9,
    [MSG_CHAR_UP]                   9,
    [MSG_CHAR_DOWN]                 9,
    [MSG_CHAR_LEFT]                 9,
    [MSG_CHAR_RIGHT]                9,
    [MSG_CHAR_EXCLAMATION]          9,
    [MSG_CHAR_QUESTION]             9,
    [MSG_CHAR_PLUS]                 9,
    [MSG_CHAR_MINUS]                9,
    [MSG_CHAR_FORWARDSLASH]        10,
    [MSG_CHAR_PERIOD]               7,
    [MSG_CHAR_AND]                  9,
    [MSG_CHAR_HASH]                 9,
    [MSG_CHAR_HEART]                9,
    [MSG_CHAR_STAR]                 9,
    [MSG_CHAR_LPAREN]               9,
    [MSG_CHAR_RPAREN]               9,
    [MSG_CHAR_TLBRACKET]            9,
    [MSG_CHAR_BRBRACKET]            9,
    [MSG_CHAR_MIDDLE_DOT]           7,
    [MSG_CHAR_HIRAGANA_SMALL_N]     8,
    [MSG_CHAR_KATAKANA_SMALL_N]     8,
    [MSG_CHAR_KANJI_C6]            11,
    [MSG_CHAR_KANJI_C7]            11,
};

u8 MsgCharWidthMenuLatin[] = {
    [MSG_CHAR_UPPER_A]              9,
    [MSG_CHAR_UPPER_B]              9,
    [MSG_CHAR_UPPER_C]              9,
    [MSG_CHAR_UPPER_D]              9,
    [MSG_CHAR_UPPER_E]              9,
    [MSG_CHAR_UPPER_F]              9,
    [MSG_CHAR_UPPER_G]              9,
    [MSG_CHAR_UPPER_H]              9,
    [MSG_CHAR_UPPER_I]              8,
    [MSG_CHAR_UPPER_J]              9,
    [MSG_CHAR_UPPER_K]              9,
    [MSG_CHAR_UPPER_L]              9,
    [MSG_CHAR_UPPER_M]              9,
    [MSG_CHAR_UPPER_N]              9,
    [MSG_CHAR_UPPER_O]              9,
    [MSG_CHAR_UPPER_P]              9,
    [MSG_CHAR_UPPER_Q]              9,
    [MSG_CHAR_UPPER_R]              9,
    [MSG_CHAR_UPPER_S]              9,
    [MSG_CHAR_UPPER_T]              9,
    [MSG_CHAR_UPPER_U]              9,
    [MSG_CHAR_UPPER_V]              9,
    [MSG_CHAR_UPPER_W]              9,
    [MSG_CHAR_UPPER_X]              9,
    [MSG_CHAR_UPPER_Y]              9,
    [MSG_CHAR_UPPER_Z]              9,
    [MSG_CHAR_LOWER_Z]              9,
};

MessageCharData MsgCharDataNormal[] = {
    {
        .raster = MsgCharImgKana,
        .charWidthTable = MsgCharWidthKana,
        .monospaceWidth = 11,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgLatin,
        .charWidthTable = MsgCharWidthLatin,
        .monospaceWidth = 11,
        .baseHeightOffset = 2,
    },
    {
        .raster = MsgCharImgTitle,
        .charWidthTable = MsgCharWidthKanji,
        .monospaceWidth = 12,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgSubtitle,
        .charWidthTable = MsgCharWidthButtons,
        .monospaceWidth = 14,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharset MsgCharsetNormal = {
    .texSize = { 16, 14 },
    .unk_02 = 14,
    .newLineY = 16,
    .charRasterSize = 112,
    .rasters = MsgCharDataNormal
};

MessageCharData MsgCharDataMenu[] = {
    {
        .raster = MsgCharImgMenuKana,
        .charWidthTable = MsgCharWidthMenuKana,
        .monospaceWidth = 9,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgMenuLatin,
        .charWidthTable = MsgCharWidthMenuLatin,
        .monospaceWidth = 9,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharset MsgCharsetMenu = {
    .texSize = { 12, 12 },
    .unk_02 = 10,
    .newLineY = 12,
    .charRasterSize = 72,
    .rasters = MsgCharDataMenu
};

MessageCharset MsgCharsetMenu2 = {
    .texSize = { 12, 12 },
    .unk_02 = 10,
    .newLineY = 16,
    .charRasterSize = 72,
    .rasters = MsgCharDataMenu
};
#else
u8 MsgCharWidthNormal[] = {
    [MSG_CHAR_NOTE]                  11,
    [MSG_CHAR_EXCLAMTION]             8,
    [MSG_CHAR_BACKSLASH]              8,
    [MSG_CHAR_HASH]                  10,
    [MSG_CHAR_DOLLAR]                 9,
    [MSG_CHAR_PERCENT]                9,
    [MSG_CHAR_AND]                    9,
    [MSG_CHAR_APOSTROPHE]             4,
    [MSG_CHAR_LPAREN]                 8,
    [MSG_CHAR_RPAREN]                 8,
    [MSG_CHAR_TIMES]                  9,
    [MSG_CHAR_PLUS]                   9,
    [MSG_CHAR_COMMA]                  5,
    [MSG_CHAR_MINUS]                  9,
    [MSG_CHAR_PERIOD]                 5,
    [MSG_CHAR_FORWARDSLASH]          10,
    [MSG_CHAR_DIGIT_0]                9,
    [MSG_CHAR_DIGIT_1]                7,
    [MSG_CHAR_DIGIT_2]                9,
    [MSG_CHAR_DIGIT_3]                9,
    [MSG_CHAR_DIGIT_4]                9,
    [MSG_CHAR_DIGIT_5]                9,
    [MSG_CHAR_DIGIT_6]                9,
    [MSG_CHAR_DIGIT_7]                9,
    [MSG_CHAR_DIGIT_8]                9,
    [MSG_CHAR_DIGIT_9]                9,
    [MSG_CHAR_COLON]                  5,
    [MSG_CHAR_SEMICOLON]              5,
    [MSG_CHAR_LESS_THAN]              8,
    [MSG_CHAR_EQUAL]                  9,
    [MSG_CHAR_GREATER_THAN]           8,
    [MSG_CHAR_QUESTION]               9,
    [MSG_CHAR_AT]                    10,
    [MSG_CHAR_UPPER_A]                9,
    [MSG_CHAR_UPPER_B]                9,
    [MSG_CHAR_UPPER_C]                9,
    [MSG_CHAR_UPPER_D]                9,
    [MSG_CHAR_UPPER_E]                9,
    [MSG_CHAR_UPPER_F]                9,
    [MSG_CHAR_UPPER_G]                9,
    [MSG_CHAR_UPPER_H]                9,
    [MSG_CHAR_UPPER_I]                7,
    [MSG_CHAR_UPPER_J]                9,
    [MSG_CHAR_UPPER_K]                9,
    [MSG_CHAR_UPPER_L]                9,
    [MSG_CHAR_UPPER_M]                9,
    [MSG_CHAR_UPPER_N]                9,
    [MSG_CHAR_UPPER_O]                9,
    [MSG_CHAR_UPPER_P]                9,
    [MSG_CHAR_UPPER_Q]                9,
    [MSG_CHAR_UPPER_R]                9,
    [MSG_CHAR_UPPER_S]                9,
    [MSG_CHAR_UPPER_T]                9,
    [MSG_CHAR_UPPER_U]                9,
    [MSG_CHAR_UPPER_V]                9,
    [MSG_CHAR_UPPER_W]                9,
    [MSG_CHAR_UPPER_X]                9,
    [MSG_CHAR_UPPER_Y]                9,
    [MSG_CHAR_UPPER_Z]                9,
    [MSG_CHAR_LBRACKET]               7,
    [MSG_CHAR_YEN]                    9,
    [MSG_CHAR_RBRACKET]               6,
    [MSG_CHAR_CARET]                  7,
    [MSG_CHAR_UNDERSCORE]             9,
    [MSG_CHAR_BACKTICK]               6,
    [MSG_CHAR_LOWER_A]                9,
    [MSG_CHAR_LOWER_B]                8,
    [MSG_CHAR_LOWER_C]                8,
    [MSG_CHAR_LOWER_D]                9,
    [MSG_CHAR_LOWER_E]                8,
    [MSG_CHAR_LOWER_F]                8,
    [MSG_CHAR_LOWER_G]                8,
    [MSG_CHAR_LOWER_H]                7,
    [MSG_CHAR_LOWER_I]                4,
    [MSG_CHAR_LOWER_J]                7,
    [MSG_CHAR_LOWER_K]                8,
    [MSG_CHAR_LOWER_L]                4,
    [MSG_CHAR_LOWER_M]                9,
    [MSG_CHAR_LOWER_N]                8,
    [MSG_CHAR_LOWER_O]                7,
    [MSG_CHAR_LOWER_P]                9,
    [MSG_CHAR_LOWER_Q]                8,
    [MSG_CHAR_LOWER_R]                8,
    [MSG_CHAR_LOWER_S]                8,
    [MSG_CHAR_LOWER_T]                8,
    [MSG_CHAR_LOWER_U]                8,
    [MSG_CHAR_LOWER_V]                8,
    [MSG_CHAR_LOWER_W]                9,
    [MSG_CHAR_LOWER_X]                8,
    [MSG_CHAR_LOWER_Y]                8,
    [MSG_CHAR_LOWER_Z]                8,
    [MSG_CHAR_LCURLY]                 7,
    [MSG_CHAR_PIPE]                   3,
    [MSG_CHAR_RCURLY]                 7,
    [MSG_CHAR_TILDA]                 10,
    [MSG_CHAR_DEGREE]                 7,
    [MSG_CHAR_UPPER_A_GRAVE]          9,
    [MSG_CHAR_UPPER_A_ACUTE]          9,
    [MSG_CHAR_UPPER_A_CIRCUMFLEX]     9,
    [MSG_CHAR_UPPER_A_UMLAUT]         9,
    [MSG_CHAR_UPPER_C_CEDILLA]        9,
    [MSG_CHAR_UPPER_E_GRAVE]          9,
    [MSG_CHAR_UPPER_E_ACUTE]          9,
    [MSG_CHAR_UPPER_E_CIRCUMFLEX]     9,
    [MSG_CHAR_UPPER_E_UMLAUT]         9,
    [MSG_CHAR_UPPER_I_GRAVE]          7,
    [MSG_CHAR_UPPER_I_ACUTE]          7,
    [MSG_CHAR_UPPER_I_CIRCUMFLEX]     7,
    [MSG_CHAR_UPPER_I_UMLAUT]         8,
    [MSG_CHAR_UPPER_N_TILDE]          9,
    [MSG_CHAR_UPPER_O_GRAVE]          9,
#if VERSION_IQUE
    [MSG_CHAR_UPPER_O_ACUTE ... MSG_CHAR_BUTTON_C_LEFT] = 18,
#else
    [MSG_CHAR_UPPER_O_ACUTE]          9,
    [MSG_CHAR_UPPER_O_CIRCUMFLEX]     9,
    [MSG_CHAR_UPPER_O_UMLAUT]         9,
    [MSG_CHAR_UPPER_U_GRAVE]          9,
    [MSG_CHAR_UPPER_U_ACUTE]          9,
    [MSG_CHAR_UPPER_U_CIRCUMFLEX]     9,
    [MSG_CHAR_UPPER_U_UMLAUT]         9,
    [MSG_CHAR_SHARP_S]                9,
    [MSG_CHAR_LOWER_A_GRAVE]          9,
    [MSG_CHAR_LOWER_A_ACUTE]          9,
    [MSG_CHAR_LOWER_A_CIRCUMFLEX]     9,
    [MSG_CHAR_LOWER_A_UMLAUT]         9,
    [MSG_CHAR_LOWER_C_CEDILLA]        8,
    [MSG_CHAR_LOWER_E_GRAVE]          8,
    [MSG_CHAR_LOWER_E_ACUTE]          8,
    [MSG_CHAR_LOWER_E_CIRCUMFLEX]     8,
    [MSG_CHAR_LOWER_E_UMLAUT]         8,
#if VERSION_PAL
    [MSG_CHAR_LOWER_I_GRAVE]          4,
    [MSG_CHAR_LOWER_I_ACUTE]          4,
    [MSG_CHAR_LOWER_I_CIRCUMFLEX]     5,
#else
    [MSG_CHAR_LOWER_I_GRAVE]          6,
    [MSG_CHAR_LOWER_I_ACUTE]          6,
    [MSG_CHAR_LOWER_I_CIRCUMFLEX]     6,
#endif
    [MSG_CHAR_LOWER_I_UMLAUT]         7,
    [MSG_CHAR_LOWER_N_TILDE]          9,
    [MSG_CHAR_LOWER_O_GRAVE]          7,
    [MSG_CHAR_LOWER_O_ACUTE]          7,
    [MSG_CHAR_LOWER_O_CIRCUMFLEX]     7,
    [MSG_CHAR_LOWER_O_UMLAUT]         8,
    [MSG_CHAR_LOWER_U_GRAVE]          8,
    [MSG_CHAR_LOWER_U_ACUTE]          8,
    [MSG_CHAR_LOWER_U_CIRCUMFLEX]     8,
    [MSG_CHAR_LOWER_U_UMLAUT]         8,
    [MSG_CHAR_INVERTED_EXCLAMTION]    6,
    [MSG_CHAR_INVERTED_QUESTION]      9,
    [MSG_CHAR_FEM_ORDINAL]            7,
    [MSG_CHAR_HEART]                 11,
    [MSG_CHAR_STAR]                  11,
    [MSG_CHAR_UP]                    11,
    [MSG_CHAR_DOWN]                  11,
    [MSG_CHAR_LEFT]                  12,
    [MSG_CHAR_RIGHT]                 12,
    [MSG_CHAR_CIRCLE]                11,
    [MSG_CHAR_CROSS]                 11,
    [MSG_CHAR_BUTTON_A]              13,
    [MSG_CHAR_BUTTON_B]              13,
    [MSG_CHAR_BUTTON_L]              14,
    [MSG_CHAR_BUTTON_R]              14,
    [MSG_CHAR_BUTTON_Z]              12,
    [MSG_CHAR_BUTTON_C_UP]           13,
    [MSG_CHAR_BUTTON_C_DOWN]         13,
    [MSG_CHAR_BUTTON_C_LEFT]         13,
#endif
    [MSG_CHAR_BUTTON_C_RIGHT]        13,
    [MSG_CHAR_BUTTON_START]          16,
    [MSG_CHAR_DOUBLE_QUOTE_OPEN]      9,
    [MSG_CHAR_DOUBLE_QUOTE_CLOSE]     9,
    [MSG_CHAR_SINGLE_QUOTE_OPEN]      5,
    [MSG_CHAR_SINGLE_QUOTE_CLOSE]     5,
};

MessageCharData MsgCharDataNormal[] = {
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 10,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 10,
        .baseHeightOffset = -2,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 10,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 10,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharData MsgCharDataMenu[] = {
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 9,
        .baseHeightOffset = -2,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 9,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 9,
        .baseHeightOffset = 0,
    },
    {
        .raster = MsgCharImgNormal,
        .charWidthTable = MsgCharWidthNormal,
        .monospaceWidth = 9,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharset MsgCharsetNormal = {
    .texSize = { 16, 16 },
    .unk_02 = 14,
    .newLineY = 16,
    .charRasterSize = 128,
    .rasters = MsgCharDataNormal
};

MessageCharset MsgCharsetMenu = {
    .texSize = { 16, 16 },
    .unk_02 = 14,
    .newLineY = 16,
    .charRasterSize = 128,
    .rasters = MsgCharDataMenu
};
#endif

u8 MsgCharWidthTitle[] = {
    8, 8, 8, 9, 8, 8, 8, 8,
    5, 8, 9, 8,10, 8, 8, 9,
    8, 9, 8, 8, 8, 8,10, 9,
    9, 8, 4, 3, 4, 9, 9, 9,
    9, 9, 9, 9, 9, 9, 9,10,
    10
};

u8 MsgCharWidthSubtitle[] = {
    9, 9, 8, 8, 7, 7, 8, 7,
    3, 7, 7, 7, 8, 7, 8, 8,
    8, 7, 7, 8, 7, 7, 8, 8,
    8, 7, 4, 3, 4, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8,
    8
};

MessageCharData MsgCharDataTitle[] = {
    {
        .raster = MsgCharImgTitle,
        .charWidthTable = MsgCharWidthTitle,
        .monospaceWidth = 14,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharData MsgCharDataSubtitle[] = {
    {
        .raster = MsgCharImgSubtitle,
        .charWidthTable = MsgCharWidthSubtitle,
        .monospaceWidth = 10,
        .baseHeightOffset = 0,
    },
    {}
};

MessageCharset MsgCharsetTitle = {
    .texSize = { 12, 15 },
    .unk_02 = 14,
    .newLineY = 16,
    .charRasterSize = 96,
    .rasters = MsgCharDataTitle
};

MessageCharset MsgCharsetSubtitle = {
    .texSize = { 12, 12 },
    .unk_02 = 10,
    .newLineY = 10,
    .charRasterSize = 72,
    .rasters = MsgCharDataSubtitle
};

MessageCharset* MsgCharsets[] = {
    [MSG_FONT_NORMAL]   &MsgCharsetNormal,
    [MSG_FONT_MENU]     &MsgCharsetMenu,
#if VERSION_JP
    [MSG_FONT_2]        &MsgCharsetMenu2,
#else
    [MSG_FONT_2]        &MsgCharsetMenu,
#endif
    [MSG_FONT_TITLE]    &MsgCharsetTitle,
    [MSG_FONT_SUBTITLE] &MsgCharsetSubtitle,
    NULL
};

IMG_PTR MsgLetterRasterOffsets[] = {
    charset_letter_content_1_OFFSET,
    charset_letter_content_2_OFFSET,
    charset_letter_content_3_OFFSET,
    charset_letter_content_4_OFFSET,
    charset_letter_content_5_OFFSET,
    charset_letter_content_6_OFFSET,
    charset_letter_content_7_OFFSET,
    charset_letter_content_8_OFFSET,
    charset_letter_content_9_OFFSET,
    charset_letter_content_10_OFFSET,
    charset_letter_content_11_OFFSET,
    charset_letter_content_12_OFFSET,
};

PAL_PTR MsgLetterPaletteOffsets[] = {
    charset_letter_content_1_pal_OFFSET,
    charset_letter_content_2_pal_OFFSET,
    charset_letter_content_3_pal_OFFSET,
    charset_letter_content_4_pal_OFFSET,
    charset_letter_content_5_pal_OFFSET,
    charset_letter_content_6_pal_OFFSET,
    charset_letter_content_7_pal_OFFSET,
    charset_letter_content_8_pal_OFFSET,
    charset_letter_content_9_pal_OFFSET,
    charset_letter_content_10_pal_OFFSET,
    charset_letter_content_11_pal_OFFSET,
    charset_letter_content_12_pal_OFFSET,
};

MsgVoice MsgVoices[] = {
    [MSG_VOICE_NORMAL] {
        .voiceA = SOUND_MSG_VOICE_1A,
        .voiceB = SOUND_MSG_VOICE_1B,
        .pitchShift = 0
    },
    [MSG_VOICE_BOWSER] {
        .voiceA = SOUND_MSG_VOICE_4A,
        .voiceB = SOUND_MSG_VOICE_4B,
        .pitchShift = -50
    },
    [MSG_VOICE_STAR] {
        .voiceA = SOUND_MSG_VOICE_STAR,
        .voiceB = SOUND_MSG_VOICE_STAR,
        .pitchShift = 0
    },
};

#if !VERSION_JP
s16 MsgStyleVerticalLineOffsets[] = {
    [MSG_STYLE_NONE]       0,
    [MSG_STYLE_RIGHT]     -4,
    [MSG_STYLE_LEFT]      -4,
    [MSG_STYLE_CENTER]    -4,
    [MSG_STYLE_TATTLE]    -4,
    [MSG_STYLE_CHOICE]     0,
    [MSG_STYLE_INSPECT]   -4,
    [MSG_STYLE_SIGN]      -4,
    [MSG_STYLE_LAMPPOST]  -4,
    [MSG_STYLE_POSTCARD]   0,
    [MSG_STYLE_POPUP]      0,
    [MSG_STYLE_B]          0,
    [MSG_STYLE_UPGRADE]    0,
    [MSG_STYLE_NARRATE]   -4,
    [MSG_STYLE_EPILOGUE]  -4,
    [MSG_STYLE_F]          0,
};
#endif
