#include "common.h"
#include "filemenu.h"
#include "ld_addrs.h"

#include "charset/charset.h"

s32 msg_get_print_char_width(s32 character, s32 charset, s32 variation, f32 msgScale, s32 overrideCharWidth, u8 flags);

extern MessageCharset* MsgCharsets[5];
extern PAL_BIN D_802F4560[80][8];
extern u8 filemenu_glyphBuffer[20][0x80];

#if VERSION_IQUE
u8 filemenu_msg_C6[] = { 0xF7, 0xF7, 0x84, 0x05, 0x62, 0x14, 0xFD };
u8 filemenu_msg_C7[] = { 0xFD };
u8 filemenu_msg_C8[] = { 0xFD };
u8 filemenu_msg_C9[] = { 0x6C, 0x2B, 0x8D, 0x04, 0xFD };
u8 filemenu_msg_CA[] = { 0x7C, 0x04, 0x7D, 0x04, 0xFD };
#elif VERSION_PAL
u8 filemenu_msg_C6[] = {0xFD};   // SPACE[End]
u8 filemenu_msg_C7[] = {0xFD};                                 // [End]
u8 filemenu_msg_C8[] = {0xFD};                                 // [End]
u8 filemenu_msg_C9[] = {0x94, 0xFD};         // BACK[End]
u8 filemenu_msg_CA[] = {0x25, 0x2E, 0x24, 0xFD};               // END[End]
u8 filemenu_msg_CA_de[] = {0x25, 0x2E, 0x24, 0x25, 0xFD};               // ENDE[End]
u8 filemenu_msg_CA_fr[] = {0x26, 0x29, 0x2E, 0xFD};
u8 filemenu_msg_CA_es[] = {0x26, 0x29, 0x2E, 0xFD};
#else
u8 filemenu_msg_C6[] = { 0x33, 0x30, 0x21, 0x23, 0x25, 0xFD };   // SPACE[End]
u8 filemenu_msg_C7[] = { 0xFD };                                 // [End]
u8 filemenu_msg_C8[] = { 0xFD };                                 // [End]
u8 filemenu_msg_C9[] = { 0x22, 0x21, 0x23, 0x2B, 0xFD };         // BACK[End]
u8 filemenu_msg_CA[] = { 0x25, 0x2E, 0x24, 0xFD };               // END[End]
#endif

#if VERSION_PAL
u8* filemenu_specialSymbols[][5] = {
    [LANGUAGE_EN] = { filemenu_msg_C8, filemenu_msg_C6, filemenu_msg_C7, filemenu_msg_C9, filemenu_msg_CA },
    [LANGUAGE_DE] = { filemenu_msg_C8, filemenu_msg_C6, filemenu_msg_C7, filemenu_msg_C9, filemenu_msg_CA_de },
    [LANGUAGE_FR] = { filemenu_msg_C8, filemenu_msg_C6, filemenu_msg_C7, filemenu_msg_C9, filemenu_msg_CA_fr },
    [LANGUAGE_ES] = { filemenu_msg_C8, filemenu_msg_C6, filemenu_msg_C7, filemenu_msg_C9, filemenu_msg_CA_es },
};
#else
s32 filemenu_specialSymbols[] = { (s32)filemenu_msg_C6, (s32)filemenu_msg_C7, (s32)filemenu_msg_C8, (s32)filemenu_msg_C9, (s32)filemenu_msg_CA };
#endif

Gfx filemenu_dl_draw_char_init[] = {
    gsDPPipeSync(),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_ON),
    gsDPSetCycleType(G_CYC_1CYCLE),
    gsDPSetTexturePersp(G_TP_NONE),
    gsDPSetTextureDetail(G_TD_CLAMP),
    gsDPSetTextureLOD(G_TL_TILE),
    gsDPSetTextureFilter(G_TF_POINT),
    gsDPSetTextureLUT(G_TT_RGBA16),
    gsDPSetTextureConvert(G_TC_FILT),
    gsDPSetRenderMode(G_RM_TEX_EDGE, G_RM_TEX_EDGE2),
    gsDPSetCombineMode(G_CC_DECALRGBA, G_CC_DECALRGBA),
    gsDPSetPrimColor(0, 0, 40, 40, 40, 72),
    gsSPEndDisplayList(),
};

Gfx* filemenu_savedGfxPos = NULL;
s32 filemenu_charset = 0;
s32 filemenu_charset_raster_id = 0;
s32 filemenu_char_color = -1;

#if VERSION_IQUE
u32 filemenu_glyphBufferIndex = 0;
#endif

#if VERSION_PAL
u8 D_filemenu_802508D0[] = {0x21, 0x24, 0x26, 0x26};
u8 D_filemenu_802508D4[] = {0x07, 0x07, 0x05, 0x05};
u8 D_filemenu_802508D8[] = {0x22, 0x22, 0x1A, 0x26};
u8 D_filemenu_802508DC[] = {0x0B, 0x0B, 0x1A, 0x1A};
u8 D_filemenu_802508E0[] = {0x32, 0x32, 0x26, 0x2C};
u8 D_filemenu_802508E4[] = {0x1E, 0x19, 0x0A, 0x18};
u8 D_filemenu_802508E8[] = {0x08, 0x10, 0x10, 0x14};
u8 D_filemenu_802508EC[] = {0x0E, 0x0E, 0x16, 0x15};
u8 D_filemenu_802508F0[] = {0x14, 0x08, 0x12, 0x19};
u8 D_filemenu_802508F4[] = {0x14, 0x08, 0x12, 0x19};
u8 D_filemenu_802508F8[] = {0x26, 0x33, 0x3B, 0x3C};
u8 D_filemenu_802508FC[] = {0x26, 0x33, 0x3C, 0x3F};
u16 D_filemenu_80250900[] = {0x00B4, 0x00C8, 0x0124, 0x00B4};
u8 D_filemenu_80250908[] = {0x75, 0x3E, 0xD0, 0x96};
u8 D_filemenu_8025090C[] = {0xFD, 0x00, 0xFD, 0xFD};
u8 D_filemenu_80250910[] = {0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xC8, 0xC8, 0xC8, 0xA2, 0xB2, 0xA2, 0xA6, 0xA2, 0xC8, 0xA2, 0xA2};
u8 D_filemenu_80250920[] = {0x76, 0x8A, 0x9A, 0xA2};
u8 D_filemenu_80250924[] = {0x0A, 0x42, 0x0A, 0x0A};
u8 D_filemenu_80250928[] = {0x3C, 0x0A, 0x4B, 0x4F};
u8 D_filemenu_8025092C[] = {0x01, 0x3B, 0x01, 0x01};
u8 D_filemenu_80250930[] = {0xB6, 0xB6, 0xC2, 0xD4};
u8 D_filemenu_80250934[] = {0x00, 0x00, 0x14, 0x11};
u8 D_filemenu_80250938[] = {0x19, 0x0A, 0x19, 0x0A};
u8 D_filemenu_8025093C[] = {0x10, 0x0A, 0x0A, 0x14};
u16 D_filemenu_80250940[] = {0x00B6, 0x0113, 0x00BE, 0x00C6};
u8 D_filemenu_80250948[] = {0x4A, 0x1E, 0x46, 0x44};
u8 D_filemenu_8025094C[] = {0x14, 0x25, 0x15, 0x12};
s8 D_filemenu_80250950[] = {0xFD, 0x02, 0xFD, 0xFD};
u8 D_filemenu_80250954[] = {0x9A, 0xAE, 0x9A, 0x9A};
u8 D_filemenu_80250958[] = {0xA4, 0xA4, 0xC0, 0xA4};
u8 D_filemenu_8025095C[] = {0x24, 0x24, 0x32, 0x24};
u8 D_filemenu_80250960[] = {0xA4, 0xA4, 0xA4, 0xB4};
u8 D_filemenu_80250964[] = {0xB8, 0xB4, 0xA0, 0xCC};
u8 D_filemenu_80250968[] = {0x00, 0x00, 0x00, 0x10};
#endif

#if VERSION_IQUE
u8 filemenu_msg_01[] = { 0xF7, 0xF7, 0xF7, 0xF7, 0xF7, 0x7A, 0x14, 0x7B, 0x14, 0x79, 0x19, 0x7F, 0x06, 0x79, 0x04, 0x7A, 0x04, 0xFD };
u8 filemenu_msg_02[] = { 0xF7, 0xF7, 0xF7, 0xF7, 0xF7, 0x7A, 0x14, 0x7B, 0x14, 0x79, 0x19, 0x7F, 0x06, 0x8C, 0x30, 0x6C, 0x12, 0xFD };
u8 filemenu_msg_03[] = { 0x7A, 0x14, 0x7B, 0x14, 0x79, 0x19, 0x7F, 0x06, 0x89, 0x0D, 0x71, 0x15, 0xFD };
u8 filemenu_msg_04[] = { 0x82, 0x08, 0x68, 0x12, 0x85, 0x0B, 0x6D, 0x05, 0x79, 0x19, 0x7F, 0x06, 0x74, 0x08, 0xFD };
u8 filemenu_msg_05[] = { 0x82, 0x08, 0x68, 0x12, 0x82, 0x06, 0x85, 0x0B, 0x6D, 0x05, 0x79, 0x19, 0x7F, 0x06, 0x74, 0x08, 0xFD };
u8 filemenu_msg_06[] = { 0x71, 0x05, 0xFD };
u8 filemenu_msg_07[] = { 0x82, 0x07, 0x6C, 0x02, 0xFD };
u8 filemenu_msg_08[] = { 0x7D, 0x0C, 0x85, 0x12, 0x85, 0x05, 0x79, 0x02, 0xFD };
u8 filemenu_msg_09[] = { 0x8C, 0x30, 0x6C, 0x12, 0x79, 0x19, 0x7F, 0x06, 0xFD };
u8 filemenu_msg_10[] = { 0x8F, 0x0F, 0x66, 0x0B, 0xFD };
u8 filemenu_msg_11[] = { 0x82, 0x08, 0x68, 0x12, 0x79, 0x19, 0x7F, 0x06, 0xFD };
u8 filemenu_msg_12[] = { 0x79, 0x04, 0x7A, 0x04, 0x7D, 0x0C, 0x85, 0x12, 0xFD };
u8 filemenu_msg_13[] = { 0x75, 0x05, 0xFD };
u8 filemenu_msg_14[] = { 0x62, 0x06, 0xFD };
u8 filemenu_msg_15[] = { 0x7D, 0x0F, 0xFD };
u8 filemenu_msg_16[] = { 0x8C, 0x30, 0x6C, 0x12, 0xFD };
u8 filemenu_msg_17[] = { 0x89, 0x22, 0x68, 0x03, 0x76, 0x0C, 0x71, 0x05, 0x75, 0x19, 0x76, 0x19, 0xFD };
u8 filemenu_msg_18[] = { 0x8E, 0x0C, 0x74, 0x06, 0x5F, 0x09, 0x74, 0x08, 0xFD };
u8 filemenu_msg_19[] = { 0x79, 0x19, 0x7F, 0x06, 0x72, 0x0A, 0x66, 0x11, 0x62, 0x06, 0xFD };
u8 filemenu_msg_20[] = { 0x75, 0x05, 0xFD };
u8 filemenu_msg_21[] = { 0x8E, 0x0C, 0x74, 0x06, 0x5F, 0x09, 0x74, 0x08, 0xFD };
u8 filemenu_msg_22[] = { 0x79, 0x19, 0x7F, 0x06, 0xFD };
u8 filemenu_msg_23[] = { 0x83, 0x02, 0x84, 0x09, 0x8C, 0x30, 0x6C, 0x12, 0x74, 0x08, 0xFD };
u8 filemenu_msg_24[] = { 0x8E, 0x0C, 0x74, 0x06, 0x82, 0x08, 0x68, 0x12, 0x82, 0x06, 0x6C, 0x05, 0x6D, 0x05, 0x79, 0x19, 0x7F, 0x06, 0x74, 0x08, 0xFD };
u8 filemenu_msg_25[] = { 0x79, 0x04, 0x7A, 0x04, 0x7D, 0x0C, 0x85, 0x12, 0xFD };
u8 filemenu_msg_26[] = { 0x79, 0x19, 0x7F, 0x06, 0xFD };
u8 filemenu_msg_27[] = { 0x8B, 0x08, 0x7D, 0x08, 0x8C, 0x30, 0x6C, 0x12, 0x8C, 0x04, 0x75, 0x05, 0xFD };
u8 filemenu_msg_28[] = { 0xFD };
u8 filemenu_msg_29[] = { 0x82, 0x08, 0x68, 0x12, 0xFD };
u8 filemenu_msg_30[] = { 0x82, 0x06, 0xFD };
u8 filemenu_msg_31[] = { 0x8B, 0x08, 0x7D, 0x08, 0x8A, 0x1C, 0x64, 0x1E, 0x75, 0x05, 0xFD };
u8 filemenu_msg_32[] = { 0x73, 0x1F, 0x7B, 0x11, 0x73, 0x06, 0x6D, 0x05, 0x79, 0x19, 0x7F, 0x06, 0x72, 0x0A, 0x66, 0x11, 0x87, 0x04, 0xFD };
u8 filemenu_createfile_gridData[] = {
        0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
        0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A,
        0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
        0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A,
        0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x10, 0x0E, 0x0D, 0xF7,
        0x00, 0x90, 0x91, 0x20, 0xC6, 0xF7, 0xF7, 0xC9, 0xF7, 0xF7, 0xCA, 0xF7, 0xF7
};
u8 filemenu_msg_33[] = { 0x74, 0x08, 0xFD };
u8 filemenu_msg_34[] = { 0x75, 0x05, 0xFD };
#elif VERSION_PAL

u8 filemenu_msg_pal_24[] = {0x1F, 0xFD};  // ?[End]

// Select file to start
u8 filemenu_msg_01[] = {0x33, 0x45, 0x4C, 0x45, 0x43, 0x54, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x53, 0x54, 0x41, 0x52, 0x54, 0x1A, 0xFD};
u8 filemenu_msg_01_de[] = {0x37, 0x7A, 0x48, 0x4C, 0x45, 0xF7, 0x45, 0x49, 0x4E, 0x45, 0xF7, 0x24, 0x41, 0x54, 0x45, 0x49, 0x1A, 0xFD};
u8 filemenu_msg_01_fr[] = {0x23, 0x48, 0x4F, 0x49, 0x53, 0x49, 0x52, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0x1A, 0xFD};
u8 filemenu_msg_01_es[] = {0x25, 0x4C, 0x49, 0x47, 0x45, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0x1A, 0xFD};

// Select file to delete
u8 filemenu_msg_02[] = {0x33, 0x45, 0x4C, 0x45, 0x43, 0x54, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x44, 0x45, 0x4C, 0x45, 0x54, 0x45, 0x1A, 0xFD};
u8 filemenu_msg_02_de[] = {0x37, 0x7A, 0x48, 0x4C, 0x45, 0xF7, 0x5A, 0x55, 0xF7, 0x4C, 0x88, 0x53, 0x43, 0x48, 0x45, 0x4E, 0x44, 0x45, 0xF7, 0x24, 0x41, 0x54, 0x45, 0x49, 0x1A, 0xFD};
u8 filemenu_msg_02_fr[] = {0x23, 0x48, 0x4F, 0x49, 0x53, 0x49, 0x52, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0xF7, 0x77, 0xF7, 0x45, 0x46, 0x46, 0x41, 0x43, 0x45, 0x52, 0x1A, 0xFD};
u8 filemenu_msg_02_es[] = {0x25, 0x4C, 0x49, 0x47, 0x45, 0xF7, 0x45, 0x4C, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0xF7, 0x41, 0xF7, 0x42, 0x4F, 0x52, 0x52, 0x41, 0x52, 0x1A, 0xFD};

// Copy which file
u8 filemenu_msg_04[] = {0x23, 0x4F, 0x50, 0x59, 0xF7, 0x57, 0x48, 0x49, 0x43, 0x48, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0x1F, 0xFD};
u8 filemenu_msg_04_de[] = {0x37, 0x45, 0x4C, 0x43, 0x48, 0x45, 0xF7, 0x24, 0x41, 0x54, 0x45, 0x49, 0xF7, 0x4B, 0x4F, 0x50, 0x49, 0x45, 0x52, 0x45, 0x4E, 0x1F, 0xFD};
u8 filemenu_msg_04_fr[] = {0x26, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0xF7, 0x53, 0x4F, 0x55, 0x52, 0x43, 0x45, 0x1F, 0xFD};
u8 filemenu_msg_04_es[] = {0x8E, 0x31, 0x55, 0x7D, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0xF7, 0x43, 0x4F, 0x50, 0x49, 0x41, 0x53, 0x1F, 0xFD};

// Copy to which file
u8 filemenu_msg_05[] = {0x23, 0x4F, 0x50, 0x59, 0xF7, 0x54, 0x4F, 0xF7, 0x57, 0x48, 0x49, 0x43, 0x48, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0x1F, 0xFD};
u8 filemenu_msg_05_de[] = {0x29, 0x4E, 0xF7, 0x57, 0x45, 0x4C, 0x43, 0x48, 0x45, 0xF7, 0x24, 0x41, 0x54, 0x45, 0x49, 0xF7, 0x4B, 0x4F, 0x50, 0x49, 0x45, 0x52, 0x45, 0x4E, 0x1F, 0xFD};
u8 filemenu_msg_05_fr[] = {0x26, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0xF7, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4E, 0x41, 0x54, 0x49, 0x4F, 0x4E, 0x1F, 0xFD};
u8 filemenu_msg_05_es[] = {0x8E, 0x24, 0x86, 0x4E, 0x44, 0x45, 0xF7, 0x4C, 0x4F, 0xF7, 0x43, 0x4F, 0x50, 0x49, 0x41, 0x53, 0x1F, 0xFD};

// NEW
u8 filemenu_msg_06[] = {0x2E, 0x25, 0x37, 0xFD};
u8 filemenu_msg_06_de[] = {0x2E, 0x45, 0x55, 0xFD};
u8 filemenu_msg_06_fr[] = {0x2E, 0x4F, 0x55, 0x56, 0x45, 0x41, 0x55, 0xFD};
u8 filemenu_msg_06_es[] = {0x2E, 0x55, 0x45, 0x56, 0x4F, 0xFD};

// Level
u8 filemenu_msg_07[] = {0x2C, 0x45, 0x56, 0x45, 0x4C, 0xFD};
u8 filemenu_msg_07_fr[] = {0x2E, 0x49, 0x56, 0x45, 0x41, 0x55, 0xFD};
u8 filemenu_msg_07_es[] = {0x2E, 0x49, 0x56, 0x45, 0x4C, 0xFD};

// Play Time
u8 filemenu_msg_08[] = {0x30, 0x4C, 0x41, 0x59, 0xF7, 0x34, 0x49, 0x4D, 0x45, 0xFD};
u8 filemenu_msg_08_de[] = {0x33, 0x50, 0x49, 0x45, 0x4C, 0x5A, 0x45, 0x49, 0x54, 0xFD};
u8 filemenu_msg_08_fr[] = {0x34, 0x45, 0x4D, 0x50, 0x53, 0xFD};
u8 filemenu_msg_08_es[] = {0x34, 0x49, 0x45, 0x4D, 0x50, 0x4F, 0xFD};

// Delete File
u8 filemenu_msg_09[] = {0x24, 0x45, 0x4C, 0x45, 0x54, 0x45, 0xF7, 0x26, 0x49, 0x4C, 0x45, 0xFD};
u8 filemenu_msg_09_de[] = {0x2C, 0x88, 0x53, 0x43, 0x48, 0x45, 0x4E, 0xFD};
u8 filemenu_msg_09_fr[] = {0x25, 0x46, 0x46, 0x41, 0x43, 0x45, 0x52, 0xFD};
u8 filemenu_msg_09_es[] = {0x22, 0x4F, 0x52, 0x52, 0x41, 0x52, 0xFD};

// Cancel
u8 filemenu_msg_10[] = {0x23, 0x41, 0x4E, 0x43, 0x45, 0x4C, 0xFD};
u8 filemenu_msg_10_de[] = {0x21, 0x42, 0x42, 0x52, 0x45, 0x43, 0x48, 0x45, 0x4E, 0xFD};
u8 filemenu_msg_10_fr[] = {0x21, 0x4E, 0x4E, 0x55, 0x4C, 0x45, 0x52, 0xFD};
u8 filemenu_msg_10_es[] = {0x33, 0x41, 0x4C, 0x49, 0x52, 0xFD};

// Copy File
u8 filemenu_msg_11[] = {0x23, 0x4F, 0x50, 0x59, 0xF7, 0x26, 0x49, 0x4C, 0x45, 0xFD};
u8 filemenu_msg_11_de[] = {0x2B, 0x4F, 0x50, 0x49, 0x45, 0x52, 0x45, 0x4E, 0xFD};
u8 filemenu_msg_11_fr[] = {0x23, 0x4F, 0x50, 0x49, 0x45, 0x52, 0xFD};
u8 filemenu_msg_11_es[] = {0x23, 0x4F, 0x50, 0x49, 0x41, 0x52, 0xFD};

// First Play
u8 filemenu_msg_12[] = {0x26, 0x49, 0x52, 0x53, 0x54, 0xF7, 0x30, 0x4C, 0x41, 0x59, 0xFD};
u8 filemenu_msg_12_de[] = {0x2E, 0x45, 0x55, 0x45, 0x53, 0xF7, 0x33, 0x50, 0x49, 0x45, 0x4C, 0xFD};
u8 filemenu_msg_12_fr[] = {0x30, 0x52, 0x45, 0x4D, 0x49, 0x7C, 0x52, 0x45, 0xF7, 0x50, 0x41, 0x52, 0x54, 0x49, 0x45, 0xFD};
u8 filemenu_msg_12_es[] = {0x30, 0x52, 0x49, 0x4D, 0x45, 0x52, 0x41, 0xF7, 0x36, 0x45, 0x5A, 0xFD};

u8 filemenu_msg_13[] = {0x0E, 0xFD};  // .[End]

// Yes
u8 filemenu_msg_14[] = {0x39, 0x45, 0x53, 0xFD};
u8 filemenu_msg_14_de[] = {0x2A, 0x41, 0xFD};
u8 filemenu_msg_14_fr[] = {0x2F, 0x55, 0x49, 0xFD};
u8 filemenu_msg_14_es[] = {0x33, 0x81, 0xFD};

// No
u8 filemenu_msg_15[] = {0x2E, 0x4F, 0xFD};
u8 filemenu_msg_15_de[] = {0x2E, 0x45, 0x49, 0x4E, 0xFD};
u8 filemenu_msg_15_fr[] = {0x2E, 0x4F, 0x4E, 0xFD};
u8 filemenu_msg_15_es[] = {0x2E, 0x4F, 0xFD};

// Delete
u8 filemenu_msg_16[] = {0x24, 0x45, 0x4C, 0x45, 0x54, 0x45, 0xFD};
u8 filemenu_msg_16_de[] = {0x4C, 0x88, 0x53, 0x43, 0x48, 0x45, 0x4E, 0xFD};
u8 filemenu_msg_16_fr[] = {0x25, 0x46, 0x46, 0x41, 0x43, 0x45, 0x52, 0xFD};
u8 filemenu_msg_16_es[] = {0x8E, 0x22, 0x4F, 0x52, 0x52, 0x4F, 0xF7, 0x45, 0x4C, 0xFD};

// File name is :
u8 filemenu_msg_19[] = {0x26, 0x49, 0x4C, 0x45, 0xF7, 0x4E, 0x41, 0x4D, 0x45, 0xF7, 0x49, 0x53, 0xF7, 0x1A, 0xFD};
u8 filemenu_msg_19_de[] = {0x24, 0x45, 0x52, 0xF7, 0x2E, 0x41, 0x4D, 0x45, 0xF7, 0x4C, 0x41, 0x55, 0x54, 0x45, 0x54, 0xF7, 0x1A, 0xFD};
u8 filemenu_msg_19_fr[] = {0x2E, 0x4F, 0x4D, 0xF7, 0x44, 0x55, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0xF7, 0x1A, 0xFD};
u8 filemenu_msg_19_es[] = {0x2E, 0x4F, 0x4D, 0x42, 0x52, 0x45, 0xF7, 0x44, 0x45, 0x4C, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0xF7, 0x1A, 0xFD};

// OK?
u8 filemenu_msg_21[] = {0x2F, 0x2B, 0x1F, 0xFD};
u8 filemenu_msg_21_es[] = {0x8E, 0x36, 0x41, 0x4C, 0x45, 0x1F, 0xFD};

// File
u8 filemenu_msg_22[] = {0x26, 0x49, 0x4C, 0x45, 0xFD};
u8 filemenu_msg_22_de[] = {0x24, 0x41, 0x54, 0x45, 0x49, 0xFD};
u8 filemenu_msg_22_fr[] = {0x26, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0xFD};
u8 filemenu_msg_22_es[] = {0x26, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0xFD};

// <DE> Dat. / <FR/ES> Fich.
u8 filemenu_msg_pal_20_de[] = {0x24, 0x41, 0x54, 0x0E, 0xFD};
u8 filemenu_msg_pal_20_fr_es[] = {0x26, 0x49, 0x43, 0x48, 0x0E, 0xFD};

// will be deleted.
u8 filemenu_msg_23[] = {0x57, 0x49, 0x4C, 0x4C, 0xF7, 0x42, 0x45, 0xF7, 0x44, 0x45, 0x4C, 0x45, 0x54, 0x45, 0x44, 0x0E, 0xFD};
u8 filemenu_msg_23_de[] = {0x57, 0x49, 0x52, 0x44, 0xF7, 0x47, 0x45, 0x4C, 0x88, 0x53, 0x43, 0x48, 0x54, 0x0E, 0xFD};
u8 filemenu_msg_23_fr[] = {0x53, 0x45, 0x52, 0x41, 0xF7, 0x45, 0x46, 0x46, 0x41, 0x43, 0x7D, 0x0E, 0xFD};
u8 filemenu_msg_23_es[] = {0x53, 0x45, 0x52, 0x78, 0xF7, 0x42, 0x4F, 0x52, 0x52, 0x41, 0x44, 0x4F, 0x0E, 0xFD};

// OK to copy to this file?
u8 filemenu_msg_24[] = {0x2F, 0x2B, 0xF7, 0x54, 0x4F, 0xF7, 0x43, 0x4F, 0x50, 0x59, 0xF7, 0x54, 0x4F, 0xF7, 0x54, 0x48, 0x49, 0x53, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0x1F, 0xFD};
u8 filemenu_msg_24_de[] = {0x33, 0x4F, 0x4C, 0x4C, 0xF7, 0x41, 0x55, 0x46, 0xF7, 0x44, 0x49, 0x45, 0x53, 0x45, 0xF7, 0x24, 0x41, 0x54, 0x45, 0x49, 0xF7, 0x4B, 0x4F, 0x50, 0x49, 0x45, 0x52, 0x54, 0xF7, 0x57, 0x45, 0x52, 0x44, 0x45, 0x4E, 0x1F, 0xFD};
u8 filemenu_msg_24_fr[] = {0x23, 0x4F, 0x4E, 0x46, 0x49, 0x52, 0x4D, 0x45, 0x52, 0xF7, 0x4C, 0x41, 0xF7, 0x43, 0x4F, 0x50, 0x49, 0x45, 0x1F, 0xFD};
u8 filemenu_msg_24_es[] = {0x8E, 0x31, 0x55, 0x49, 0x45, 0x52, 0x45, 0x53, 0xF7, 0x43, 0x4F, 0x50, 0x49, 0x41, 0x52, 0x4C, 0x4F, 0xF7, 0x41, 0x51, 0x55, 0x81, 0xF7, 0x1F, 0xFD};

// Start game with
u8 filemenu_msg_25[] = {0x33, 0x54, 0x41, 0x52, 0x54, 0xF7, 0x47, 0x41, 0x4D, 0x45, 0xF7, 0x57, 0x49, 0x54, 0x48, 0xFD};
u8 filemenu_msg_25_de[] = {0x33, 0x50, 0x49, 0x45, 0x4C, 0xF7, 0x4D, 0x49, 0x54, 0xFD};
u8 filemenu_msg_25_fr[] = {0x23, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x43, 0x45, 0x52, 0xF7, 0x55, 0x4E, 0x45, 0xF7, 0x50, 0x41, 0x52, 0x54, 0x49, 0x45, 0xF7, 0x41, 0x56, 0x45, 0x43, 0xF7, 0x4C, 0x45, 0xFD};
u8 filemenu_msg_25_es[] = {0x8E, 0x31, 0x55, 0x49, 0x45, 0x52, 0x45, 0x53, 0xF7, 0x45, 0x53, 0x54, 0x45, 0xF7, 0x46, 0x49, 0x43, 0x48, 0x45, 0x52, 0x4F, 0x1F, 0xFD};

// <DE> beginnen?
u8 filemenu_msg_pal_24_de[] = {0x42, 0x45, 0x47, 0x49, 0x4E, 0x4E, 0x45, 0x4E, 0x1F, 0xFD};

// has been deleted.
u8 filemenu_msg_27[] = {0x48, 0x41, 0x53, 0xF7, 0x42, 0x45, 0x45, 0x4E, 0xF7, 0x44, 0x45, 0x4C, 0x45, 0x54, 0x45, 0x44, 0x0E, 0xFD};
u8 filemenu_msg_27_de[] = {0x57, 0x55, 0x52, 0x44, 0x45, 0xF7, 0x47, 0x45, 0x4C, 0x88, 0x53, 0x43, 0x48, 0x54, 0x0E, 0xFD};
u8 filemenu_msg_27_fr[] = {0x41, 0xF7, 0x7D, 0x54, 0x7D, 0xF7, 0x45, 0x46, 0x46, 0x41, 0x43, 0x7D, 0x0E, 0xFD};
u8 filemenu_msg_27_es[] = {0x48, 0x41, 0xF7, 0x53, 0x49, 0x44, 0x4F, 0xF7, 0x42, 0x4F, 0x52, 0x52, 0x41, 0x44, 0x4F, 0x0E, 0xFD};

// <blank> / Le / El
u8 filemenu_msg_28[] = {0xFD};
u8 filemenu_msg_28_fr[] = {0x2C, 0x45, 0xFD};
u8 filemenu_msg_28_es[] = {0x25, 0x4C, 0xFD};

// Copy from
u8 filemenu_msg_29[] = {0x23, 0x4F, 0x50, 0x59, 0xF7, 0x46, 0x52, 0x4F, 0x4D, 0xFD};
u8 filemenu_msg_29_de[] = {0x36, 0x4F, 0x4E, 0xFD};
u8 filemenu_msg_29_fr[] = {0x23, 0x4F, 0x50, 0x49, 0x45, 0x52, 0xF7, 0x44, 0x55, 0xFD};
u8 filemenu_msg_29_es[] = {0x23, 0x4F, 0x50, 0x49, 0x41, 0xF7, 0x44, 0x45, 0x4C, 0xFD};

// to
u8 filemenu_msg_30[] = {0x54, 0x4F, 0xFD};
u8 filemenu_msg_30_de[] = {0x4E, 0x41, 0x43, 0x48, 0xFD};
u8 filemenu_msg_30_fr[] = {0x41, 0x55, 0xFD};
u8 filemenu_msg_30_es[] = {0x41, 0x4C, 0xFD};

// <DE> kopieren.
u8 filemenu_msg_pal_30_de[] = {0x4B, 0x4F, 0x50, 0x49, 0x45, 0x52, 0x45, 0x4E, 0x0E, 0xFD};

// has been created.
u8 filemenu_msg_31[] = {0x48, 0x41, 0x53, 0xF7, 0x42, 0x45, 0x45, 0x4E, 0xF7, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x0E, 0xFD};
u8 filemenu_msg_31_de[] = {0x57, 0x55, 0x52, 0x44, 0x45, 0xF7, 0x45, 0x52, 0x53, 0x54, 0x45, 0x4C, 0x4C, 0x54, 0x0E, 0xFD};
u8 filemenu_msg_31_fr[] = {0x41, 0xF7, 0x7D, 0x54, 0x7D, 0xF7, 0x43, 0x52, 0x7D, 0x7D, 0x0E, 0xFD};
u8 filemenu_msg_31_es[] = {0x48, 0x41, 0xF7, 0x53, 0x49, 0x44, 0x4F, 0xF7, 0x43, 0x52, 0x45, 0x41, 0x44, 0x4F, 0x0E, 0xFD};

// Enter a file name
u8 filemenu_msg_32[] = {0x25, 0x4E, 0x54, 0x45, 0x52, 0xF7, 0x41, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x4E, 0x41, 0x4D, 0x45, 0x01, 0xFD};
u8 filemenu_msg_32_de[] = {0x27, 0x49, 0x42, 0xF7, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0xF7, 0x2E, 0x41, 0x4D, 0x45, 0x4E, 0xF7, 0x45, 0x49, 0x4E, 0x01, 0xFD};
u8 filemenu_msg_32_fr[] = {0x25, 0x4E, 0x54, 0x52, 0x45, 0x52, 0xF7, 0x4C, 0x45, 0xF7, 0x4E, 0x4F, 0x4D, 0xF7, 0x44, 0x55, 0xF7, 0x26, 0x49, 0x43, 0x48, 0x49, 0x45, 0x52, 0x01, 0xFD};
u8 filemenu_msg_32_es[] = {0x8D, 0x29, 0x4E, 0x54, 0x52, 0x4F, 0x44, 0x55, 0x43, 0x45, 0xF7, 0x4E, 0x4F, 0x4D, 0x42, 0x52, 0x45, 0x01, 0xFD};

u8 filemenu_msg_36[] = {0x11, 0xFD};  // 1[End]
u8 filemenu_msg_37[] = {0x12, 0xFD};  // 2[End]
u8 filemenu_msg_38[] = {0x13, 0xFD};  // 3[End]
u8 filemenu_msg_39[] = {0x14, 0xFD};  // 4[End]

u8 filemenu_createfile_gridData[] = {0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x61, 0x66, 0x6A, 0x6D, 0x6F, 0x73, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x84, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x10, 0x0E, 0x0D, 0xF7, 0x00, 0x90, 0x91, 0x20, 0xF7, 0xF7, 0xF7, 0xC9, 0xF7, 0xF7, 0xCA, 0xF7, 0xF7};

#else
u8 filemenu_msg_01[] = { 0x33, 0x45, 0x4C, 0x45, 0x43, 0x54, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x53,
                    0x54, 0x41, 0x52, 0x54, 0x1A, 0xFD };
u8 filemenu_msg_02[] = { 0x33, 0x45, 0x4C, 0x45, 0x43, 0x54, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x44,
                    0x45, 0x4C, 0x45, 0x54, 0x45, 0x1A, 0xFD };
u8 filemenu_msg_03[] = { 0x33, 0x45, 0x4C, 0x45, 0x43, 0x54, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x53,
                    0x41, 0x56, 0x45, 0xFD };
u8 filemenu_msg_04[] = { 0x23, 0x4F, 0x50, 0x59, 0xF7, 0x57, 0x48, 0x49, 0x43, 0x48, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0x1F,
                    0xFD };
u8 filemenu_msg_05[] = { 0x23, 0x4F, 0x50, 0x59, 0xF7, 0x54, 0x4F, 0xF7, 0x57, 0x48, 0x49, 0x43, 0x48, 0xF7, 0x46, 0x49,
                    0x4C, 0x45, 0x1F, 0xFD };
u8 filemenu_msg_06[] = { 0x2E, 0x25, 0x37, 0xFD };
u8 filemenu_msg_07[] = { 0x2C, 0x45, 0x56, 0x45, 0x4C, 0xFD };
u8 filemenu_msg_08[] = { 0x30, 0x4C, 0x41, 0x59, 0xF7, 0x34, 0x49, 0x4D, 0x45, 0xFD };
u8 filemenu_msg_09[] = { 0x24, 0x45, 0x4C, 0x45, 0x54, 0x45, 0xF7, 0x26, 0x49, 0x4C, 0x45, 0xFD };
u8 filemenu_msg_10[] = { 0x23, 0x41, 0x4E, 0x43, 0x45, 0x4C, 0xFD };
u8 filemenu_msg_11[] = { 0x23, 0x4F, 0x50, 0x59, 0xF7, 0x26, 0x49, 0x4C, 0x45, 0xFD };
u8 filemenu_msg_12[] = { 0x26, 0x49, 0x52, 0x53, 0x54, 0xF7, 0x30, 0x4C, 0x41, 0x59, 0xFD };
u8 filemenu_msg_13[] = { 0x0E, 0xFD };
u8 filemenu_msg_14[] = { 0x39, 0x45, 0x53, 0xFD };
u8 filemenu_msg_15[] = { 0x2E, 0x4F, 0xFD };
u8 filemenu_msg_16[] = { 0x24, 0x45, 0x4C, 0x45, 0x54, 0x45, 0xFD };
u8 filemenu_msg_17[] = { 0x2F, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x45, 0xF7, 0x54, 0x4F, 0xF7, 0x2E, 0x45, 0x57, 0xF7,
                    0x24, 0x41, 0x54, 0x41, 0xFD };
u8 filemenu_msg_18[] = { 0x33, 0x41, 0x56, 0x45, 0xF7, 0x2F, 0x2B, 0x1F, 0xFD };
u8 filemenu_msg_19[] = { 0x26, 0x49, 0x4C, 0x45, 0xF7, 0x4E, 0x41, 0x4D, 0x45, 0xF7, 0x49, 0x53, 0xF7, 0x1A, 0xFD };
u8 filemenu_msg_20[] = { 0x0E, 0xFD };
u8 filemenu_msg_21[] = { 0x2F, 0x2B, 0x1F, 0xFD };
u8 filemenu_msg_22[] = { 0x26, 0x49, 0x4C, 0x45, 0xFD };
u8 filemenu_msg_23[] = { 0x57, 0x49, 0x4C, 0x4C, 0xF7, 0x42, 0x45, 0xF7, 0x44, 0x45, 0x4C, 0x45, 0x54, 0x45, 0x44, 0x0E,
                    0xFD };
u8 filemenu_msg_24[] = { 0x2F, 0x2B, 0xF7, 0x54, 0x4F, 0xF7, 0x43, 0x4F, 0x50, 0x59, 0xF7, 0x54, 0x4F, 0xF7, 0x54, 0x48,
                    0x49, 0x53, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0x1F, 0xFD };
u8 filemenu_msg_25[] = { 0x33, 0x54, 0x41, 0x52, 0x54, 0xF7, 0x47, 0x41, 0x4D, 0x45, 0xF7, 0x57, 0x49, 0x54, 0x48, 0xFD };
u8 filemenu_msg_26[] = { 0x26, 0x49, 0x4C, 0x45, 0xFD };
u8 filemenu_msg_27[] = { 0x48, 0x41, 0x53, 0xF7, 0x42, 0x45, 0x45, 0x4E, 0xF7, 0x44, 0x45, 0x4C, 0x45, 0x54, 0x45, 0x44,
                    0x0E, 0xFD };
u8 filemenu_msg_28[] = { 0xFD };
u8 filemenu_msg_29[] = { 0x23, 0x4F, 0x50, 0x59, 0xF7, 0x46, 0x52, 0x4F, 0x4D, 0xFD };
u8 filemenu_msg_30[] = { 0x54, 0x4F, 0xFD };
u8 filemenu_msg_31[] = { 0x48, 0x41, 0x53, 0xF7, 0x42, 0x45, 0x45, 0x4E, 0xF7, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
                    0x0E, 0xFD };
u8 filemenu_msg_32[] = { 0x25, 0x4E, 0x54, 0x45, 0x52, 0xF7, 0x41, 0xF7, 0x46, 0x49, 0x4C, 0x45, 0xF7, 0x4E, 0x41, 0x4D,
                    0x45, 0x01, 0xFD };
u8 filemenu_createfile_gridData[] = { 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
                                  0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A,
                                  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
                                  0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A,
                                  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x10, 0x0E, 0x0D, 0xF7,
                                  0x00, 0x90, 0x91, 0x20, 0xC6, 0xF7, 0xF7, 0xC9, 0xF7, 0xF7, 0xCA, 0xF7, 0xF7
};
u8 filemenu_msg_33[] = { 0x1F, 0xFD };
u8 filemenu_msg_34[] = { 0x0E, 0xFD };
#endif

u8 *gFileMenuMessages[] = {
    [FILE_MESSAGE_NONE]                        NULL,
    [FILE_MESSAGE_SELECT_FILE_TO_START]        filemenu_msg_01,
    [FILE_MESSAGE_SELECT_FILE_TO_DELETE]       filemenu_msg_02,
#if !VERSION_PAL
    [FILE_MESSAGE_SELECT_FILE_TO_SAVE]         filemenu_msg_03,
#endif
    [FILE_MESSAGE_COPY_WHICH_FILE]             filemenu_msg_04,
    [FILE_MESSAGE_COPY_TO_WHICH_FILE]          filemenu_msg_05,
    [FILE_MESSAGE_NEW]                         filemenu_msg_06,
    [FILE_MESSAGE_LEVEL]                       filemenu_msg_07,
    [FILE_MESSAGE_PLAY_TIME]                   filemenu_msg_08,
    [FILE_MESSAGE_DELETE_FILE]                 filemenu_msg_09,
    [FILE_MESSAGE_CANCEL]                      filemenu_msg_10,
    [FILE_MESSAGE_COPY_FILE]                   filemenu_msg_11,
    [FILE_MESSAGE_FIRST_PLAY]                  filemenu_msg_12,
    [FILE_MESSAGE_PERIOD_13]                   filemenu_msg_13,
    [FILE_MESSAGE_YES]                         filemenu_msg_14,
    [FILE_MESSAGE_NO]                          filemenu_msg_15,
    [FILE_MESSAGE_DELETE]                      filemenu_msg_16,
#if !VERSION_PAL
    [FILE_MESSAGE_OVERRIDE_TO_NEW_DATA]        filemenu_msg_17,
    [FILE_MESSAGE_SAVE_OK]                     filemenu_msg_18,
#endif
    [FILE_MESSAGE_FILE_NAME_IS]                filemenu_msg_19,
#if VERSION_PAL
    [FILE_MESSAGE_PERIOD_20]                   filemenu_msg_13,
#else
    [FILE_MESSAGE_PERIOD_20]                   filemenu_msg_20,
#endif
    [FILE_MESSAGE_OK]                          filemenu_msg_21,
    [FILE_MESSAGE_FILE_22]                     filemenu_msg_22,
#if VERSION_PAL
    [FILE_MESSAGE_PAL_FILE_20]                 filemenu_msg_22,
#endif
    [FILE_MESSAGE_WILL_BE_DELETED]             filemenu_msg_23,
    [FILE_MESSAGE_OK_TO_COPY_TO_THIS_FILE]     filemenu_msg_24,
    [FILE_MESSAGE_START_GAME_WITH]             filemenu_msg_25,
#if VERSION_PAL
    [FILE_MESSAGE_PAL_QUESTION_24]             filemenu_msg_pal_24,
    [FILE_MESSAGE_FILE_26]                     filemenu_msg_22,
#else
    [FILE_MESSAGE_FILE_26]                     filemenu_msg_26,
#endif
    [FILE_MESSAGE_HAS_BEEN_DELETED]            filemenu_msg_27,
    [FILE_MESSAGE_28]                          filemenu_msg_28,
    [FILE_MESSAGE_COPY_FROM]                   filemenu_msg_29,
    [FILE_MESSAGE_TO]                          filemenu_msg_30,
#if VERSION_PAL
    [FILE_MESSAGE_PAL_PERIOD_30]               filemenu_msg_13,
#endif
    [FILE_MESSAGE_HAS_BEEN_CREATED]            filemenu_msg_31,
#if VERSION_PAL
    [FILE_MESSAGE_PAL_ARTICLE]                 filemenu_msg_28,
#endif
    [FILE_MESSAGE_ENTER_A_FILE_NAME]           filemenu_msg_32,
#if VERSION_PAL
    [FILE_MESSAGE_QUESTION]                    filemenu_msg_pal_24,
    [FILE_MESSAGE_PERIOD_34]                   filemenu_msg_13,
    [FILE_MESSAGE_PAL_FILENUM_1]               filemenu_msg_36,
    [FILE_MESSAGE_PAL_FILENUM_2]               filemenu_msg_37,
    [FILE_MESSAGE_PAL_FILENUM_3]               filemenu_msg_38,
    [FILE_MESSAGE_PAL_FILENUM_4]               filemenu_msg_39,
#else
    [FILE_MESSAGE_QUESTION]                    filemenu_msg_33,
    [FILE_MESSAGE_PERIOD_34]                   filemenu_msg_34,
#endif
};

#if VERSION_PAL
u8* gFileMenuMessages_de[] = {
    [FILE_MESSAGE_NONE]                        NULL,
    [FILE_MESSAGE_SELECT_FILE_TO_START]        filemenu_msg_01_de,
    [FILE_MESSAGE_SELECT_FILE_TO_DELETE]       filemenu_msg_02_de,
    [FILE_MESSAGE_COPY_WHICH_FILE]             filemenu_msg_04_de,
    [FILE_MESSAGE_COPY_TO_WHICH_FILE]          filemenu_msg_05_de,
    [FILE_MESSAGE_NEW]                         filemenu_msg_06_de,
    [FILE_MESSAGE_LEVEL]                       filemenu_msg_07,
    [FILE_MESSAGE_PLAY_TIME]                   filemenu_msg_08_de,
    [FILE_MESSAGE_DELETE_FILE]                 filemenu_msg_09_de,
    [FILE_MESSAGE_CANCEL]                      filemenu_msg_10_de,
    [FILE_MESSAGE_COPY_FILE]                   filemenu_msg_11_de,
    [FILE_MESSAGE_FIRST_PLAY]                  filemenu_msg_12_de,
    [FILE_MESSAGE_PERIOD_13]                   filemenu_msg_13,
    [FILE_MESSAGE_YES]                         filemenu_msg_14_de,
    [FILE_MESSAGE_NO]                          filemenu_msg_15_de,
    [FILE_MESSAGE_DELETE]                      filemenu_msg_16_de,
    [FILE_MESSAGE_FILE_NAME_IS]                filemenu_msg_19_de,
    [FILE_MESSAGE_PERIOD_20]                   filemenu_msg_13,
    [FILE_MESSAGE_OK]                          filemenu_msg_21,
    [FILE_MESSAGE_FILE_22]                     filemenu_msg_22_de,
    [FILE_MESSAGE_PAL_FILE_20]                 filemenu_msg_pal_20_de,
    [FILE_MESSAGE_WILL_BE_DELETED]             filemenu_msg_23_de,
    [FILE_MESSAGE_OK_TO_COPY_TO_THIS_FILE]     filemenu_msg_24_de,
    [FILE_MESSAGE_START_GAME_WITH]             filemenu_msg_25_de,
    [FILE_MESSAGE_PAL_QUESTION_24]             filemenu_msg_pal_24_de,
    [FILE_MESSAGE_FILE_26]                     filemenu_msg_22_de,
    [FILE_MESSAGE_HAS_BEEN_DELETED]            filemenu_msg_27_de,
    [FILE_MESSAGE_28]                          filemenu_msg_28,
    [FILE_MESSAGE_COPY_FROM]                   filemenu_msg_29_de,
    [FILE_MESSAGE_TO]                          filemenu_msg_30_de,
    [FILE_MESSAGE_PAL_PERIOD_30]               filemenu_msg_pal_30_de,
    [FILE_MESSAGE_HAS_BEEN_CREATED]            filemenu_msg_31_de,
    [FILE_MESSAGE_PAL_ARTICLE]                 filemenu_msg_28,
    [FILE_MESSAGE_ENTER_A_FILE_NAME]           filemenu_msg_32_de,
    [FILE_MESSAGE_QUESTION]                    filemenu_msg_pal_24,
    [FILE_MESSAGE_PERIOD_34]                   filemenu_msg_13,
    [FILE_MESSAGE_PAL_FILENUM_1]               filemenu_msg_36,
    [FILE_MESSAGE_PAL_FILENUM_2]               filemenu_msg_37,
    [FILE_MESSAGE_PAL_FILENUM_3]               filemenu_msg_38,
    [FILE_MESSAGE_PAL_FILENUM_4]               filemenu_msg_39,
};

u8* gFileMenuMessages_fr[] = {
    [FILE_MESSAGE_NONE]                        NULL,
    [FILE_MESSAGE_SELECT_FILE_TO_START]        filemenu_msg_01_fr,
    [FILE_MESSAGE_SELECT_FILE_TO_DELETE]       filemenu_msg_02_fr,
    [FILE_MESSAGE_COPY_WHICH_FILE]             filemenu_msg_04_fr,
    [FILE_MESSAGE_COPY_TO_WHICH_FILE]          filemenu_msg_05_fr,
    [FILE_MESSAGE_NEW]                         filemenu_msg_06_fr,
    [FILE_MESSAGE_LEVEL]                       filemenu_msg_07_fr,
    [FILE_MESSAGE_PLAY_TIME]                   filemenu_msg_08_fr,
    [FILE_MESSAGE_DELETE_FILE]                 filemenu_msg_09_fr,
    [FILE_MESSAGE_CANCEL]                      filemenu_msg_10_fr,
    [FILE_MESSAGE_COPY_FILE]                   filemenu_msg_11_fr,
    [FILE_MESSAGE_FIRST_PLAY]                  filemenu_msg_12_fr,
    [FILE_MESSAGE_PERIOD_13]                   filemenu_msg_13,
    [FILE_MESSAGE_YES]                         filemenu_msg_14_fr,
    [FILE_MESSAGE_NO]                          filemenu_msg_15_fr,
    [FILE_MESSAGE_DELETE]                      filemenu_msg_16_fr,
    [FILE_MESSAGE_FILE_NAME_IS]                filemenu_msg_19_fr,
    [FILE_MESSAGE_PERIOD_20]                   filemenu_msg_13,
    [FILE_MESSAGE_OK]                          filemenu_msg_21,
    [FILE_MESSAGE_FILE_22]                     filemenu_msg_22_fr,
    [FILE_MESSAGE_PAL_FILE_20]                 filemenu_msg_pal_20_fr_es,
    [FILE_MESSAGE_WILL_BE_DELETED]             filemenu_msg_23_fr,
    [FILE_MESSAGE_OK_TO_COPY_TO_THIS_FILE]     filemenu_msg_24_fr,
    [FILE_MESSAGE_START_GAME_WITH]             filemenu_msg_25_fr,
    [FILE_MESSAGE_PAL_QUESTION_24]             filemenu_msg_pal_24,
    [FILE_MESSAGE_FILE_26]                     filemenu_msg_22_fr,
    [FILE_MESSAGE_HAS_BEEN_DELETED]            filemenu_msg_27_fr,
    [FILE_MESSAGE_28]                          filemenu_msg_28_fr,
    [FILE_MESSAGE_COPY_FROM]                   filemenu_msg_29_fr,
    [FILE_MESSAGE_TO]                          filemenu_msg_30_fr,
    [FILE_MESSAGE_PAL_PERIOD_30]               filemenu_msg_13,
    [FILE_MESSAGE_HAS_BEEN_CREATED]            filemenu_msg_31_fr,
    [FILE_MESSAGE_PAL_ARTICLE]                 filemenu_msg_28,
    [FILE_MESSAGE_ENTER_A_FILE_NAME]           filemenu_msg_32_fr,
    [FILE_MESSAGE_QUESTION]                    filemenu_msg_pal_24,
    [FILE_MESSAGE_PERIOD_34]                   filemenu_msg_13,
    [FILE_MESSAGE_PAL_FILENUM_1]               filemenu_msg_36,
    [FILE_MESSAGE_PAL_FILENUM_2]               filemenu_msg_37,
    [FILE_MESSAGE_PAL_FILENUM_3]               filemenu_msg_38,
    [FILE_MESSAGE_PAL_FILENUM_4]               filemenu_msg_39,
};

u8* gFileMenuMessages_es[] = {
    [FILE_MESSAGE_NONE]                        NULL,
    [FILE_MESSAGE_SELECT_FILE_TO_START]        filemenu_msg_01_es,
    [FILE_MESSAGE_SELECT_FILE_TO_DELETE]       filemenu_msg_02_es,
    [FILE_MESSAGE_COPY_WHICH_FILE]             filemenu_msg_04_es,
    [FILE_MESSAGE_COPY_TO_WHICH_FILE]          filemenu_msg_05_es,
    [FILE_MESSAGE_NEW]                         filemenu_msg_06_es,
    [FILE_MESSAGE_LEVEL]                       filemenu_msg_07_es,
    [FILE_MESSAGE_PLAY_TIME]                   filemenu_msg_08_es,
    [FILE_MESSAGE_DELETE_FILE]                 filemenu_msg_09_es,
    [FILE_MESSAGE_CANCEL]                      filemenu_msg_10_es,
    [FILE_MESSAGE_COPY_FILE]                   filemenu_msg_11_es,
    [FILE_MESSAGE_FIRST_PLAY]                  filemenu_msg_12_es,
    [FILE_MESSAGE_PERIOD_13]                   filemenu_msg_13,
    [FILE_MESSAGE_YES]                         filemenu_msg_14_es,
    [FILE_MESSAGE_NO]                          filemenu_msg_15_es,
    [FILE_MESSAGE_DELETE]                      filemenu_msg_16_es,
    [FILE_MESSAGE_FILE_NAME_IS]                filemenu_msg_19_es,
    [FILE_MESSAGE_PERIOD_20]                   filemenu_msg_13,
    [FILE_MESSAGE_OK]                          filemenu_msg_21_es,
    [FILE_MESSAGE_FILE_22]                     filemenu_msg_22_es,
    [FILE_MESSAGE_PAL_FILE_20]                 filemenu_msg_pal_20_fr_es,
    [FILE_MESSAGE_WILL_BE_DELETED]             filemenu_msg_23_es,
    [FILE_MESSAGE_OK_TO_COPY_TO_THIS_FILE]     filemenu_msg_24_es,
    [FILE_MESSAGE_START_GAME_WITH]             filemenu_msg_25_es,
    [FILE_MESSAGE_PAL_QUESTION_24]             filemenu_msg_pal_24,
    [FILE_MESSAGE_FILE_26]                     filemenu_msg_22_es,
    [FILE_MESSAGE_HAS_BEEN_DELETED]            filemenu_msg_27_es,
    [FILE_MESSAGE_28]                          filemenu_msg_28_es,
    [FILE_MESSAGE_COPY_FROM]                   filemenu_msg_29_es,
    [FILE_MESSAGE_TO]                          filemenu_msg_30_es,
    [FILE_MESSAGE_PAL_PERIOD_30]               filemenu_msg_13,
    [FILE_MESSAGE_HAS_BEEN_CREATED]            filemenu_msg_31_es,
    [FILE_MESSAGE_PAL_ARTICLE]                 filemenu_msg_28_es,
    [FILE_MESSAGE_ENTER_A_FILE_NAME]           filemenu_msg_32_es,
    [FILE_MESSAGE_QUESTION]                    filemenu_msg_pal_24,
    [FILE_MESSAGE_PERIOD_34]                   filemenu_msg_13,
    [FILE_MESSAGE_PAL_FILENUM_1]               filemenu_msg_36,
    [FILE_MESSAGE_PAL_FILENUM_2]               filemenu_msg_37,
    [FILE_MESSAGE_PAL_FILENUM_3]               filemenu_msg_38,
    [FILE_MESSAGE_PAL_FILENUM_4]               filemenu_msg_39,
};

u8 **gFileMenuMessages_intl[] = {
    gFileMenuMessages,
    gFileMenuMessages_de,
    gFileMenuMessages_fr,
    gFileMenuMessages_es,
};
#endif

s32 filemenu_draw_char(s32 c, s32 x, s32 y, s32 flag1, s32 color, s32 flag2) {
    MessageCharset* charset;
    s32 texSizeX;
    s32 texSizeY;
    s32 charRasterSize;
    MessageCharData* charData;
    u8* raster;
    s32 charWidth;

    if (flag1 != filemenu_charset) {
        filemenu_charset = flag1;
        filemenu_charset_raster_id = 0;
    }

    charset = MsgCharsets[filemenu_charset];
    texSizeX = charset->texSize.x;
    texSizeY = charset->texSize.y;
    charRasterSize = charset->charRasterSize;
    charData = &charset->rasters[filemenu_charset_raster_id];
    charWidth = charData->monospaceWidth;
    raster = charData->raster;

    if (c < 0xA2) {
        charWidth = charData->charWidthTable[c];
        if (gMainGfxPos != filemenu_savedGfxPos) {
            gSPDisplayList(gMainGfxPos++, filemenu_dl_draw_char_init);
            filemenu_char_color = -1;
        }

        if (filemenu_char_color != color) {
            filemenu_char_color = color;
            gDPLoadTLUT_pal16(gMainGfxPos++, 0, D_802F4560[color]);
        }

        if (texSizeX >= 16 && texSizeX % 16 == 0) {
            gDPLoadTextureBlock_4b(gMainGfxPos++, &raster[charRasterSize * c], G_IM_FMT_CI,
                                texSizeX, texSizeY, 0,
                                G_TX_WRAP, G_TX_WRAP, G_TX_NOMASK, G_TX_NOMASK, G_TX_NOLOD, G_TX_NOLOD);
        } else {
            gDPLoadTextureTile_4b(gMainGfxPos++, &raster[charRasterSize * c], G_IM_FMT_CI,
                                texSizeX, texSizeY,
                                0, 0, texSizeX - 1, texSizeY - 1, 0,
                                G_TX_WRAP, G_TX_WRAP, G_TX_NOMASK, G_TX_NOMASK, G_TX_NOLOD, G_TX_NOLOD);
        }

        if (flag2) {
            gDPSetCombineMode(gMainGfxPos++, PM_CC_07, PM_CC_07);
            gDPSetRenderMode(gMainGfxPos++, G_RM_CLD_SURF, G_RM_CLD_SURF2);
            filemenu_draw_rect((x + 2) * 4, (y + 2) * 4, (2 + x + texSizeX) * 4, (2 + y + texSizeY) * 4, 0, 0, 0, 0x400, 0x400);
            gDPPipeSync(gMainGfxPos++);
            gDPSetCombineMode(gMainGfxPos++, G_CC_DECALRGBA, G_CC_DECALRGBA);
            gDPSetRenderMode(gMainGfxPos++, G_RM_TEX_EDGE, G_RM_TEX_EDGE2);
        }

        filemenu_draw_rect(x * 4, y * 4, (x + texSizeX) * 4, (y + texSizeY) * 4, 0, 0, 0, 0x400, 0x400);
        filemenu_savedGfxPos = gMainGfxPos;
        return charWidth;
    }

#if VERSION_IQUE
    if (c >= 0x100) {
        int offset;
        s32 character;
        s32* offsetPtr = &filemenu_glyphBufferIndex;

        character = c < 0 ? c + 0xFF : c;
        offset = (((character >> 8) - 1) * 0x31) + (c & 0xff) + 0x47;
        *offsetPtr = offset; // Probably modifying data outside of the filemenu_glyphBuffer array

        load_font_data(charset_standard_OFFSET + offset * 0x80, 0x80, &filemenu_glyphBuffer[*offsetPtr][0]);

        if (gMainGfxPos != filemenu_savedGfxPos) {
            gSPDisplayList(gMainGfxPos++, filemenu_dl_draw_char_init);
            filemenu_char_color = -1;
        }

        if (filemenu_char_color != color) {
            filemenu_char_color = color;
            gDPLoadTLUT_pal16(gMainGfxPos++, 0, D_802F4560[color]);
        }

        gDPLoadTextureBlock_4b(gMainGfxPos++, &filemenu_glyphBuffer[*offsetPtr][0], G_IM_FMT_CI, 16, 16, 0, G_TX_NOMIRROR | G_TX_WRAP, G_TX_NOMIRROR | G_TX_WRAP, G_TX_NOMASK, G_TX_NOMASK, G_TX_NOLOD, G_TX_NOLOD);

        if (flag2) {
            gDPSetCombineMode(gMainGfxPos++, PM_CC_07, PM_CC_07);
            gDPSetRenderMode(gMainGfxPos++, G_RM_CLD_SURF, G_RM_CLD_SURF2);
            filemenu_draw_rect((x + 2) * 4, (y + 2) * 4, (x + 18) * 4, (y + 18) * 4, 0, 0, 0, 0x400, 0x400);
            gDPPipeSync(gMainGfxPos++);
            gDPSetCombineMode(gMainGfxPos++, G_CC_DECALRGBA, G_CC_DECALRGBA);
            gDPSetRenderMode(gMainGfxPos++, G_RM_TEX_EDGE, G_RM_TEX_EDGE2);
        }

        filemenu_draw_rect(x * 4, y * 4, (x + 16) * 4, (y + 16) * 4, 0, 0, 0, 0x400, 0x400);
        filemenu_savedGfxPos = gMainGfxPos;
        *offsetPtr = (*offsetPtr + 1) % 20;

        return 16;
    }
#endif

    if (c == MSG_CHAR_READ_SPACE) {
        return charWidth - 6;
    }

    switch (c) {
        case MSG_CHAR_READ_VARIANT0:
            filemenu_charset_raster_id = 0;
            break;
        case MSG_CHAR_READ_VARIANT1:
            filemenu_charset_raster_id = 1;
            break;
        case MSG_CHAR_READ_VARIANT2:
            filemenu_charset_raster_id = 2;
            break;
        case MSG_CHAR_READ_VARIANT3:
            filemenu_charset_raster_id = 3;
            break;
    }
    return 0;
}

void filemenu_draw_message(u8* message, s32 x, s32 y, s32 alpha, s32 color, u32 flags) {
    s32 flag1 = flags & 1;
    s32 flag2 = flags >> 3;

    flag2 &= 1;
    if (flag1 == 1) {
        y -= 2;
    }

    if ((u32)message < 0x100) {
        if ((u32)message - 0xA2 >= 0x4E) {
            filemenu_draw_char((s32)message, x, y, flag1, color, flag2);
            return;
        }
        if ((s32) message >= 0xC6) {
#if VERSION_PAL
            message = (u8*) filemenu_specialSymbols[gCurrentLanguage][(s32) message - 0xC6];
#else
            message = (u8*)filemenu_specialSymbols[(s32) message - 0xC6];
#endif
        }
    }

    if ((s32) message < 0) {
        u8* tmp;
        filemenu_draw_char(0xF3, x, y, flag1, color, flag2);
        tmp = message;
        while (*tmp != MSG_CHAR_READ_END) {
#if VERSION_IQUE
            int ord = *tmp;
            if (ord >= MSG_CHAR_MULTIBYTE_FIRST && ord <= MSG_CHAR_MULTIBYTE_LAST) {
                tmp++;
                ord = (*tmp << 8) + ord;
                x += filemenu_draw_char(ord, x, y + 1, flag1, color, flag2);
            } else {
                ord = *tmp;
                x += filemenu_draw_char(ord, x, y, flag1, color, flag2);
            }
            tmp++;
#else
            x += filemenu_draw_char(*tmp, x, y, flag1, color, flag2);
            tmp++;
#endif
        }
    }
}

u8* filemenu_get_menu_message(s32 idx) {
#if VERSION_PAL
    return gFileMenuMessages_intl[gCurrentLanguage][idx];
#else
    return gFileMenuMessages[idx];
#endif
}

void filemenu_draw_file_name(u8* filename, s32 length, s32 x, s32 y, s32 alpha, s32 arg5, s32 arg6, s32 charWidth) {
    s32 i;

    for (i = 0; i < length; i++) {
        u32 c = filename[i];

        if (c != MSG_CHAR_READ_SPACE) {
#if VERSION_IQUE
            // Numerals get drawn one pixel lower than other characters
            if (c >= MSG_CHAR_DIGIT_0 && c <= MSG_CHAR_DIGIT_9) {
                filemenu_draw_message((u8*)c, x + (i * charWidth), y + 1, alpha, arg5, arg6);
            } else {
                filemenu_draw_message((u8*)c, x + (i * charWidth), y, alpha, arg5, arg6);
            }
#elif VERSION_PAL
            s32 offset = (8 - msg_get_print_char_width(c, 0, 0, 1.0f, 0, 1)) / 2;

            filemenu_draw_message((u8*)c, x + (i * charWidth) + offset, y, alpha, arg5, arg6);
#else
            filemenu_draw_message((u8*)c, x + (i * charWidth), y, alpha, arg5, arg6);
#endif
        }
    }
}
