#ifndef _SCRIPT_API_BATTLE_H_
#define _SCRIPT_API_BATTLE_H_

#include "common_structs.h"
#include "evt.h"

#include "script_api/common.h"
#include "battle/action_cmd.h"

#include "effects.h"

API_CALLABLE(EnablePartnerBlur);
API_CALLABLE(DisablePartnerBlur);
API_CALLABLE(UseBattleCamPreset);
API_CALLABLE(SetBattleCamTarget);
API_CALLABLE(SetBattleCamOffsetY);
API_CALLABLE(AddBattleCamOffsetY);
API_CALLABLE(SetBattleCamYaw);
API_CALLABLE(BattleCamTargetActor);
API_CALLABLE(MoveBattleCamOver);
API_CALLABLE(SetBattleCamDist);
API_CALLABLE(AddBattleCamDist);
API_CALLABLE(FreezeBattleCam);
API_CALLABLE(DisableBattleCamClampX);
API_CALLABLE(ShowMessageBox);
API_CALLABLE(ShowVariableMessageBox);
API_CALLABLE(IsMessageBoxDisplayed);
API_CALLABLE(WaitForMessageBoxDone);
API_CALLABLE(ForceCloseMessageBox);
API_CALLABLE(SetMessageBoxDuration);
API_CALLABLE(ItemDamageEnemy);
API_CALLABLE(ItemAfflictEnemy);
API_CALLABLE(ItemSpookEnemy);
API_CALLABLE(ItemCheckHit);
API_CALLABLE(ActorSpeak);
API_CALLABLE(EndActorSpeech);
API_CALLABLE(ShowBattleChoice);
API_CALLABLE(OverrideBattleDmaDest);
API_CALLABLE(LoadBattleDmaData);
API_CALLABLE(EnableBattleFloorReflections);
API_CALLABLE(SetDarknessMode);
API_CALLABLE(PlaySoundAtActor);
API_CALLABLE(PlaySoundAtPart);
API_CALLABLE(SetForegroundModelsVisibleUnchecked);
API_CALLABLE(SetForegroundModelsVisible);
API_CALLABLE(MakeStatusField);
API_CALLABLE(MultiplyByActorScale);
API_CALLABLE(MultiplyVec2ByActorScale);
API_CALLABLE(MultiplyVec3ByActorScale);
API_CALLABLE(ApplyShrinkFromOwner);
API_CALLABLE(StartRumble);
API_CALLABLE(HasMerleeCastsLeft);
API_CALLABLE(SpawnRecoverHeartFX);
API_CALLABLE(SpawnRecoverFlowerFX);
API_CALLABLE(IncrementPlayerHP);
API_CALLABLE(IncrementPlayerFP);
API_CALLABLE(StartRumbleWithParams);
API_CALLABLE(LoadItemScript);
API_CALLABLE(LoadMoveScript);
API_CALLABLE(LoadBattleSection);
API_CALLABLE(GetBattlePhase);
API_CALLABLE(GetLastElement);
API_CALLABLE(SetDamageSource);
API_CALLABLE(GetDamageSource);
API_CALLABLE(SetGoalToHome);
API_CALLABLE(SetIdleGoalToHome);
API_CALLABLE(SetGoalToIndex);
API_CALLABLE(GetIndexFromPos);
API_CALLABLE(GetIndexFromHome);
API_CALLABLE(CountTargets);
API_CALLABLE(ForceHomePos);
API_CALLABLE(SetHomePos);
API_CALLABLE(SetGoalToTarget);
API_CALLABLE(SetPartGoalToTarget);
API_CALLABLE(SetGoalToFirstTarget);
API_CALLABLE(SetGoalPos);
API_CALLABLE(SetIdleGoal);
API_CALLABLE(AddGoalPos);
API_CALLABLE(GetGoalPos);
API_CALLABLE(GetIdleGoal);
API_CALLABLE(GetPartTarget);
API_CALLABLE(GetActorPos);
API_CALLABLE(GetPartOffset);
API_CALLABLE(GetPartPos);
API_CALLABLE(GetHomePos);
API_CALLABLE(SetActorPos);
API_CALLABLE(SetPartPos);
API_CALLABLE(SetEnemyTargetOffset);
API_CALLABLE(SetAnimation);
API_CALLABLE(GetAnimation);
API_CALLABLE(SetAnimationRate);
API_CALLABLE(SetActorYaw);
API_CALLABLE(GetActorYaw);
API_CALLABLE(SetPartYaw);
API_CALLABLE(GetPartYaw);
API_CALLABLE(SetActorJumpGravity);
API_CALLABLE(SetActorIdleJumpGravity);
API_CALLABLE(SetActorSpeed);
API_CALLABLE(SetActorIdleSpeed);
API_CALLABLE(SetPartJumpGravity);
API_CALLABLE(SetPartMoveSpeed);
API_CALLABLE(SetJumpAnimations);
API_CALLABLE(AddActorPos);
API_CALLABLE(SetActorDispOffset);
API_CALLABLE(GetPartDispOffset);
API_CALLABLE(SetPartDispOffset);
API_CALLABLE(AddPartDispOffset);
API_CALLABLE(FreezeBattleState);
API_CALLABLE(GetActorVar);
API_CALLABLE(SetActorVar);
API_CALLABLE(AddActorVar);
API_CALLABLE(GetPartMovementVar);
API_CALLABLE(SetPartMovementVar);
API_CALLABLE(AddPartMovementVar);
API_CALLABLE(SetActorRotation);
API_CALLABLE(SetActorRotationOffset);
API_CALLABLE(GetActorRotation);
API_CALLABLE(SetPartRotation);
API_CALLABLE(SetPartRotationOffset);
API_CALLABLE(GetPartRotation);
API_CALLABLE(SetActorScale);
API_CALLABLE(SetActorScaleModifier);
API_CALLABLE(GetActorScale);
API_CALLABLE(SetPartScale);
API_CALLABLE(GetPartScale);
API_CALLABLE(GetBattleFlags);
API_CALLABLE(SetBattleFlagBits);
API_CALLABLE(GetBattleFlags2);
API_CALLABLE(SetBattleFlagBits2);
API_CALLABLE(SetActorFlags);
API_CALLABLE(SetActorFlagBits);
API_CALLABLE(GetActorFlags);
API_CALLABLE(SetPartFlags);
API_CALLABLE(SetPartFlagBits);
API_CALLABLE(SetPartTargetFlags);
API_CALLABLE(SetPartTargetFlagBits);
API_CALLABLE(GetPartFlags);
API_CALLABLE(GetPartTargetFlags);
API_CALLABLE(SetPartEventFlags);
API_CALLABLE(SetPartEventBits);
API_CALLABLE(GetPartEventFlags);
API_CALLABLE(HPBarToHome);
API_CALLABLE(HPBarToCurrent);
API_CALLABLE(SetHPBarOffset);
API_CALLABLE(SetActorStatusOffsets);
API_CALLABLE(SummonEnemy);
API_CALLABLE(GetOwnerID);
API_CALLABLE(SetOwnerID);
API_CALLABLE(ActorExists);
API_CALLABLE(SetEnabledStarPowers);
API_CALLABLE(SetBattleInputMask);
API_CALLABLE(SetBattleInputButtons);
API_CALLABLE(CheckButtonPress);
API_CALLABLE(CheckButtonHeld);
API_CALLABLE(CheckButtonDown);
API_CALLABLE(GetBattleState);
API_CALLABLE(CreateCurrentPosTargetList);
API_CALLABLE(CreateHomeTargetList);
API_CALLABLE(InitTargetIterator);
API_CALLABLE(SetOwnerTarget);
API_CALLABLE(ChooseNextTarget);
API_CALLABLE(GetTargetListLength);
API_CALLABLE(GetOwnerTarget);
API_CALLABLE(func_8026E914);
API_CALLABLE(GetPlayerActorID);
API_CALLABLE(GetDistanceToGoal);
API_CALLABLE(SetActorPaletteEffect);
API_CALLABLE(AddActorDecoration);
API_CALLABLE(RemoveActorDecoration);
API_CALLABLE(ModifyActorDecoration);
API_CALLABLE(UseIdleAnimation);
API_CALLABLE(GetStatusFlags);
API_CALLABLE(RemovePlayerBuffs);
API_CALLABLE(SetPartAlpha);
API_CALLABLE(CreatePartShadow);
API_CALLABLE(RemovePartShadow);
API_CALLABLE(SetEndBattleFadeOutRate);
API_CALLABLE(SetBattleVar);
API_CALLABLE(GetBattleVar);
API_CALLABLE(ResetAllActorSounds);
API_CALLABLE(SetActorSounds);
API_CALLABLE(ResetActorSounds);
API_CALLABLE(SetPartSounds);
API_CALLABLE(SetActorType);
API_CALLABLE(ShowShockEffect);
API_CALLABLE(GetActorAttackBoost);
API_CALLABLE(GetActorDefenseBoost);
API_CALLABLE(BoostAttack);
API_CALLABLE(BoostDefense);
API_CALLABLE(VanishActor);
API_CALLABLE(ElectrifyActor);
API_CALLABLE(HealActor);
API_CALLABLE(WaitForBuffDone);
API_CALLABLE(CopyBuffs);
API_CALLABLE(GetMenuSelection);
API_CALLABLE(PlayerFallToGoal);
API_CALLABLE(PlayerLandJump);
API_CALLABLE(PlayerRunToGoal);
API_CALLABLE(CancelablePlayerRunToGoal);
API_CALLABLE(GetPlayerHP);
API_CALLABLE(PlayerDamageEnemy);
API_CALLABLE(PlayerPowerBounceEnemy);
API_CALLABLE(PlayerTestEnemy);
API_CALLABLE(DispatchDamagePlayerEvent);
API_CALLABLE(EnablePlayerBlur);
API_CALLABLE(PlayerBasicJumpToGoal);
API_CALLABLE(PlayerSuperJumpToGoal);
API_CALLABLE(PlayerUltraJumpToGoal);
API_CALLABLE(GetPlayerActionQuality);
API_CALLABLE(BindTakeTurn);
API_CALLABLE(PauseTakeTurn);
API_CALLABLE(ResumeTakeTurn);
API_CALLABLE(BindIdle);
API_CALLABLE(EnableIdleScript);
API_CALLABLE(BindHandleEvent);
API_CALLABLE(BindHandlePhase);
API_CALLABLE(JumpToGoal);
API_CALLABLE(IdleJumpToGoal);
API_CALLABLE(JumpWithBounce);
API_CALLABLE(LandJump);
API_CALLABLE(FallToGoal);
API_CALLABLE(RunToGoal);
API_CALLABLE(IdleRunToGoal);
API_CALLABLE(JumpPartTo);
API_CALLABLE(FallPartTo);
API_CALLABLE(LandJumpPart);
API_CALLABLE(RunPartTo);
API_CALLABLE(FlyToGoal);
API_CALLABLE(IdleFlyToGoal);
API_CALLABLE(FlyPartTo);
API_CALLABLE(GetLastEvent);
API_CALLABLE(SetTargetActor);
API_CALLABLE(SetEnemyHP);
API_CALLABLE(GetActorHP);
API_CALLABLE(GetEnemyMaxHP);
API_CALLABLE(RemoveActor);
API_CALLABLE(DropStarPoints);
API_CALLABLE(SetDefenseTable);
API_CALLABLE(SetStatusTable);
API_CALLABLE(SetIdleAnimations);
API_CALLABLE(EnemyDamageTarget);
API_CALLABLE(EnemyFollowupAfflictTarget);
API_CALLABLE(EnemyTestTarget);
API_CALLABLE(DispatchDamageEvent);
API_CALLABLE(DispatchEvent);
API_CALLABLE(ShowHealthBar);
API_CALLABLE(SetTargetOffset);
API_CALLABLE(SetProjectileTargetOffset);
API_CALLABLE(EnableActorBlur);
API_CALLABLE(AfflictActor);
API_CALLABLE(GetInstigatorValue);
API_CALLABLE(GetEncounterTrigger);
API_CALLABLE(YieldTurn);
API_CALLABLE(SetActorSize);
API_CALLABLE(GetActorSize);
API_CALLABLE(SetPartSize);
API_CALLABLE(GetOriginalActorType);
API_CALLABLE(GetCurrentActorType);
API_CALLABLE(GetLastDamage);
API_CALLABLE(EnableActorGlow);
API_CALLABLE(WasStatusInflicted);
API_CALLABLE(CopyStatusEffects);
API_CALLABLE(ClearStatusEffects);
API_CALLABLE(MakeOwnerTargetIndex);
API_CALLABLE(GetActorLevel);
API_CALLABLE(PartnerDamageEnemy);
API_CALLABLE(PartnerAfflictEnemy);
API_CALLABLE(PartnerPowerBounceEnemy);
API_CALLABLE(PartnerTestEnemy);
API_CALLABLE(DeletePartner);
API_CALLABLE(GetDamageIntensity);
API_CALLABLE(AddEffectOffset);
API_CALLABLE(LoadStarPowerScript);
API_CALLABLE(ForceBattleCamTarget);
API_CALLABLE(SetBattleCamParam);
API_CALLABLE(GetPartAnimNotify);
API_CALLABLE(InitAnimatedModels);
API_CALLABLE(BattleCam_Init);
API_CALLABLE(SetCamLookTarget);
API_CALLABLE(func_802807D0);
API_CALLABLE(PartnerYieldTurn); ///< YieldTurn copy
API_CALLABLE(SetBattleCamTargetingModes);
API_CALLABLE(UseBattleCamPresetImmediately);
API_CALLABLE(UseBattleCamPresetWait);
API_CALLABLE(HideHealthBar);
API_CALLABLE(GetPartnerActionQuality);
API_CALLABLE(CreateNpc);
API_CALLABLE(EnableBattleStatusBar);
API_CALLABLE(PlayerYieldTurn);
API_CALLABLE(ShowStartRecoveryShimmer);
API_CALLABLE(ShowRecoveryShimmer);
API_CALLABLE(PlayerHopToGoal);
API_CALLABLE(WaitForState);
API_CALLABLE(SetBattleMenuEnabledFlags);
API_CALLABLE(SetBattleState);
API_CALLABLE(func_8027D434);
API_CALLABLE(func_8026F1A0);
API_CALLABLE(PlayLoopingSoundAtActor);
API_CALLABLE(StopLoopingSoundAtActor);
API_CALLABLE(EnableActorPaletteEffects);
API_CALLABLE(SetActorPaletteSwapParams);
API_CALLABLE(BattleCamTargetActorPart);
API_CALLABLE(GetDarknessStatus);
API_CALLABLE(CancelEnemyTurn);
API_CALLABLE(GetAnimatedNodeRotation);
API_CALLABLE(GetAnimatedNodePosition);
API_CALLABLE(DispatchEventPlayer);

extern EvtScript EVS_Mario_HandlePhase;
extern EvtScript EVS_Peach_HandlePhase;
extern EvtScript EVS_ExecuteMarioAction;
extern EvtScript EVS_ExecutePeachAction;
extern EvtScript EVS_Player_HandleEvent;
extern EvtScript BtlPutPartnerAway;
extern EvtScript BtlBringPartnerOut;
extern EvtScript EVS_MarioEnterStage;
extern EvtScript EVS_PeachEnterStage;
extern EvtScript EVS_PlayerFirstStrike;
extern EvtScript EVS_StartDefend;
extern EvtScript EVS_RunAwayStart;
extern EvtScript EVS_RunAwayFail;
extern EvtScript EVS_PlayerDies;
extern EvtScript EVS_Unused_EatItem;
extern EvtScript EVS_Unused_DrinkItem;
extern EvtScript EVS_UseLifeShroom;
extern EvtScript EVS_MerleeRunOut;
extern EvtScript EVS_MerleeAttackBonus;
extern EvtScript EVS_MerleeDefenseBonus;
extern EvtScript EVS_MerleeExpBonus;
extern EvtScript EVS_PlayerHappy;
extern EvtScript EVS_ApplyDizzyAttack;
extern EvtScript EVS_PlayerRegainAbility;
extern EvtScript EVS_UseMystery;
extern EvtScript EVS_PlaySleepHitFX;
extern EvtScript EVS_PlayDizzyHitFX;
extern EvtScript EVS_PlayParalyzeHitFX;
extern EvtScript EVS_PlayPoisonHitFX;
extern EvtScript EVS_PlayStopHitFX;
extern EvtScript EVS_PlayFreezeHitFX;
extern EvtScript EVS_PlayShrinkHitFX;
extern EvtScript EVS_ForceNextTarget;
extern EvtScript EVS_Enemy_Hit;
extern EvtScript EVS_Partner_RunAway;
extern EvtScript EVS_Partner_SpikeContact;
extern EvtScript EVS_Partner_BombetteSpikeContact;
extern EvtScript EVS_Partner_BurnContact;
extern EvtScript EVS_Partner_Recover;
extern EvtScript EVS_Partner_ShockHit;
extern EvtScript EVS_Partner_BurnHit;
extern EvtScript EVS_Partner_Hit;
extern EvtScript EVS_Partner_Drop;
extern EvtScript EVS_Partner_NoDamageHit;
extern EvtScript EVS_Partner_LakilesterHit;
extern EvtScript EVS_Enemy_HopToPos;
extern EvtScript EVS_Enemy_BurnHit;
extern EvtScript EVS_Enemy_ShockHit;
extern EvtScript EVS_Enemy_ShockHit_Impl;
extern EvtScript EVS_Partner_Celebrate;
extern EvtScript EVS_Enemy_NoDamageHit;
extern EvtScript EVS_Enemy_Death;
extern EvtScript EVS_Enemy_DeathWithoutRemove;
extern EvtScript EVS_Enemy_ScareAway;
extern EvtScript EVS_Enemy_SpinSmashHit;
extern EvtScript EVS_Enemy_FlipBackUp;
extern EvtScript EVS_Enemy_Knockback;
extern EvtScript EVS_Enemy_ReturnHome;
extern EvtScript EVS_Enemy_Recover;
extern EvtScript EVS_Enemy_HopHome;
extern EvtScript EVS_Enemy_AirLift;
extern EvtScript EVS_Enemy_BlowAway;
extern EvtScript Rumble_1;
extern EvtScript Rumble_2;
extern EvtScript Rumble_3;
extern EvtScript Rumble_4;
extern EvtScript Rumble_5;
extern EvtScript Rumble_6;
extern EvtScript Rumble_7;
extern EvtScript Rumble_Unused_1;
extern EvtScript Rumble_Unused_2;
extern EvtScript Rumble_Unused_3;
extern EvtScript Rumble_Unused_4;

#endif
