#include "script_api/macros.h"

enum GameFlags {
    GF_Unused_EVT_00                            = GameFlag(0x000),
    GF_StartedChapter1                          = GameFlag(0x001),
    GF_StartedChapter2                          = GameFlag(0x002),
    GF_StartedChapter3                          = GameFlag(0x003),
    GF_StartedChapter4                          = GameFlag(0x004),
    GF_StartedChapter5                          = GameFlag(0x005),
    GF_StartedChapter6                          = GameFlag(0x006),
    GF_StartedChapter7                          = GameFlag(0x007),
    GF_StartedChapter8                          = GameFlag(0x008),
    GF_DemoSceneDone                            = GameFlag(0x009),
    GF_Unused_EVT_0A                            = GameFlag(0x00A),
    GF_Unused_EVT_0B                            = GameFlag(0x00B),
    GF_Unused_EVT_0C                            = GameFlag(0x00C),
    GF_Unused_EVT_0D                            = GameFlag(0x00D),
    GF_Unused_EVT_0E                            = GameFlag(0x00E),
    GF_Unused_EVT_0F                            = GameFlag(0x00F),
    GF_Unused_EVT_10                            = GameFlag(0x010),
    GF_Unused_EVT_11                            = GameFlag(0x011),
    GF_Unused_EVT_12                            = GameFlag(0x012),
    GF_Unused_EVT_13                            = GameFlag(0x013),
    GF_Unused_EVT_14                            = GameFlag(0x014),
    GF_Unused_EVT_15                            = GameFlag(0x015),
    GF_Unused_EVT_16                            = GameFlag(0x016),
    GF_Unused_EVT_17                            = GameFlag(0x017),
    GF_Unused_EVT_18                            = GameFlag(0x018),
    GF_Unused_EVT_19                            = GameFlag(0x019),
    GF_Unused_EVT_1A                            = GameFlag(0x01A),
    GF_Unused_EVT_1B                            = GameFlag(0x01B),
    GF_Unused_EVT_1C                            = GameFlag(0x01C),
    GF_Unused_EVT_1D                            = GameFlag(0x01D),
    GF_KMR04_Tree3_Dolly                        = GameFlag(0x01E),
    GF_KMR02_KeptDolly                          = GameFlag(0x01F),
    GF_KMR02_Met_Goompapa                       = GameFlag(0x020),
    GF_KMR02_Goompapa_SaidFarewell              = GameFlag(0x021),
    GF_KMR02_Met_Goomama                        = GameFlag(0x022),
    GF_KMR02_Goomama_SaidFarewell               = GameFlag(0x023),
    GF_KMR02_Met_Goombario                      = GameFlag(0x024),
    GF_KMR02_Goombario_SwapDialogue             = GameFlag(0x025),
    GF_KMR02_Met_Gooma                          = GameFlag(0x026),
    GF_KMR02_Gooma_HealthAdvice                 = GameFlag(0x027),
    GF_KMR02_Met_Goompa                         = GameFlag(0x028),
    GF_KMR02_Goompa_SwapDialogue                = GameFlag(0x029),
    GF_KMR02_ToadHouse_Intro                    = GameFlag(0x02A),
    GF_KMR02_ReturnedWithGoompa                 = GameFlag(0x02B),
    GF_Unused_KMR_0E                            = GameFlag(0x02C),
    GF_KMR11_GoombaBrosFledToCastle             = GameFlag(0x02D),
    GF_KMR02_Item_ShootingStar                  = GameFlag(0x02E),
    GF_KMR02_Bush2_Coin                         = GameFlag(0x02F),
    GF_KMR02_Tree1_Goomnut                      = GameFlag(0x030),
    GF_KMR02_Item_FireFlower                    = GameFlag(0x031),
    GF_KMR03_ItemBlock_Coin                     = GameFlag(0x032),
    GF_Unused_KMR_15                            = GameFlag(0x033),
    GF_KMR03_HiddenItem_RepelGel                = GameFlag(0x034),
    GF_KMR03_Tree1_Mushroom                     = GameFlag(0x035),
    GF_KMR03_Hammer1Block                       = GameFlag(0x036),
    GF_Unused_KMR_19                            = GameFlag(0x037),
    GF_KMR03_Item_CoinA                         = GameFlag(0x038),
    GF_KMR03_Item_CoinB                         = GameFlag(0x039),
    GF_KMR03_Item_CoinC                         = GameFlag(0x03A),
    GF_KMR03_Item_CoinD                         = GameFlag(0x03B),
    GF_KMR04_Tree1_Coin                         = GameFlag(0x03C),
    GF_KMR04_Tree2_Coin                         = GameFlag(0x03D),
    GF_KMR04_Bush1_Coin                         = GameFlag(0x03E),
    GF_KMR04_Bush2_Coin                         = GameFlag(0x03F),
    GF_KMR04_Bush3_CoinA                        = GameFlag(0x040),
    GF_KMR04_Bush3_CoinB                        = GameFlag(0x041),
    GF_KMR04_Bush4_Coin                         = GameFlag(0x042),
    GF_KMR04_Bush5_Coin                         = GameFlag(0x043),
    GF_Unused_KMR_26                            = GameFlag(0x044),
    GF_Unused_KMR_27                            = GameFlag(0x045),
    GF_KMR04_MultiCoinBrick                     = GameFlag(0x046),
    GF_KMR04_Hammer1Block                       = GameFlag(0x047),
    GF_KMR05_EnemyWarning                       = GameFlag(0x048),
    GF_KMR05_Tree1_Coin                         = GameFlag(0x049),
    GF_KMR05_Item_StarPiece                     = GameFlag(0x04A),
    GF_Unused_KMR_2D                            = GameFlag(0x04B),
    GF_Unused_KMR_2E                            = GameFlag(0x04C),
    GF_KMR09_ItemBlock_CoinA                    = GameFlag(0x04D),
    GF_KMR09_ItemBlock_CoinB                    = GameFlag(0x04E),
    GF_KMR06_Item_Mushroom                      = GameFlag(0x04F),
    GF_KMR06_BadgeBlock_CloseCall               = GameFlag(0x050),
    GF_KMR11_ItemBlock_SuperShroom              = GameFlag(0x051),
    GF_KMR11_Tree1_StarPiece                    = GameFlag(0x052),
    GF_KMR11_Tree2_Coin                         = GameFlag(0x053),
    GF_KMR10_Chest_HammerThrow                  = GameFlag(0x054),
    GF_KMR10_ItemBlock_SleepySheep              = GameFlag(0x055),
    GF_KMR00_HiddenPanel                        = GameFlag(0x056),
    GF_Unused_KMR_39                            = GameFlag(0x057),
    GF_KMR03_HiddenPanel                        = GameFlag(0x058),
    GF_Unused_KMR_3B                            = GameFlag(0x059),
    GF_KMR11_HiddenPanel                        = GameFlag(0x05A),
    GF_KMR10_UnreadFlagForSpring                = GameFlag(0x05B),
    GF_Unused_KMR_3E                            = GameFlag(0x05C),
    GF_Unused_KMR_3F                            = GameFlag(0x05D),
    GF_Tutorial_Badges                          = GameFlag(0x05E),
    GF_Tutorial_SaveBlock                       = GameFlag(0x05F),
    GF_Tutorial_HeartBlock                      = GameFlag(0x060),
    GF_Tutorial_GotItem                         = GameFlag(0x061),
    GF_KMR20_ReunitedWithLuigi                  = GameFlag(0x062), ///< and saw him whistling
    GF_KMR20_Gift_LuigisAutograph               = GameFlag(0x063),
    GF_KMR02_Gift_TheTape                       = GameFlag(0x064),
    GF_Tutorial_GotStarPiece                    = GameFlag(0x065),
    GF_FoughtTheMaster                          = GameFlag(0x066),
    GF_KMR20_ReadThankYouLetterFromKoopaVillage = GameFlag(0x067),
    GF_KMR02_Goombario_RelayedMessage           = GameFlag(0x068),
    GF_KMR20_CaughtLuigiInBasement              = GameFlag(0x069),
    GF_KMR20_CaughtLuigiReadingLetter           = GameFlag(0x06A),
    GF_KMR20_FoundLuigisDiary                   = GameFlag(0x06B),
    GF_KMR20_CheckedDeskForMail                 = GameFlag(0x06C),
    GF_KMR20_ChasedOffShyGuy                    = GameFlag(0x06D),
    GF_KMR10_KnockedSpringOutOfTree             = GameFlag(0x06E),
    GF_Unused_KMR_51                            = GameFlag(0x06F),
    GF_Unused_KMR_52                            = GameFlag(0x070),
    GF_Unused_KMR_53                            = GameFlag(0x071),
    GF_Unused_KMR_54                            = GameFlag(0x072),
    GF_Unused_KMR_55                            = GameFlag(0x073),
    GF_Unused_KMR_56                            = GameFlag(0x074),
    GF_Unused_KMR_57                            = GameFlag(0x075),
    GF_Unused_KMR_58                            = GameFlag(0x076),
    GF_Unused_KMR_59                            = GameFlag(0x077),
    GF_Unused_KMR_5A                            = GameFlag(0x078),
    GF_Unused_KMR_5B                            = GameFlag(0x079),
    GF_Unused_KMR_5C                            = GameFlag(0x07A),
    GF_Unused_KMR_5D                            = GameFlag(0x07B),
    GF_Unused_KMR_5E                            = GameFlag(0x07C),
    GF_Unused_KMR_5F                            = GameFlag(0x07D),
    GF_Unused_KMR_60                            = GameFlag(0x07E),
    GF_Unused_KMR_61                            = GameFlag(0x07F),
    GF_Unused_KMR_62                            = GameFlag(0x080),
    GF_Unused_KMR_63                            = GameFlag(0x081),
    GF_Unused_MAC_00                            = GameFlag(0x082),
    GF_MAC02_UnlockedHouse                      = GameFlag(0x083),
    GF_MAC02_Item_OddKey                        = GameFlag(0x084),
    GF_MAC01_UnlockedRowfBadge_00               = GameFlag(0x085),
    GF_MAC01_UnlockedRowfBadge_01               = GameFlag(0x086),
    GF_MAC01_UnlockedRowfBadge_02               = GameFlag(0x087),
    GF_MAC01_UnlockedRowfBadge_03               = GameFlag(0x088),
    GF_MAC01_UnlockedRowfBadge_04               = GameFlag(0x089),
    GF_MAC01_UnlockedRowfBadge_05               = GameFlag(0x08A),
    GF_MAC01_UnlockedRowfBadge_06               = GameFlag(0x08B),
    GF_MAC01_UnlockedRowfBadge_07               = GameFlag(0x08C),
    GF_MAC01_UnlockedRowfBadge_08               = GameFlag(0x08D),
    GF_MAC01_UnlockedRowfBadge_09               = GameFlag(0x08E),
    GF_MAC01_UnlockedRowfBadge_0A               = GameFlag(0x08F),
    GF_MAC01_UnlockedRowfBadge_0B               = GameFlag(0x090),
    GF_MAC01_UnlockedRowfBadge_0C               = GameFlag(0x091),
    GF_MAC01_UnlockedRowfBadge_0D               = GameFlag(0x092),
    GF_MAC01_UnlockedRowfBadge_0E               = GameFlag(0x093),
    GF_MAC01_UnlockedRowfBadge_0F               = GameFlag(0x094),
    GF_Unused_MAC_13                            = GameFlag(0x095), ///< presumably for Rowf's 17th badge
    GF_Unused_MAC_14                            = GameFlag(0x096), ///< presumably for Rowf's 18th badge
    GF_Unused_MAC_15                            = GameFlag(0x097), ///< presumably for Rowf's 19th badge
    GF_Unused_MAC_16                            = GameFlag(0x098), ///< presumably for Rowf's 20th badge
    GF_MAC01_UnlockedLetter_00                  = GameFlag(0x099),
    GF_MAC01_UnlockedLetter_01                  = GameFlag(0x09A),
    GF_MAC01_UnlockedLetter_02                  = GameFlag(0x09B),
    GF_MAC01_UnlockedLetter_03                  = GameFlag(0x09C),
    GF_MAC01_UnlockedLetter_04                  = GameFlag(0x09D),
    GF_MAC01_UnlockedLetter_05                  = GameFlag(0x09E),
    GF_MAC01_UnlockedLetter_06                  = GameFlag(0x09F),
    GF_MAC01_UnlockedLetter_07                  = GameFlag(0x0A0),
    GF_MAC01_UnlockedLetter_08                  = GameFlag(0x0A1),
    GF_MAC01_UnlockedLetter_09                  = GameFlag(0x0A2),
    GF_MAC01_UnlockedLetter_0A                  = GameFlag(0x0A3),
    GF_MAC01_UnlockedLetter_0B                  = GameFlag(0x0A4),
    GF_MAC01_UnlockedLetter_0C                  = GameFlag(0x0A5),
    GF_MAC01_UnlockedLetter_0D                  = GameFlag(0x0A6),
    GF_MAC01_UnlockedLetter_0E                  = GameFlag(0x0A7),
    GF_MAC01_UnlockedLetter_0F                  = GameFlag(0x0A8),
    GF_MAC01_UnlockedLetter_10                  = GameFlag(0x0A9),
    GF_MAC01_UnlockedLetter_11                  = GameFlag(0x0AA),
    GF_MAC01_UnlockedLetter_12                  = GameFlag(0x0AB),
    GF_MAC01_ReadLetter_00                      = GameFlag(0x0AC),
    GF_MAC01_ReadLetter_01                      = GameFlag(0x0AD),
    GF_MAC01_ReadLetter_02                      = GameFlag(0x0AE),
    GF_MAC01_ReadLetter_03                      = GameFlag(0x0AF),
    GF_MAC01_ReadLetter_04                      = GameFlag(0x0B0),
    GF_MAC01_ReadLetter_05                      = GameFlag(0x0B1),
    GF_MAC01_ReadLetter_06                      = GameFlag(0x0B2),
    GF_MAC01_ReadLetter_07                      = GameFlag(0x0B3),
    GF_MAC01_ReadLetter_08                      = GameFlag(0x0B4),
    GF_MAC01_ReadLetter_09                      = GameFlag(0x0B5),
    GF_MAC01_ReadLetter_0A                      = GameFlag(0x0B6),
    GF_MAC01_ReadLetter_0B                      = GameFlag(0x0B7),
    GF_MAC01_ReadLetter_0C                      = GameFlag(0x0B8),
    GF_MAC01_ReadLetter_0D                      = GameFlag(0x0B9),
    GF_MAC01_ReadLetter_0E                      = GameFlag(0x0BA),
    GF_MAC01_ReadLetter_0F                      = GameFlag(0x0BB),
    GF_MAC01_ReadLetter_10                      = GameFlag(0x0BC),
    GF_MAC01_ReadLetter_11                      = GameFlag(0x0BD),
    GF_MAC01_ReadLetter_12                      = GameFlag(0x0BE),
    GF_MAC00_RussT_HeardLore_00                 = GameFlag(0x0BF),
    GF_MAC00_RussT_HeardLore_01                 = GameFlag(0x0C0),
    GF_MAC00_RussT_HeardLore_02                 = GameFlag(0x0C1),
    GF_MAC00_RussT_HeardLore_03                 = GameFlag(0x0C2),
    GF_MAC00_RussT_HeardLore_04                 = GameFlag(0x0C3),
    GF_MAC00_RussT_HeardLore_05                 = GameFlag(0x0C4),
    GF_MAC00_RussT_HeardLore_06                 = GameFlag(0x0C5),
    GF_MAC00_RussT_HeardLore_07                 = GameFlag(0x0C6),
    GF_MAC00_RussT_HeardLore_08                 = GameFlag(0x0C7),
    GF_MAC00_RussT_HeardLore_09                 = GameFlag(0x0C8),
    GF_MAC00_RussT_HeardLore_0A                 = GameFlag(0x0C9),
    GF_MAC00_RussT_HeardLore_0B                 = GameFlag(0x0CA),
    GF_MAC00_RussT_HeardLore_0C                 = GameFlag(0x0CB),
    GF_MAC00_RussT_HeardLore_0D                 = GameFlag(0x0CC),
    GF_MAC00_RussT_HeardLore_0E                 = GameFlag(0x0CD),
    GF_MAC00_RussT_HeardLore_0F                 = GameFlag(0x0CE),
    GF_MAC00_RussT_HeardLore_10                 = GameFlag(0x0CF),
    GF_MAC00_RussT_HeardLore_11                 = GameFlag(0x0D0),
    GF_MAC00_RussT_HeardLore_12                 = GameFlag(0x0D1),
    GF_MAC00_RussT_HeardLore_13                 = GameFlag(0x0D2),
    GF_MAC00_RussT_HeardLore_14                 = GameFlag(0x0D3),
    GF_MAC00_RussT_HeardLore_15                 = GameFlag(0x0D4),
    GF_MAC00_RussT_HeardLore_16                 = GameFlag(0x0D5),
    GF_MAC00_RussT_HeardLore_17                 = GameFlag(0x0D6),
    GF_MAC00_RussT_HeardLore_18                 = GameFlag(0x0D7),
    GF_MAC00_RussT_HeardLore_19                 = GameFlag(0x0D8),
    GF_MAC00_RussT_HeardLore_1A                 = GameFlag(0x0D9),
    GF_MAC00_RussT_HeardLore_1B                 = GameFlag(0x0DA),
    GF_MAC00_RussT_HeardLore_1C                 = GameFlag(0x0DB),
    GF_MAC00_RussT_HeardLore_1D                 = GameFlag(0x0DC),
    GF_MAC00_RussT_HeardLore_1E                 = GameFlag(0x0DD),
    GF_MAC00_RussT_HeardLore_1F                 = GameFlag(0x0DE),
    GF_MAC00_RussT_HeardLore_20                 = GameFlag(0x0DF),
    GF_MAC00_RussT_HeardLore_21                 = GameFlag(0x0E0),
    GF_MAC00_RussT_HeardLore_22                 = GameFlag(0x0E1),
    GF_MAC00_RussT_HeardLore_23                 = GameFlag(0x0E2),
    GF_Unused_MAC_61                            = GameFlag(0x0E3), ///< presumably for RussT's 37th lore
    GF_Unused_MAC_62                            = GameFlag(0x0E4), ///< presumably for RussT's 38th lore
    GF_Unused_MAC_63                            = GameFlag(0x0E5), ///< presumably for RussT's 39th lore
    GF_Unused_MAC_64                            = GameFlag(0x0E6), ///< presumably for RussT's 40th lore
    GF_Unused_MAC_65                            = GameFlag(0x0E7), ///< presumably for RussT's 41st lore
    GF_Unused_MAC_66                            = GameFlag(0x0E8), ///< presumably for RussT's 42nd lore
    GF_Unused_MAC_67                            = GameFlag(0x0E9), ///< presumably for RussT's 43th lore
    GF_Unused_MAC_68                            = GameFlag(0x0EA), ///< presumably for RussT's 44th lore
    GF_Unused_MAC_69                            = GameFlag(0x0EB), ///< presumably for RussT's 45th lore
    GF_Unused_MAC_6A                            = GameFlag(0x0EC), ///< presumably for RussT's 46th lore
    GF_Unused_MAC_6B                            = GameFlag(0x0ED), ///< presumably for RussT's 47th lore
    GF_Unused_MAC_6C                            = GameFlag(0x0EE), ///< presumably for RussT's 48th lore
    GF_Unused_MAC_6D                            = GameFlag(0x0EF), ///< presumably for RussT's 49th lore
    GF_Unused_MAC_6E                            = GameFlag(0x0F0), ///< presumably for RussT's 50th lore
    GF_MAC00_Met_RussT                          = GameFlag(0x0F1),
    GF_MAC00_Met_TheMaster                      = GameFlag(0x0F2),
    GF_MAC00_DictionaryStolen                   = GameFlag(0x0F3),
    GF_MAC00_DictionaryReturned                 = GameFlag(0x0F4),
    GF_MAC00_TranslatedMysteryNote              = GameFlag(0x0F5),
    GF_MAC00_TranslatedSuspiciousNote           = GameFlag(0x0F6),
    GF_MAC01_ShyGuyTookOverShop                 = GameFlag(0x0F7),
    GF_MAC00_ShyGuyChasedFromShop               = GameFlag(0x0F8),
    GF_MAC01_Merlon_Shoo1                       = GameFlag(0x0F9),
    GF_MAC01_Merlon_Shoo2                       = GameFlag(0x0FA),
    GF_MAC01_Merlon_Shoo3                       = GameFlag(0x0FB),
    GF_MAC01_Merlon_HintFromDarkToads           = GameFlag(0x0FC),
    GF_MAC01_Merlon_HeardAboutDream             = GameFlag(0x0FD),
    GF_MAC01_QuickChangeDropped                 = GameFlag(0x0FE),
    GF_MAC01_Item_QuickChange                   = GameFlag(0x0FF),
    GF_MAC01_Met_Rowf_Early                     = GameFlag(0x100),
    GF_MAC01_Met_Rowf_Late                      = GameFlag(0x101),
    GF_MAC01_CalculatorReturned                 = GameFlag(0x102),
    GF_MAC01_Met_Rhuff                          = GameFlag(0x103),
    GF_MAC01_RowfBadgeAvailableA                = GameFlag(0x104),
    GF_MAC01_RowfBadgeAvailableB                = GameFlag(0x105),
    GF_MAC01_RowfBadgeAvailableC                = GameFlag(0x106),
    GF_MAC01_RowfBadgesChosen                   = GameFlag(0x107),
    GF_MAC01_Met_Postmaster                     = GameFlag(0x108),
    GF_MAC01_CheckedForLetters                  = GameFlag(0x109),
    GF_MAC01_MailbagReturned                    = GameFlag(0x10A),
    GF_Unused_MAC_89                            = GameFlag(0x10B),
    GF_MAC01_CalculatorStolen                   = GameFlag(0x10C),
    GF_MAC01_MailbagStolen                      = GameFlag(0x10D),
    GF_MAC01_ChasedShyGuyFromToadHouse          = GameFlag(0x10E),
    GF_MAC01_ShyGuysTramplingGarden             = GameFlag(0x10F),
    GF_MAC01_ChasedShyGuysFromGardenA           = GameFlag(0x110),
    GF_MAC01_ChasedShyGuysFromGardenB           = GameFlag(0x111),
    GF_MAC02_HeardAboutMinhT                    = GameFlag(0x112),
    GF_MAC01_HeardAboutBubulbs                  = GameFlag(0x113),
    GF_MAC01_Planted_MagicalSeed1               = GameFlag(0x114),
    GF_MAC01_Planted_MagicalSeed2               = GameFlag(0x115),
    GF_MAC01_Planted_MagicalSeed3               = GameFlag(0x116),
    GF_MAC01_Planted_MagicalSeed4               = GameFlag(0x117),
    GF_MAC02_Met_TayceT                         = GameFlag(0x118),
    GF_MAC02_TayceT_HoldingCake                 = GameFlag(0x119),
    GF_MAC02_TayceT_HasCookbook                 = GameFlag(0x11A),
    GF_MAC02_Gift_MagicalSeed1                  = GameFlag(0x11B),
    GF_MAC03_BombedRock                         = GameFlag(0x11C),
    GF_MAC03_Conductor_ThankYouA                = GameFlag(0x11D),
    GF_MAC03_ShyGuyBlockingTracks               = GameFlag(0x11E),
    GF_MAC03_ShyGuyChasedOff                    = GameFlag(0x11F),
    GF_MAC03_Conductor_ThankYouB                = GameFlag(0x120),
    GF_MAC04_Item_ToyTrain                      = GameFlag(0x121), ///< note: item ID has 00020021
    GF_MAC04_StoreroomKeyStolen                 = GameFlag(0x122),
    GF_MAC04_Met_ChetRippo                      = GameFlag(0x123),
    GF_MAC04_HeardGoombaFamilyArgument          = GameFlag(0x124),
    GF_MAC05_SimonGaveLyrics                    = GameFlag(0x125),
    GF_MAC05_SimonGotMelody                     = GameFlag(0x126),
    GF_MAC00_HiddenPanel                        = GameFlag(0x127),
    GF_Unused_MAC_A6                            = GameFlag(0x128),
    GF_MAC02_HiddenPanel                        = GameFlag(0x129),
    GF_MAC03_HiddenPanel                        = GameFlag(0x12A),
    GF_Unused_MAC_A9                            = GameFlag(0x12B),
    GF_MAC05_HiddenPanel                        = GameFlag(0x12C),
    GF_MAC00_Item_StarPiece                     = GameFlag(0x12D),
    GF_MAC01_Tree1_StarPiece                    = GameFlag(0x12E),
    GF_MAC04_Item_SnowmanDoll                   = GameFlag(0x12F), ///< note: item ID has 00020081
    GF_MAC04_Item_VoltShroom                    = GameFlag(0x130),  ///< note: item ID has 0002008B
    GF_MAC04_Item_DizzyDial                     = GameFlag(0x131),   ///< note: item ID has 0002009A
    GF_MAC05_MultiCoinBrick                     = GameFlag(0x132),
    GF_MAC01_KootFavor_ReadNewsBulletin         = GameFlag(0x133),
    GF_MAC01_KootFavor_ReadGossipBulletin       = GameFlag(0x134),
    GF_MAC05_Met_Simon                          = GameFlag(0x135),
    GF_MAC02_DiscoveredRecipe_00                = GameFlag(0x136),
    GF_MAC02_DiscoveredRecipe_01                = GameFlag(0x137),
    GF_MAC02_DiscoveredRecipe_02                = GameFlag(0x138),
    GF_MAC02_DiscoveredRecipe_03                = GameFlag(0x139),
    GF_MAC02_DiscoveredRecipe_04                = GameFlag(0x13A),
    GF_MAC02_DiscoveredRecipe_05                = GameFlag(0x13B),
    GF_MAC02_DiscoveredRecipe_06                = GameFlag(0x13C),
    GF_MAC02_DiscoveredRecipe_07                = GameFlag(0x13D),
    GF_MAC02_DiscoveredRecipe_08                = GameFlag(0x13E),
    GF_MAC02_DiscoveredRecipe_09                = GameFlag(0x13F),
    GF_MAC02_DiscoveredRecipe_0A                = GameFlag(0x140),
    GF_MAC02_DiscoveredRecipe_0B                = GameFlag(0x141),
    GF_MAC02_DiscoveredRecipe_0C                = GameFlag(0x142),
    GF_MAC02_DiscoveredRecipe_0D                = GameFlag(0x143),
    GF_MAC02_DiscoveredRecipe_0E                = GameFlag(0x144),
    GF_MAC02_DiscoveredRecipe_0F                = GameFlag(0x145),
    GF_MAC02_DiscoveredRecipe_10                = GameFlag(0x146),
    GF_MAC02_DiscoveredRecipe_11                = GameFlag(0x147),
    GF_MAC02_DiscoveredRecipe_12                = GameFlag(0x148),
    GF_MAC02_DiscoveredRecipe_13                = GameFlag(0x149),
    GF_MAC02_DiscoveredRecipe_14                = GameFlag(0x14A),
    GF_MAC02_DiscoveredRecipe_15                = GameFlag(0x14B),
    GF_MAC02_DiscoveredRecipe_16                = GameFlag(0x14C),
    GF_MAC02_DiscoveredRecipe_17                = GameFlag(0x14D),
    GF_MAC02_DiscoveredRecipe_18                = GameFlag(0x14E),
    GF_MAC02_DiscoveredRecipe_19                = GameFlag(0x14F),
    GF_MAC02_DiscoveredRecipe_1A                = GameFlag(0x150),
    GF_MAC02_DiscoveredRecipe_1B                = GameFlag(0x151),
    GF_MAC02_DiscoveredRecipe_1C                = GameFlag(0x152),
    GF_MAC02_DiscoveredRecipe_1D                = GameFlag(0x153),
    GF_MAC02_DiscoveredRecipe_1E                = GameFlag(0x154),
    GF_MAC02_DiscoveredRecipe_1F                = GameFlag(0x155),
    GF_MAC02_DiscoveredRecipe_20                = GameFlag(0x156),
    GF_MAC02_DiscoveredRecipe_21                = GameFlag(0x157),
    GF_MAC02_DiscoveredRecipe_22                = GameFlag(0x158),
    GF_MAC02_DiscoveredRecipe_23                = GameFlag(0x159),
    GF_MAC02_DiscoveredRecipe_24                = GameFlag(0x15A),
    GF_MAC02_DiscoveredRecipe_25                = GameFlag(0x15B),
    GF_MAC02_DiscoveredRecipe_26                = GameFlag(0x15C),
    GF_MAC02_DiscoveredRecipe_27                = GameFlag(0x15D),
    GF_MAC02_DiscoveredRecipe_28                = GameFlag(0x15E),
    GF_MAC02_DiscoveredRecipe_29                = GameFlag(0x15F),
    GF_MAC02_DiscoveredRecipe_2A                = GameFlag(0x160),
    GF_MAC02_DiscoveredRecipe_2B                = GameFlag(0x161),
    GF_MAC02_DiscoveredRecipe_2C                = GameFlag(0x162),
    GF_MAC02_DiscoveredRecipe_2D                = GameFlag(0x163),
    GF_MAC02_DiscoveredRecipe_2E                = GameFlag(0x164),
    GF_MAC02_DiscoveredRecipe_2F                = GameFlag(0x165),
    GF_MAC02_DiscoveredRecipe_30                = GameFlag(0x166),
    GF_MAC02_DiscoveredRecipe_31                = GameFlag(0x167),
    GF_MAC02_DiscoveredRecipe_32                = GameFlag(0x168),
    GF_MAC02_DiscoveredRecipe_33                = GameFlag(0x169),
    GF_MAC03_UnlockedPlayroom                   = GameFlag(0x16A),
    GF_MGM00_Met_Receptionist                   = GameFlag(0x16B),
    GF_MGM_Unlocked_JumpAttack                  = GameFlag(0x16C),
    GF_MGM_Met_JumpAttack                       = GameFlag(0x16D),
    GF_MGM_Unlocked_SmashAttack                 = GameFlag(0x16E),
    GF_MGM_Met_SmashAttack                      = GameFlag(0x16F),
    GF_MAC01_BoughtBadgeFromRowf                = GameFlag(0x170),
    GF_Unused_MAC_EF                            = GameFlag(0x171),
    GF_Unused_MAC_F0                            = GameFlag(0x172),
    GF_Unused_MAC_F1                            = GameFlag(0x173),
    GF_Unused_MAC_F2                            = GameFlag(0x174),
    GF_Unused_MAC_F3                            = GameFlag(0x175),
    GF_Unused_MAC_F4                            = GameFlag(0x176),
    GF_Unused_MAC_F5                            = GameFlag(0x177),
    GF_Unused_MAC_F6                            = GameFlag(0x178),
    GF_Unused_MAC_F7                            = GameFlag(0x179),
    GF_Unused_MAC_F8                            = GameFlag(0x17A),
    GF_Unused_MAC_F9                            = GameFlag(0x17B),
    GF_Unused_MAC_FA                            = GameFlag(0x17C),
    GF_Unused_MAC_FB                            = GameFlag(0x17D),
    GF_Unused_MAC_FC                            = GameFlag(0x17E),
    GF_Unused_MAC_FD                            = GameFlag(0x17F),
    GF_Unused_MAC_FE                            = GameFlag(0x180),
    GF_Unused_MAC_FF                            = GameFlag(0x181),
    GF_Unused_MAC_100                           = GameFlag(0x182),
    GF_Unused_MAC_101                           = GameFlag(0x183),
    GF_Unused_TIK_00                            = GameFlag(0x184),
    GF_TIK15_Met_RipCheato                      = GameFlag(0x185),
    GF_TIK02_BoardedFloor                       = GameFlag(0x186),
    GF_TIK02_Hammer1Block                       = GameFlag(0x187),
    GF_TIK02_Hammer2Block                       = GameFlag(0x188),
    GF_TIK14_BombedWall                         = GameFlag(0x189),
    GF_TIK01_Hammer2Block                       = GameFlag(0x18A),
    GF_TIK12_Hammer3BlockA                      = GameFlag(0x18B),
    GF_TIK12_Hammer3BlockB                      = GameFlag(0x18C),
    GF_TIK23_Hammer2Block                       = GameFlag(0x18D),
    GF_TIK24_Hammer3Block                       = GameFlag(0x18E),
    GF_TIK02_Chest_ShrinkStomp                  = GameFlag(0x18F),
    GF_TIK03_ItemBlock_SnowmanDoll              = GameFlag(0x190),
    GF_TIK03_ItemBlock_CoinA                    = GameFlag(0x191),
    GF_TIK03_ItemBlock_CoinB                    = GameFlag(0x192),
    GF_TIK05_Chest_PowerSmash                   = GameFlag(0x193),
    GF_TIK07_Item_StarPiece                     = GameFlag(0x194),
    GF_TIK10_HiddenItem_CoinA                   = GameFlag(0x195),
    GF_TIK10_HiddenItem_CoinB                   = GameFlag(0x196),
    GF_TIK10_HiddenItem_CoinC                   = GameFlag(0x197),
    GF_TIK18_HiddenItem_SuperShroom             = GameFlag(0x198),
    GF_TIK18_MultiCoinBrick                     = GameFlag(0x199),
    GF_TIK20_ItemBlock_ShootingStar             = GameFlag(0x19A),
    GF_TIK21_ItemBlock_Coin                     = GameFlag(0x19B),
    GF_TIK21_HiddenItem_CoinA                   = GameFlag(0x19C),
    GF_TIK21_HiddenItem_CoinB                   = GameFlag(0x19D),
    GF_TIK21_HiddenItem_CoinC                   = GameFlag(0x19E),
    GF_TIK21_HiddenItem_CoinD                   = GameFlag(0x19F),
    GF_TIK23_HiddenItem_MapleSyrup              = GameFlag(0x1A0),
    GF_TIK23_HiddenItem_StopWatch               = GameFlag(0x1A1),
    GF_TIK23_HiddenItem_VoltShroom              = GameFlag(0x1A2),
    GF_TIK23_ItemBlock_Coin                     = GameFlag(0x1A3),
    GF_TIK24_HiddenItem_LifeShroom              = GameFlag(0x1A4),
    GF_TIK24_ItemBlock_CoinA                    = GameFlag(0x1A5),
    GF_TIK24_ItemBlock_CoinB                    = GameFlag(0x1A6),
    GF_TIK25_GiantChest                         = GameFlag(0x1A7),
    GF_TIK05_SpringBrick                        = GameFlag(0x1A8),
    GF_TIK25_SpringBrickA                       = GameFlag(0x1A9),
    GF_TIK25_SpringBrickB                       = GameFlag(0x1AA),
    GF_TIK_DefeatedOneBlooper                   = GameFlag(0x1AB),
    GF_TIK_DefeatedTwoBloopers                  = GameFlag(0x1AC),
    GF_TIK01_Defeated_Blooper                   = GameFlag(0x1AD),
    GF_TIK02_Defeated_Blooper                   = GameFlag(0x1AE),
    GF_TIK08_Defeated_Blooper                   = GameFlag(0x1AF),
    GF_TIK09_Defeated_Ambush                    = GameFlag(0x1B0),
    GF_TIK07_SuperBlock                         = GameFlag(0x1B1),
    GF_TIK10_SuperBlock                         = GameFlag(0x1B2),
    GF_TIK02_SuperBlock                         = GameFlag(0x1B3),
    GF_TIK17_SuperBlock                         = GameFlag(0x1B4),
    GF_TIK19_SuperBlock                         = GameFlag(0x1B5),
    GF_Tutorial_SuperBlock                      = GameFlag(0x1B6), ///< has learned about super blocks
    GF_Unused_TIK_33                            = GameFlag(0x1B7),
    GF_Unused_TIK_34                            = GameFlag(0x1B8),
    GF_Unused_TIK_35                            = GameFlag(0x1B9),
    GF_Unused_TIK_36                            = GameFlag(0x1BA),
    GF_Unused_TIK_37                            = GameFlag(0x1BB),
    GF_Unused_TIK_38                            = GameFlag(0x1BC),
    GF_Unused_TIK_39                            = GameFlag(0x1BD),
    GF_Unused_TIK_3A                            = GameFlag(0x1BE),
    GF_Unused_TIK_3B                            = GameFlag(0x1BF),
    GF_Unused_TIK_3C                            = GameFlag(0x1C0),
    GF_Unused_TIK_3D                            = GameFlag(0x1C1),
    GF_Unused_TIK_3E                            = GameFlag(0x1C2),
    GF_Unused_TIK_3F                            = GameFlag(0x1C3),
    GF_Unused_TIK_40                            = GameFlag(0x1C4),
    GF_Unused_TIK_41                            = GameFlag(0x1C5),
    GF_Unused_TIK_42                            = GameFlag(0x1C6),
    GF_Unused_TIK_43                            = GameFlag(0x1C7),
    GF_Unused_TIK_44                            = GameFlag(0x1C8),
    GF_Unused_TIK_45                            = GameFlag(0x1C9),
    GF_Unused_TIK_46                            = GameFlag(0x1CA),
    GF_Unused_KGR_00                            = GameFlag(0x1CB),
    GF_Unused_KGR_01                            = GameFlag(0x1CC),
    GF_Unused_KGR_02                            = GameFlag(0x1CD),
    GF_Unused_KGR_03                            = GameFlag(0x1CE),
    GF_Unused_KGR_04                            = GameFlag(0x1CF),
    GF_Unused_KGR_05                            = GameFlag(0x1D0),
    GF_Unused_KGR_06                            = GameFlag(0x1D1),
    GF_Unused_KGR_07                            = GameFlag(0x1D2),
    GF_Unused_KGR_08                            = GameFlag(0x1D3),
    GF_Unused_KGR_09                            = GameFlag(0x1D4),
    GF_Unused_KGR_0A                            = GameFlag(0x1D5),
    GF_Unused_KGR_0B                            = GameFlag(0x1D6),
    GF_Unused_KGR_0C                            = GameFlag(0x1D7),
    GF_Unused_KGR_0D                            = GameFlag(0x1D8),
    GF_Unused_KGR_0E                            = GameFlag(0x1D9),
    GF_Unused_KGR_0F                            = GameFlag(0x1DA),
    GF_Unused_KGR_10                            = GameFlag(0x1DB),
    GF_Unused_KGR_11                            = GameFlag(0x1DC),
    GF_Unused_KGR_12                            = GameFlag(0x1DD),
    GF_Unused_KGR_13                            = GameFlag(0x1DE),
    GF_KKJ14_OpenedPassage                      = GameFlag(0x1DF),
    GF_KKJ14_RevealedButton                     = GameFlag(0x1E0),
    GF_KKJ14_SkipSecretPassage                  = GameFlag(0x1E1),
    GF_KKJ20_PeachMet_ToadInHiding              = GameFlag(0x1E2),
    GF_KKJ17_FoundMagicChest                    = GameFlag(0x1E3),
    GF_KKJ16_Item_PowerRush                     = GameFlag(0x1E4),
    GF_KKJ16_Gift_ShootingStar                  = GameFlag(0x1E5),
    GF_KKJ17_Item_DeepFocus                     = GameFlag(0x1E6),
    GF_KKJ20_Chest_LastStand                    = GameFlag(0x1E7),
    GF_KKJ29_PeachWonJamminJelly                = GameFlag(0x1E8),
    GF_KKJ_Stored_PowerRush                     = GameFlag(0x1E9),
    GF_KKJ_Stored_ShootingStar                  = GameFlag(0x1EA),
    GF_KKJ_Stored_DeepFocus                     = GameFlag(0x1EB),
    GF_KKJ_Stored_LastStand                     = GameFlag(0x1EC),
    GF_KKJ_Stored_JamminJelly                   = GameFlag(0x1ED),
    GF_KKJ_Retrieved_PowerRush                  = GameFlag(0x1EE),
    GF_KKJ_Retrieved_ShootingStar               = GameFlag(0x1EF),
    GF_KKJ_Retrieved_DeepFocus                  = GameFlag(0x1F0),
    GF_KKJ_Retrieved_LastStand                  = GameFlag(0x1F1),
    GF_KKJ_Retrieved_JamminJelly                = GameFlag(0x1F2),
    GF_KKJ18_GourmetGuy_GaveKey                 = GameFlag(0x1F3),
    GF_KKJ11_UnlockedKitchen                    = GameFlag(0x1F4),
    GF_KKJ11_TrickedGuard                       = GameFlag(0x1F5),
    GF_KKJ10_UnlockedDoor                       = GameFlag(0x1F6),
    GF_KKJ12_TrickedGuard                       = GameFlag(0x1F7),
    GF_KKJ16_Item_LifeShroom                    = GameFlag(0x1F8),
    GF_KKJ20_Met_ToadInHiding                   = GameFlag(0x1F9),
    GF_KKJ13_BowserTaunts                       = GameFlag(0x1FA),
    GF_KKJ23_BowserFledToTower                  = GameFlag(0x1FB),
    GF_KKJ25_Defeated_Kammy                     = GameFlag(0x1FC),
    GF_KKJ25_Defeated_Bowser                    = GameFlag(0x1FD),
    GF_KKJ25_Visited                            = GameFlag(0x1FE),
    GF_Unused_KKJ_20                            = GameFlag(0x1FF),
    GF_Unused_KKJ_21                            = GameFlag(0x200),
    GF_Unused_KKJ_22                            = GameFlag(0x201),
    GF_Unused_KKJ_23                            = GameFlag(0x202),
    GF_Unused_KKJ_24                            = GameFlag(0x203),
    GF_Unused_KKJ_25                            = GameFlag(0x204),
    GF_Unused_KKJ_26                            = GameFlag(0x205),
    GF_Unused_KKJ_27                            = GameFlag(0x206),
    GF_Unused_KKJ_28                            = GameFlag(0x207),
    GF_Unused_KKJ_29                            = GameFlag(0x208),
    GF_Unused_KKJ_2A                            = GameFlag(0x209),
    GF_Unused_KKJ_2B                            = GameFlag(0x20A),
    GF_Unused_KKJ_2C                            = GameFlag(0x20B),
    GF_Unused_KKJ_2D                            = GameFlag(0x20C),
    GF_Unused_KKJ_2E                            = GameFlag(0x20D),
    GF_Unused_KKJ_2F                            = GameFlag(0x20E),
    GF_Unused_KKJ_30                            = GameFlag(0x20F),
    GF_Unused_KKJ_31                            = GameFlag(0x210),
    GF_Unused_KKJ_32                            = GameFlag(0x211),
    GF_Unused_KKJ_33                            = GameFlag(0x212),
    GF_Unused_HOS_00                            = GameFlag(0x213),
    GF_HOS04_Visited                            = GameFlag(0x214),
    GF_Unused_HOS_02                            = GameFlag(0x215),
    GF_Unused_HOS_03                            = GameFlag(0x216),
    GF_HOS06_Met_Merluvlee                      = GameFlag(0x217),
    GF_HOS06_MerluvleeRequestedCrystalBall      = GameFlag(0x218),
    GF_HOS06_Gift_MerluvleesAutograph           = GameFlag(0x219),
    GF_HOS00_HiddenPanel                        = GameFlag(0x21A),
    GF_HOS01_HiddenPanel                        = GameFlag(0x21B),
    GF_HOS06_HiddenPanel                        = GameFlag(0x21C),
    GF_Unused_HOS_0A                            = GameFlag(0x21D),
    GF_Unused_HOS_0B                            = GameFlag(0x21E),
    GF_Unused_HOS_0C                            = GameFlag(0x21F),
    GF_HOS01_Item_StarPiece                     = GameFlag(0x220),
    GF_Unused_HOS_0E                            = GameFlag(0x221),
    GF_Unused_HOS_0F                            = GameFlag(0x222),
    GF_Unused_HOS_10                            = GameFlag(0x223),
    GF_Unused_HOS_11                            = GameFlag(0x224),
    GF_Unused_HOS_12                            = GameFlag(0x225),
    GF_Unused_HOS_13                            = GameFlag(0x226),
    GF_Unused_HOS_14                            = GameFlag(0x227),
    GF_Unused_HOS_15                            = GameFlag(0x228),
    GF_Unused_HOS_16                            = GameFlag(0x229),
    GF_Unused_HOS_17                            = GameFlag(0x22A),
    GF_Unused_HOS_18                            = GameFlag(0x22B),
    GF_Unused_HOS_19                            = GameFlag(0x22C),
    GF_Unused_HOS_1A                            = GameFlag(0x22D),
    GF_Unused_HOS_1B                            = GameFlag(0x22E),
    GF_Unused_HOS_1C                            = GameFlag(0x22F),
    GF_Unused_HOS_1D                            = GameFlag(0x230),
    GF_Unused_HOS_1E                            = GameFlag(0x231),
    GF_Unused_HOS_1F                            = GameFlag(0x232),
    GF_Unused_HOS_20                            = GameFlag(0x233),
    GF_Unused_HOS_21                            = GameFlag(0x234),
    GF_Unused_HOS_22                            = GameFlag(0x235),
    GF_NOK01_RecoveredShellA                    = GameFlag(0x236),
    GF_NOK01_RecoveredBlockShell                = GameFlag(0x237),
    GF_NOK01_RecoveredTreeShell                 = GameFlag(0x238),
    GF_NOK02_StolenShellComplaintA              = GameFlag(0x239),
    GF_NOK02_RecoveredShellA                    = GameFlag(0x23A),
    GF_NOK02_StolenShellComplaintB              = GameFlag(0x23B),
    GF_NOK02_RecoveredShellB                    = GameFlag(0x23C),
    GF_NOK02_KoloradoWife_FuzzyComplaint        = GameFlag(0x23D),
    GF_Unused_NOK_08                            = GameFlag(0x23E),
    GF_Unused_NOK_09                            = GameFlag(0x23F),
    GF_Unused_NOK_0A                            = GameFlag(0x240),
    GF_NOK15_BombedWall                         = GameFlag(0x241),
    GF_NOK03_Item_HPPlusB                       = GameFlag(0x242),
    GF_NOK02_Item_StarPiece                     = GameFlag(0x243),
    GF_NOK12_Item_StarPiece                     = GameFlag(0x244),
    GF_NOK14_Item_ThunderBolt                   = GameFlag(0x245),
    GF_NOK14_Item_CoinA                         = GameFlag(0x246),
    GF_NOK14_Item_CoinB                         = GameFlag(0x247),
    GF_NOK14_Item_CoinC                         = GameFlag(0x248),
    GF_NOK14_Item_CoinD                         = GameFlag(0x249),
    GF_NOK14_Item_CoinE                         = GameFlag(0x24A),
    GF_Unused_NOK_15                            = GameFlag(0x24B),
    GF_NOK01_Bush1_Coin                         = GameFlag(0x24C),
    GF_NOK01_Bush3_DriedShroom                  = GameFlag(0x24D),
    GF_NOK01_Bush4_KoopaLeaf                    = GameFlag(0x24E),
    GF_NOK01_Bush5_Coin                         = GameFlag(0x24F),
    GF_NOK02_Bush1_KoopaLeaf                    = GameFlag(0x250),
    GF_NOK15_Tree1_StarPiece                    = GameFlag(0x251),
    GF_NOK11_ItemBlock_Coin                     = GameFlag(0x252),
    GF_NOK11_BadgeBlock_DizzyAttack             = GameFlag(0x253),
    GF_NOK11_ItemBlock_FrightJar                = GameFlag(0x254),
    GF_NOK12_ItemBlock_POWBlock                 = GameFlag(0x255),
    GF_NOK13_BadgeBlock_AttackFXB               = GameFlag(0x256),
    GF_NOK14_HiddenItem_FireFlower              = GameFlag(0x257),
    GF_NOK12_MultiCoinBrick                     = GameFlag(0x258),
    GF_Unused_NOK_23                            = GameFlag(0x259),
    GF_Unused_NOK_24                            = GameFlag(0x25A),
    GF_Unused_NOK_25                            = GameFlag(0x25B),
    GF_Unused_NOK_26                            = GameFlag(0x25C),
    GF_Unused_NOK_27                            = GameFlag(0x25D),
    GF_NOK01_HiddenPanel                        = GameFlag(0x25E),
    GF_Unused_NOK_29                            = GameFlag(0x25F),
    GF_NOK13_HiddenPanel                        = GameFlag(0x260),
    GF_NOK14_HiddenPanel                        = GameFlag(0x261),
    GF_NOK11_Defeated_KentC                     = GameFlag(0x262), ///< also allows Kolorado to return home
    GF_NOK01_Bush6_Glasses                      = GameFlag(0x263),
    GF_NOK01_Bush7_EmptyWallet                  = GameFlag(0x264),
    GF_NOK02_Gift_KoopaLegends                  = GameFlag(0x265),
    GF_NOK02_ConfrontedBobombs                  = GameFlag(0x266),
    GF_NOK12_Item_SleepySheep                   = GameFlag(0x267),
    GF_NOK13_Item_HoneySyrup                    = GameFlag(0x268),
    GF_NOK02_Met_KoopaKoot                      = GameFlag(0x269),
    GF_Unused_NOK_34                            = GameFlag(0x26A),
    GF_Unused_NOK_35                            = GameFlag(0x26B),
    GF_Unused_NOK_36                            = GameFlag(0x26C),
    GF_Unused_NOK_37                            = GameFlag(0x26D),
    GF_Unused_NOK_38                            = GameFlag(0x26E),
    GF_Unused_NOK_39                            = GameFlag(0x26F),
    GF_Unused_NOK_3A                            = GameFlag(0x270),
    GF_Unused_NOK_3B                            = GameFlag(0x271),
    GF_Unused_NOK_3C                            = GameFlag(0x272),
    GF_Unused_NOK_3D                            = GameFlag(0x273),
    GF_Unused_NOK_3E                            = GameFlag(0x274),
    GF_Unused_NOK_3F                            = GameFlag(0x275),
    GF_Unused_NOK_40                            = GameFlag(0x276),
    GF_Unused_NOK_41                            = GameFlag(0x277),
    GF_Unused_NOK_42                            = GameFlag(0x278),
    GF_Unused_NOK_43                            = GameFlag(0x279),
    GF_Unused_NOK_44                            = GameFlag(0x27A),
    GF_Unused_NOK_45                            = GameFlag(0x27B),
    GF_Unused_NOK_46                            = GameFlag(0x27C),
    GF_Unused_NOK_47                            = GameFlag(0x27D),
    GF_TRD01_Item_SmashCharge                   = GameFlag(0x27E),
    GF_TRD03_Item_PowerBounce                   = GameFlag(0x27F),
    GF_TRD09_ItemBlock_MapleSyrup               = GameFlag(0x280),
    GF_TRD00_Chest_Refund                       = GameFlag(0x281),
    GF_TRD00_Chest_FPPlusB                      = GameFlag(0x282),
    GF_Unused_TRD_05                            = GameFlag(0x283),
    GF_Unused_TRD_06                            = GameFlag(0x284),
    GF_TRD01_Item_FortressKey                   = GameFlag(0x285),
    GF_TRD03_Item_FortressKeyA                  = GameFlag(0x286),
    GF_TRD03_Item_FortressKeyB                  = GameFlag(0x287),
    GF_TRD08_Item_FortressKey                   = GameFlag(0x288),
    GF_Unused_TRD_0B                            = GameFlag(0x289),
    GF_TRD01_UnlockedDoor                       = GameFlag(0x28A),
    GF_TRD02_UnlockedDoor                       = GameFlag(0x28B),
    GF_TRD04_UnlockedUpperDoor                  = GameFlag(0x28C),
    GF_TRD04_UnlockedLowerDoor                  = GameFlag(0x28D),
    GF_Unused_TRD_10                            = GameFlag(0x28E),
    GF_TRD02_BombedWall                         = GameFlag(0x28F),
    GF_TRD03_BombedCenterCell                   = GameFlag(0x290),
    GF_TRD03_BombedRightCell                    = GameFlag(0x291),
    GF_TRD05_BombedWall                         = GameFlag(0x292),
    GF_TRD06_BombedWall                         = GameFlag(0x293),
    GF_TRD06_Met_Bombette                       = GameFlag(0x294),
    GF_TRD09_Defeated_BillBlasters              = GameFlag(0x295),
    GF_TRD09_BombedRock                         = GameFlag(0x296),
    GF_TRD10_Defeated_KoopaBros                 = GameFlag(0x297),
    GF_Unused_TRD_1A                            = GameFlag(0x298),
    GF_TRD01_Defeated_KoopaGuard                = GameFlag(0x299),
    GF_TRD07_Defeated_DungeonAmbush             = GameFlag(0x29A),
    GF_Unused_TRD_1D                            = GameFlag(0x29B),
    GF_Unused_TRD_1E                            = GameFlag(0x29C),
    GF_Unused_TRD_1F                            = GameFlag(0x29D),
    GF_Unused_TRD_20                            = GameFlag(0x29E),
    GF_Unused_TRD_21                            = GameFlag(0x29F),
    GF_Unused_TRD_22                            = GameFlag(0x2A0),
    GF_Unused_TRD_23                            = GameFlag(0x2A1),
    GF_Unused_TRD_24                            = GameFlag(0x2A2),
    GF_Unused_TRD_25                            = GameFlag(0x2A3),
    GF_Unused_TRD_26                            = GameFlag(0x2A4),
    GF_Unused_TRD_27                            = GameFlag(0x2A5),
    GF_Unused_TRD_28                            = GameFlag(0x2A6),
    GF_Unused_TRD_29                            = GameFlag(0x2A7),
    GF_Unused_TRD_2A                            = GameFlag(0x2A8),
    GF_Unused_TRD_2B                            = GameFlag(0x2A9),
    GF_Unused_TRD_2C                            = GameFlag(0x2AA),
    GF_Unused_TRD_2D                            = GameFlag(0x2AB),
    GF_Unused_TRD_2E                            = GameFlag(0x2AC),
    GF_Unused_TRD_2F                            = GameFlag(0x2AD),
    GF_IWA01_Item_QuakeHammer                   = GameFlag(0x2AE),
    GF_IWA02_Item_StarPiece                     = GameFlag(0x2AF),
    GF_IWA03_Item_StarPiece                     = GameFlag(0x2B0),
    GF_IWA03_Chest_DamageDodgeB                 = GameFlag(0x2B1),
    GF_Unused_IWA_04                            = GameFlag(0x2B2),
    GF_IWA00_Item_CoinA                         = GameFlag(0x2B3),
    GF_IWA00_Item_CoinB                         = GameFlag(0x2B4),
    GF_IWA00_Item_CoinC                         = GameFlag(0x2B5),
    GF_IWA03_Item_CoinA                         = GameFlag(0x2B6),
    GF_IWA03_Item_CoinB                         = GameFlag(0x2B7),
    GF_IWA03_Item_CoinC                         = GameFlag(0x2B8),
    GF_IWA03_Item_CoinD                         = GameFlag(0x2B9),
    GF_IWA03_Item_CoinE                         = GameFlag(0x2BA),
    GF_IWA03_Item_CoinF                         = GameFlag(0x2BB),
    GF_IWA03_Item_CoinG                         = GameFlag(0x2BC),
    GF_IWA03_Item_CoinH                         = GameFlag(0x2BD),
    GF_IWA03_ItemBlock_Coin                     = GameFlag(0x2BE),
    GF_IWA03_ItemBlock_Mushroom                 = GameFlag(0x2BF),
    GF_IWA03_ItemBlock_HoneySyrup               = GameFlag(0x2C0),
    GF_IWA01_Item_Letter01                      = GameFlag(0x2C1),
    GF_IWA03_Item_LettertoKolorado              = GameFlag(0x2C2),
    GF_IWA04_Item_Letter10                      = GameFlag(0x2C3),
    GF_IWA04_Defeated_Buzzar                    = GameFlag(0x2C4),
    GF_IWA10_Bush1_Coin                         = GameFlag(0x2C5),
    GF_IWA10_Bush2_Coin                         = GameFlag(0x2C6),
    GF_IWA10_Bush3_Coin                         = GameFlag(0x2C7),
    GF_Unused_IWA_1A                            = GameFlag(0x2C8),
    GF_Unused_IWA_1B                            = GameFlag(0x2C9),
    GF_Unused_IWA_1C                            = GameFlag(0x2CA),
    GF_IWA00_ItemBlock_SleepySheep              = GameFlag(0x2CB),
    GF_IWA02_Gift_MagicalSeed2                  = GameFlag(0x2CC),
    GF_IWA01_HiddenPanel                        = GameFlag(0x2CD),
    GF_Unused_IWA_20                            = GameFlag(0x2CE),
    GF_IWA01_Hammer1Block                       = GameFlag(0x2CF),
    GF_IWA10_Hammer1Block                       = GameFlag(0x2D0),
    GF_IWA10_SuperBlock                         = GameFlag(0x2D1),
    GF_IWA00_Met_Whacka                         = GameFlag(0x2D2),
    GF_Unused_IWA_25                            = GameFlag(0x2D3),
    GF_Unused_IWA_26                            = GameFlag(0x2D4),
    GF_Unused_IWA_27                            = GameFlag(0x2D5),
    GF_Unused_IWA_28                            = GameFlag(0x2D6),
    GF_Unused_IWA_29                            = GameFlag(0x2D7),
    GF_Unused_IWA_2A                            = GameFlag(0x2D8),
    GF_Unused_IWA_2B                            = GameFlag(0x2D9),
    GF_Unused_IWA_2C                            = GameFlag(0x2DA),
    GF_Unused_IWA_2D                            = GameFlag(0x2DB),
    GF_Unused_IWA_2E                            = GameFlag(0x2DC),
    GF_Unused_IWA_2F                            = GameFlag(0x2DD),
    GF_Unused_IWA_30                            = GameFlag(0x2DE),
    GF_Unused_IWA_31                            = GameFlag(0x2DF),
    GF_Unused_IWA_32                            = GameFlag(0x2E0),
    GF_Unused_IWA_33                            = GameFlag(0x2E1),
    GF_Unused_IWA_34                            = GameFlag(0x2E2),
    GF_Unused_IWA_35                            = GameFlag(0x2E3),
    GF_Unused_IWA_36                            = GameFlag(0x2E4),
    GF_Unused_IWA_37                            = GameFlag(0x2E5),
    GF_Unused_IWA_38                            = GameFlag(0x2E6),
    GF_Unused_IWA_39                            = GameFlag(0x2E7),
    GF_Unused_IWA_3A                            = GameFlag(0x2E8),
    GF_Unused_IWA_3B                            = GameFlag(0x2E9),
    GF_DRO02_Sheek_SpokeTo                      = GameFlag(0x2EA),
    GF_DRO02_Sheek_AskedAboutDesert             = GameFlag(0x2EB),
    GF_DRO02_Sheek_AskedAboutRuins              = GameFlag(0x2EC),
    GF_DRO02_Sheek_AskedAboutMoustafa           = GameFlag(0x2ED),
    GF_DRO02_Moustafa_UnusedDialogOverride      = GameFlag(0x2EE),
    GF_DRO02_Moustafa_HeardAboutDryDryRuins     = GameFlag(0x2EF),
    GF_Unused_DRO_06                            = GameFlag(0x2F0),
    GF_Unused_DRO_07                            = GameFlag(0x2F1),
    GF_DRO01_Gift_Melody                        = GameFlag(0x2F2),
    GF_DRO01_Gift_ToldComposerAboutMelody       = GameFlag(0x2F3),
    GF_DRO02_HiddenPanel                        = GameFlag(0x2F4),
    GF_DRO02_Item_Letter08                      = GameFlag(0x2F5),
    GF_DRO01_Gift_RedJar                        = GameFlag(0x2F6),
    GF_DRO01_Gift_CrystalBall                   = GameFlag(0x2F7),
    GF_DRO01_Tree1_Coin                         = GameFlag(0x2F8),
    GF_DRO01_HeardHintAboutSpinningRoof         = GameFlag(0x2F9),
    GF_Unused_DRO_10                            = GameFlag(0x2FA),
    GF_Unused_DRO_11                            = GameFlag(0x2FB),
    GF_Unused_DRO_12                            = GameFlag(0x2FC),
    GF_Unused_DRO_13                            = GameFlag(0x2FD),
    GF_Unused_DRO_14                            = GameFlag(0x2FE),
    GF_Unused_DRO_15                            = GameFlag(0x2FF),
    GF_Unused_DRO_16                            = GameFlag(0x300),
    GF_Unused_DRO_17                            = GameFlag(0x301),
    GF_Unused_DRO_18                            = GameFlag(0x302),
    GF_Unused_DRO_19                            = GameFlag(0x303),
    GF_Unused_DRO_1A                            = GameFlag(0x304),
    GF_Unused_DRO_1B                            = GameFlag(0x305),
    GF_Unused_DRO_1C                            = GameFlag(0x306),
    GF_Unused_DRO_1D                            = GameFlag(0x307),
    GF_Unused_DRO_1E                            = GameFlag(0x308),
    GF_Unused_DRO_1F                            = GameFlag(0x309),
    GF_Unused_DRO_20                            = GameFlag(0x30A),
    GF_Unused_DRO_21                            = GameFlag(0x30B),
    GF_Unused_DRO_22                            = GameFlag(0x30C),
    GF_Unused_DRO_23                            = GameFlag(0x30D),
    GF_SBK30_Met_Kolorado                       = GameFlag(0x30E),
    GF_SBK34_Met_Nomadimouse                    = GameFlag(0x30F),
    GF_Unused_SBK_02                            = GameFlag(0x310),
    GF_SBK_KeptArtifactFromKolorado             = GameFlag(0x311), ///< refused to give it to him
    GF_SBK_GaveArtifactToKolorado               = GameFlag(0x312),
    GF_SBK30_Kolorado_SharedRumorAboutMoustafa  = GameFlag(0x313),
    GF_Unused_SBK_06                            = GameFlag(0x314),
    GF_Unused_SBK_07                            = GameFlag(0x315),
    GF_Unused_SBK_08                            = GameFlag(0x316),
    GF_Unused_SBK_09                            = GameFlag(0x317),
    GF_SBK56_Tree1_Lemon                        = GameFlag(0x318),
    GF_SBK56_UnusedA                            = GameFlag(0x319), ///< set to false, never read. presumably once used for fruit trees that no longer exist.
    GF_SBK56_Tree2_Lime                         = GameFlag(0x31A),
    GF_SBK56_UnusedB                            = GameFlag(0x31B), ///< set to false, never read. presumably once used for fruit trees that no longer exist.
    GF_SBK33_HiddenPanel                        = GameFlag(0x31C),
    GF_SBK00_ItemBlock_FrightJar                = GameFlag(0x31D),
    GF_SBK00_ItemBlock_Coin                     = GameFlag(0x31E),
    GF_SBK10_HiddenItem_ThunderRage             = GameFlag(0x31F),
    GF_SBK14_ItemBlock_Coin                     = GameFlag(0x320),
    GF_SBK14_ItemBlock_HoneySyrup               = GameFlag(0x321),
    GF_SBK20_ItemBlock_Mushroom                 = GameFlag(0x322),
    GF_SBK20_ItemBlock_SuperShroom              = GameFlag(0x323),
    GF_SBK20_ItemBlock_UltraShroom              = GameFlag(0x324),
    GF_SBK22_ItemBlock_CoinA                    = GameFlag(0x325),
    GF_SBK22_ItemBlock_CoinB                    = GameFlag(0x326),
    GF_SBK22_ItemBlock_CoinC                    = GameFlag(0x327),
    GF_SBK22_ItemBlock_CoinD                    = GameFlag(0x328),
    GF_SBK22_ItemBlock_FireFlower               = GameFlag(0x329),
    GF_SBK24_HiddenBadge_RunawayPay             = GameFlag(0x32A),
    GF_SBK43_ItemBlock_Coin                     = GameFlag(0x32B),
    GF_SBK46_ItemBlock_Coin                     = GameFlag(0x32C),
    GF_SBK46_HiddenItem_LifeShroom              = GameFlag(0x32D),
    GF_SBK61_HiddenBadge_AttackFXC              = GameFlag(0x32E),
    GF_SBK64_ItemBlock_Coin                     = GameFlag(0x32F),
    GF_SBK06_MultiCoinBrick                     = GameFlag(0x330),
    GF_SBK14_MultiCoinBrick                     = GameFlag(0x331),
    GF_SBK25_MultiCoinBrickA                    = GameFlag(0x332),
    GF_SBK25_MultiCoinBrickB                    = GameFlag(0x333),
    GF_SBK40_MultiCoinBrick                     = GameFlag(0x334),
    GF_SBK52_MultiCoinBrick                     = GameFlag(0x335),
    GF_SBK55_MultiCoinBrick                     = GameFlag(0x336),
    GF_SBK66_MultiCoinBrickA                    = GameFlag(0x337),
    GF_SBK66_MultiCoinBrickB                    = GameFlag(0x338),
    GF_SBK66_MultiCoinBrickC                    = GameFlag(0x339),
    GF_SBK66_MultiCoinBrickD                    = GameFlag(0x33A),
    GF_SBK66_MultiCoinBrickE                    = GameFlag(0x33B),
    GF_SBK66_MultiCoinBrickF                    = GameFlag(0x33C),
    GF_SBK56_SuperBlock                         = GameFlag(0x33D),
    GF_SBK30_Visited                            = GameFlag(0x33E),
    GF_SBK05_Item_FireFlower                    = GameFlag(0x33F),
    GF_SBK30_Tree2_Letter02                     = GameFlag(0x340),
    GF_SBK36_Tree9_Letter03                     = GameFlag(0x341),
    GF_SBK45_Item_SpinAttack                    = GameFlag(0x342),
    GF_SBK45_Item_StopWatch                     = GameFlag(0x343),
    GF_SBK55_Item_TastyTonic                    = GameFlag(0x344),
    GF_SBK06_Tree1_Coin                         = GameFlag(0x345),
    GF_SBK26_Tree1_Coin                         = GameFlag(0x346),
    GF_SBK34_Tree1_Coin                         = GameFlag(0x347),
    GF_SBK35_Tree1_Coin                         = GameFlag(0x348),
    GF_SBK36_Tree1_Coin                         = GameFlag(0x349),
    GF_SBK36_Tree2_Coin                         = GameFlag(0x34A),
    GF_SBK36_Tree6_Coin                         = GameFlag(0x34B),
    GF_SBK46_Tree2_Coin                         = GameFlag(0x34C),
    GF_SBK55_Tree1_Coin                         = GameFlag(0x34D),
    GF_SBK56_Tree3_Coin                         = GameFlag(0x34E),
    GF_SBK56_Tree9_Coin                         = GameFlag(0x34F),
    GF_SBK66_Tree3_Coin                         = GameFlag(0x350),
    GF_SBK30_KooperMetKolorado                  = GameFlag(0x351),
    GF_Unused_SBK_44                            = GameFlag(0x352),
    GF_Unused_SBK_45                            = GameFlag(0x353),
    GF_Unused_SBK_46                            = GameFlag(0x354),
    GF_Unused_SBK_47                            = GameFlag(0x355),
    GF_Unused_SBK_48                            = GameFlag(0x356),
    GF_Unused_SBK_49                            = GameFlag(0x357),
    GF_Unused_SBK_4A                            = GameFlag(0x358),
    GF_Unused_SBK_4B                            = GameFlag(0x359),
    GF_Unused_SBK_4C                            = GameFlag(0x35A),
    GF_Unused_SBK_4D                            = GameFlag(0x35B),
    GF_Unused_SBK_4E                            = GameFlag(0x35C),
    GF_Unused_SBK_4F                            = GameFlag(0x35D),
    GF_Unused_SBK_50                            = GameFlag(0x35E),
    GF_Unused_SBK_51                            = GameFlag(0x35F),
    GF_Unused_SBK_52                            = GameFlag(0x360),
    GF_Unused_SBK_53                            = GameFlag(0x361),
    GF_Unused_SBK_54                            = GameFlag(0x362),
    GF_Unused_SBK_55                            = GameFlag(0x363),
    GF_Unused_SBK_56                            = GameFlag(0x364),
    GF_Unused_SBK_57                            = GameFlag(0x365),
    GF_ISK02_UnlockedDoor                       = GameFlag(0x366),
    GF_ISK03_Item_RuinsKey                      = GameFlag(0x367),
    GF_ISK04_BombedWall                         = GameFlag(0x368),
    GF_ISK04_UnlockedDoor                       = GameFlag(0x369),
    GF_ISK06_Item_RuinsKey                      = GameFlag(0x36A),
    GF_ISK07_Item_RuinsKey                      = GameFlag(0x36B),
    GF_ISK07_Defeated_Mummies                   = GameFlag(0x36C),
    GF_ISK07_UnlockedDoor                       = GameFlag(0x36D),
    GF_ISK_BombedWallFrom08                     = GameFlag(0x36E),
    GF_ISK10_BombedWall                         = GameFlag(0x36F),
    GF_ISK_BombedWallFrom10                     = GameFlag(0x370),
    GF_ISK13_Item_LunarStone                    = GameFlag(0x371),
    GF_ISK05_Item_PyramidStone                  = GameFlag(0x372),
    GF_ISK14_Item_DiamondStone                  = GameFlag(0x373),
    GF_ISK07_Item_Artifact                      = GameFlag(0x374),
    GF_ISK06_Item_StarPiece                     = GameFlag(0x375),
    GF_ISK07_OpenedSarcophagi                   = GameFlag(0x376),
    GF_ISK12_Item_RuinsKey                      = GameFlag(0x377),
    GF_ISK11_UnlockedDoor                       = GameFlag(0x378),
    GF_ISK01_FirstWarning                       = GameFlag(0x379),
    GF_ISK04_SecondWarning                      = GameFlag(0x37A),
    GF_ISK09_ThirdWarning                       = GameFlag(0x37B),
    GF_ISK11_FourthWarning                      = GameFlag(0x37C),
    GF_ISK19_FinalWarning                       = GameFlag(0x37D),
    GF_ISK05_Hammer2Block                       = GameFlag(0x37E),
    GF_ISK07_Hammer2Block                       = GameFlag(0x37F),
    GF_ISK09_Hammer2Block                       = GameFlag(0x380),
    GF_ISK12_Hammer2Block                       = GameFlag(0x381),
    GF_ISK13_Hammer2Block                       = GameFlag(0x382),
    GF_ISK14_Hammer2Block                       = GameFlag(0x383),
    GF_ISK09_GiantChest                         = GameFlag(0x384),
    GF_ISK09_Chest_SlowGo                       = GameFlag(0x385),
    GF_ISK16_Defeated_Tutankoopa                = GameFlag(0x386),
    GF_ISK10_SuperBlock                         = GameFlag(0x387),
    GF_ISK05_Defeated_StoneChomp                = GameFlag(0x388),
    GF_ISK13_Defeated_StoneChomp                = GameFlag(0x389),
    GF_ISK14_Defeated_StoneChomp                = GameFlag(0x38A),
    GF_Unused_ISK_25                            = GameFlag(0x38B),
    GF_Unused_ISK_26                            = GameFlag(0x38C),
    GF_Unused_ISK_27                            = GameFlag(0x38D),
    GF_Unused_ISK_28                            = GameFlag(0x38E),
    GF_Unused_ISK_29                            = GameFlag(0x38F),
    GF_Unused_ISK_2A                            = GameFlag(0x390),
    GF_Unused_ISK_2B                            = GameFlag(0x391),
    GF_Unused_ISK_2C                            = GameFlag(0x392),
    GF_Unused_ISK_2D                            = GameFlag(0x393),
    GF_Unused_ISK_2E                            = GameFlag(0x394),
    GF_Unused_ISK_2F                            = GameFlag(0x395),
    GF_Unused_ISK_30                            = GameFlag(0x396),
    GF_Unused_ISK_31                            = GameFlag(0x397),
    GF_Unused_ISK_32                            = GameFlag(0x398),
    GF_Unused_ISK_33                            = GameFlag(0x399),
    GF_Unused_ISK_34                            = GameFlag(0x39A),
    GF_Unused_ISK_35                            = GameFlag(0x39B),
    GF_MIM_ChoosingPath                         = GameFlag(0x39C), ///< unclear logic
    GF_MIM08_BadgeBlock_HPPlusA                 = GameFlag(0x39D),
    GF_MIM09_BadgeBlock_FPPlusA                 = GameFlag(0x39E),
    GF_MIM10_Defeated_JrTroopa                  = GameFlag(0x39F),
    GF_MIM10_JrTroopaFreakout                   = GameFlag(0x3A0),
    GF_MIM10_JrTroopaEscaped                    = GameFlag(0x3A1),
    GF_MIM04_Gift_MagicalSeed3                  = GameFlag(0x3A2),
    GF_Unused_MIM_07                            = GameFlag(0x3A3),
    GF_Unused_MIM_08                            = GameFlag(0x3A4),
    GF_MIM12_HiddenPanel                        = GameFlag(0x3A5),
    GF_Unused_MIM_0A                            = GameFlag(0x3A6),
    GF_MIM11_ItemBlock_VoltShroom               = GameFlag(0x3A7),
    GF_Unused_MIM_0C                            = GameFlag(0x3A8),
    GF_Unused_MIM_0D                            = GameFlag(0x3A9),
    GF_Unused_MIM_0E                            = GameFlag(0x3AA),
    GF_Unused_MIM_0F                            = GameFlag(0x3AB),
    GF_Unused_MIM_10                            = GameFlag(0x3AC),
    GF_Unused_MIM_11                            = GameFlag(0x3AD),
    GF_Unused_MIM_12                            = GameFlag(0x3AE),
    GF_Unused_MIM_13                            = GameFlag(0x3AF),
    GF_Unused_MIM_14                            = GameFlag(0x3B0),
    GF_Unused_MIM_15                            = GameFlag(0x3B1),
    GF_Unused_MIM_16                            = GameFlag(0x3B2),
    GF_Unused_MIM_17                            = GameFlag(0x3B3),
    GF_Unused_MIM_18                            = GameFlag(0x3B4),
    GF_Unused_MIM_19                            = GameFlag(0x3B5),
    GF_Unused_MIM_1A                            = GameFlag(0x3B6),
    GF_Unused_MIM_1B                            = GameFlag(0x3B7),
    GF_Unused_MIM_1C                            = GameFlag(0x3B8),
    GF_Unused_MIM_1D                            = GameFlag(0x3B9),
    GF_Unused_MIM_1E                            = GameFlag(0x3BA),
    GF_Unused_MIM_1F                            = GameFlag(0x3BB),
    GF_Unused_OBK_00                            = GameFlag(0x3BC),
    GF_OBK01_Visited                            = GameFlag(0x3BD),
    GF_Unused_OBK_02                            = GameFlag(0x3BE),
    GF_OBK01_Gift_OldPhoto                      = GameFlag(0x3BF),
    GF_OBK01_Portrait_Farewell                  = GameFlag(0x3C0),
    GF_OBK01_HiddenPanel                        = GameFlag(0x3C1),
    GF_OBK02_TriggeredChestTrap                 = GameFlag(0x3C2),
    GF_OBK02_Chest_Trap                         = GameFlag(0x3C3),
    GF_OBK02_HiddenPanel                        = GameFlag(0x3C4),
    GF_OBK03_Crate_SuperShroom                  = GameFlag(0x3C5),
    GF_Unused_OBK_0A                            = GameFlag(0x3C6),
    GF_OBK04_GiantChest                         = GameFlag(0x3C7),
    GF_OBK04_BoardedFloor                       = GameFlag(0x3C8),
    GF_OBK04_UnusedBoardedFloor                 = GameFlag(0x3C9),
    GF_OBK04_Crate_MapleSyrup                   = GameFlag(0x3CA),
    GF_OBK04_HeardAboutHiddenPanels             = GameFlag(0x3CB),
    GF_OBK04_HiddenPanel                        = GameFlag(0x3CC),
    GF_OBK05_BoardedFloor                       = GameFlag(0x3CD),
    GF_OBK06_BombedWall                         = GameFlag(0x3CE),
    GF_OBK06_Item_BoosPortrait                  = GameFlag(0x3CF),
    GF_OBK06_Crate_StarPiece                    = GameFlag(0x3D0),
    GF_Unused_OBK_15                            = GameFlag(0x3D1),
    GF_OBK07_Chest_Weight                       = GameFlag(0x3D2),
    GF_OBK08_Item_Record                        = GameFlag(0x3D3),
    GF_OBK08_HiddenPanel                        = GameFlag(0x3D4),
    GF_OBK01_Met_Portrait                       = GameFlag(0x3D5),
    GF_Unused_OBK_1A                            = GameFlag(0x3D6),
    GF_Unused_OBK_1B                            = GameFlag(0x3D7),
    GF_Unused_OBK_1C                            = GameFlag(0x3D8),
    GF_Unused_OBK_1D                            = GameFlag(0x3D9),
    GF_Unused_OBK_1E                            = GameFlag(0x3DA),
    GF_Unused_OBK_1F                            = GameFlag(0x3DB),
    GF_Unused_OBK_20                            = GameFlag(0x3DC),
    GF_Unused_OBK_21                            = GameFlag(0x3DD),
    GF_Unused_OBK_22                            = GameFlag(0x3DE),
    GF_Unused_OBK_23                            = GameFlag(0x3DF),
    GF_Unused_OBK_24                            = GameFlag(0x3E0),
    GF_Unused_OBK_25                            = GameFlag(0x3E1),
    GF_Unused_OBK_26                            = GameFlag(0x3E2),
    GF_Unused_OBK_27                            = GameFlag(0x3E3),
    GF_Unused_OBK_28                            = GameFlag(0x3E4),
    GF_Unused_OBK_29                            = GameFlag(0x3E5),
    GF_Unused_OBK_2A                            = GameFlag(0x3E6),
    GF_Unused_OBK_2B                            = GameFlag(0x3E7),
    GF_Unused_OBK_2C                            = GameFlag(0x3E8),
    GF_Unused_ARN_00                            = GameFlag(0x3E9),
    GF_ARN02_ItemBlock_CoinA                    = GameFlag(0x3EA),
    GF_ARN02_ItemBlock_CoinB                    = GameFlag(0x3EB),
    GF_ARN02_ItemBlock_RepelGel                 = GameFlag(0x3EC),
    GF_ARN02_Item_DizzyDial                     = GameFlag(0x3ED),
    GF_ARN02_Item_LetterFiceT                   = GameFlag(0x3EE),
    GF_ARN03_ItemBlock_Coin                     = GameFlag(0x3EF),
    GF_ARN04_ItemBlock_SuperShroom              = GameFlag(0x3F0),
    GF_ARN04_ItemBlock_Coin                     = GameFlag(0x3F1),
    GF_ARN04_MultiCoinBrick                     = GameFlag(0x3F2),
    GF_Unused_ARN_0A                            = GameFlag(0x3F3),
    GF_Unused_ARN_0B                            = GameFlag(0x3F4),
    GF_Unused_ARN_0C                            = GameFlag(0x3F5),
    GF_ARN05_GaveGiftAdvice                     = GameFlag(0x3F6),
    GF_ARN03_RecievedPackage                    = GameFlag(0x3F7),
    GF_ARN10_Defeated_Goomba                    = GameFlag(0x3F8),
    GF_ARN12_Defeated_Goomba                    = GameFlag(0x3F9),
    GF_ARN13_Defeated_Goomba                    = GameFlag(0x3FA),
    GF_ARN04_Item_StarPiece                     = GameFlag(0x3FB),
    GF_ARN03_WaitingForPackage                  = GameFlag(0x3FC),
    GF_Unused_ARN_14                            = GameFlag(0x3FD),
    GF_Unused_ARN_15                            = GameFlag(0x3FE),
    GF_Unused_ARN_16                            = GameFlag(0x3FF),
    GF_Unused_ARN_17                            = GameFlag(0x400),
    GF_Unused_ARN_18                            = GameFlag(0x401),
    GF_Unused_ARN_19                            = GameFlag(0x402),
    GF_Unused_ARN_1A                            = GameFlag(0x403),
    GF_Unused_ARN_1B                            = GameFlag(0x404),
    GF_Unused_ARN_1C                            = GameFlag(0x405),
    GF_Unused_ARN_1D                            = GameFlag(0x406),
    GF_Unused_ARN_1E                            = GameFlag(0x407),
    GF_Unused_ARN_1F                            = GameFlag(0x408),
    GF_Unused_ARN_20                            = GameFlag(0x409),
    GF_Unused_ARN_21                            = GameFlag(0x40A),
    GF_Unused_ARN_22                            = GameFlag(0x40B),
    GF_Unused_ARN_23                            = GameFlag(0x40C),
    GF_Unused_ARN_24                            = GameFlag(0x40D),
    GF_Unused_ARN_25                            = GameFlag(0x40E),
    GF_Unused_ARN_26                            = GameFlag(0x40F),
    GF_DGB01_UnlockedEastWing                   = GameFlag(0x410),
    GF_DGB01_Visited                            = GameFlag(0x411),
    GF_DGB03_Item_StarPiece                     = GameFlag(0x412),
    GF_DGB03_UnlockedThirdFloor                 = GameFlag(0x413),
    GF_DGB03_PushedClock                        = GameFlag(0x414),
    GF_DGB03_PushedClockLeft                    = GameFlag(0x415),
    GF_DGB04_SuperBlock                         = GameFlag(0x416),
    GF_DGB05_BoardedFloor                       = GameFlag(0x417),
    GF_DGB06_Chest_CastleKey1                   = GameFlag(0x418),
    GF_Unused_DGB_09                            = GameFlag(0x419),
    GF_DGB07_Item_StarPiece                     = GameFlag(0x41A),
    GF_DGB09_BombedWall                         = GameFlag(0x41B),
    GF_DGB10_BoardedFloor1                      = GameFlag(0x41C),
    GF_DGB10_BoardedFloor2                      = GameFlag(0x41D),
    GF_DGB10_BoardedFloor3                      = GameFlag(0x41E),
    GF_DGB11_Item_DDownJump                     = GameFlag(0x41F),
    GF_Unused_DGB_10                            = GameFlag(0x420),
    GF_DGB12_Chest_CastleKey1                   = GameFlag(0x421),
    GF_DGB13_Item_MegaRush                      = GameFlag(0x422),
    GF_DGB13_Item_CoinA                         = GameFlag(0x423),
    GF_DGB13_Item_CoinB                         = GameFlag(0x424),
    GF_DGB13_Item_CoinC                         = GameFlag(0x425),
    GF_DGB13_Item_CoinD                         = GameFlag(0x426),
    GF_DGB13_Item_CoinE                         = GameFlag(0x427),
    GF_DGB13_Item_CoinF                         = GameFlag(0x428),
    GF_DGB14_ItemBlock_MapleSyrup               = GameFlag(0x429),
    GF_DGB15_UnlockedUpperFoyer                 = GameFlag(0x42A),
    GF_DGB15_CloseCallWithTubba                 = GameFlag(0x42B),
    GF_DGB16_EscapedFromTubba                   = GameFlag(0x42C),
    GF_DGB16_Item_CastleKey1                    = GameFlag(0x42D),
    GF_Unused_DGB_1E                            = GameFlag(0x42E),
    GF_DGB18_Chest_MysticalKey                  = GameFlag(0x42F),
    GF_Unused_DGB_20                            = GameFlag(0x430),
    GF_Unused_DGB_21                            = GameFlag(0x431),
    GF_Unused_DGB_22                            = GameFlag(0x432),
    GF_Unused_DGB_23                            = GameFlag(0x433),
    GF_Unused_DGB_24                            = GameFlag(0x434),
    GF_Unused_DGB_25                            = GameFlag(0x435),
    GF_Unused_DGB_26                            = GameFlag(0x436),
    GF_Unused_DGB_27                            = GameFlag(0x437),
    GF_Unused_DGB_28                            = GameFlag(0x438),
    GF_Unused_DGB_29                            = GameFlag(0x439),
    GF_Unused_DGB_2A                            = GameFlag(0x43A),
    GF_Unused_DGB_2B                            = GameFlag(0x43B),
    GF_Unused_DGB_2C                            = GameFlag(0x43C),
    GF_Unused_DGB_2D                            = GameFlag(0x43D),
    GF_Unused_DGB_2E                            = GameFlag(0x43E),
    GF_Unused_DGB_2F                            = GameFlag(0x43F),
    GF_Unused_DGB_30                            = GameFlag(0x440),
    GF_Unused_DGB_31                            = GameFlag(0x441),
    GF_Unused_DGB_32                            = GameFlag(0x442),
    GF_Unused_DGB_33                            = GameFlag(0x443),
    GF_Unused_DGB_34                            = GameFlag(0x444),
    GF_Unused_DGB_35                            = GameFlag(0x445),
    GF_Unused_DGB_36                            = GameFlag(0x446),
    GF_Unused_DGB_37                            = GameFlag(0x447),
    GF_Unused_DGB_38                            = GameFlag(0x448),
    GF_Unused_DGB_39                            = GameFlag(0x449),
    GF_Unused_OMO_00                            = GameFlag(0x44A),
    GF_OMO01_Met_GourmetGuy                     = GameFlag(0x44B),
    GF_OMO03_LearnedAboutTrainSwitches          = GameFlag(0x44C),
    GF_OMO03_BlueSwitchActivated                = GameFlag(0x44D),
    GF_OMO04_Item_Mushroom                      = GameFlag(0x44E),
    GF_OMO07_Item_ThunderRage                   = GameFlag(0x44F),
    GF_OMO09_Item_SuperSoda                     = GameFlag(0x450),
    GF_OMO13_Defeated_AntiGuy                   = GameFlag(0x451),
    GF_OMO05_Item_Cookbook                      = GameFlag(0x452),
    GF_OMO01_Visited                            = GameFlag(0x453),
    GF_OMO01_Item_Calculator                    = GameFlag(0x454),
    GF_OMO09_Defeated_CalculatorThief           = GameFlag(0x455),
    GF_OMO01_HiddenItem_Mystery                 = GameFlag(0x456),
    GF_OMO01_HiddenItem_FrightJar               = GameFlag(0x457),
    GF_OMO02_ShyGuyFledBehindWall               = GameFlag(0x458),
    GF_OMO02_BombedWall                         = GameFlag(0x459),
    GF_OMO02_ItemBlock_SleepySheep              = GameFlag(0x45A),
    GF_OMO02_HiddenItem_Coin                    = GameFlag(0x45B),
    GF_OMO02_Item_ShootingStar                  = GameFlag(0x45C),
    GF_OMO03_HiddenItem_StoneCap                = GameFlag(0x45D),
    GF_OMO04_SpawnedPeachChoice1                = GameFlag(0x45E),
    GF_OMO04_Chest_StoreroomKey                 = GameFlag(0x45F),
    GF_OMO04_ItemBlock_CoinA                    = GameFlag(0x460),
    GF_OMO04_ItemBlock_CoinB                    = GameFlag(0x461),
    GF_OMO04_ItemBlock_ThunderBolt              = GameFlag(0x462),
    GF_OMO04_Item_CoinA                         = GameFlag(0x463),
    GF_OMO04_Item_CoinB                         = GameFlag(0x464),
    GF_OMO04_Item_CoinC                         = GameFlag(0x465),
    GF_OMO04_Item_CoinD                         = GameFlag(0x466),
    GF_OMO04_Item_CoinE                         = GameFlag(0x467),
    GF_OMO04_Item_CoinF                         = GameFlag(0x468),
    GF_OMO04_Item_CoinG                         = GameFlag(0x469),
    GF_OMO04_Item_CoinH                         = GameFlag(0x46A),
    GF_Unused_OMO_21                            = GameFlag(0x46B),
    GF_OMO04_Item_StarPieceA                    = GameFlag(0x46C),
    GF_OMO04_Item_StarPieceB                    = GameFlag(0x46D),
    GF_OMO05_ItemBlock_CoinA                    = GameFlag(0x46E),
    GF_OMO05_ItemBlock_CoinB                    = GameFlag(0x46F),
    GF_OMO05_HiddenItem_DizzyDial               = GameFlag(0x470),
    GF_OMO05_HiddenItem_SuperSoda               = GameFlag(0x471),
    GF_OMO06_Chest_Mailbag                      = GameFlag(0x472),
    GF_OMO06_HiddenItem_ThunderRage             = GameFlag(0x473),
    GF_OMO07_SpawnedPeachChoice2                = GameFlag(0x474),
    GF_OMO07_ItemBlock_Coin                     = GameFlag(0x475),
    GF_OMO07_Chest_FryingPan                    = GameFlag(0x476),
    GF_OMO07_Chest_DefendPlusA                  = GameFlag(0x477),
    GF_OMO07_Chest_IcePower                     = GameFlag(0x478),
    GF_OMO08_HiddenItem_FireFlower              = GameFlag(0x479),
    GF_OMO09_SpawnedPeachChoice3                = GameFlag(0x47A),
    GF_OMO09_Chest_Dictionary                   = GameFlag(0x47B),
    GF_OMO09_Defeated_MysteryNoteThief          = GameFlag(0x47C),
    GF_OMO09_Item_MysteryNote                   = GameFlag(0x47D),
    GF_OMO09_Item_CoinA                         = GameFlag(0x47E),
    GF_OMO09_Item_CoinB                         = GameFlag(0x47F),
    GF_OMO09_Item_CoinC                         = GameFlag(0x480),
    GF_OMO09_Item_CoinD                         = GameFlag(0x481),
    GF_OMO09_Item_CoinE                         = GameFlag(0x482),
    GF_OMO09_Item_CoinF                         = GameFlag(0x483),
    GF_Unused_OMO_3A                            = GameFlag(0x484),
    GF_Unused_OMO_3B                            = GameFlag(0x485),
    GF_Unused_OMO_3C                            = GameFlag(0x486),
    GF_Unused_OMO_3D                            = GameFlag(0x487),
    GF_OMO09_Item_CoinG                         = GameFlag(0x488),
    GF_OMO09_Item_CoinH                         = GameFlag(0x489),
    GF_Unused_OMO_40                            = GameFlag(0x48A),
    GF_Unused_OMO_41                            = GameFlag(0x48B),
    GF_Unused_OMO_42                            = GameFlag(0x48C),
    GF_OMO09_Item_CoinI                         = GameFlag(0x48D),
    GF_OMO09_Item_CoinJ                         = GameFlag(0x48E),
    GF_Unused_OMO_45                            = GameFlag(0x48F),
    GF_Unused_OMO_46                            = GameFlag(0x490),
    GF_Unused_OMO_47                            = GameFlag(0x491),
    GF_OMO09_Item_CoinK                         = GameFlag(0x492),
    GF_OMO09_Item_CoinL                         = GameFlag(0x493),
    GF_Unused_OMO_4A                            = GameFlag(0x494),
    GF_Unused_OMO_4B                            = GameFlag(0x495),
    GF_OMO09_Item_StarPiece                     = GameFlag(0x496),
    GF_OMO09_MultiCoinBrick                     = GameFlag(0x497),
    GF_OMO10_HiddenItem_SuperShroom             = GameFlag(0x498),
    GF_OMO11_MultiCoinBrick                     = GameFlag(0x499),
    GF_OMO11_HiddenBadge_DeepFocus2             = GameFlag(0x49A),
    GF_OMO11_ItemBlock_CoinA                    = GameFlag(0x49B),
    GF_OMO11_ItemBlock_CoinB                    = GameFlag(0x49C),
    GF_OMO11_HiddenItem_VoltShroom              = GameFlag(0x49D),
    GF_OMO11_HiddenItem_SnowmanDoll             = GameFlag(0x49E),
    GF_OMO13_Chest_PowerPlusB                   = GameFlag(0x49F),
    GF_OMO13_ItemBlock_Coin                     = GameFlag(0x4A0),
    GF_OMO13_HiddenItem_MapleSyrup              = GameFlag(0x4A1),
    GF_OMO17_ItemBlock_CoinA                    = GameFlag(0x4A2),
    GF_OMO17_ItemBlock_CoinB                    = GameFlag(0x4A3),
    GF_OMO17_ItemBlock_CoinC                    = GameFlag(0x4A4),
    GF_OMO17_MultiCoinBrick                     = GameFlag(0x4A5),
    GF_OMO03_HiddenPanel                        = GameFlag(0x4A6),
    GF_OMO06_HiddenPanel                        = GameFlag(0x4A7),
    GF_OMO08_HiddenPanel                        = GameFlag(0x4A8),
    GF_OMO10_HiddenPanel                        = GameFlag(0x4A9),
    GF_OMO11_SuperBlock                         = GameFlag(0x4AA),
    GF_Unused_OMO_61                            = GameFlag(0x4AB),
    GF_Unused_OMO_62                            = GameFlag(0x4AC),
    GF_Unused_OMO_63                            = GameFlag(0x4AD),
    GF_Unused_OMO_64                            = GameFlag(0x4AE),
    GF_Unused_OMO_65                            = GameFlag(0x4AF),
    GF_Unused_OMO_66                            = GameFlag(0x4B0),
    GF_Unused_OMO_67                            = GameFlag(0x4B1),
    GF_Unused_OMO_68                            = GameFlag(0x4B2),
    GF_Unused_OMO_69                            = GameFlag(0x4B3),
    GF_Unused_OMO_6A                            = GameFlag(0x4B4),
    GF_Unused_OMO_6B                            = GameFlag(0x4B5),
    GF_Unused_OMO_6C                            = GameFlag(0x4B6),
    GF_Unused_OMO_6D                            = GameFlag(0x4B7),
    GF_Unused_OMO_6E                            = GameFlag(0x4B8),
    GF_Unused_OMO_6F                            = GameFlag(0x4B9),
    GF_Unused_OMO_70                            = GameFlag(0x4BA),
    GF_Unused_OMO_71                            = GameFlag(0x4BB),
    GF_Unused_OMO_72                            = GameFlag(0x4BC),
    GF_Unused_OMO_73                            = GameFlag(0x4BD),
    GF_Unused_OMO_74                            = GameFlag(0x4BE),
    GF_Unused_JAN_00                            = GameFlag(0x4BF),
    GF_JAN00_Item_CoinA                         = GameFlag(0x4C0),
    GF_JAN00_Item_CoinB                         = GameFlag(0x4C1),
    GF_MAC01_Defeated_JrTroopa4                 = GameFlag(0x4C2),
    GF_JAN00_Item_StopWatch                     = GameFlag(0x4C3),
    GF_JAN01_SavedKolorado                      = GameFlag(0x4C4),
    GF_JAN01_Item_CoinA                         = GameFlag(0x4C5),
    GF_JAN01_Item_Letter11                      = GameFlag(0x4C6),
    GF_JAN02_Met_VillageLeader                  = GameFlag(0x4C7),
    GF_JAN03_AgreedToRescueChildren             = GameFlag(0x4C8),
    GF_JAN04_SushieTreeHitCounterA              = GameFlag(0x4C9), ///< paired with B for 4 states: 00/01/10/11
    GF_JAN04_SushieTreeHitCounterB              = GameFlag(0x4CA), ///< paired with A for 4 states: 00/01/10/11
    GF_JAN04_Tree2_Letter04                     = GameFlag(0x4CB),
    GF_JAN04_Chest_VolcanoVase                  = GameFlag(0x4CC),
    GF_JAN04_Item_StarPiece                     = GameFlag(0x4CD),
    GF_JAN05_SavedYoshi                         = GameFlag(0x4CE), ///< Blue/Purple
    GF_JAN07_SavedYoshi                         = GameFlag(0x4CF),
    GF_JAN08_SavedYoshi                         = GameFlag(0x4D0),
    GF_JAN10_SavedYoshi                         = GameFlag(0x4D1),
    GF_JAN11_SavedYoshi                         = GameFlag(0x4D2),
    GF_JAN05_CreateLogBridge                    = GameFlag(0x4D3),
    GF_JAN06_CreateLogBridge                    = GameFlag(0x4D4),
    GF_JAN10_CreateLogBridge                    = GameFlag(0x4D5),
    GF_JAN05_BadgeBlock_PowerQuake              = GameFlag(0x4D6),
    GF_JAN05_Bush2_Coin                         = GameFlag(0x4D7),
    GF_JAN06_Item_Coin                          = GameFlag(0x4D8),
    GF_JAN22_Item_JamminJelly                   = GameFlag(0x4D9),
    GF_JAN12_PullVine_Egg2                      = GameFlag(0x4DA),
    GF_JAN14_PullVine_FireFlower                = GameFlag(0x4DB),
    GF_JAN14_PullVine_Mushroom                  = GameFlag(0x4DC),
    GF_JAN18_Item_HappyHeartB                   = GameFlag(0x4DD),
    GF_JAN01_HiddenItem_RepelGel                = GameFlag(0x4DE),
    GF_JAN01_HiddenItem_Mystery                 = GameFlag(0x4DF),
    GF_Unused_JAN_21                            = GameFlag(0x4E0),
    GF_JAN08_HiddenItem_ThunderRage             = GameFlag(0x4E1),
    GF_JAN12_HiddenItem_StoneCap                = GameFlag(0x4E2),
    GF_JAN13_HiddenItem_VoltShroom              = GameFlag(0x4E3),
    GF_JAN01_Tree7_StarPiece                    = GameFlag(0x4E4),
    GF_JAN05_Tree2_Coin                         = GameFlag(0x4E5),
    GF_JAN06_Tree1_Coin                         = GameFlag(0x4E6),
    GF_JAN07_Tree1_Coin                         = GameFlag(0x4E7),
    GF_JAN08_Tree2_Coin                         = GameFlag(0x4E8),
    GF_JAN08_Tree3_Coin                         = GameFlag(0x4E9),
    GF_JAN09_Tree2_Coin                         = GameFlag(0x4EA),
    GF_JAN09_Tree3_FrightJar                    = GameFlag(0x4EB),
    GF_JAN12_Tree1_Coin                         = GameFlag(0x4EC),
    GF_JAN13_Tree1_Coin                         = GameFlag(0x4ED),
    GF_JAN15_Tree2_Coin                         = GameFlag(0x4EE),
    GF_JAN_30                                   = GameFlag(0x4EF),	///< ///< intended for an incorrectly-formatted coin drop for a tree in jan_22
    GF_JAN05_Bush1_Coin                         = GameFlag(0x4F0),
    GF_JAN08_Bush1_Coin                         = GameFlag(0x4F1),
    GF_JAN08_Bush2_Coin                         = GameFlag(0x4F2),
    GF_JAN09_Bush1_Coin                         = GameFlag(0x4F3),
    GF_JAN09_Bush6_Coin                         = GameFlag(0x4F4),
    GF_JAN02_HiddenPanel                        = GameFlag(0x4F5),
    GF_JAN15_HiddenPanel                        = GameFlag(0x4F6),
    GF_JAN13_SolvedBlockPuzzle                  = GameFlag(0x4F7),
    GF_JAN07_YoshiCriedForHelp                  = GameFlag(0x4F8),
    GF_JAN15_EncounteredMiniboss                = GameFlag(0x4F9),
    GF_JAN22_Met_Raven                          = GameFlag(0x4FA), ///< just a normal raven
    GF_JAN03_Gift_MagicalSeed4                  = GameFlag(0x4FB),
    GF_JAN04_Met_Bubulb                         = GameFlag(0x4FC),
    GF_JAN01_Item_CoinB                         = GameFlag(0x4FD),
    GF_JAN08_SuperBlock                         = GameFlag(0x4FE),
    GF_JAN08_Item_CoinA                         = GameFlag(0x4FF),
    GF_JAN08_Item_CoinB                         = GameFlag(0x500),
    GF_JAN08_Item_CoinC                         = GameFlag(0x501),
    GF_JAN10_Item_StarPiece                     = GameFlag(0x502),
    GF_Unused_JAN_44                            = GameFlag(0x503),
    GF_Unused_JAN_45                            = GameFlag(0x504),
    GF_Unused_JAN_46                            = GameFlag(0x505),
    GF_Unused_JAN_47                            = GameFlag(0x506),
    GF_Unused_JAN_48                            = GameFlag(0x507),
    GF_Unused_JAN_49                            = GameFlag(0x508),
    GF_Unused_JAN_4A                            = GameFlag(0x509),
    GF_Unused_JAN_4B                            = GameFlag(0x50A),
    GF_Unused_JAN_4C                            = GameFlag(0x50B),
    GF_Unused_JAN_4D                            = GameFlag(0x50C),
    GF_Unused_JAN_4E                            = GameFlag(0x50D),
    GF_Unused_JAN_4F                            = GameFlag(0x50E),
    GF_Unused_JAN_50                            = GameFlag(0x50F),
    GF_Unused_JAN_51                            = GameFlag(0x510),
    GF_Unused_JAN_52                            = GameFlag(0x511),
    GF_Unused_JAN_53                            = GameFlag(0x512),
    GF_Unused_JAN_54                            = GameFlag(0x513),
    GF_Unused_JAN_55                            = GameFlag(0x514),
    GF_Unused_JAN_56                            = GameFlag(0x515),
    GF_Unused_JAN_57                            = GameFlag(0x516),
    GF_Unused_JAN_58                            = GameFlag(0x517),
    GF_Unused_JAN_59                            = GameFlag(0x518),
    GF_Unused_JAN_5A                            = GameFlag(0x519),
    GF_Unused_JAN_5B                            = GameFlag(0x51A),
    GF_Unused_JAN_5C                            = GameFlag(0x51B),
    GF_Unused_KZN_00                            = GameFlag(0x51C),
    GF_KZN01_IntruderAlert                      = GameFlag(0x51D),
    GF_KZN18_IntruderAlert                      = GameFlag(0x51E),
    GF_KZN06_Visited                            = GameFlag(0x51F),
    GF_KZN06_HiddenItem_LifeShroom              = GameFlag(0x520),
    GF_KZN06_Hammer3Block                       = GameFlag(0x521),
    GF_KZN07_Hammer3Block                       = GameFlag(0x522),
    GF_KZN07_GiantChest                         = GameFlag(0x523),
    GF_KZN17_Hammer3BlockA                      = GameFlag(0x524),
    GF_KZN17_Hammer3BlockB                      = GameFlag(0x525),
    GF_KZN17_Hammer3BlockC                      = GameFlag(0x526),
    GF_KZN17_Hammer3BlockD                      = GameFlag(0x527),
    GF_KZN17_Hammer3BlockE                      = GameFlag(0x528),
    GF_KZN17_Hammer3BlockF                      = GameFlag(0x529),
    GF_KZN17_Hammer3BlockG                      = GameFlag(0x52A),
    GF_Unused_KZN_0F                            = GameFlag(0x52B),
    GF_KZN08_Chest_DizzyStomp                   = GameFlag(0x52C),
    GF_KZN03_SpokeWithKolorado                  = GameFlag(0x52D),
    GF_Unused_KZN_12                            = GameFlag(0x52E),
    GF_KZN19_KoloradoDeadEnd                    = GameFlag(0x52F),
    GF_KZN04_SuperBlock                         = GameFlag(0x530),
    GF_KZN09_SuperBlock                         = GameFlag(0x531),
    GF_KZN03_Item_FireShield                    = GameFlag(0x532),
    GF_KZN03_Item_POWBlock                      = GameFlag(0x533),
    GF_KZN03_ItemBlock_CoinA                    = GameFlag(0x534),
    GF_KZN03_ItemBlock_CoinB                    = GameFlag(0x535),
    GF_KZN03_ItemBlock_CoinC                    = GameFlag(0x536),
    GF_KZN03_ItemBlock_CoinD                    = GameFlag(0x537),
    GF_KZN19_ItemBlock_SuperShroom              = GameFlag(0x538),
    GF_KZN19_ItemBlock_MapleSyrup               = GameFlag(0x539),
    GF_KZN09_HiddenPanel                        = GameFlag(0x53A),
    GF_KZN18_HiddenPanel                        = GameFlag(0x53B),
    GF_Unused_KZN_20                            = GameFlag(0x53C),
    GF_Unused_KZN_21                            = GameFlag(0x53D),
    GF_Unused_KZN_22                            = GameFlag(0x53E),
    GF_Unused_KZN_23                            = GameFlag(0x53F),
    GF_Unused_KZN_24                            = GameFlag(0x540),
    GF_Unused_KZN_25                            = GameFlag(0x541),
    GF_Unused_KZN_26                            = GameFlag(0x542),
    GF_Unused_KZN_27                            = GameFlag(0x543),
    GF_Unused_KZN_28                            = GameFlag(0x544),
    GF_Unused_KZN_29                            = GameFlag(0x545),
    GF_Unused_KZN_2A                            = GameFlag(0x546),
    GF_Unused_KZN_2B                            = GameFlag(0x547),
    GF_Unused_KZN_2C                            = GameFlag(0x548),
    GF_Unused_KZN_2D                            = GameFlag(0x549),
    GF_Unused_KZN_2E                            = GameFlag(0x54A),
    GF_Unused_KZN_2F                            = GameFlag(0x54B),
    GF_Unused_KZN_30                            = GameFlag(0x54C),
    GF_Unused_KZN_31                            = GameFlag(0x54D),
    GF_Unused_KZN_32                            = GameFlag(0x54E),
    GF_Unused_KZN_33                            = GameFlag(0x54F),
    GF_Unused_KZN_34                            = GameFlag(0x550),
    GF_Unused_KZN_35                            = GameFlag(0x551),
    GF_Unused_FLO_00                            = GameFlag(0x552),
    GF_FLO25_GaveRedBerry                       = GameFlag(0x553),
    GF_FLO08_GaveYellowBerry                    = GameFlag(0x554),
    GF_FLO23_GaveBlueBerry                      = GameFlag(0x555),
    GF_FLO03_Defeated_Dayzee                    = GameFlag(0x556),
    GF_FLO03_Defeated_MontyMoleA                = GameFlag(0x557),
    GF_FLO03_Defeated_MontyMoleB                = GameFlag(0x558),
    GF_FLO03_Defeated_MontyMoleC                = GameFlag(0x559),
    GF_FLO03_Defeated_MontyMoleD                = GameFlag(0x55A),
    GF_FLO00_PlacedFertileSoil                  = GameFlag(0x55B),
    GF_FLO00_PlacedMagicalBean                  = GameFlag(0x55C),
    GF_FLO00_Met_Tolielup                       = GameFlag(0x55D),
    GF_FLO07_Item_CrystalBerry                  = GameFlag(0x55E),
    GF_FLO10_LilyRequestedWaterStone            = GameFlag(0x55F),
    GF_FLO10_ShowedLilyTheWaterStone            = GameFlag(0x560),
    GF_FLO11_Defeated_Lakitus                   = GameFlag(0x561),
    GF_FLO12_Met_Rosie                          = GameFlag(0x562),
    GF_FLO12_RosieRequestedSomethingBeautiful   = GameFlag(0x563),
    GF_FLO12_HeldItemPickup                     = GameFlag(0x564),
    GF_FLO08_Item_StarPiece                     = GameFlag(0x565),
    GF_FLO09_Item_HappyFlowerB                  = GameFlag(0x566),
    GF_FLO10_Tree1_JamminJelly                  = GameFlag(0x567),
    GF_FLO11_MultiCoinBrick                     = GameFlag(0x568),
    GF_FLO13_Item_MegaSmash                     = GameFlag(0x569),
    GF_FLO13_Item_ShootingStar                  = GameFlag(0x56A),
    GF_FLO14_Item_StarPiece                     = GameFlag(0x56B),
    GF_FLO16_Item_StarPiece                     = GameFlag(0x56C),
    GF_FLO17_Item_Letter09                      = GameFlag(0x56D),
    GF_FLO17_HiddenItem_ThunderRage             = GameFlag(0x56E),
    GF_FLO19_Item_SJumpChg                      = GameFlag(0x56F),
    GF_FLO22_Item_FlowerSaverB                  = GameFlag(0x570),
    GF_FLO24_ItemBlock_DizzyDial                = GameFlag(0x571),
    GF_FLO24_HiddenItem_MapleSyrup              = GameFlag(0x572),
    GF_FLO22_ThrewBlueBerryDownWell             = GameFlag(0x573),
    GF_FLO07_CrystalBerryFellOnLeftSide         = GameFlag(0x574), ///< item can be spawned on either side of Posie
    GF_Unused_FLO_23                            = GameFlag(0x575),
    GF_Unused_FLO_24                            = GameFlag(0x576),
    GF_Unused_FLO_25                            = GameFlag(0x577),
    GF_Unused_FLO_26                            = GameFlag(0x578),
    GF_FLO15_BombedRock                         = GameFlag(0x579),
    GF_FLO08_SuperBlock                         = GameFlag(0x57A),
    GF_FLO16_SuperBlock                         = GameFlag(0x57B),
    GF_FLO03_HiddenPanel                        = GameFlag(0x57C),
    GF_Unused_FLO_2B                            = GameFlag(0x57D),
    GF_FLO24_HiddenPanel                        = GameFlag(0x57E),
    GF_FLO25_HiddenPanel                        = GameFlag(0x57F),
    GF_FLO23_HiddenItem_Coin                    = GameFlag(0x580),
    GF_FLO23_HiddenItem_ShootingStar            = GameFlag(0x581),
    GF_FLO15_SunThankedPlayer                   = GameFlag(0x582),
    GF_FLO03_DefeatedAll_MontyMoles             = GameFlag(0x583),
    GF_FLO14_GaveBerryToBubblePlant             = GameFlag(0x584),
    GF_Unused_FLO_33                            = GameFlag(0x585),
    GF_Unused_FLO_34                            = GameFlag(0x586),
    GF_Unused_FLO_35                            = GameFlag(0x587),
    GF_Unused_FLO_36                            = GameFlag(0x588),
    GF_Unused_FLO_37                            = GameFlag(0x589),
    GF_Unused_FLO_38                            = GameFlag(0x58A),
    GF_Unused_FLO_39                            = GameFlag(0x58B),
    GF_Unused_FLO_3A                            = GameFlag(0x58C),
    GF_Unused_FLO_3B                            = GameFlag(0x58D),
    GF_Unused_FLO_3C                            = GameFlag(0x58E),
    GF_Unused_FLO_3D                            = GameFlag(0x58F),
    GF_Unused_FLO_3E                            = GameFlag(0x590),
    GF_Unused_FLO_3F                            = GameFlag(0x591),
    GF_Unused_FLO_40                            = GameFlag(0x592),
    GF_Unused_FLO_41                            = GameFlag(0x593),
    GF_Unused_FLO_42                            = GameFlag(0x594),
    GF_Unused_FLO_43                            = GameFlag(0x595),
    GF_Unused_FLO_44                            = GameFlag(0x596),
    GF_SAM04_PlacedScarf                        = GameFlag(0x597),
    GF_SAM04_PlacedBucket                       = GameFlag(0x598),
    GF_SAM12_Item_StarStone                     = GameFlag(0x599),
    GF_SAM01_Met_MayorsWife                     = GameFlag(0x59A),
    GF_SAM01_Chest_AttackFXE                    = GameFlag(0x59B),
    GF_SAM01_HiddenPanel                        = GameFlag(0x59C),
    GF_SAM01_Visited                            = GameFlag(0x59D),
    GF_SAM02_Item_IcedPotato                    = GameFlag(0x59E),
    GF_SAM02_MushroomPresents                   = GameFlag(0x59F),
    GF_SAM02_Item_UltraShroom                   = GameFlag(0x5A0),
    GF_SAM02_Item_MushroomA                     = GameFlag(0x5A1),
    GF_SAM02_Item_MushroomB                     = GameFlag(0x5A2),
    GF_SAM02_Item_MushroomC                     = GameFlag(0x5A3),
    GF_SAM02_Item_MushroomD                     = GameFlag(0x5A4),
    GF_SAM04_HiddenPanel                        = GameFlag(0x5A5),
    GF_SAM04_Item_Letter05                      = GameFlag(0x5A6),
    GF_SAM04_Item_RepelGel                      = GameFlag(0x5A7),
    GF_Unused_SAM_11                            = GameFlag(0x5A8),
    GF_SAM05_Item_Letter06                      = GameFlag(0x5A9),
    GF_SAM05_HiddenItem_StopWatch               = GameFlag(0x5AA),
    GF_SAM06_Merle_HeardLongerMessage           = GameFlag(0x5AB),
    GF_Unused_SAM_15                            = GameFlag(0x5AC),
    GF_SAM06_FoundSidewaysStarKid               = GameFlag(0x5AD),
    GF_SAM07_IceBroken                          = GameFlag(0x5AE),
    GF_SAM07_FloorRaised                        = GameFlag(0x5AF),
    GF_SAM07_HiddenItem_UltraShroom             = GameFlag(0x5B0),
    GF_SAM08_SuperBlock                         = GameFlag(0x5B1),
    GF_Unused_SAM_1B                            = GameFlag(0x5B2),
    GF_Unused_SAM_1C                            = GameFlag(0x5B3),
    GF_SAM09_Visited                            = GameFlag(0x5B4),
    GF_Unused_SAM_1E                            = GameFlag(0x5B5),
    GF_SAM10_BombedWall                         = GameFlag(0x5B6),
    GF_SAM10_BadgeBlock_MegaJump                = GameFlag(0x5B7),
    GF_SAM10_Item_StarPiece                     = GameFlag(0x5B8),
    GF_SAM11_LeftTown                           = GameFlag(0x5B9),
    GF_SAM11_Item_WarehouseKey                  = GameFlag(0x5BA),
    GF_SAM11_UnlockedDoor                       = GameFlag(0x5BB),
    GF_SAM11_LeftHerringwaysHouse               = GameFlag(0x5BC),
    GF_Unused_SAM_26                            = GameFlag(0x5BD),
    GF_Unused_SAM_27                            = GameFlag(0x5BE),
    GF_Unused_SAM_28                            = GameFlag(0x5BF),
    GF_Unused_SAM_29                            = GameFlag(0x5C0),
    GF_Unused_SAM_2A                            = GameFlag(0x5C1),
    GF_Unused_SAM_2B                            = GameFlag(0x5C2),
    GF_Unused_SAM_2C                            = GameFlag(0x5C3),
    GF_Unused_SAM_2D                            = GameFlag(0x5C4),
    GF_Unused_SAM_2E                            = GameFlag(0x5C5),
    GF_Unused_SAM_2F                            = GameFlag(0x5C6),
    GF_Unused_SAM_30                            = GameFlag(0x5C7),
    GF_Unused_SAM_31                            = GameFlag(0x5C8),
    GF_Unused_SAM_32                            = GameFlag(0x5C9),
    GF_Unused_SAM_33                            = GameFlag(0x5CA),
    GF_Unused_SAM_34                            = GameFlag(0x5CB),
    GF_Unused_SAM_35                            = GameFlag(0x5CC),
    GF_Unused_SAM_36                            = GameFlag(0x5CD),
    GF_Unused_SAM_37                            = GameFlag(0x5CE),
    GF_Unused_SAM_38                            = GameFlag(0x5CF),
    GF_Unused_SAM_39                            = GameFlag(0x5D0),
    GF_Unused_SAM_3A                            = GameFlag(0x5D1),
    GF_PRA_BrokeIllusion                        = GameFlag(0x5D2), ///< realised the reflections are fake by bombing wall in pra_13
    GF_PRA02_DoorColorToggle                    = GameFlag(0x5D3), ///< 0 = blue
    GF_PRA11_Chest_RedKey                       = GameFlag(0x5D4),
    GF_PRA05_Chest_BlueKey                      = GameFlag(0x5D5),
    GF_PRA02_Visited                            = GameFlag(0x5D6),
    GF_PRA02_UnlockedRedDoor                    = GameFlag(0x5D7),
    GF_PRA02_UnlockedBlueDoor                   = GameFlag(0x5D8),
    GF_PRA04_BoardedFloor                       = GameFlag(0x5D9),
    GF_PRA04_ItemBlock_SuperShroom              = GameFlag(0x5DA),
    GF_PRA06_Item_ShootingStar                  = GameFlag(0x5DB),
    GF_PRA09_BombedWall                         = GameFlag(0x5DC),
    GF_PRA12_Chest_PDownDUp                     = GameFlag(0x5DD),
    GF_PRA13_BombedWallA                        = GameFlag(0x5DE),
    GF_PRA13_BombedWallB                        = GameFlag(0x5DF),
    GF_PRA14_MultiCoinBrickA                    = GameFlag(0x5E0),
    GF_PRA14_MultiCoinBrickB                    = GameFlag(0x5E1),
    GF_PRA15_Item_StarPiece                     = GameFlag(0x5E2),
    GF_Unused_PRA_11                            = GameFlag(0x5E3),
    GF_Unused_PRA_12                            = GameFlag(0x5E4),
    GF_PRA21_ItemBlock_MapleSyrup               = GameFlag(0x5E5),
    GF_PRA21_HiddenPanel                        = GameFlag(0x5E6),
    GF_PRA22_HiddenItem_JamminJelly             = GameFlag(0x5E7),
    GF_PRA22_HiddenPanel                        = GameFlag(0x5E8),
    GF_PRA27_Chest_PalaceKey                    = GameFlag(0x5E9),
    GF_PRA28_Chest_PUpDDown                     = GameFlag(0x5EA),
    GF_PRA33_Unused                             = GameFlag(0x5EB), ///< set false on map load, not referenced afterward
    GF_PRA33_BombedWall                         = GameFlag(0x5EC),
    GF_PRA35_Chest_TripleDip                    = GameFlag(0x5ED),
    GF_Unused_PRA_1C                            = GameFlag(0x5EE),
    GF_Unused_PRA_1D                            = GameFlag(0x5EF),
    GF_PRA34_UnlockedDoor                       = GameFlag(0x5F0),
    GF_Unused_PRA_1F                            = GameFlag(0x5F1),
    GF_Unused_PRA_20                            = GameFlag(0x5F2),
    GF_Unused_PRA_21                            = GameFlag(0x5F3),
    GF_Unused_PRA_22                            = GameFlag(0x5F4),
    GF_Unused_PRA_23                            = GameFlag(0x5F5),
    GF_Unused_PRA_24                            = GameFlag(0x5F6),
    GF_Unused_PRA_25                            = GameFlag(0x5F7),
    GF_Unused_PRA_26                            = GameFlag(0x5F8),
    GF_Unused_PRA_27                            = GameFlag(0x5F9),
    GF_Unused_PRA_28                            = GameFlag(0x5FA),
    GF_Unused_PRA_29                            = GameFlag(0x5FB),
    GF_Unused_PRA_2A                            = GameFlag(0x5FC),
    GF_Unused_PRA_2B                            = GameFlag(0x5FD),
    GF_Unused_PRA_2C                            = GameFlag(0x5FE),
    GF_Unused_PRA_2D                            = GameFlag(0x5FF),
    GF_Unused_PRA_2E                            = GameFlag(0x600),
    GF_Unused_PRA_2F                            = GameFlag(0x601),
    GF_Unused_PRA_30                            = GameFlag(0x602),
    GF_Unused_PRA_31                            = GameFlag(0x603),
    GF_Unused_PRA_32                            = GameFlag(0x604),
    GF_Unused_PRA_33                            = GameFlag(0x605),
    GF_Unused_PRA_34                            = GameFlag(0x606),
    GF_Unused_PRA_35                            = GameFlag(0x607),
    GF_Unused_PRA_36                            = GameFlag(0x608),
    GF_KPA01_ItemBlock_POWBlock                 = GameFlag(0x609),
    GF_KPA03_ItemBlock_ShootingStar             = GameFlag(0x60A),
    GF_KPA10_ItemBlock_LifeShroom               = GameFlag(0x60B),
    GF_KPA11_Defeated_Guard                     = GameFlag(0x60C),
    GF_KPA11_Item_CastleKey2                    = GameFlag(0x60D),
    GF_KPA13_BlueSwitchA                        = GameFlag(0x60E),
    GF_KPA13_BlueSwitchB                        = GameFlag(0x60F),
    GF_KPA14_UnlockedDoor                       = GameFlag(0x610),
    GF_KPA14_Item_Mystery                       = GameFlag(0x611),
    GF_KPA14_Item_ThunderRage                   = GameFlag(0x612),
    GF_KPA15_Chest_CastleKey2                   = GameFlag(0x613),
    GF_KPA16_ShutOffLava                        = GameFlag(0x614),
    GF_KPA16_Defeated_SwitchGuards              = GameFlag(0x615),
    GF_KPA17_BombedWall                         = GameFlag(0x616),
    GF_KPA17_Crate_TastyTonic                   = GameFlag(0x617),
    GF_KPA17_Crate_LifeShroom                   = GameFlag(0x618),
    GF_KPA52_UnlockedDoor                       = GameFlag(0x619),
    GF_KPA53_Met_PeachImposter                  = GameFlag(0x61A),
    GF_KPA53_Defeated_PeachImposter             = GameFlag(0x61B),
    GF_KPA62_UnlockedFrontDoor                  = GameFlag(0x61C),
    GF_KPA62_BadgeBlock_DeepFocus3              = GameFlag(0x61D),
    GF_Unused_KPA_15                            = GameFlag(0x61E),
    GF_KPA61_ItemBlock_SuperShroomA             = GameFlag(0x61F),
    GF_KPA61_ItemBlock_MapleSyrup               = GameFlag(0x620),
    GF_KPA61_ItemBlock_SuperShroomB             = GameFlag(0x621),
    GF_KPA61_Item_JamminJelly                   = GameFlag(0x622),
    GF_KPA82_PassedThroughDoor                  = GameFlag(0x623), ///< not really used, GB_KPA82_BowserDoorState does the real work
    GF_KPA82_SpokeToDoor                        = GameFlag(0x624),
    GF_KPA91_UnlockedDoor                       = GameFlag(0x625),
    GF_KPA91_Defeated_Guard                     = GameFlag(0x626),
    GF_KPA91_Item_PrisonKey1                    = GameFlag(0x627),
    GF_KPA95_UnlockedDoor                       = GameFlag(0x628),
    GF_KPA95_Defeated_Guard                     = GameFlag(0x629),
    GF_KPA95_Item_PrisonKey1                    = GameFlag(0x62A),
    GF_KPA100_Item_CastleKey2                   = GameFlag(0x62B),
    GF_KPA101_Item_UltraShroom                  = GameFlag(0x62C),
    GF_KPA111_ItemBlock_SuperShroom             = GameFlag(0x62D),
    GF_KPA111_HiddenItem_MapleSyrup             = GameFlag(0x62E),
    GF_KPA113_UnlockedDoor                      = GameFlag(0x62F),
    GF_KPA119_Item_CastleKey2                   = GameFlag(0x630),
    GF_KPA133_Item_BombedWall                   = GameFlag(0x631),
    GF_KPA133_Item_CastleKey2                   = GameFlag(0x632),
    GF_KPA133_BlueSwitch                        = GameFlag(0x633),
    GF_Unused_KPA_2B                            = GameFlag(0x634),
    GF_KPA134_UnlockedDoor                      = GameFlag(0x635),
    GF_KPA134_BlueSwitch                        = GameFlag(0x636),
    GF_KPA134_HiddenItem_MapleSyrup             = GameFlag(0x637),
    GF_Unused_KPA_2F                            = GameFlag(0x638),
    GF_Unused_KPA_30                            = GameFlag(0x639),
    GF_Unused_KPA_31                            = GameFlag(0x63A),
    GF_Unused_KPA_32                            = GameFlag(0x63B),
    GF_Unused_KPA_33                            = GameFlag(0x63C),
    GF_Unused_KPA_34                            = GameFlag(0x63D),
    GF_Unused_KPA_35                            = GameFlag(0x63E),
    GF_Unused_KPA_36                            = GameFlag(0x63F),
    GF_Unused_KPA_37                            = GameFlag(0x640),
    GF_Unused_KPA_38                            = GameFlag(0x641),
    GF_Unused_KPA_39                            = GameFlag(0x642),
    GF_Unused_KPA_3A                            = GameFlag(0x643),
    GF_Unused_KPA_3B                            = GameFlag(0x644),
    GF_Unused_KPA_3C                            = GameFlag(0x645),
    GF_Unused_KPA_3D                            = GameFlag(0x646),
    GF_Unused_KPA_3E                            = GameFlag(0x647),
    GF_Unused_KPA_3F                            = GameFlag(0x648),
    GF_Unused_KPA_40                            = GameFlag(0x649),
    GF_Unused_KPA_41                            = GameFlag(0x64A),
    GF_Unused_KPA_42                            = GameFlag(0x64B),
    GF_Unused_KPA_43                            = GameFlag(0x64C),
    GF_Unused_KPA_44                            = GameFlag(0x64D),
    GF_Unused_KPA_45                            = GameFlag(0x64E),
    GF_Unused_KPA_46                            = GameFlag(0x64F),
    GF_Unused_KPA_47                            = GameFlag(0x650),
    GF_Unused_KPA_48                            = GameFlag(0x651),
    GF_Unused_KPA_49                            = GameFlag(0x652),
    GF_Unused_KPA_4A                            = GameFlag(0x653),
    GF_Unused_KPA_4B                            = GameFlag(0x654),
    GF_Unused_KPA_4C                            = GameFlag(0x655),
    GF_Unused_END_00                            = GameFlag(0x656),
    GF_Unused_END_01                            = GameFlag(0x657),
    GF_Unused_END_02                            = GameFlag(0x658),
    GF_Unused_END_03                            = GameFlag(0x659),
    GF_Unused_END_04                            = GameFlag(0x65A),
    GF_Unused_END_05                            = GameFlag(0x65B),
    GF_Unused_END_06                            = GameFlag(0x65C),
    GF_Unused_END_07                            = GameFlag(0x65D),
    GF_Unused_END_08                            = GameFlag(0x65E),
    GF_Unused_END_09                            = GameFlag(0x65F),
    GF_Unused_END_0A                            = GameFlag(0x660),
    GF_Unused_END_0B                            = GameFlag(0x661),
    GF_Unused_END_0C                            = GameFlag(0x662),
    GF_Unused_END_0D                            = GameFlag(0x663),
    GF_Unused_END_0E                            = GameFlag(0x664),
    GF_Unused_END_0F                            = GameFlag(0x665),
    GF_Unused_END_10                            = GameFlag(0x666),
    GF_Unused_END_11                            = GameFlag(0x667),
    GF_Unused_END_12                            = GameFlag(0x668),
    GF_Unused_END_13                            = GameFlag(0x669),
    GF_Unused_END_14                            = GameFlag(0x66A),
    GF_OSR02_HiddenItem_UltraShroom             = GameFlag(0x66B),
    GF_Unused_OSR_01                            = GameFlag(0x66C),
    GF_Unused_OSR_02                            = GameFlag(0x66D),
    GF_Unused_OSR_03                            = GameFlag(0x66E),
    GF_Unused_OSR_04                            = GameFlag(0x66F),
    GF_Unused_OSR_05                            = GameFlag(0x670),
    GF_Unused_OSR_06                            = GameFlag(0x671),
    GF_Unused_OSR_07                            = GameFlag(0x672),
    GF_Unused_OSR_08                            = GameFlag(0x673),
    GF_Unused_OSR_09                            = GameFlag(0x674),
    GF_Unused_OSR_0A                            = GameFlag(0x675),
    GF_Unused_OSR_0B                            = GameFlag(0x676),
    GF_Unused_OSR_0C                            = GameFlag(0x677),
    GF_Unused_OSR_0D                            = GameFlag(0x678),
    GF_Unused_OSR_0E                            = GameFlag(0x679),
    GF_Unused_OSR_0F                            = GameFlag(0x67A),
    GF_Unused_OSR_10                            = GameFlag(0x67B),
    GF_Unused_OSR_11                            = GameFlag(0x67C),
    GF_Unused_OSR_12                            = GameFlag(0x67D),
    GF_Unused_OSR_13                            = GameFlag(0x67E),
    GF_Unused_OSR_14                            = GameFlag(0x67F),
    GF_MAC01_RowfBadge_00                       = GameFlag(0x680),
    GF_MAC01_RowfBadge_01                       = GameFlag(0x681),
    GF_MAC01_RowfBadge_02                       = GameFlag(0x682),
    GF_MAC01_RowfBadge_03                       = GameFlag(0x683),
    GF_MAC01_RowfBadge_04                       = GameFlag(0x684),
    GF_MAC01_RowfBadge_05                       = GameFlag(0x685),
    GF_MAC01_RowfBadge_06                       = GameFlag(0x686),
    GF_MAC01_RowfBadge_07                       = GameFlag(0x687),
    GF_MAC01_RowfBadge_08                       = GameFlag(0x688),
    GF_MAC01_RowfBadge_09                       = GameFlag(0x689),
    GF_MAC01_RowfBadge_0A                       = GameFlag(0x68A),
    GF_MAC01_RowfBadge_0B                       = GameFlag(0x68B),
    GF_MAC01_RowfBadge_0C                       = GameFlag(0x68C),
    GF_MAC01_RowfBadge_0D                       = GameFlag(0x68D),
    GF_MAC01_RowfBadge_0E                       = GameFlag(0x68E),
    GF_MAC01_RowfBadge_0F                       = GameFlag(0x68F),
    GF_Unused_BAT_10                            = GameFlag(0x690),
    GF_Unused_BAT_11                            = GameFlag(0x691),
    GF_Unused_BAT_12                            = GameFlag(0x692),
    GF_Unused_BAT_13                            = GameFlag(0x693),
    GF_ISK02_Item_SpikeShield                   = GameFlag(0x694),
    GF_Unused_BAT_15                            = GameFlag(0x695),
    GF_Unused_BAT_16                            = GameFlag(0x696),
    GF_Unused_BAT_17                            = GameFlag(0x697),
    GF_Unused_BAT_18                            = GameFlag(0x698),
    GF_Unused_BAT_19                            = GameFlag(0x699),
    GF_Unused_BAT_1A                            = GameFlag(0x69A),
    GF_Unused_BAT_1B                            = GameFlag(0x69B),
    GF_Unused_BAT_1C                            = GameFlag(0x69C),
    GF_Unused_BAT_1D                            = GameFlag(0x69D),
    GF_Unused_BAT_1E                            = GameFlag(0x69E),
    GF_Unused_BAT_1F                            = GameFlag(0x69F),
    GF_Unused_BAT_20                            = GameFlag(0x6A0),
    GF_Unused_BAT_21                            = GameFlag(0x6A1),
    GF_Unused_BAT_22                            = GameFlag(0x6A2),
    GF_Unused_BAT_23                            = GameFlag(0x6A3),
    GF_Unused_BAT_24                            = GameFlag(0x6A4),
    GF_Unused_BAT_25                            = GameFlag(0x6A5),
    GF_Unused_BAT_26                            = GameFlag(0x6A6),
    GF_Unused_BAT_27                            = GameFlag(0x6A7),
    GF_KootFavor_LeftKoopaVillage               = GameFlag(0x6A8), ///< set when leaving toward nok_13 or nok_03, but not the warp pipe
    GF_KootFavor_LeftKoopaArea                  = GameFlag(0x6A9), ///< only set when leaving nok_11 toward mac_01, unlocks the ability to give up on the current favor
    GF_MAC02_KootFavor_CurrentComplete          = GameFlag(0x6AA),
    GF_NOK02_KootFavor00_Unlocked               = GameFlag(0x6AB),
    GF_NOK02_KootFavor00_GaveUp                 = GameFlag(0x6AC),
    GF_NOK02_KootFavor00_Complete               = GameFlag(0x6AD),
    GF_NOK02_KootFavor01_Unlocked               = GameFlag(0x6AE),
    GF_NOK02_KootFavor01_GaveUp                 = GameFlag(0x6AF),
    GF_NOK02_KootFavor01_Complete               = GameFlag(0x6B0),
    GF_NOK02_KootFavor02_Unlocked               = GameFlag(0x6B1),
    GF_NOK02_KootFavor02_GaveUp                 = GameFlag(0x6B2),
    GF_NOK02_KootFavor02_Complete               = GameFlag(0x6B3),
    GF_NOK02_KootFavor03_Unlocked               = GameFlag(0x6B4),
    GF_NOK02_KootFavor03_GaveUp                 = GameFlag(0x6B5),
    GF_NOK02_KootFavor03_Complete               = GameFlag(0x6B6),
    GF_NOK02_KootFavor04_Unlocked               = GameFlag(0x6B7),
    GF_NOK02_KootFavor04_GaveUp                 = GameFlag(0x6B8),
    GF_NOK02_KootFavor04_Complete               = GameFlag(0x6B9),
    GF_NOK02_KootFavor05_Unlocked               = GameFlag(0x6BA),
    GF_NOK02_KootFavor05_GaveUp                 = GameFlag(0x6BB),
    GF_NOK02_KootFavor05_Complete               = GameFlag(0x6BC),
    GF_NOK02_KootFavor06_Unlocked               = GameFlag(0x6BD),
    GF_NOK02_KootFavor06_GaveUp                 = GameFlag(0x6BE),
    GF_NOK02_KootFavor06_Complete               = GameFlag(0x6BF),
    GF_NOK02_KootFavor07_Unlocked               = GameFlag(0x6C0),
    GF_NOK02_KootFavor07_GaveUp                 = GameFlag(0x6C1),
    GF_NOK02_KootFavor07_Complete               = GameFlag(0x6C2),
    GF_NOK02_KootFavor08_Unlocked               = GameFlag(0x6C3),
    GF_NOK02_KootFavor08_GaveUp                 = GameFlag(0x6C4),
    GF_NOK02_KootFavor08_Complete               = GameFlag(0x6C5),
    GF_NOK02_KootFavor09_Unlocked               = GameFlag(0x6C6),
    GF_NOK02_KootFavor09_GaveUp                 = GameFlag(0x6C7),
    GF_NOK02_KootFavor09_Complete               = GameFlag(0x6C8),
    GF_NOK02_KootFavor0A_Unlocked               = GameFlag(0x6C9),
    GF_NOK02_KootFavor0A_GaveUp                 = GameFlag(0x6CA),
    GF_NOK02_KootFavor0A_Complete               = GameFlag(0x6CB),
    GF_NOK02_KootFavor0B_Unlocked               = GameFlag(0x6CC),
    GF_NOK02_KootFavor0B_GaveUp                 = GameFlag(0x6CD),
    GF_NOK02_KootFavor0B_Complete               = GameFlag(0x6CE),
    GF_NOK02_KootFavor0C_Unlocked               = GameFlag(0x6CF),
    GF_NOK02_KootFavor0C_GaveUp                 = GameFlag(0x6D0),
    GF_NOK02_KootFavor0C_Complete               = GameFlag(0x6D1),
    GF_NOK02_KootFavor0D_Unlocked               = GameFlag(0x6D2),
    GF_NOK02_KootFavor0D_GaveUp                 = GameFlag(0x6D3),
    GF_NOK02_KootFavor0D_Complete               = GameFlag(0x6D4),
    GF_NOK02_KootFavor0E_Unlocked               = GameFlag(0x6D5),
    GF_NOK02_KootFavor0E_GaveUp                 = GameFlag(0x6D6),
    GF_NOK02_KootFavor0E_Complete               = GameFlag(0x6D7),
    GF_NOK02_KootFavor0F_Unlocked               = GameFlag(0x6D8),
    GF_NOK02_KootFavor0F_GaveUp                 = GameFlag(0x6D9),
    GF_NOK02_KootFavor0F_Complete               = GameFlag(0x6DA),
    GF_NOK02_KootFavor10_Unlocked               = GameFlag(0x6DB),
    GF_NOK02_KootFavor10_GaveUp                 = GameFlag(0x6DC),
    GF_NOK02_KootFavor10_Complete               = GameFlag(0x6DD),
    GF_NOK02_KootFavor11_Unlocked               = GameFlag(0x6DE),
    GF_NOK02_KootFavor11_GaveUp                 = GameFlag(0x6DF),
    GF_NOK02_KootFavor11_Complete               = GameFlag(0x6E0),
    GF_NOK02_KootFavor12_Unlocked               = GameFlag(0x6E1),
    GF_NOK02_KootFavor12_GaveUp                 = GameFlag(0x6E2),
    GF_NOK02_KootFavor12_Complete               = GameFlag(0x6E3),
    GF_NOK02_KootFavor13_Unlocked               = GameFlag(0x6E4),
    GF_NOK02_KootFavor13_GaveUp                 = GameFlag(0x6E5),
    GF_NOK02_KootFavor13_Complete               = GameFlag(0x6E6),
    GF_Met_ChuckQuizmo                          = GameFlag(0x6E7),
    GF_Quizmo_HasLocation                       = GameFlag(0x6E8),
    GF_Quizmo_ChangedLocation                   = GameFlag(0x6E9),
    GF_HOS06_Met_Merlow                         = GameFlag(0x6EA),
    GF_HOS06_MerlowBadge_00                     = GameFlag(0x6EB),
    GF_HOS06_MerlowBadge_01                     = GameFlag(0x6EC),
    GF_HOS06_MerlowBadge_02                     = GameFlag(0x6ED),
    GF_HOS06_MerlowBadge_03                     = GameFlag(0x6EE),
    GF_HOS06_MerlowBadge_04                     = GameFlag(0x6EF),
    GF_HOS06_MerlowBadge_05                     = GameFlag(0x6F0),
    GF_HOS06_MerlowBadge_06                     = GameFlag(0x6F1),
    GF_HOS06_MerlowBadge_07                     = GameFlag(0x6F2),
    GF_HOS06_MerlowBadge_08                     = GameFlag(0x6F3),
    GF_HOS06_MerlowBadge_09                     = GameFlag(0x6F4),
    GF_HOS06_MerlowBadge_0A                     = GameFlag(0x6F5),
    GF_HOS06_MerlowBadge_0B                     = GameFlag(0x6F6),
    GF_HOS06_MerlowBadge_0C                     = GameFlag(0x6F7),
    GF_HOS06_MerlowBadge_0D                     = GameFlag(0x6F8),
    GF_HOS06_MerlowBadge_0E                     = GameFlag(0x6F9),
    GF_Unused_NPC_52                            = GameFlag(0x6FA), ///< presumably for Merlow's 16th badge
    GF_TradingEvent1_Active                     = GameFlag(0x6FB),
    GF_TradingEvent2_Active                     = GameFlag(0x6FC),
    GF_TradingEvent3_Active                     = GameFlag(0x6FD),
    GF_NOK02_KootFavor14_Unlocked               = GameFlag(0x6FE),
    GF_Unused_NPC_57                            = GameFlag(0x6FF), ///< would be GF_NOK02_KootFavor14_GaveUp, but you cant really give up this one
    GF_Unused_NPC_58                            = GameFlag(0x700), ///< would be GF_NOK02_KootFavor14_Complete, but you cant really complete this one
    GF_Quizmo_TakingQuiz                        = GameFlag(0x701),
    GF_Unused_NPC_5A                            = GameFlag(0x702),
    GF_Unused_NPC_5B                            = GameFlag(0x703),
    GF_Unused_NPC_5C                            = GameFlag(0x704),
    GF_Unused_NPC_5D                            = GameFlag(0x705),
    GF_Unused_NPC_5E                            = GameFlag(0x706),
    GF_Unused_NPC_5F                            = GameFlag(0x707),
    GF_Unused_NPC_60                            = GameFlag(0x708),
    GF_Unused_NPC_61                            = GameFlag(0x709),
    GF_Unused_NPC_62                            = GameFlag(0x70A),
    GF_Unused_NPC_63                            = GameFlag(0x70B),
    GF_Unused_NPC_64                            = GameFlag(0x70C),
    GF_Unused_NPC_65                            = GameFlag(0x70D),
    GF_Unused_NPC_66                            = GameFlag(0x70E),
    GF_Unused_NPC_67                            = GameFlag(0x70F),
    GF_Unused_NPC_68                            = GameFlag(0x710),
    GF_Unused_NPC_69                            = GameFlag(0x711),
    GF_Unused_NPC_6A                            = GameFlag(0x712),
    GF_Unused_NPC_6B                            = GameFlag(0x713),
    GF_Unused_NPC_6C                            = GameFlag(0x714),
    GF_SpawnedItemDrop_00                       = GameFlag(0x715), ///< comes from the third u16 in the selected item entry for enemy's drop table
    GF_Unused_BTL_01                            = GameFlag(0x716), ///< presumably for GF_SpawnedItemDrop_01
    GF_Unused_BTL_02                            = GameFlag(0x717), ///< presumably for GF_SpawnedItemDrop_02
    GF_Unused_BTL_03                            = GameFlag(0x718), ///< presumably for GF_SpawnedItemDrop_03
    GF_Tutorial_SwapTurnOrder                   = GameFlag(0x719),
    GF_Tutorial_SpikyEnemy                      = GameFlag(0x71A),
    GF_Tutorial_FlyingEnemy                     = GameFlag(0x71B),
    GF_Unused_BTL_07                            = GameFlag(0x71C),
    GF_Unused_BTL_08                            = GameFlag(0x71D),
    GF_Unused_BTL_09                            = GameFlag(0x71E),
    GF_Unused_BTL_0A                            = GameFlag(0x71F),
    GF_Unused_BTL_0B                            = GameFlag(0x720),
    GF_Unused_BTL_0C                            = GameFlag(0x721),
    GF_Unused_BTL_0D                            = GameFlag(0x722),
    GF_Unused_BTL_0E                            = GameFlag(0x723),
    GF_Unused_BTL_0F                            = GameFlag(0x724),
    GF_Unused_BTL_10                            = GameFlag(0x725),
    GF_Unused_BTL_11                            = GameFlag(0x726),
    GF_Unused_BTL_12                            = GameFlag(0x727),
    GF_Unused_BTL_13                            = GameFlag(0x728),
    GF_Unused_BTL_14                            = GameFlag(0x729),
    GF_Unused_BTL_15                            = GameFlag(0x72A),
    GF_Unused_BTL_16                            = GameFlag(0x72B),
    GF_Unused_BTL_17                            = GameFlag(0x72C),
    GF_Unused_BTL_18                            = GameFlag(0x72D),
    GF_FBTL_00                                  = GameFlag(0x72E),
    GF_FBTL_01                                  = GameFlag(0x72F),
    GF_FBTL_02                                  = GameFlag(0x730),
    GF_FBTL_03                                  = GameFlag(0x731),
    GF_FBTL_04                                  = GameFlag(0x732),
    GF_FBTL_05                                  = GameFlag(0x733),
    GF_FBTL_06                                  = GameFlag(0x734),
    GF_FBTL_07                                  = GameFlag(0x735),
    GF_FBTL_08                                  = GameFlag(0x736),
    GF_FBTL_09                                  = GameFlag(0x737),
    GF_FBTL_0A                                  = GameFlag(0x738),
    GF_FBTL_0B                                  = GameFlag(0x739),
    GF_FBTL_0C                                  = GameFlag(0x73A),
    GF_FBTL_0D                                  = GameFlag(0x73B),
    GF_FBTL_0E                                  = GameFlag(0x73C),
    GF_FBTL_0F                                  = GameFlag(0x73D),
    GF_FBTL_10                                  = GameFlag(0x73E),
    GF_FBTL_11                                  = GameFlag(0x73F),
    GF_FBTL_12                                  = GameFlag(0x740),
    GF_FBTL_13                                  = GameFlag(0x741),
    GF_FBTL_14                                  = GameFlag(0x742),
    GF_FBTL_15                                  = GameFlag(0x743),
    GF_FBTL_16                                  = GameFlag(0x744),
    GF_FBTL_17                                  = GameFlag(0x745),
    GF_FBTL_18                                  = GameFlag(0x746),
    GF_FBTL_19                                  = GameFlag(0x747),
    GF_FBTL_1A                                  = GameFlag(0x748),
    GF_FBTL_1B                                  = GameFlag(0x749),
    GF_FBTL_1C                                  = GameFlag(0x74A),
    GF_FBTL_1D                                  = GameFlag(0x74B),
    GF_FBTL_1E                                  = GameFlag(0x74C),
    GF_FBTL_1F                                  = GameFlag(0x74D),
    GF_FBTL_20                                  = GameFlag(0x74E),
    GF_FBTL_21                                  = GameFlag(0x74F),
    GF_FBTL_22                                  = GameFlag(0x750),
    GF_FBTL_23                                  = GameFlag(0x751),
    GF_FBTL_24                                  = GameFlag(0x752),
    GF_FBTL_25                                  = GameFlag(0x753),
    GF_FBTL_26                                  = GameFlag(0x754),
    GF_FBTL_27                                  = GameFlag(0x755),
    GF_FBTL_28                                  = GameFlag(0x756),
    GF_FBTL_29                                  = GameFlag(0x757),
    GF_FBTL_2A                                  = GameFlag(0x758),
    GF_FBTL_2B                                  = GameFlag(0x759),
    GF_FBTL_2C                                  = GameFlag(0x75A),
    GF_FBTL_2D                                  = GameFlag(0x75B),
    GF_FBTL_2E                                  = GameFlag(0x75C),
    GF_FBTL_2F                                  = GameFlag(0x75D),
    GF_FBTL_30                                  = GameFlag(0x75E),
    GF_FBTL_31                                  = GameFlag(0x75F),
    GF_FBTL_32                                  = GameFlag(0x760),
    GF_FBTL_33                                  = GameFlag(0x761),
    GF_FBTL_34                                  = GameFlag(0x762),
    GF_FBTL_35                                  = GameFlag(0x763),
    GF_FBTL_36                                  = GameFlag(0x764),
    GF_FBTL_37                                  = GameFlag(0x765),
    GF_FBTL_38                                  = GameFlag(0x766),
    GF_FBTL_39                                  = GameFlag(0x767),
    GF_FBTL_3A                                  = GameFlag(0x768),
    GF_FBTL_3B                                  = GameFlag(0x769),
    GF_FBTL_3C                                  = GameFlag(0x76A),
    GF_FBTL_3D                                  = GameFlag(0x76B),
    GF_FBTL_3E                                  = GameFlag(0x76C),
    GF_FBTL_3F                                  = GameFlag(0x76D),
    GF_FBTL_40                                  = GameFlag(0x76E),
    GF_FBTL_41                                  = GameFlag(0x76F),
    GF_FBTL_42                                  = GameFlag(0x770),
    GF_FBTL_43                                  = GameFlag(0x771),
    GF_FBTL_44                                  = GameFlag(0x772),
    GF_FBTL_45                                  = GameFlag(0x773),
    GF_FBTL_46                                  = GameFlag(0x774),
    GF_FBTL_47                                  = GameFlag(0x775),
    GF_FBTL_48                                  = GameFlag(0x776),
    GF_FBTL_49                                  = GameFlag(0x777),
    GF_FBTL_4A                                  = GameFlag(0x778),
    GF_Unused_FBTL_4B                           = GameFlag(0x779),
    GF_Unused_FBTL_4C                           = GameFlag(0x77A),
    GF_Unused_FBTL_4D                           = GameFlag(0x77B),
    GF_Unused_FBTL_4E                           = GameFlag(0x77C),
    GF_Unused_FBTL_4F                           = GameFlag(0x77D),
    GF_Unused_FBTL_50                           = GameFlag(0x77E),
    GF_Unused_FBTL_51                           = GameFlag(0x77F),
    GF_Unused_FBTL_52                           = GameFlag(0x780),
    GF_Unused_FBTL_53                           = GameFlag(0x781),
    GF_Unused_FBTL_54                           = GameFlag(0x782),
    GF_Unused_FBTL_55                           = GameFlag(0x783),
    GF_Unused_FBTL_56                           = GameFlag(0x784),
    GF_Unused_FBTL_57                           = GameFlag(0x785),
    GF_Unused_FBTL_58                           = GameFlag(0x786),
    GF_Unused_FBTL_59                           = GameFlag(0x787),
    GF_Unused_FBTL_5A                           = GameFlag(0x788),
    GF_Unused_FBTL_5B                           = GameFlag(0x789),
    GF_Unused_FBTL_5C                           = GameFlag(0x78A),
    GF_Unused_FBTL_5D                           = GameFlag(0x78B),
    GF_Unused_FBTL_5E                           = GameFlag(0x78C),
    GF_TIK01_WarpPipes                          = GameFlag(0x78D), ///< to Goomba Village, Koopa Village, Dry Dry Outpost
    GF_TIK08_WarpPipe                           = GameFlag(0x78E), ///< to Yoshi Village
    GF_TIK09_WarpPipe                           = GameFlag(0x78F), ///< to Boo's Mansion
    GF_Unused_DOKAN_03                          = GameFlag(0x790),
    GF_KMR02_WarpPipe                           = GameFlag(0x791), ///< from Goomba Village
    GF_NOK02_WarpPipe                           = GameFlag(0x792), ///< from Koopa Village
    GF_DRO01_WarpPipe                           = GameFlag(0x793), ///< from Dry Dry Outpost
    GF_MIM11_WarpPipe                           = GameFlag(0x794), ///< from Boo's Mansion
    GF_JAN03_WarpPipe                           = GameFlag(0x795), ///< from Yoshi Village
    GF_Unused_DOKAN_09                          = GameFlag(0x796),
    GF_Unused_DOKAN_0A                          = GameFlag(0x797),
    GF_Unused_DOKAN_0B                          = GameFlag(0x798),
    GF_Unused_DOKAN_0C                          = GameFlag(0x799),
    GF_Unused_DOKAN_0D                          = GameFlag(0x79A),
    GF_Unused_DOKAN_0E                          = GameFlag(0x79B),
    GF_Unused_DOKAN_0F                          = GameFlag(0x79C),
    GF_Unused_DOKAN_10                          = GameFlag(0x79D),
    GF_Unused_DOKAN_11                          = GameFlag(0x79E),
    GF_Unused_DOKAN_12                          = GameFlag(0x79F),
    GF_Unused_DOKAN_13                          = GameFlag(0x7A0),
    GF_Unused_DOKAN_14                          = GameFlag(0x7A1),
    GF_Unused_DOKAN_15                          = GameFlag(0x7A2),
    GF_Unused_DOKAN_16                          = GameFlag(0x7A3),
    GF_Unused_DOKAN_17                          = GameFlag(0x7A4),
    GF_Unused_DOKAN_18                          = GameFlag(0x7A5),
    GF_Unused_DOKAN_19                          = GameFlag(0x7A6),
    GF_Unused_DOKAN_1A                          = GameFlag(0x7A7),
    GF_Unused_DOKAN_1B                          = GameFlag(0x7A8),
    GF_Unused_DOKAN_1C                          = GameFlag(0x7A9),
    GF_MAP_ToadTown                             = GameFlag(0x7AA),
    GF_MAP_PeachCastleGrounds                   = GameFlag(0x7AB),
    GF_MAP_ShootingStarSummit                   = GameFlag(0x7AC),
    GF_MAP_ToadTownTunnels                      = GameFlag(0x7AD),
    GF_MAP_GoombaVillage                        = GameFlag(0x7AE),
    GF_MAP_GoombaRoad                           = GameFlag(0x7AF),
    GF_MAP_PleasantPath                         = GameFlag(0x7B0),
    GF_MAP_KoopaVillage                         = GameFlag(0x7B1),
    GF_MAP_KoopaBrosFortress                    = GameFlag(0x7B2),
    GF_MAP_MtRugged                             = GameFlag(0x7B3),
    GF_MAP_DryDryDesert                         = GameFlag(0x7B4),
    GF_MAP_DryDryOutpost                        = GameFlag(0x7B5),
    GF_MAP_DryDryRuins                          = GameFlag(0x7B6),
    GF_MAP_ForeverForest                        = GameFlag(0x7B7),
    GF_MAP_BoosMansion                          = GameFlag(0x7B8),
    GF_MAP_GustyGulch                           = GameFlag(0x7B9),
    GF_MAP_TubbasManor                          = GameFlag(0x7BA),
    GF_MAP_WindyMill                            = GameFlag(0x7BB),
    GF_MAP_ShyGuysToybox                        = GameFlag(0x7BC),
    GF_MAP_JadeJungle                           = GameFlag(0x7BD),
    GF_MAP_YoshisVillage                        = GameFlag(0x7BE),
    GF_MAP_MtLavalava                           = GameFlag(0x7BF),
    GF_MAP_FlowerFields                         = GameFlag(0x7C0),
    GF_MAP_CloudyClimb                          = GameFlag(0x7C1),
    GF_MAP_ShiverCity                           = GameFlag(0x7C2),
    GF_MAP_ShiverSnowfield                      = GameFlag(0x7C3),
    GF_MAP_StarbornValley                       = GameFlag(0x7C4),
    GF_MAP_ShiverMountain                       = GameFlag(0x7C5),
    GF_MAP_CrystalPalace                        = GameFlag(0x7C6),
    GF_MAP_StarWay                              = GameFlag(0x7C7),
    GF_MAP_StarHaven                            = GameFlag(0x7C8),
    GF_MAP_BowsersCastle                        = GameFlag(0x7C9),
    GF_MAP_PeachsCastle                         = GameFlag(0x7CA),
    GF_MAP_MariosHouse                          = GameFlag(0x7CB),
    GF_Unused_MAP_22                            = GameFlag(0x7CC),
    GF_Unused_MAP_23                            = GameFlag(0x7CD),
    GF_Unused_MAP_24                            = GameFlag(0x7CE),
    GF_Unused_MAP_25                            = GameFlag(0x7CF),
    GF_Unused_MAP_26                            = GameFlag(0x7D0),
    GF_Unused_MAP_27                            = GameFlag(0x7D1),
    GF_Unused_MAP_28                            = GameFlag(0x7D2),
    GF_Unused_MAP_29                            = GameFlag(0x7D3),
    GF_Unused_MAP_2A                            = GameFlag(0x7D4),
    GF_Unused_MAP_2B                            = GameFlag(0x7D5),
    GF_Unused_MAP_2C                            = GameFlag(0x7D6),
    GF_Unused_MAP_2D                            = GameFlag(0x7D7),
    GF_Unused_MAP_2E                            = GameFlag(0x7D8),
    GF_Unused_MAP_2F                            = GameFlag(0x7D9),
    GF_Unused_MAP_30                            = GameFlag(0x7DA),
    GF_Unused_MAP_31                            = GameFlag(0x7DB),
    GF_Unused_MAP_32                            = GameFlag(0x7DC),
    GF_Unused_MAP_33                            = GameFlag(0x7DD),
    GF_Unused_MAP_34                            = GameFlag(0x7DE),
    GF_Unused_MAP_35                            = GameFlag(0x7DF),
    GF_Unused_7E0                               = GameFlag(0x7E0),
    GF_Unused_7E1                               = GameFlag(0x7E1),
    GF_Unused_7E2                               = GameFlag(0x7E2),
    GF_Unused_7E3                               = GameFlag(0x7E3),
    GF_Unused_7E4                               = GameFlag(0x7E4),
    GF_Unused_7E5                               = GameFlag(0x7E5),
    GF_Unused_7E6                               = GameFlag(0x7E6),
    GF_Unused_7E7                               = GameFlag(0x7E7),
    GF_Unused_7E8                               = GameFlag(0x7E8),
    GF_Unused_7E9                               = GameFlag(0x7E9),
    GF_Unused_7EA                               = GameFlag(0x7EA),
    GF_Unused_7EB                               = GameFlag(0x7EB),
    GF_Unused_7EC                               = GameFlag(0x7EC),
    GF_Unused_7ED                               = GameFlag(0x7ED),
    GF_Unused_7EE                               = GameFlag(0x7EE),
    GF_Unused_7EF                               = GameFlag(0x7EF),
    GF_Unused_7F0                               = GameFlag(0x7F0),
    GF_Unused_7F1                               = GameFlag(0x7F1),
    GF_Unused_7F2                               = GameFlag(0x7F2),
    GF_Unused_7F3                               = GameFlag(0x7F3),
    GF_Unused_7F4                               = GameFlag(0x7F4),
    GF_Unused_7F5                               = GameFlag(0x7F5),
    GF_Unused_7F6                               = GameFlag(0x7F6),
    GF_Unused_7F7                               = GameFlag(0x7F7),
    GF_Unused_7F8                               = GameFlag(0x7F8),
    GF_Unused_7F9                               = GameFlag(0x7F9),
    GF_Unused_7FA                               = GameFlag(0x7FA),
    GF_Unused_7FB                               = GameFlag(0x7FB),
    GF_Unused_7FC                               = GameFlag(0x7FC),
    GF_Unused_7FD                               = GameFlag(0x7FD),
    GF_Unused_7FE                               = GameFlag(0x7FE),
    GF_Unused_7FF                               = GameFlag(0x7FF),
};
