<div align="center">
  <h1>Round 1</h1>
  <p>Day 47</p>
  <sub>
    Author: <a href="https://github.com/plskz" target="_blank">Zai Santillan</a>
    <br>
    <small>July 17, 2022 - Sunday</small>
  </sub>
</div>

[<< Day 46](day046.md) | [Day 48 >>](day048.md)

## Today's Progress:

- Solve [type-challenges](https://github.com/type-challenges/type-challenges):

  - https://github.com/type-challenges/type-challenges/issues/13097
  - https://github.com/type-challenges/type-challenges/issues/13098
  - https://github.com/type-challenges/type-challenges/issues/13108
  - https://github.com/type-challenges/type-challenges/issues/13111

- workout
- finished [No BS TS](https://youtube.com/playlist?list=PLNqp92_EXZBJYFrpEzdO2EapvU0GOJ09n) 🎉
- practice using [zustand](https://github.com/pmndrs/zustand)
- [plskz/react-projects](https://github.com/plskz/react-projects): rewrote **part1** into typescript. (didn't commit it)
- started working on my temporary website (plskz.me)

  - using Vite@React/TypeScript and TailwindCSS

    ![plskz.me](https://cdn.discordapp.com/attachments/997966010600656977/998260617054007357/unknown.png)

## Notes:

- what utility would I use if I want a specific optional property to be required, without changing any other properties? (Question from [No BS TS #33](https://www.youtube.com/watch?v=_cbJ2iN25_I&list=PLNqp92_EXZBJYFrpEzdO2EapvU0GOJ09n&index=36))

  <details>
  <summary>Solution</summary>

  Using `Required<T>` and `Pick<T, K>`

  ```typescript
  interface Person {
    id: number;
    name: string;
    age?: number;
    location?: string;
  }

  type RequiredAge = Person & Required<Pick<Person, 'age'>>;

  // ts-error Propery 'age' is missing
  const person: RequiredAge = {
    id: 1,
    name: 'John',
  };
  ```

  </details>

- same above but make it generic

  <details>
  <summary>Solution</summary>

  pick properties from `T` and make them required.

  ```typescript
  interface Person {
    id: number;
    name: string;
    age?: number;
    location?: string;
    random: string;
  }

  type RequiredSomething<T, U extends keyof T> = T & Required<Pick<T, U>>;

  const person2: RequiredSomething<Person, 'age' | 'location'> = {
    id: 2,
    name: 'Foo',
    age: 9,
    location: 'hush',
    random: 'i love raccoons',
  };
  ```

  </details>

- make all properties optional and then pick one or more to be required

  <details>
  <summary>Solution</summary>

  Using `Partial<T>`

  ```typescript
  interface Book {
    author: string;
    title: string;
    description: string;
  }

  type OptiRequired<T, U extends keyof T> = Partial<T> & Required<Pick<T, U>>;

  const favoriteBook: OptiRequired<Book, 'title'> = {
    title: 'Atomic Habits',
  };
  ```

  </details>

- libraries that I will be using for my temporary website (plskz.me)
  - https://github.com/simple-icons/simple-icons
  - https://github.com/wwayne/react-tooltip/
  - https://github.com/timolins/react-hot-toast

## Resources:

- https://www.typescriptlang.org/docs/handbook/release-notes/typescript-2-1.html#keyof-and-lookup-types
- https://www.typescriptlang.org/docs/handbook/2/mapped-types.html
- [what means a type like SomeType in typescript?](https://stackoverflow.com/questions/62905202/what-means-a-type-like-sometypet-u-v-in-typescript)
- [About "\*.d.ts" in TypeScript](https://stackoverflow.com/questions/21247278/about-d-ts-in-typescript)
- [Why do we use the letters T,U in generics](https://stackoverflow.com/questions/68458146/why-do-we-use-the-letters-t-u-in-generics)
- [What does `<T = {}>` mean?](https://stackoverflow.com/questions/69301000/what-does-t-mean?)
- https://www.tutorialsteacher.com/typescript/typescript-generic-interface
- https://www.typescriptlang.org/docs/handbook/release-notes/typescript-2-8.html
- https://blog.logrocket.com/understanding-infer-typescript/
- https://www.freecodecamp.org/news/advanced-typescript-types-cheat-sheet-with-examples/
- https://www.youtube.com/watch?v=sqTPGMipjHk
- [Zustand React Typescript Tutorial (vs Easy Peasy)](https://youtu.be/dOJkaYE249I)

[<< Day 46](day046.md) | [Day 48 >>](day048.md)
