all_html_fxs <- ls(asNamespace("dash"))[startsWith(ls(asNamespace("dash")), "html")]
all_html_fxs <- grep("^html(.)+", all_html_fxs, value = TRUE)
html_tags <- tolower(substring(all_html_fxs, 5))

# Tags that {dash} appends "El" to their names
tags_replace <- c("map", "object")
for (tag_replace in tags_replace) {
  html_tags[html_tags == paste0(tag_replace, "el")] <- tag_replace
}

cat(
  "## Generated by `scripts/generate_tags.R`; do not edit by hand",
  "all_tags <- c(",
  paste0(
    "  \"",
    paste(html_tags, collapse = "\",\n  \""),
    "\""
  ),
  ")",
  "names(all_tags) <- all_tags",
  sep = "\n",
  file =  rprojroot::find_package_root_file(file.path("R", "all_tags.R"))
)
