% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\docType{data}
\name{tags}
\alias{tags}
\alias{html}
\alias{h1}
\alias{h2}
\alias{h3}
\alias{h4}
\alias{div}
\alias{span}
\alias{p}
\alias{strong}
\alias{br}
\alias{button}
\alias{a}
\alias{img}
\alias{dash_tag}
\title{Create HTML tags}
\usage{
html

h1(...)

h2(...)

h3(...)

h4(...)

div(...)

span(...)

p(...)

strong(...)

br(...)

button(...)

a(...)

img(...)

dash_tag(tag_name, content = list())
}
\arguments{
\item{...}{Any named arguments become tag attributes, and any unnamed
arguments become children. A named argument with a value of \code{NULL} will
be removed, and a named argument with a value of \code{NA} will be rendered
as a boolean argument. See 'Special attributes' below for more information.}

\item{tag_name}{The name of the HTML tag.}

\item{content}{List of attributes and children.}
}
\description{
Create an HTML tag to place in a Dash app layout. All tags are available
in the \code{html} list, and some common tags have shortcuts as functions for
convenience (e.g. \code{h1()} produces \verb{<h1>} and is equivalent to \code{html$h1()}).
}
\section{Special attributes}{

There are a few HTML attributes that are treated in a special way:
\itemize{
\item To add a \code{class} attribute, use the \code{className} parameter
\item To add a \code{for} attribute, use the \code{htmlFor} parameter
\item The \code{style} attribute is not provided as a string. Instead, it's provided
as a named list, where the name and value of each element correspond to the
CSS property and value. Each CSS property should be written in camelCase.
\item A special property \code{n_clicks} is automatically added to every HTML tag.
This property represents the number of times that this element has been
clicked on. If not explicitly initialized to a certain integer, its default
value is \code{NULL} initially.
}
}

\examples{
if (interactive()) {
    app <- dash_app()
    app \%>\% set_layout(
      html$div(
        h1(
          "title",
          style = list(
            "color" = "red",
            "backgroundColor" = "blue"
          )
        ),
        "some text",
        button(
          "can't click me",
          disabled = NA,
          className = "mybtn"
        )
      )
    )
    app \%>\% run_app()
}
}
\keyword{datasets}
