% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{set_layout}
\alias{set_layout}
\title{Set the layout of a Dash app}
\usage{
set_layout(app, ...)
}
\arguments{
\item{app}{A dash application created with \code{\link[=dash_app]{dash_app()}}}

\item{...}{Dash components to create the user interface, provided either as
comma-separated components or a list of components. You can also provide a
function returning a Dash component if you want the layout to re-render on
every page load.}
}
\description{
Set the layout of a Dash app
}
\examples{
app <- dash_app()

app \%>\% set_layout("hello", "Dash")
app \%>\% set_layout(div("hello"), "Dash")
app \%>\% set_layout(list(div("hello"), "Dash"))
app \%>\% set_layout("Conditional UI using an if statement: ",
                   if (TRUE) "rendered",
                   if (FALSE) "not rendered")
app \%>\% set_layout(function() { div("Current time: ", Sys.time()) })
}
