% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{dash_app}
\alias{dash_app}
\title{Create a Dash application}
\usage{
dash_app(
  title = NULL,
  update_title = "Updating...",
  assets_folder = "assets",
  assets_url_path = "/assets",
  assets_ignore = NULL,
  eager_loading = FALSE,
  serve_locally = TRUE,
  pathname_url_base = "/",
  pathname_routes_prefix = NULL,
  pathname_requests_prefix = NULL,
  compress = TRUE,
  suppress_callback_exceptions = FALSE,
  show_undo_redo = FALSE
)
}
\arguments{
\item{title}{\emph{(character)} The browser window title.}

\item{update_title}{\emph{(character)} The browser window title while a callback
is being processed. Set to \code{NULL} or \code{""} if you don't want Dash to
automatically update the window title.}

\item{assets_folder}{\emph{(character)} Path (relative to the current working
directory) containing extra files to be served by the browser. All files
with ".js" or ".css" extensions will automatically be included on the page,
unless excluded with \code{assets_ignore}. Any other files, such as images, will
only be served if explicitly requested.}

\item{assets_url_path}{\emph{(character)} URL path for serving assets. For
example, a value of "www" means that any request path that begins with
"/www" will be mapped to the \code{assets_folder}. If your assets are hosted
online, you can provide a CDN URL, such as "http://your-assets-website".}

\item{assets_ignore}{\emph{(character)} Regular expression for ".js" and ".css"
files that should not be automatically included. Ignored files will still
be served if explicitly requested. Note that you cannot use this to
prevent access to sensitive files since ignored files are accessible
by users.}

\item{eager_loading}{\emph{(logical)} Whether asynchronous resources are
prefetched (\code{TRUE}) or loaded on-demand (\code{FALSE}).}

\item{serve_locally}{\emph{(logical)} Whether to serve HTML dependencies locally
or remotely (via URL).}

\item{pathname_url_base}{\emph{(character)} Local URL prefix to use app-wide.}

\item{pathname_routes_prefix}{\emph{(character)} Prefix applied to the backend
routes. Defaults to \code{pathname_url_base}.}

\item{pathname_requests_prefix}{\emph{(character)} Prefix applied to request
endpoints made by Dash's front-end. Defaults to \code{pathname_url_base}.}

\item{compress}{\emph{(logical)} Whether to try to compress files and data. If
\code{TRUE}, then \code{brotli} compression is attempted first, then \code{gzip}, then the
\code{deflate} algorithm, before falling back to identity.}

\item{suppress_callback_exceptions}{\emph{(logical)} Whether to relay warnings
about possible layout mis-specifications when registering a callback.}

\item{show_undo_redo}{\emph{(logical)} If \code{TRUE}, the app will have undo and redo
buttons for stepping through the history of the app state.}
}
\description{
This is a convenience function that returns a \code{\link{Dash}} R6 object.
For advanced usage, you can use the object as an R6 object directly instead
of the functions provided by the \code{{dash}} package.
}
\seealso{
\code{\link[=run_app]{run_app()}}
}
