% Auto-generated: do not edit by hand
\name{dashDataTable}

\alias{dashDataTable}

\title{DataTable component}

\description{
Dash DataTable is an interactive table component designed for viewing, editing, and exploring large datasets. DataTable is rendered with standard, semantic HTML <table/> markup, which makes it accessible, responsive, and easy to style. This component was written from scratch in React.js specifically for the Dash community. Its API was designed to be ergonomic and its behavior is completely customizable through its properties.
}

\usage{
dashDataTable(id=NULL, data=NULL, columns=NULL, active_cell=NULL,
include_headers_on_copy_paste=NULL, locale_format=NULL,
markdown_options=NULL, css=NULL, data_previous=NULL,
data_timestamp=NULL, editable=NULL, end_cell=NULL,
export_columns=NULL, export_format=NULL,
export_headers=NULL, fill_width=NULL, hidden_columns=NULL,
is_focused=NULL, merge_duplicate_headers=NULL,
fixed_columns=NULL, fixed_rows=NULL, column_selectable=NULL,
row_deletable=NULL, cell_selectable=NULL,
row_selectable=NULL, selected_cells=NULL,
selected_rows=NULL, selected_columns=NULL,
selected_row_ids=NULL, start_cell=NULL,
style_as_list_view=NULL, page_action=NULL,
page_current=NULL, page_count=NULL, page_size=NULL,
dropdown=NULL, dropdown_conditional=NULL,
dropdown_data=NULL, tooltip=NULL, tooltip_conditional=NULL,
tooltip_data=NULL, tooltip_header=NULL, tooltip_delay=NULL,
tooltip_duration=NULL, filter_query=NULL,
filter_action=NULL, filter_options=NULL, sort_action=NULL,
sort_mode=NULL, sort_by=NULL, sort_as_null=NULL,
style_table=NULL, style_cell=NULL, style_data=NULL,
style_filter=NULL, style_header=NULL,
style_cell_conditional=NULL, style_data_conditional=NULL,
style_filter_conditional=NULL,
style_header_conditional=NULL, virtualization=NULL,
derived_filter_query_structure=NULL,
derived_viewport_data=NULL, derived_viewport_indices=NULL,
derived_viewport_row_ids=NULL,
derived_viewport_selected_columns=NULL,
derived_viewport_selected_rows=NULL,
derived_viewport_selected_row_ids=NULL,
derived_virtual_data=NULL, derived_virtual_indices=NULL,
derived_virtual_row_ids=NULL,
derived_virtual_selected_rows=NULL,
derived_virtual_selected_row_ids=NULL, loading_state=NULL,
persistence=NULL, persisted_props=NULL,
persistence_type=NULL)
}

\arguments{
\item{id}{Character. The ID of the table.}

\item{data}{List of list with named elements and values of type character | numeric | logicals. The contents of the table.
The keys of each item in data should match the column IDs.
Each item can also have an 'id' key, whose value is its row ID. If there
is a column with ID='id' this will display the row ID, otherwise it is
just used to reference the row for selections, filtering, etc.
Example:
[
     {'column-1': 4.5, 'column-2': 'montreal', 'column-3': 'canada'},
     {'column-1': 8, 'column-2': 'boston', 'column-3': 'america'}
]}

\item{columns}{List of lists containing elements 'clearable', 'deletable', 'editable', 'filter_options', 'hideable', 'renamable', 'selectable', 'format', 'id', 'name', 'presentation', 'on_change', 'sort_as_null', 'validation', 'type'.
those elements have the following types:
  - clearable (a value equal to: 'first', 'last' | logical | list of logicals; optional): if true, the user can clear the column by clicking on the `clear`
action button on the column. if there are multiple header rows, true
will display the action button on each row.
if `last`, the `clear` action button will only appear on the last header
row. if `first` it will only appear on the first header row. these
are respectively shortcut equivalents to `[false, ..., false, true]` and
`[true, false, ..., false]`.
if there are merged, multi-header columns then you can choose
which column header row to display the `clear` action button in by
supplying an array of booleans.
for example, `[true, false]` will display the `clear` action button
on the first row, but not the second row.
if the `clear` action button appears on a merged column, then clicking
on that button will clear *all* of the merged columns associated with it.
unlike `column.deletable`, this action does not remove the column(s)
from the table. it only removed the associated entries from `data`.
  - deletable (a value equal to: 'first', 'last' | logical | list of logicals; optional): if true, the user can remove the column by clicking on the `delete`
action button on the column. if there are multiple header rows, true
will display the action button on each row.
if `last`, the `delete` action button will only appear on the last header
row. if `first` it will only appear on the first header row. these
are respectively shortcut equivalents to `[false, ..., false, true]` and
`[true, false, ..., false]`.
if there are merged, multi-header columns then you can choose
which column header row to display the `delete` action button in by
supplying an array of booleans.
for example, `[true, false]` will display the `delete` action button
on the first row, but not the second row.
if the `delete` action button appears on a merged column, then clicking
on that button will remove *all* of the merged columns associated with it.
  - editable (logical; optional): there are two `editable` flags in the table.
this is the  column-level editable flag and there is
also the table-level `editable` flag.
these flags determine whether the contents of the table
are editable or not.
if the column-level `editable` flag is set it overrides
the table-level `editable` flag for that column.
  - filter_options (optional): there are two `filter_options` props in the table.
this is the column-level filter_options prop and there is
also the table-level `filter_options` prop.
these props determine whether the applicable filter relational
operators will default to `sensitive` or `insensitive` comparison.
if the column-level `filter_options` prop is set it overrides
the table-level `filter_options` prop for that column.. filter_options has the following type: lists containing elements 'case'.
those elements have the following types:
  - case (a value equal to: 'sensitive', 'insensitive'; optional)
  - hideable (a value equal to: 'first', 'last' | logical | list of logicals; optional): if true, the user can hide the column by clicking on the `hide`
action button on the column. if there are multiple header rows, true
will display the action button on each row.
if `last`, the `hide` action button will only appear on the last header
row. if `first` it will only appear on the first header row. these
are respectively shortcut equivalents to `[false, ..., false, true]` and
`[true, false, ..., false]`.
if there are merged, multi-header columns then you can choose
which column header row to display the `hide` action button in by
supplying an array of booleans.
for example, `[true, false]` will display the `hide` action button
on the first row, but not the second row.
if the `hide` action button appears on a merged column, then clicking
on that button will hide *all* of the merged columns associated with it.
  - renamable (a value equal to: 'first', 'last' | logical | list of logicals; optional): if true, the user can rename the column by clicking on the `rename`
action button on the column. if there are multiple header rows, true
will display the action button on each row.
if `last`, the `rename` action button will only appear on the last header
row. if `first` it will only appear on the first header row. these
are respectively shortcut equivalents to `[false, ..., false, true]` and
`[true, false, ..., false]`.
if there are merged, multi-header columns then you can choose
which column header row to display the `rename` action button in by
supplying an array of booleans.
for example, `[true, false]` will display the `rename` action button
on the first row, but not the second row.
if the `rename` action button appears on a merged column, then clicking
on that button will rename *all* of the merged columns associated with it.
  - selectable (a value equal to: 'first', 'last' | logical | list of logicals; optional): if true, the user can select the column by clicking on the checkbox or radio button
in the column. if there are multiple header rows, true will display the input
on each row.
if `last`, the input will only appear on the last header row. if `first` it will only
appear on the first header row. these are respectively shortcut equivalents to
`[false, ..., false, true]` and `[true, false, ..., false]`.
if there are merged, multi-header columns then you can choose which column header
row to display the input in by supplying an array of booleans.
for example, `[true, false]` will display the `selectable` input on the first row,
but now on the second row.
if the `selectable` input appears on a merged columns, then clicking on that input
will select *all* of the merged columns associated with it.
the table-level prop `column_selectable` is used to determine the type of column
selection to use.
  - format (optional): the formatting applied to the column's data.
this prop is derived from the [d3-format](https://github.com/d3/d3-format) library specification. apart from
being structured slightly differently (under a single prop), the usage is the same.
see also dash_table.formattemplate.  it contains helper functions for typical number formats.. format has the following type: lists containing elements 'locale', 'nully', 'prefix', 'specifier'.
those elements have the following types:
  - locale (optional): represents localization specific formatting information.
when left unspecified, will use the default value provided by d3-format.. locale has the following type: lists containing elements 'symbol', 'decimal', 'group', 'grouping', 'numerals', 'percent', 'separate_4digits'.
those elements have the following types:
  - symbol (list of characters; optional): (default: ['$', '']).  a list of two strings representing the
 prefix and suffix symbols. typically used for currency, and implemented using d3's
 currency format, but you can use this for other symbols such as measurement units
  - decimal (character; optional): (default: '.').  the string used for the decimal separator
  - group (character; optional): (default: ',').  the string used for the groups separator
  - grouping (list of numerics; optional): (default: [3]).  a list of integers representing the grouping pattern. the default is
3 for thousands.
  - numerals (list of characters; optional): a list of ten strings used as replacements for numbers 0-9
  - percent (character; optional): (default: '\%').  the string used for the percentage symbol
  - separate_4digits (logical; optional): (default: true). separates integers with 4-digits or less
  - nully (logical | numeric | character | named list | unnamed list; optional): a value that will be used in place of the nully value during formatting.
  if the value type matches the column type, it will be formatted normally.
  - prefix (numeric; optional): a number representing the si unit to use during formatting.
  see `dash_table.format.prefix` enumeration for the list of valid values
  - specifier (character; optional): (default: '').  represents the d3 rules to apply when formatting the number.
  - id (character; required): the `id` of the column.
the column `id` is used to match cells in data with particular columns.
the `id` is not visible in the table.
  - name (character | list of characters; required): the `name` of the column, as it appears in the column header.
if `name` is a list of strings, then the columns
will render with multiple headers rows.
  - presentation (a value equal to: 'input', 'dropdown', 'markdown'; optional): the `presentation` to use to display data. markdown can be used on
columns with type 'text'.  see 'dropdown' for more info.
defaults to 'input' for ['datetime', 'numeric', 'text', 'any'].
  - on_change (optional): the `on_change` behavior of the column for user-initiated modifications.. on_change has the following type: lists containing elements 'action', 'failure'.
those elements have the following types:
  - action (a value equal to: 'coerce', 'none', 'validate'; optional): (default 'coerce'):  'none': do not validate data;
 'coerce': check if the data corresponds to the destination type and
 attempts to coerce it into the destination type if not;
 'validate': check if the data corresponds to the destination type (no coercion).
  - failure (a value equal to: 'accept', 'default', 'reject'; optional): (default 'reject'):  what to do with the value if the action fails.
 'accept': use the invalid value;
 'default': replace the provided value with `validation.default`;
 'reject': do not modify the existing value.
  - sort_as_null (list of character | numeric | logicals; optional): an array of string, number and boolean values that are treated as `null`
(i.e. ignored and always displayed last) when sorting.
this value overrides the table-level `sort_as_null`.
  - validation (optional): the `validation` options for user input processing that can accept, reject or apply a
default value.. validation has the following type: lists containing elements 'allow_null', 'default', 'allow_yy'.
those elements have the following types:
  - allow_null (logical; optional): allow the use of nully values. (undefined, null, nan) (default: false)
  - default (logical | numeric | character | named list | unnamed list; optional): the default value to apply with on_change.failure = 'default'. (default: none)
  - allow_yy (logical; optional): this is for `datetime` columns only.  allow 2-digit years (default: false).
  if true, we interpret years as ranging from now-70 to now+29 - in 2019
  this is 1949 to 2048 but in 2020 it will be different. if used with
  `action: 'coerce'`, will convert user input to a 4-digit year.
  - type (a value equal to: 'any', 'numeric', 'text', 'datetime'; optional): the data-type provides support for per column typing and allows for data
validation and coercion.
'numeric': represents both floats and ints.
'text': represents a string.
'datetime': a string representing a date or date-time, in the form:
  'yyyy-mm-dd hh:mm:ss.ssssss' or some truncation thereof. years must
  have 4 digits, unless you use `validation.allow_yy: true`. also
  accepts 't' or 't' between date and time, and allows timezone info
  at the end. to convert these strings to python `datetime` objects,
  use `dateutil.parser.isoparse`. in r use `parse_iso_8601` from the
  `parsedate` library.
  warning: these parsers do not work with 2-digit years, if you use
  `validation.allow_yy: true` and do not coerce to 4-digit years.
  and parsers that do work with 2-digit years may make a different
  guess about the century than we make on the front end.
'any': represents any type of data.
defaults to 'any' if undefined.s. Columns describes various aspects about each individual column.
`name` and `id` are the only required parameters.}

\item{active_cell}{Lists containing elements 'row', 'column', 'row_id', 'column_id'.
those elements have the following types:
  - row (numeric; optional)
  - column (numeric; optional)
  - row_id (character | numeric; optional)
  - column_id (character; optional). The row and column indices and IDs of the currently active cell.
`row_id` is only returned if the data rows have an `id` key.}

\item{include_headers_on_copy_paste}{Logical. If true, headers are included when copying from the table to different
tabs and elsewhere. Note that headers are ignored when copying from the table onto itself and
between two tables within the same tab.}

\item{locale_format}{Lists containing elements 'symbol', 'decimal', 'group', 'grouping', 'numerals', 'percent', 'separate_4digits'.
those elements have the following types:
  - symbol (list of characters; optional): (default: ['$', '']). a  list of two strings representing the
  prefix and suffix symbols. typically used for currency, and implemented using d3's
  currency format, but you can use this for other symbols such as measurement units.
  - decimal (character; optional): (default: '.'). the string used for the decimal separator.
  - group (character; optional): (default: ','). the string used for the groups separator.
  - grouping (list of numerics; optional): (default: [3]). a  list of integers representing the grouping pattern.
  - numerals (list of characters; optional): a list of ten strings used as replacements for numbers 0-9.
  - percent (character; optional): (default: '\%'). the string used for the percentage symbol.
  - separate_4digits (logical; optional): (default: true). separate integers with 4-digits or less.. The localization specific formatting information applied to all columns in the table.
This prop is derived from the [d3.formatLocale](https://github.com/d3/d3-format#formatLocale) data structure specification.
When left unspecified, each individual nested prop will default to a pre-determined value.}

\item{markdown_options}{Lists containing elements 'link_target', 'html'.
those elements have the following types:
  - link_target (character | a value equal to: '_blank', '_parent', '_self', '_top'; optional): (default: '_blank').  the link's behavior (_blank opens the link in a
new tab, _parent opens the link in the parent frame, _self opens the link in the
current tab, and _top opens the link in the top frame) or a string
  - html (logical; optional): (default: false)  if true, html may be used in markdown cells
be careful enabling html if the content being rendered can come
from an untrusted user, as this may create an xss vulnerability.. The `markdown_options` property allows customization of the markdown cells behavior.}

\item{css}{List of lists containing elements 'selector', 'rule'.
those elements have the following types:
  - selector (character; required)
  - rule (character; required)s. The `css` property is a way to embed CSS selectors and rules
onto the page.
We recommend starting with the `style_*` properties
before using this `css` property.
Example:
[
    {"selector": ".dash-spreadsheet", "rule": 'font-family: "monospace"'}
]}

\item{data_previous}{List of named lists. The previous state of `data`. `data_previous`
has the same structure as `data` and it will be updated
whenever `data` changes, either through a callback or
by editing the table.
This is a read-only property: setting this property will not
have any impact on the table.}

\item{data_timestamp}{Numeric. The unix timestamp when the data was last edited.
Use this property with other timestamp properties
(such as `n_clicks_timestamp` in `dash_html_components`)
to determine which property has changed within a callback.}

\item{editable}{Logical. If True, then the data in all of the cells is editable.
When `editable` is True, particular columns can be made
uneditable by setting `editable` to `False` inside the `columns`
property.
If False, then the data in all of the cells is uneditable.
When `editable` is False, particular columns can be made
editable by setting `editable` to `True` inside the `columns`
property.}

\item{end_cell}{Lists containing elements 'row', 'column', 'row_id', 'column_id'.
those elements have the following types:
  - row (numeric; optional)
  - column (numeric; optional)
  - row_id (character | numeric; optional)
  - column_id (character; optional). When selecting multiple cells
(via clicking on a cell and then shift-clicking on another cell),
`end_cell` represents the row / column coordinates and IDs of the cell
in one of the corners of the region.
`start_cell` represents the coordinates of the other corner.}

\item{export_columns}{A value equal to: 'all', 'visible'. Denotes the columns that will be used in the export data file.
If `all`, all columns will be used (visible + hidden). If `visible`,
only the visible columns will be used. Defaults to `visible`.}

\item{export_format}{A value equal to: 'csv', 'xlsx', 'none'. Denotes the type of the export data file,
Defaults to `'none'`}

\item{export_headers}{A value equal to: 'none', 'ids', 'names', 'display'. Denotes the format of the headers in the export data file.
If `'none'`, there will be no header. If `'display'`, then the header
of the data file will be be how it is currently displayed. Note that
`'display'` is only supported for `'xlsx'` export_format and will behave
like `'names'` for `'csv'` export format. If `'ids'` or `'names'`,
then the headers of data file will be the column id or the column
names, respectively}

\item{fill_width}{Logical. `fill_width` toggles between a set of CSS for two common behaviors:
True: The table container's width will grow to fill the available space;
False: The table container's width will equal the width of its content.}

\item{hidden_columns}{List of characters. List of columns ids of the columns that are currently hidden.
See the associated nested prop `columns.hideable`.}

\item{is_focused}{Logical. If True, then the `active_cell` is in a focused state.}

\item{merge_duplicate_headers}{Logical. If True, then column headers that have neighbors with duplicate names
will be merged into a single cell.
This will be applied for single column headers and multi-column
headers.}

\item{fixed_columns}{Lists containing elements 'data', 'headers'.
those elements have the following types:
  - data (a value equal to: 0; optional): example `{'headers':false, 'data':0}` no columns are fixed (the default)
  - headers (a value equal to: false; optional) | lists containing elements 'data', 'headers'.
those elements have the following types:
  - data (numeric; optional): example `{'headers':true, 'data':1}` one column is fixed.
  - headers (a value equal to: true; required). `fixed_columns` will "fix" the set of columns so that
they remain visible when scrolling horizontally across
the unfixed columns. `fixed_columns` fixes columns
from left-to-right.
If `headers` is False, no columns are fixed.
If `headers` is True, all operation columns (see `row_deletable` and `row_selectable`)
are fixed. Additional data columns can be fixed by
assigning a number to `data`.

Note that fixing columns introduces some changes to the
underlying markup of the table and may impact the
way that your columns are rendered or sized.
View the documentation examples to learn more.}

\item{fixed_rows}{Lists containing elements 'data', 'headers'.
those elements have the following types:
  - data (a value equal to: 0; optional): example `{'headers':false, 'data':0}` no rows are fixed (the default)
  - headers (a value equal to: false; optional) | lists containing elements 'data', 'headers'.
those elements have the following types:
  - data (numeric; optional): example `{'headers':true, 'data':1}` one row is fixed.
  - headers (a value equal to: true; required). `fixed_rows` will "fix" the set of rows so that
they remain visible when scrolling vertically down
the table. `fixed_rows` fixes rows
from top-to-bottom, starting from the headers.
If `headers` is False, no rows are fixed.
If `headers` is True, all header and filter rows (see `filter_action`) are
fixed. Additional data rows can be fixed by assigning
a number to `data`.  Note that fixing rows introduces some changes to the
underlying markup of the table and may impact the
way that your columns are rendered or sized.
View the documentation examples to learn more.}

\item{column_selectable}{A value equal to: 'single', 'multi', false. If `single`, then the user can select a single column or group
of merged columns via the radio button that will appear in the
header rows.
If `multi`, then the user can select multiple columns or groups
of merged columns via the checkbox that will appear in the header
rows.
If false, then the user will not be able to select columns and no
input will appear in the header rows.
When a column is selected, its id will be contained in `selected_columns`
and `derived_viewport_selected_columns`.}

\item{row_deletable}{Logical. If True, then a `x` will appear next to each `row`
and the user can delete the row.}

\item{cell_selectable}{Logical. If True (default), then it is possible to click and navigate
table cells.}

\item{row_selectable}{A value equal to: 'single', 'multi', false. If `single`, then the user can select a single row
via a radio button that will appear next to each row.
If `multi`, then the user can select multiple rows
via a checkbox that will appear next to each row.
If false, then the user will not be able to select rows
and no additional UI elements will appear.
When a row is selected, its index will be contained
in `selected_rows`.}

\item{selected_cells}{List of lists containing elements 'row', 'column', 'row_id', 'column_id'.
those elements have the following types:
  - row (numeric; optional)
  - column (numeric; optional)
  - row_id (character | numeric; optional)
  - column_id (character; optional)s. `selected_cells` represents the set of cells that are selected,
as an array of objects, each item similar to `active_cell`.
Multiple cells can be selected by holding down shift and
clicking on a different cell or holding down shift and navigating
with the arrow keys.}

\item{selected_rows}{List of numerics. `selected_rows` contains the indices of rows that
are selected via the UI elements that appear when
`row_selectable` is `'single'` or `'multi'`.}

\item{selected_columns}{List of characters. `selected_columns` contains the ids of columns that
are selected via the UI elements that appear when
`column_selectable` is `'single' or 'multi'`.}

\item{selected_row_ids}{List of character | numerics. `selected_row_ids` contains the ids of rows that
are selected via the UI elements that appear when
`row_selectable` is `'single'` or `'multi'`.}

\item{start_cell}{Lists containing elements 'row', 'column', 'row_id', 'column_id'.
those elements have the following types:
  - row (numeric; optional)
  - column (numeric; optional)
  - row_id (character | numeric; optional)
  - column_id (character; optional). When selecting multiple cells
(via clicking on a cell and then shift-clicking on another cell),
`start_cell` represents the [row, column] coordinates of the cell
in one of the corners of the region.
`end_cell` represents the coordinates of the other corner.}

\item{style_as_list_view}{Logical. If True, then the table will be styled like a list view
and not have borders between the columns.}

\item{page_action}{A value equal to: 'custom', 'native', 'none'. `page_action` refers to a mode of the table where
not all of the rows are displayed at once: only a subset
are displayed (a "page") and the next subset of rows
can viewed by clicking "Next" or "Previous" buttons
at the bottom of the page.
Pagination is used to improve performance: instead of
rendering all of the rows at once (which can be expensive),
we only display a subset of them.
With pagination, we can either page through data that exists
in the table (e.g. page through `10,000` rows in `data` `100` rows at a time)
or we can update the data on-the-fly with callbacks
when the user clicks on the "Previous" or "Next" buttons.
These modes can be toggled with this `page_action` parameter:
`'native'`: all data is passed to the table up-front, paging logic is
handled by the table;
`'custom'`: data is passed to the table one page at a time, paging logic
is handled via callbacks;
`'none'`: disables paging, render all of the data at once.}

\item{page_current}{Numeric. `page_current` represents which page the user is on.
Use this property to index through data in your callbacks with
backend paging.}

\item{page_count}{Numeric. `page_count` represents the number of the pages in the
paginated table. This is really only useful when performing
backend pagination, since the front end is able to use the
full size of the table to calculate the number of pages.}

\item{page_size}{Numeric. `page_size` represents the number of rows that will be
displayed on a particular page when `page_action` is `'custom'` or `'native'`}

\item{dropdown}{List with named elements and values of type lists containing elements 'clearable', 'options'.
those elements have the following types:
  - clearable (logical; optional)
  - options (required): . options has the following type: list of lists containing elements 'label', 'value'.
those elements have the following types:
  - label (character; required)
  - value (numeric | character | logical; required)s. `dropdown` specifies dropdown options for different columns.
Each entry refers to the column ID.
The `clearable` property defines whether the value can be deleted.
The `options` property refers to the `options` of the dropdown.}

\item{dropdown_conditional}{List of lists containing elements 'clearable', 'if', 'options'.
those elements have the following types:
  - clearable (logical; optional)
  - if (optional): . if has the following type: lists containing elements 'column_id', 'filter_query'.
those elements have the following types:
  - column_id (character; optional)
  - filter_query (character; optional)
  - options (required): . options has the following type: list of lists containing elements 'label', 'value'.
those elements have the following types:
  - label (character; required)
  - value (numeric | character | logical; required)ss. `dropdown_conditional` specifies dropdown options in various columns and cells.
This property allows you to specify different dropdowns
depending on certain conditions. For example, you may
render different "city" dropdowns in a row depending on the
current value in the "state" column.}

\item{dropdown_data}{List of list with named elements and values of type lists containing elements 'clearable', 'options'.
those elements have the following types:
  - clearable (logical; optional)
  - options (required): . options has the following type: list of lists containing elements 'label', 'value'.
those elements have the following types:
  - label (character; required)
  - value (numeric | character | logical; required)ss. `dropdown_data` specifies dropdown options on a row-by-row, column-by-column basis.
Each item in the array corresponds to the corresponding dropdowns for the `data` item
at the same index. Each entry in the item refers to the Column ID.}

\item{tooltip}{List with named elements and values of type character | lists containing elements 'delay', 'duration', 'type', 'use_with', 'value'.
those elements have the following types:
  - delay (numeric; optional): represents the delay in milliseconds before
the tooltip is shown when hovering a cell. this overrides
the table's `tooltip_delay` property. if set to `none`,
the tooltip will be shown immediately.
  - duration (numeric; optional): represents the duration in milliseconds
during which the tooltip is shown when hovering a cell.
this overrides the table's `tooltip_duration` property.
if set to `none`, the tooltip will not disappear.
  - type (a value equal to: 'text', 'markdown'; optional): refers to the type of tooltip syntax used
for the tooltip generation. can either be `markdown`
or `text`. defaults to `text`.
  - use_with (a value equal to: 'both', 'data', 'header'; optional): refers to whether the tooltip will be shown
only on data or headers. can be `both`, `data`, `header`.
defaults to `both`.
  - value (character; required): refers to the syntax-based content of
the tooltip. this value is required. alternatively, the value of the
property can also be  a plain string. the `text` syntax will be used in
that case.. `tooltip` is the column based tooltip configuration applied to all rows. The key is the column
 id and the value is a tooltip configuration.
Example: {i: {'value': i, 'use_with: 'both'} for i in df.columns}}

\item{tooltip_conditional}{List of lists containing elements 'delay', 'duration', 'if', 'type', 'value'.
those elements have the following types:
  - delay (numeric; optional): the `delay` represents the delay in milliseconds before
the tooltip is shown when hovering a cell. this overrides
the table's `tooltip_delay` property. if set to `none`,
the tooltip will be shown immediately.
  - duration (numeric; optional): the `duration` represents the duration in milliseconds
during which the tooltip is shown when hovering a cell.
this overrides the table's `tooltip_duration` property.
if set to `none`, the tooltip will not disappear.
  - if (required): the `if` refers to the condition that needs to be fulfilled
in order for the associated tooltip configuration to be
used. if multiple conditions are defined, all conditions
must be met for the tooltip to be used by a cell.. if has the following type: lists containing elements 'column_id', 'filter_query', 'row_index'.
those elements have the following types:
  - column_id (character; optional): `column_id` refers to the column id that must be matched.
  - filter_query (character; optional): `filter_query` refers to the query that must evaluate to true.
  - row_index (numeric | a value equal to: 'odd', 'even'; optional): `row_index` refers to the index of the row in the source `data`.
  - type (a value equal to: 'text', 'markdown'; optional): the `type` refers to the type of tooltip syntax used
for the tooltip generation. can either be `markdown`
or `text`. defaults to `text`.
  - value (character; required): the `value` refers to the syntax-based content of the tooltip. this value is required.s. `tooltip_conditional` represents the tooltip shown
for different columns and cells.
This property allows you to specify different tooltips
depending on certain conditions. For example, you may have
different tooltips in the same column based on the value
of a certain data property.
Priority is from first to last defined conditional tooltip
in the list. Higher priority (more specific) conditional
tooltips should be put at the beginning of the list.}

\item{tooltip_data}{List of list with named elements and values of type character | lists containing elements 'delay', 'duration', 'type', 'value'.
those elements have the following types:
  - delay (numeric; optional): the `delay` represents the delay in milliseconds before
the tooltip is shown when hovering a cell. this overrides
the table's `tooltip_delay` property. if set to `none`,
the tooltip will be shown immediately.
  - duration (numeric; optional): the `duration` represents the duration in milliseconds
during which the tooltip is shown when hovering a cell.
this overrides the table's `tooltip_duration` property.
if set to `none`, the tooltip will not disappear.
alternatively, the value of the property can also be
a plain string. the `text` syntax will be used in
that case.
  - type (a value equal to: 'text', 'markdown'; optional): for each tooltip configuration,
the `type` refers to the type of tooltip syntax used
for the tooltip generation. can either be `markdown`
or `text`. defaults to `text`.
  - value (character; required): the `value` refers to the syntax-based content of the tooltip. this value is required.s. `tooltip_data` represents the tooltip shown
for different columns and cells.
A list of dicts for which each key is
a column id and the value is a tooltip configuration.}

\item{tooltip_header}{List with named elements and values of type character | lists containing elements 'delay', 'duration', 'type', 'value'.
those elements have the following types:
  - delay (numeric; optional): the `delay` represents the delay in milliseconds before
the tooltip is shown when hovering a cell. this overrides
the table's `tooltip_delay` property. if set to `none`,
the tooltip will be shown immediately.
  - duration (numeric; optional): the `duration` represents the duration in milliseconds
during which the tooltip is shown when hovering a cell.
this overrides the table's `tooltip_duration` property.
if set to `none`, the tooltip will not disappear.
alternatively, the value of the property can also be
a plain string. the `text` syntax will be used in
that case.
  - type (a value equal to: 'text', 'markdown'; optional): for each tooltip configuration,
the `type` refers to the type of tooltip syntax used
for the tooltip generation. can either be `markdown`
or `text`. defaults to `text`.
  - value (character; required): the `value` refers to the syntax-based content of the tooltip. this value is required. | list of a value equal to: null | character | lists containing elements 'delay', 'duration', 'type', 'value'.
those elements have the following types:
  - delay (numeric; optional)
  - duration (numeric; optional)
  - type (a value equal to: 'text', 'markdown'; optional)
  - value (character; required)s. `tooltip_header` represents the tooltip shown
for each header column and optionally each header row.
Example to show long column names in a tooltip: {i: i for i in df.columns}.
Example to show different column names in a tooltip: {'Rep': 'Republican', 'Dem': 'Democrat'}.
If the table has multiple rows of headers, then use a list as the value of the
`tooltip_header` items.}

\item{tooltip_delay}{Numeric. `tooltip_delay` represents the table-wide delay in milliseconds before
the tooltip is shown when hovering a cell. If set to `None`, the tooltip
will be shown immediately.
Defaults to 350.}

\item{tooltip_duration}{Numeric. `tooltip_duration` represents the table-wide duration in milliseconds
during which the tooltip will be displayed when hovering a cell. If
set to `None`, the tooltip will not disappear.
Defaults to 2000.}

\item{filter_query}{Character. If `filter_action` is enabled, then the current filtering
string is represented in this `filter_query`
property.}

\item{filter_action}{A value equal to: 'custom', 'native', 'none' | lists containing elements 'type', 'operator'.
those elements have the following types:
  - type (a value equal to: 'custom', 'native'; required)
  - operator (a value equal to: 'and', 'or'; optional). The `filter_action` property controls the behavior of the `filtering` UI.
If `'none'`, then the filtering UI is not displayed.
If `'native'`, then the filtering UI is displayed and the filtering
logic is handled by the table. That is, it is performed on the data
that exists in the `data` property.
If `'custom'`, then the filtering UI is displayed but it is the
responsibility of the developer to program the filtering
through a callback (where `filter_query` or `derived_filter_query_structure` would be the input
and `data` would be the output).}

\item{filter_options}{Lists containing elements 'case'.
those elements have the following types:
  - case (a value equal to: 'sensitive', 'insensitive'; optional). There are two `filter_options` props in the table.
This is the table-level filter_options prop and there is
also the column-level `filter_options` prop.
These props determine whether the applicable filter relational
operators will default to `sensitive` or `insensitive` comparison.
If the column-level `filter_options` prop is set it overrides
the table-level `filter_options` prop for that column.}

\item{sort_action}{A value equal to: 'custom', 'native', 'none'. The `sort_action` property enables data to be
sorted on a per-column basis.
If `'none'`, then the sorting UI is not displayed.
If `'native'`, then the sorting UI is displayed and the sorting
logic is handled by the table. That is, it is performed on the data
that exists in the `data` property.
If `'custom'`, the the sorting UI is displayed but it is the
responsibility of the developer to program the sorting
through a callback (where `sort_by` would be the input and `data`
would be the output).
Clicking on the sort arrows will update the
`sort_by` property.}

\item{sort_mode}{A value equal to: 'single', 'multi'. Sorting can be performed across multiple columns
(e.g. sort by country, sort within each country,
 sort by year) or by a single column.
NOTE - With multi-column sort, it's currently
not possible to determine the order in which
the columns were sorted through the UI.
See [https://github.com/plotly/dash-table/issues/170](https://github.com/plotly/dash-table/issues/170)}

\item{sort_by}{List of lists containing elements 'column_id', 'direction'.
those elements have the following types:
  - column_id (character; required)
  - direction (a value equal to: 'asc', 'desc'; required)s. `sort_by` describes the current state
of the sorting UI.
That is, if the user clicked on the sort arrow
of a column, then this property will be updated
with the column ID and the direction
(`asc` or `desc`) of the sort.
For multi-column sorting, this will be a list of
sorting parameters, in the order in which they were
clicked.}

\item{sort_as_null}{List of character | numeric | logicals. An array of string, number and boolean values that are treated as `None`
(i.e. ignored and always displayed last) when sorting.
This value will be used by columns without `sort_as_null`.
Defaults to `[]`.}

\item{style_table}{Named list. CSS styles to be applied to the outer `table` container.
This is commonly used for setting properties like the
width or the height of the table.}

\item{style_cell}{Named list. CSS styles to be applied to each individual cell of the table.
This includes the header cells, the `data` cells, and the filter
cells.}

\item{style_data}{Named list. CSS styles to be applied to each individual data cell.
That is, unlike `style_cell`, it excludes the header and filter cells.}

\item{style_filter}{Named list. CSS styles to be applied to the filter cells.
Note that this may change in the future as we build out a
more complex filtering UI.}

\item{style_header}{Named list. CSS styles to be applied to each individual header cell.
That is, unlike `style_cell`, it excludes the `data` and filter cells.}

\item{style_cell_conditional}{List of lists containing elements 'if'.
those elements have the following types:
  - if (optional): . if has the following type: lists containing elements 'column_id', 'column_type'.
those elements have the following types:
  - column_id (character | list of characters; optional)
  - column_type (a value equal to: 'any', 'numeric', 'text', 'datetime'; optional)s. Conditional CSS styles for the cells.
This can be used to apply styles to cells on a per-column basis.}

\item{style_data_conditional}{List of lists containing elements 'if'.
those elements have the following types:
  - if (optional): . if has the following type: lists containing elements 'column_id', 'column_type', 'filter_query', 'state', 'row_index', 'column_editable'.
those elements have the following types:
  - column_id (character | list of characters; optional)
  - column_type (a value equal to: 'any', 'numeric', 'text', 'datetime'; optional)
  - filter_query (character; optional)
  - state (a value equal to: 'active', 'selected'; optional)
  - row_index (numeric | a value equal to: 'odd', 'even' | list of numerics; optional)
  - column_editable (logical; optional)s. Conditional CSS styles for the data cells.
This can be used to apply styles to data cells on a per-column basis.}

\item{style_filter_conditional}{List of lists containing elements 'if'.
those elements have the following types:
  - if (optional): . if has the following type: lists containing elements 'column_id', 'column_type', 'column_editable'.
those elements have the following types:
  - column_id (character | list of characters; optional)
  - column_type (a value equal to: 'any', 'numeric', 'text', 'datetime'; optional)
  - column_editable (logical; optional)s. Conditional CSS styles for the filter cells.
This can be used to apply styles to filter cells on a per-column basis.}

\item{style_header_conditional}{List of lists containing elements 'if'.
those elements have the following types:
  - if (optional): . if has the following type: lists containing elements 'column_id', 'column_type', 'header_index', 'column_editable'.
those elements have the following types:
  - column_id (character | list of characters; optional)
  - column_type (a value equal to: 'any', 'numeric', 'text', 'datetime'; optional)
  - header_index (numeric | list of numerics | a value equal to: 'odd', 'even'; optional)
  - column_editable (logical; optional)s. Conditional CSS styles for the header cells.
This can be used to apply styles to header cells on a per-column basis.}

\item{virtualization}{Logical. This property tells the table to use virtualization when rendering.
Assumptions are that:
the width of the columns is fixed;
the height of the rows is always the same; and
runtime styling changes will not affect width and height vs. first rendering}

\item{derived_filter_query_structure}{Named list. This property represents the current structure of
`filter_query` as a tree structure. Each node of the
query structure has:
type (string; required):
  'open-block',
  'logical-operator',
  'relational-operator',
  'unary-operator', or
  'expression';
subType (string; optional):
  'open-block': '()',
  'logical-operator': '&&', '||',
  'relational-operator': '=', '>=', '>', '<=', '<', '!=', 'contains',
  'unary-operator': '!', 'is bool', 'is even', 'is nil', 'is num', 'is object', 'is odd', 'is prime', 'is str',
  'expression': 'value', 'field';
value (any):
  'expression, value': passed value,
  'expression, field': the field/prop name.
block (nested query structure; optional).
left (nested query structure; optional).
right (nested query structure; optional).
If the query is invalid or empty, the `derived_filter_query_structure` will
be `None`.}

\item{derived_viewport_data}{List of named lists. This property represents the current state of `data`
on the current page. This property will be updated
on paging, sorting, and filtering.}

\item{derived_viewport_indices}{List of numerics. `derived_viewport_indices` indicates the order in which the original
rows appear after being filtered, sorted, and/or paged.
`derived_viewport_indices` contains indices for the current page,
while `derived_virtual_indices` contains indices across all pages.}

\item{derived_viewport_row_ids}{List of character | numerics. `derived_viewport_row_ids` lists row IDs in the order they appear
after being filtered, sorted, and/or paged.
`derived_viewport_row_ids` contains IDs for the current page,
while `derived_virtual_row_ids` contains IDs across all pages.}

\item{derived_viewport_selected_columns}{List of characters. `derived_viewport_selected_columns` contains the ids of the
`selected_columns` that are not currently hidden.}

\item{derived_viewport_selected_rows}{List of numerics. `derived_viewport_selected_rows` represents the indices of the
`selected_rows` from the perspective of the `derived_viewport_indices`.}

\item{derived_viewport_selected_row_ids}{List of character | numerics. `derived_viewport_selected_row_ids` represents the IDs of the
`selected_rows` on the currently visible page.}

\item{derived_virtual_data}{List of named lists. This property represents the visible state of `data`
across all pages after the front-end sorting and filtering
as been applied.}

\item{derived_virtual_indices}{List of numerics. `derived_virtual_indices` indicates the order in which the original
rows appear after being filtered and sorted.
`derived_viewport_indices` contains indices for the current page,
while `derived_virtual_indices` contains indices across all pages.}

\item{derived_virtual_row_ids}{List of character | numerics. `derived_virtual_row_ids` indicates the row IDs in the order in which
they appear after being filtered and sorted.
`derived_viewport_row_ids` contains IDs for the current page,
while `derived_virtual_row_ids` contains IDs across all pages.}

\item{derived_virtual_selected_rows}{List of numerics. `derived_virtual_selected_rows` represents the indices of the
 `selected_rows` from the perspective of the `derived_virtual_indices`.}

\item{derived_virtual_selected_row_ids}{List of character | numerics. `derived_virtual_selected_row_ids` represents the IDs of the
`selected_rows` as they appear after filtering and sorting,
across all pages.}

\item{loading_state}{Lists containing elements 'is_loading', 'prop_name', 'component_name'.
those elements have the following types:
  - is_loading (logical; optional): determines if the component is loading or not
  - prop_name (character; optional): holds which property is loading
  - component_name (character; optional): holds the name of the component that is loading. Object that holds the loading state object coming from dash-renderer}

\item{persistence}{Logical | character | numeric. Used to allow user interactions in this component to be persisted when
the component - or the page - is refreshed. If `persisted` is truthy and
hasn't changed from its previous value, any `persisted_props` that the
user has changed while using the app will keep those changes, as long as
the new prop value also matches what was given originally.
Used in conjunction with `persistence_type` and `persisted_props`.}

\item{persisted_props}{List of a value equal to: 'columns.name', 'data', 'filter_query', 'hidden_columns', 'selected_columns', 'selected_rows', 'sort_by's. Properties whose user interactions will persist after refreshing the
component or the page.}

\item{persistence_type}{A value equal to: 'local', 'session', 'memory'. Where persisted user changes will be stored:
memory: only kept in memory, reset on page refresh.
local: window.localStorage, data is kept after the browser quit.
session: window.sessionStorage, data is cleared once the browser quit.}
}

\value{named list of JSON elements corresponding to React.js properties and their values}

\examples{
# For comprehensive documentation of this package's features,
# please consult https://dashr.plot.ly/datatable
#
# A package vignette is currently in development and will
# provide many of the same examples currently available online
# in an offline-friendly format.

# The following if statement is not required to run this
# example locally, but was added at the request of CRAN
# maintainers.
if (interactive() && require(dash)) {
  library(dash)

  app <- Dash$new()

  # We can easily restrict the number of rows to display at
  # once by using style_table:
  app$layout(
    dashDataTable(
      id = "table",
      columns = lapply(colnames(iris),
                       function(colName){
                         list(
                           id = colName,
                           name = colName
                         )
                       }),
      style_table = list(
        maxHeight = "250px",
        overflowY = "scroll"
      ),
      data = df_to_list(iris)
    )
  )

  app$run_server()

  app <- Dash$new()

  # We can also make rows and columns selectable/deletable
  # by setting a few additional attributes:
  app$layout(
    dashDataTable(
      id = "table",
      columns = lapply(colnames(iris),
                       function(colName){
                         list(
                           id = colName,
                           name = colName,
                           deletable = TRUE
                         )
                       }),
      style_table = list(
        maxHeight = "250px",
        overflowY = "scroll"
      ),
      data = df_to_list(iris),
      editable = TRUE,
      filter_action = "native",
      sort_action = "native",
      sort_mode = "multi",
      column_selectable = "single",
      row_selectable = "multi",
      row_deletable = TRUE
    )
  )

  app$run_server()
}
}
