% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-advanced.R
\name{callback_context}
\alias{callback_context}
\title{In addition to event properties like n_clicks that change whenever an event
happens there is a global variable dash$callback_context, available only
inside a callback. It has properties:}
\usage{
callback_context()
}
\description{
\code{triggered}: list of changed properties. This will be empty on initial load,
unless an input prop got its value from another initial callback. After a user
action it is a length-1 list, unless two properties of a single component
update simultaneously, such as a value and a timestamp or event counter.
}
\details{
\code{inputs} and \code{states}: allow you to access the callback params by id and prop
instead of through the function arguments.
}
\examples{
if (interactive()) {
    dash_app() \%>\%
      set_layout(
        button('Button 1', id='btn1'),
        button('Button 2', id='btn2'),
        button('Button 3', id='btn3'),
        div(id='container')
      ) \%>\%
      add_callback(
        output("container", "children"),
        list(
          input("btn1", "n_clicks"),
          input("btn2", "n_clicks"),
          input("btn3", "n_clicks")
        ),
        function(btn1, btn2, btn3) {
          ctx <- callback_context()
          prevent_update(is.null(ctx))
          sprintf("Triggered: \%s, btn1: \%s, btn2: \%s, btn3: \%s",
                  ctx$triggered$prop_id, btn1, btn2, btn3)
        }
      ) \%>\%
      run_app()
  }
}
