% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{add_script}
\alias{add_script}
\title{Add external (JavaScript) scripts to a Dash app}
\usage{
add_script(app, script)
}
\arguments{
\item{app}{A dash application created with \code{\link[=dash_app]{dash_app()}}}

\item{script}{A single script or a list of scripts. Each script is either
a string (the URL), or a named list with \code{src} (the URL) and any other valid
\verb{<script>} tag attributes. See examples below.
Note that this is only used to add \strong{external} scripts, not local.}
}
\description{
Add external (JavaScript) scripts to a Dash app
}
\examples{
app <- dash_app()

# Add a single script with URL
app \%>\% add_script("https://stackpath.bootstrapcdn.com/bootstrap/4.4.0/js/bootstrap.min.js")

# Add multiple scripts with URL
app \%>\% add_script(list(
  "https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js",
  "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"
))

# Add a single script with a list
app \%>\% add_script(
  list(
    href = "https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js",
    integrity = "sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
  )
)

# Add multiple scripts with both URL and list
app \%>\% add_script(
  list(
    "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js",
    "https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js",
    list(
      href = "https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js",
      integrity = "sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6"
    )
  )
)
}
