% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{add_meta}
\alias{add_meta}
\title{Add \verb{<meta>} tags to a Dash app}
\usage{
add_meta(app, meta)
}
\arguments{
\item{app}{A dash application created with \code{\link[=dash_app]{dash_app()}}.}

\item{meta}{A single meta tag or a list of meta tags. Each meta tag is a
named list with two elements representing a meta tag. See examples below.}
}
\description{
Add \verb{<meta>} tags to a Dash app
}
\examples{
app <- dash_app()

# Add a single meta tag
app \%>\% add_meta(list(name = "description", content = "My App"))

# Add multiple meta tags
app \%>\% add_meta(list(
  list(name = "keywords", content = "dash, analysis, graphs"),
  list(name = "viewport", content = "width=device-width, initial-scale=1.0")
))
}
