import { createFlappyAgent, ChatGPT, createCodeInterpreter } from '@pleisto/node-flappy'
import OpenAI from 'openai'

const gpt35 = new ChatGPT(
  new OpenAI({
    apiKey: process.env.OPENAI_API_KEY!,
    baseURL: process.env.OPENAI_API_BASE!
  })
)

const agent = createFlappyAgent({
  llm: gpt35,
  features: [createCodeInterpreter(undefined, { enableNetwork: false })]
})

void agent.executePlan(
  'There are some rabbits and chickens in a barn. What is the number of chickens if there are 396 legs and 150 heads in the barn?'
)

// void agent.callFeature('pythonSandbox', {
//   code: `There are some rabbits and chickens in a barn.
//   What is the number of chickens if there are 396 legs and 150 heads in the barn?`
// })
