# Pleisto Security Policy

Pleisto takes the security of our software products and services seriously. If you believe you have found a security vulnerability in any Pleisto-owned repository, please report it to us as described below.

## Supported Versions

Use this section to tell people about which versions of your project are currently being supported with security updates.

| Version | Supported          |
| ------- | ------------------ |
| 0.x     | :white_check_mark: |

## Bug Bounty Program

If your vulnerability report affects our product or service, you may receive a bounty award according to the program descriptions.

Bounties generally range from **50-1,000 USD** depending on the severity of the bug. Due to the complexity of cross-border payments, if Pleisto Inc. does not have a bank account in the country or region where you live, we may use an Amazon Gift Card or other stored-value cards instead of a cash reward.

### How severity is determined

Pleisto reserves the right to make a final decision regarding the severity of a reported finding. Upon receipt of the finding, we will conduct an internal investigation and determine the severity of the finding by considering multiple factors including but not limited to:

- Common Vulnerability Scoring System
- The quantity of affected users and data
- The difficulty in exploiting
- Other, if any, mitigating factors or exploit scenario requirements

While we try to be as consistent as possible with rewards, our program is also evolving, and rewards may change accordingly to how our program becomes with time.

## Reporting a Vulnerability

**Please do not report security vulnerabilities through public GitHub issues.**

Instead, please report them to `secure@pleisto.com` to report any security vulnerabilities.If possible, encrypt your message with our PGP key;

```base64
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=oh8D
-----END PGP PUBLIC KEY BLOCK-----
```

You should receive a response within 36 hours. If the issue is confirmed, we will release a patch as soon as possible depending on complexity but historically within a few days.

Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:

- Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
- Full paths of source file(s) related to the manifestation of the issue
- The location of the affected source code (tag/branch/commit or direct URL)
- Any special configuration required to reproduce the issue
- Step-by-step instructions to reproduce the issue
- Proof-of-concept or exploit code (if possible)
- Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.

## Preferred Languages

We prefer all communications to be in English or Chinese.

## Comments on this Policy

If you have suggestions on how this process could be improved please submit a pull request.
