# Generated by Django 3.0 on 2020-02-07 08:10

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('user_app', '0003_achievement'),
    ]

    operations = [
        migrations.AlterField(
            model_name='achievement',
            name='color',
            field=models.CharField(default='ffffff', max_length=6, validators=[django.core.validators.RegexValidator(code='invalid_color', message='Provide color as six hexadecimal digits.', regex='^[0-9a-f]{6}$')]),
        ),
        migrations.AlterField(
            model_name='achievement',
            name='icon_class',
            field=models.TextField(validators=[django.core.validators.RegexValidator(code='invalid_icon_class', message='Invalid font-awesom icon class', regex='^(fas|far|fal|fab|fad|) fa-[-\\w]+$')]),
        ),
        migrations.CreateModel(
            name='AcquiredAchievement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('acquired_at', models.DateTimeField(auto_now_add=True)),
                ('achievement', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='acquired_achievements', to='user_app.Achievement')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='acquired_achievements', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'achievement')},
            },
        ),
    ]
