# Generated by Django 3.0 on 2020-01-21 03:02

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('activity_quiz', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('text', models.TextField()),
                ('hint', models.TextField(blank=True, null=True)),
                ('solution', models.TextField(blank=True, null=True)),
                ('order', models.PositiveIntegerField(db_index=True, default=0)),
                ('shuffle', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.RemoveField(
            model_name='activityquiz',
            name='text',
        ),
        migrations.CreateModel(
            name='SingleChoiceQuestion',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='activity_quiz.Question')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('activity_quiz.question',),
        ),
        migrations.AddField(
            model_name='question',
            name='activity',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='activity_quiz.ActivityQuiz'),
        ),
        migrations.AddField(
            model_name='question',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_activity_quiz.question_set+', to='contenttypes.ContentType'),
        ),
        migrations.CreateModel(
            name='SingleChoiceAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
                ('correct', models.BooleanField()),
                ('order', models.PositiveIntegerField(db_index=True, default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='activity_quiz.SingleChoiceQuestion')),
            ],
        ),
    ]
