---
layout: home

hero:
  name: "GPUPixel"
  text: "GPU-based Realtime AI Beauty Filter Library"
  tagline: 'High Performance, Cross-Platform'
  image:
      src: /gpupixel-logo-large.svg
      alt: cover
  actions:
    - theme: brand
      text: Get Started
      link: /guide/intro
    - theme: alt
      text: GitHub
      link: https://github.com/pixpark/gpupixel

features:
  - icon: 🤹‍♀️
    title: Beauty Filters
    details: Built-in filters like whitening, smoothing, face slimming, big eyes, lipstick, and blush
  - icon: ⚙
    title: High Performance
    details: Written in C++11 and based on OpenGL/ES, real-time high performance, suitable for live streaming and WebRTC
  - icon: 📱
    title: Cross-Platform
    details: Full platform support -> iOS, Android, Mac, Windows, Linux, etc.
  - icon: 🌇
    title: Input and Output
    details: Supports multiple formats like YUV and RGBA for input and output, with input sources including camera video and images
  - icon: 🧚‍♀️
    title: Filter Combinations
    details: Filters can be chained together to achieve complex processing effects
  - icon: 🧸
    title: Custom Filters
    details: Simple architecture, clear logic, easy to extend with custom filters
---

