# YL-800N

By default, the module is in the "hexadecimal command" mode.



## Hex command mode

### Hex frame structure

In sending order.

| Nb bytes    | Name            | Description                                                  |
| ----------- | --------------- | ------------------------------------------------------------ |
| 1           | Frame type      | - 01: Module configuration<br />- 02: MAC layer testing<br />- 03: NET layer testing<br />- 04: Debug information<br />- 05: Application data |
| 1           | Sequence number | Not enabled, fixed to 00.                                    |
| 1           | Command type    | Check command type table                                     |
| 1           | Payload length  | Up to 128 bytes                                              |
| n (varying) | Payload         |                                                              |
| 1           | Checksum        |                                                              |



#### Command type table

| Frame type              | Request code | Response code | Description                                      |
| ----------------------- | :----------: | :-----------: | ------------------------------------------------ |
| 01 Module configuration |      01      |      81       | Write configuration information request/response |
| 01 Module configuration |      02      |      82       | Read configuration information request/response  |
| 01 Module configuration |      06      |      86       | Read version information request/response        |
| 01 Module configuration |      07      |      87       | Module reset request/response                    |




| Frame type           | Request code | Response code | Description                                |
| -------------------- | :----------: | :-----------: | ------------------------------------------ |
| 04 Debug information |      01      |      81       | Write access control list request/response |
| 04 Debug information |      02      |      82       | Read access control list request/response  |



| Frame type          | Request code | Response code | Description                               |
| ------------------- | :----------: | :-----------: | ----------------------------------------- |
| 05 Application data |      01      |      81       | Application data sending request/response |
| 05 Application data |      -       |      82       | Application data reception instructions   |
| 05 Application data |      08      |      88       | Source route discovery request/response   |



### Write configuration frame structure

In sending order.

| Nb bytes | Name               | Description                                                  |
| :------: | ------------------ | ------------------------------------------------------------ |
|    2     | Configuration flag | `A5 A5`                                                      |
|    1     | Channel            | 0=431M, 1= 432M, 2=429M, 3=433M, 4=436M, 5=434M, 6=437M, 7 =435M |
|    1     | TX power           | 0=20dBm, 1=17dBm, 2=15dBm, 3=13dBm, 4=11dBm, 5=9dBm, 6=7dBm, 7=5dBm |
|    1     | User mode          | 0=hexadecimal, 1=transparent                                 |
|    1     | Role               | 0=slave, 1=master                                            |
|    2     | Network flag       | 0000 - FFFE (reverse MSB and LSB in the command)             |
|    2     | Node flag          | 0000 - FFFE (reverse MSB and LSB in the command)             |
|    3     | Reserved           |                                                              |
|    1     | Serial parameters  | Check the serial parameters table                            |
|    1     | Bandwidth          | 7 - 9 (Check the bandwidth and spread factor table) *        |
|    1     | Spread factor      | 7 - 12 (Check the bandwidth and spread factor table) *       |

\*The default signal bandwidth is 9, and the spreading factor is 9, which is equivalent to the over-the-air rate of 7.032kbps. It is recommended to use the default over-the-air rate, otherwise it will easily cause network instability.

#### Serial parameters table

| Bit (size) | Name        | Description                                                  |
| :--------: | ----------- | ------------------------------------------------------------ |
| 4 - 7 (4)  | Baudrate    | 1=1200, 2=2400, 3=4800, 4=9600 (default), 5=14400, 6=19200, <br />7=28800, 8=38400, 9=57600, 10=76800, 11=115200, 12=230400 |
|   3 (1)    | Reserved    |                                                              |
| 1 - 2 (2)  | Parity bits | 0=no parity, 1=odd parity, 2=even parity                     |
|   0 (1)    | Stop bits   | 0=1-bit stop bit, 1=2-bit stop bit                           |



#### Bandwidth and spread factor table

Over-the-air rate in kbps

| Spread factor \ Bandwidth |   7   |   8   |      **9**       |
| ------------------------: | :---: | :---: | :--------------: |
|                         7 | 5.47  | 10.94 |      21.88       |
|                         8 | 3.125 | 6.25  |       12.5       |
|                     **9** | 1.758 | 3.516 | <u>**7.032**</u> |
|                        10 | 0.977 | 1.954 |      3.908       |
|                        11 | 0.537 | 1.074 |      2.148       |
|                        12 | 0.293 | 0.586 |      1.172       |



Read configuration request: `01 00 02 00 03`

Example result: `01 00 82 10 A5 A5 01 00 00 01 00 00 00 00 00 00 03 40 09 09 D0`



## Application data frame structure

In sending order.

| Nb bytes | Name                          |                                                              |
| -------- | ----------------------------- | ------------------------------------------------------------ |
| 2        | Target address                | FFFF-FFFE, FFFF is the broadcast address (MSB and LSB must be inverted when sending) |
| 1        | Application layer ACK request | - 00: Not using APS protocol<br />- 01: Using APS protocol layer end-to-end<br />Should not use when the application layer has a response from the application device on the opposite end. |
| 1        | Send radius                   | Max. number of hops for data forwarding. (Default is 7)      |
| 1        | Discovery routing parameters  | - 0: Disable route discovery<br />- 1: Automatic route discovery<br />- 2: Forced route discovery<br />- 3: Use the source route |
| 1        | Number of relays N            | (Exists only if "source route" is used)                      |
| 2*N      | List of relays                | (Exists only if "source route" is used)                      |
| 1        | Data length                   |                                                              |
| Varying  | User data                     |                                                              |



# Resources

- http://www.rf-module.cn/uploads/YL-800N.pdf