# Contributing

## Setup

This project uses [PNPM](https://pnpm.js.org/) for package management. Please make sure you have it installed before proceeding.

1. Fork the repo and create your branch from `main`.
2. Run `pnpm install` in the repository root.
3. Run `pnpm dev` to start the development server.
5. Make your changes!

## Linting and Type Checking

This project uses [ESLint](https://eslint.org/) and [TypeScript](https://www.typescriptlang.org/) for linting and type checking, respectively. Please make sure your code passes both before submitting a PR.

```bash
pnpm run lint
pnpm run test
```

## Commit Message Format

This project follows the [Conventional Commits](https://www.conventionalcommits.org/) specification. Please make sure your commit messages are formatted correctly.

**Please mention the issue number in the commit message or the PR description.**
