#ifndef INTERRUPT_H
#define INTERRUPT_H

#include "portability.h"

void interrupt(unsigned int);
void interrupt_disable(void);
void interrupt_enable(void);
unsigned char interrupt_get_IF(void);
void interrupt_set_IF(unsigned char);
unsigned char interrupt_get_mask(void);
void interrupt_set_mask(unsigned char);
void interrupt_flush(void);
unsigned short interrupt_vector_for(int);
int interrupt_get_enabled(void);
int interrupt_pending(void);

enum {
	INTR_VBLANK  = 0x01,
	INTR_LCDSTAT = 0x02,
	INTR_TIMER   = 0x04,
	INTR_SERIAL  = 0x08,
	INTR_JOYPAD  = 0x10
};
#endif
