#!/usr/bin/perl

use strict;
use File::Basename qw/basename dirname/;

sub constant($$) {
    # The maximum length of a string literal is 509 characters in C89.
    # That is why src is split into short strings.
    my ($var, $src) = @_;
    print "static const char ${var}[][80] = {\n";
    my @lines = $src =~ /.{0,80}/gs;
    foreach (@lines) {
        s/\\/\\\\/g;
        s/"/\\"/g;
        s/\n/\\n/g;
        print "\"$_\",\n";
    }
    print "};\n\n";
}

print <<EOL;
/**
 *                                !!NOTICE!!
 * This file was automatically generated by mkloader.pl, and includes all of
 * the prelude files required by Picrin. PLEASE DO NOT EDIT THIS FILE, changes
 * will be overwritten the next time the script runs.
 */

#include "picrin.h"
#include "picrin/extra.h"

EOL

foreach my $file (@ARGV) {
    my $var = &escape_v($file);

    open IN, $file;
    local $/ = undef;
    my $src = <IN>;
    close IN;

    constant($var, $src);
}

print <<EOL;
void
pic_load_piclib(pic_state *pic)
{
  pic_value e;

EOL

foreach my $file (@ARGV) {
    print <<EOL;
  pic_try {
EOL
    my $var = &escape_v($file);
    my $basename = basename($file);
    my $dirname = basename(dirname($file));
    print "    pic_load_cstr(pic, &${var}[0][0]);\n";
    print<<EOL
  }
  pic_catch(e) {
    /* error! */
    pic_fputs(pic, "fatal error: failure in loading $dirname/$basename\\n", pic_stderr(pic));
    pic_raise(pic, e);
  }
EOL
}

print <<EOL;
}
EOL

sub escape_v {
    ($_) = @_;
    s/\.scm$//g;
    s/[^[A-Za-z0-9_]/_/g;
    "piclib_src_" . $_;
}
