# SPDX-FileCopyrightText: 2016-2022 by pi-lar GmbH
# SPDX-License-Identifier: OSL-3.0

# generated by datamodel-codegen:
#   filename:  flavor.schema.json
#   timestamp: 2024-08-29T09:54:13+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class GPU(BaseModel):
    GPUModel: Optional[str] = Field(
        None, description="The model of the GPU offered for the specific Flavor."
    )
    GPUCores: Optional[int] = Field(
        None, description="The number of GPU cores advertised by the Flavor."
    )


class Characteristics(BaseModel):
    architecture: Optional[str] = Field(None, description="Architecture of the Flavor.")
    OS: Optional[str] = Field(
        None, description="The Operating System of the advertised VM"
    )
    CPU: Optional[int] = Field(None, description="Number of CPU cores of the Flavor.")
    Memory: Optional[int] = Field(None, description="Amount of RAM of the Flavor.")
    gpu: Optional[GPU] = Field(None, description="GPU characteristics of the Flavor.")
    Storage: Optional[int] = Field(None, description="The amount of storage")


class CarbonFootprint(BaseModel):
    Embodied: Optional[int] = Field(
        None,
        description="Embodied carbon of the node hardware normalized by its expected lifetime.",
    )
    Operational: Optional[List] = Field(
        None,
        description="Forecasted average carbon intensity of the node for the next N windows/hours.",
    )


class Properties(BaseModel):
    latency: Optional[int] = Field(None, description="The latency of the Flavor.")
    securityStandards: Optional[List[str]] = Field(
        None, description="Security standards supported by the Flavor (e.g., GDPR)."
    )
    carbonFootprint: Optional[CarbonFootprint] = None


class Aggregatable(BaseModel):
    MinCount: Optional[int] = Field(
        None, description="Minimum required number of instances of the Flavor."
    )
    MaxCount: Optional[int] = Field(
        None, description="Maximum required number of instances of the Flavor."
    )


class Policy(BaseModel):
    aggregatable: Optional[Aggregatable] = None


class VMSchema(BaseModel):
    characteristics: Optional[Characteristics] = None
    properties: Optional[Properties] = None
    policy: Optional[Policy] = None
