# SPDX-FileCopyrightText: 2016-2022 by pi-lar GmbH
# SPDX-License-Identifier: OSL-3.0

# generated by datamodel-codegen:
#   filename:  flavor.schema.json
#   timestamp: 2024-08-29T09:54:13+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import BaseModel, Field


class AdditionalProperties(BaseModel):
    MeasurementUnit: Optional[str] = Field(
        None, description="The unit of measure for the measurements"
    )
    ConsumptionUnit: Optional[str] = Field(
        None, description="The unit of measure for the sensor power consumption"
    )
    SamplingRateUnit: Optional[str] = Field(
        None, description="The unit of measure for the sampling rate"
    )
    AccessProtocol: Optional[str] = Field(None, description="Not sure what that means")


class Characteristics(BaseModel):
    SensorType: Optional[str] = Field(None, description="The type of sensor")
    SensorModel: Optional[str] = Field(None, description="The model of sensor")
    SensorManufacturer: Optional[str] = Field(
        None, description="The manufacturer of sensor"
    )
    SensorMarket: Optional[str] = Field(None, description="The market of sensor")
    SamplingRate: Optional[int] = Field(
        None, description="The sampling rate of the sensor in milliseconds"
    )
    Accuracy: Optional[int] = Field(
        None, description="The accuracy reported for the measurements (unit percentage)"
    )
    Consumption: Optional[int] = Field(
        None, description="The power consumption of the reported sensor (unit mW)"
    )
    Interface: Optional[str] = Field(None, description="Not clear what that means.")
    SecurityStandards: Optional[List[str]] = Field(
        None, description="Security standards supported by the Flavor (e.g., GDPR)."
    )
    Latency: Optional[int] = Field(None, description="The latency of the Flavor.")
    additionalProperties: Optional[AdditionalProperties] = Field(
        None, description="Additional properties of the sensor"
    )


class AccessType(BaseModel):
    method: Optional[List[str]] = Field(None, description="HTTP method supported.")


class AccessTypeModel(BaseModel):
    QoS: Optional[str] = None


class SensorSchema(BaseModel):
    characteristics: Optional[Characteristics] = None
    accessType: Optional[Union[AccessType, AccessTypeModel]] = Field(
        None,
        description="The access type of the sensor. Currently, HTTP and MQTT are supported.",
    )
