# SPDX-FileCopyrightText: 2016-2022 by pi-lar GmbH
# SPDX-License-Identifier: OSL-3.0

# generated by datamodel-codegen:
#   filename:  flavor.schema.json
#   timestamp: 2024-08-29T09:54:13+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import BaseModel, Field


class PodItem(BaseModel):
    key: Optional[str] = None
    value: Optional[str] = None


class NamespaceItem(BaseModel):
    key: Optional[str] = None
    value: Optional[str] = None


class ResourceSelector(BaseModel):
    pod: Optional[List[PodItem]] = Field(
        None, description="one or many key-value pairs.", min_items=1
    )
    namespace: Optional[List[NamespaceItem]] = Field(
        None, description="one or many key-value pairs.", min_items=1
    )


class Source(BaseModel):
    isHostCluster: Optional[bool] = Field(
        None, description="The source is in the host cluster"
    )
    resourceSelector: Optional[Union[ResourceSelector, str]] = Field(
        None, description="Selector for the source"
    )


class Destination(BaseModel):
    isHostCluster: Optional[bool] = Field(
        None, description="The destination is in the host cluster"
    )
    resourceSelector: Optional[Union[ResourceSelector, str]] = Field(
        None, description="Selector for the destination"
    )


class NetworkIntentSchema(BaseModel):

    name: str = Field(..., description="The identifier of the network intent")
    source: Source = Field(..., description="The source of the communication")
    destination: Destination = Field(
        ..., description="The destination of the communication"
    )
    destinationPort: str = Field(
        ..., description="The destination port of the communication"
    )
    protocolType: str = Field(..., description="The protocol type of the communication")
