# SPDX-FileCopyrightText: 2016-2022 by pi-lar GmbH
# SPDX-License-Identifier: OSL-3.0

# generated by datamodel-codegen:
#   filename:  flavor.schema.json
#   timestamp: 2024-08-29T09:54:13+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Field

from .k8slice import K8SliceSchema as K8SSchema
from .sensor import SensorSchema
from .service import SensorSchema as ServiceSchema
from .vm import VMSchema
from .additional_information import AdditionalInformation


class Location(BaseModel):

    latitude: Optional[str] = Field(None, description="Latitude of the location")
    longitude: Optional[str] = Field(None, description="Longitude of the location")
    country: Optional[str] = Field(None, description="Country of the location")
    city: Optional[str] = Field(None, description="City of the location")
    additionalNotes: Optional[str] = Field(
        None, description="Additional notes about the location"
    )


class Name(Enum):
    k8slice = "k8slice"
    vm = "vm"
    service = "service"
    sensor = "sensor"


class Price(BaseModel):

    amount: str = Field(..., description="Amount of the price.")
    currency: str = Field(..., description="Currency of the price.")
    period: str = Field(..., description="Period of the price.")


class Owner(BaseModel):

    domain: str = Field(..., description="Domain of the node.")
    nodeId: str = Field(..., description="ID of the node.")
    ip: str = Field(..., description="IP of the node.")
    additionalInformation: Optional[AdditionalInformation] = Field(
        None, description="Additional information about the node."
    )


class FlavourType(BaseModel):
    name: Optional[Name] = Field(
        None, description="The name of the type of the Flavor."
    )
    data: Optional[Union[K8SSchema, VMSchema, ServiceSchema, SensorSchema]] = Field(
        None,
        description="A reference to a specific flavor type schema using JSON references ($ref) to external files like 'k8slice.json', 'vm.json', etc. This allows defining details specific to each flavor type.",
    )


class Flavor(BaseModel):
    flavorId: str = Field(..., description="The unique identifier for a flavor")
    providerId: str = Field(..., description="The unique identifier for a provider")
    timestamp: str = Field(
        ...,
        description="Timestamp of the provided Flavor offer. It allows to advertise Flavors in the (near) future",
    )
    location: Optional[Location] = Field(None, description="Location of the Flavor")
    networkPropertyType: Optional[str] = Field(
        None,
        description="Type of network property ensured by the provider (e.g., 5G, Wifi, Ethernet)",
    )
    flavourType: FlavourType
    price: Price = Field(..., description="Price of the Flavor.")
    owner: Owner = Field(..., description="Owner of the Flavor.")
    availability: bool = Field(..., description="Availability flag of the Flavor.")
