# SPDX-FileCopyrightText: 2016-2024 by pi-lar GmbH
# SPDX-License-Identifier: OSL-3.0

"""
To evaluate the .puml file generated by this script use www.plantuml.com/plantuml
"""

from pathlib import Path
import re
import os
import subprocess
import plantuml
from puml import make_svg

r = re.compile(
    r"NP_UTIL_STATEMACHINE_TRANSITION\(\s*(?P<MACHINE>[a-zA-Z0-9\"\-_]+)\s*,\s*(?P<SOURCE_STATE>[a-zA-Z0-9\"\-_]+)\s*,\s*(?P<TARGET_STATE>[a-zA-Z0-9\"\-_]+)\s*,\s*(?P<ACTION>[a-zA-Z0-9\"\-_]+)\s*,\s*(?P<CONDITION>[a-zA-Z0-9\"\-_]+)\s*\)"
)

with open(
    os.path.join(Path(__file__).parent.absolute(), "..", "src", "np_key.c"), "r"
) as f:
    t = f.read()

res = {}
for ele in r.finditer(t):
    ss = ele.group("SOURCE_STATE")
    if ss not in res:
        res[ss] = []

    res[ss].append(
        {
            "target": ele.group("TARGET_STATE"),
            "cond": ele.group("CONDITION").replace("_", " ").strip(),
            "action": ele.group("ACTION").replace("_", " ").strip(),
        }
    )

puml = "@startuml\n\n"
puml += "[*] --> UNUSED\n"

for k, v in res.items():
    for ve in v:
        if k != ve["target"]:
            puml += f"{k} --> {ve['target']}"
            if ve["cond"] and ve["cond"].upper() != "NULL":
                puml += f": {ve['cond']}"
            puml += "\n"
        else:
            if ve["cond"] and ve["cond"].upper() != "NULL":
                puml += f"{k} : {ve['cond']}\n"
                puml += f"{k} :  -> {ve['action']}\n"


puml += "IN_DESTROY --> [*]\n"
puml += "@enduml\n"

make_svg(puml, "states.puml")
