# Introduction

### First off, thank you for considering contributing to the neuropil-ldtsa project. 

It's people like you that can help us to create great tool for the de-centralized internet. 

### Why you should read these guidelines.

Following our guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, they should reciprocate that respect in addressing your issue, assessing changes, and helping you finalize your pull requests.

### Explain what kinds of contributions you are looking for.

Keep an open mind! Improving documentation, bug triaging, or writing tutorials are all examples of helpful contributions that mean less work for you.

neuropil(-ldtsa / -dtma) is an open source project and we love to receive contributions from our community — you! 
There are many ways to contribute, from reviewing drafts and ideas to writing tutorials or blog posts, improving the documentation, 
submitting bug reports and feature requests or writing code which can be incorporated into neuropil-ldtsa itself.

Please, don't use the issue tracker for support questions or questions not related to the outcome of this project. 
For any off-topic questions please check whether there are IRC channels out there, Stack Overflow is also worth considering.

# Ground Rules
### Set expectations for behavior (yours, and theirs).

Responsibilities
 * Ensure cross-platform compatibility for every change that's accepted. Windows, Mac, Debian & Ubuntu Linux.
 * Create issues for any major changes and enhancements that you wish to make. Discuss things transparently and get community feedback.
 * Keep feature versions as small as possible, preferably one new feature per version.
 * Be welcoming to newcomers and encourage diverse new contributors from all backgrounds. See our [Code of Conduct](https://gitlab.com/pi-lar/neuropil-ldtsa/-/blob/main/CODE_OF_CONDUCT.md).
 * We may start an new repository for your preferred programming language at any time. 
 * The protocol repositories should contain only the specifications and the bare minimum of code needed

# Your First Contribution

Unsure where to begin contributing to neuropil (-ldtsa / -dtma) ? 

You can start by looking through these beginner and help-wanted issues:
Use Cases - issues which refine our use cases and help us to understand our goal better
Documentation issues - issues which help us to document our project and our goals in the precise way it is needed
Technical issues - issues which document technical details. Looking from cybersecurity, each details can make a difference.
Examples - in our repository you will find examples: run a node and experiment with it. Improve it or send us feedback!

All issue lists are sorted by total number of comments. While not perfect, number of comments is a reasonable proxy for impact a given change will have.

### Bonus points: Add a link to a resource for people who have never contributed to open source before.

Working on your first Pull Request? You can learn how from this *free* series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

At this point, you're ready to make your changes! Feel free to ask for help; everyone is a beginner at first :smile_cat:

If a maintainer asks you to "rebase" your PR, they're saying that a lot of code has changed, and that you need to update your branch so it's easier to merge.

# Getting started

### A quick walkthrough of how to submit a contribution.
How you write this is up to you, but some things you may want to know:

* All commits to this repository will be treated as Academic Free License (AFL 3.0) as a contributor license. If possible, please add the following sentence to your own copyright notice: `Licensed to neuropil cybersecurity mesh project under the Academic Free License (AFL 3.0)`.
* For now all issues will be handled in Gitlab, our Github repositories contains the mirror  

For something that is bigger than a one or two line fix:

1. Create your own fork of the code
2. Do the changes in your fork
3. If you like the change and think the project could use it:
    * Be sure you have followed the code style for the project
    * send a pull reuqest stating that the code can be added under the Academic Free License (AFL 3.0)
    * note the neuropil Foundation Code of Conduct
4. As we plan to move to everything to a foundation, the following steps could become neccessary
    * Sign the Contributor License Agreement, CLA, with the neuropil Foundation.
    * Send a pull request indicating that you have a CLA on file.


### If you have a different process for small or "obvious" fixes, let them know.

Small contributions such as fixing spelling errors, where the content is small enough to not be considered intellectual property, can be submitted by a contributor as a patch, without a CLA.

As a rule of thumb, changes are obvious fixes if they do not introduce any new functionality or creative thinking. As long as the change does not affect functionality, some likely examples include the following:
* Spelling / grammar fixes
* Typo correction, white space and formatting changes
* Comment clean up
* Bug fixes that change default return values or error codes stored in constants
* Adding logging messages or debugging output
* Changes to ‘metadata’ files like Gemfile, .gitignore, build scripts, etc.

# How to report a bug
### Explain security disclosures first!

If you find a security vulnerability, do NOT open an issue. Email marvin@neuropil.org instead. 
Marvin is very security obsessed and is keen to hear your opinion (PGP public key will be added)

In order to determine whether you are dealing with a security issue, ask yourself these questions:
* Can I access something that's not mine, or something I shouldn't have access to?
* Can I disable something for other people?

If the answer to either of those questions are "yes", then you're probably dealing with a security issue. 
Note that even if you answer "no" to above questions, you may still be dealing with a security issue, so if you're unsure, just email us at marvin@neuropil.org

### Tell your contributors how to file a bug report.

When filing an issue, make sure to answer these five questions:

1. What version of protocol / implementation are you using?
2. What operating system and processor architecture are you using?
3. What did you do?
4. What did you expect to see?
5. What did you see instead?

# How to suggest a feature or enhancement
### If you have a particular roadmap, goals, or philosophy for development, share it here.

The neuropil project aimes to become a small component that can be integrated into bigger applications, devices or processes or OS.
Our main focus is rather to provide a reference implementation than a full application stack.

Thus you will not find fully fledged applications in our repository, but rather examples highligting specific use cases.
If you would like contribute a bigger application to the neuropil universe, the neuropil.com (tbd) and a separate repository 
is a better place to look at.

You can find a list of possible features or goals in our 'Roadmap' section at https://www.neuropil.org/tutorial/intro.html.
If you do not find these satisfactory, please reach out to eliza@neuropil.org for more.

### Explain your desired process for suggesting a feature.

If you find yourself wishing for a feature that doesn't exist in neuropil, you are probably not alone. 
There are bound to be others out there with similar needs. Many of the features that neuropil has today have been added because 
our users saw the need. Open an issue on our issues list on GitHub which describes the feature you would like to see, 
why you need it, and how it should work.


# Code review process
### Explain how a contribution gets accepted after it’s been submitted.

The core team looks at Pull Requests on a irregular basis upon requests. If more users join the project, we will 
set up regular governance calls to maintain a proper format for contributions.

After feedback has been given we expect responses within two weeks. 
After two weeks we may close the pull request if it isn't showing any activity.

# Community
If there are other channels you use besides GitHub to discuss contributions, mention them here. 
You can also list the author, maintainers, and/or contributors here, or set expectations for response time.

You can chat with the core team on https://neuropilworkspace.slack.com.
We try to look at the chat system in regular intervals during regular office hours of the week.

# BONUS: Code, commit message and labeling conventions
These sections are not necessary, but can help streamline the contributions you receive.

### Explain your preferred style for code, if you have any.
As security is very important for the project, please have a look at the output of the various toolset in the 
build pipeline. i.e. the c-code should compile without warnings (we have to work on it).

### Explain if you use any commit message conventions.
Please maintain a short, but meaningful description in your commit message that can appear/be used for the changelog as well!

### Explain if you use any labeling conventions for issues.

Please use the Academic Free License (AFL 3.0) as a contributor license.
If possible, please add the following sentence to your own copyright notice:

`Licensed to neuropil cybersecurity mesh project under the Academic Free License (AFL 3.0)`.
