# <img src="docs/images/ogcs128x128.png" valign="middle"> Outlook Google Calendar Sync

> Offers calendar synchronisation between Outlook and Google, including attendees and reminders.  
> Completely free, no install necessary, works behind web proxies and actively developed.

<p align="center"><b>:rotating_light: Not using OGCS yet? Get started <a href="https://phw198.github.io/OutlookGoogleCalendarSync/">over on the user site</a>. :rotating_light:</b></p>

### Continually Improving
<img src="docs/images/development.png" v
 align="left" width="100px"/> 
A lot of work has gone in to this project.  
If you would like to support me and further development of this tool, please [![donate](https://www.paypalobjects.com/en_GB/i/btn/btn_donate_SM.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=44DUQ7UT6WE2C&item_name=Outlook%20Google%20Calendar%20Sync%20donation.%20For%20splash%20screen%20hiding,%20enter%20your%20Gmail%20address%20in%20comment%20section)  
If you find a bug, [help squash it](https://github.com/phw198/OutlookGoogleCalendarSync/wiki/Reporting-Problems)! :lady_beetle:  


<a href="http://www.twitter.com/OGcalsync"><img src="docs/images/home_twitter_follow.png" align="center"></a> <a href="https://twitter.com/intent/tweet?original_referer=https%3A%2F%2Fabout.twitter.com%2Fresources%2Fbuttons&text=I%20just%20found%20this%20amazing%20free%20tool%20to%20sync%20Outlook%20and%20Google%20calendars&tw_p=tweetbutton&url=http%3A%2F%2Fbit.ly%2FOGcalsync&via=OGcalsync"><img src="docs/images/home_tweet.png" align="center"></a>

## Downloads & Statistics
:gear: [See the wiki](https://github.com/phw198/OutlookGoogleCalendarSync/wiki) for install, configuration guides and more.
### Latest Beta Release: [![Latest Release](https://img.shields.io/github/release/phw198/OutlookGoogleCalendarSync.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/latest) [![Latest Release downloads](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.0-beta/total.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/latest)

:floppy_disk: [Installer](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.0-beta/OGCS_Setup.exe)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.0-beta/OGCS_Setup.exe.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.0-beta/OGCS_Setup.exe)
 
:package: [Portable ZIP](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.0-beta/Portable_OGCS_v2.11.0.zip)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.0-beta/Portable_OGCS_v2.11.0.zip.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.0-beta/Portable_OGCS_v2.11.0.zip)

:information_source: Upgrades to this release  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.0-beta/OutlookGoogleCalendarSync-2.11.0-beta-full.nupkg.svg)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.0-beta/OutlookGoogleCalendarSync-2.11.0-beta-delta.nupkg.svg)

### Latest Alpha Release: [![Latest Release](https://img.shields.io/github/release/phw198/OutlookGoogleCalendarSync/all.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/tag/v2.11.1-alpha) [![Latest Release downloads](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.1-alpha/total.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/v2.11.1-alpha)

:floppy_disk: [Installer](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.1-alpha/OGCS_Setup.exe)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.1-alpha/OGCS_Setup.exe.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.1-alpha/OGCS_Setup.exe)

:package: [Portable ZIP](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.1-alpha/Portable_OGCS_v2.11.1.zip)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.1-alpha/Portable_OGCS_v2.11.1.zip.svg)](https://github.com/phw198/OutlookGoogleCalendarSync/releases/download/v2.11.1-alpha/Portable_OGCS_v2.11.1.zip)

:information_source: Upgrades to this release  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.1-alpha/OutlookGoogleCalendarSync-2.11.1-alpha-full.nupkg.svg)  
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![](https://img.shields.io/github/downloads/phw198/outlookgooglecalendarsync/v2.11.1-alpha/OutlookGoogleCalendarSync-2.11.1-alpha-delta.nupkg.svg)

## Functionality
- Supports all versions of Outlook from 2003 to 2021 64-bit! 
   - Including Microsoft365 releases from the [General Availability](https://learn.microsoft.com/en-us/windows/deployment/update/get-started-updates-channels-tools#general-availability-channel) channel
   - For "New Outlook", [check the latest developments](https://github.com/phw198/OutlookGoogleCalendarSync/issues/1881)
- Installable and portable options - even runs from a USB thumbdrive
- Synchronises items in any calendar folder, including those shared with you, from
   - Outlook :arrow_right: Google
   - Outlook :arrow_left: Google
   - Outlook :left_right_arrow: Google (two-way/bidirectional sync)
- Supports configuring multiple calendars for sync
- Includes the following calendar item attributes:
   - Subject
   - Description
   - Location
   - Attendees (including whether required or optional)
   - Reminder events
   - Availability (free/busy)
   - Privacy (public/private)
   - Colour / category (custom mappings supported)
- Exclude calendar items by:
   - Availability (free/tentative)
   - Privacy (private)
   - Title/subject
   - Outlook category
   - Google colour
- Differential comparison updates only attributes that have changed
- Customisable date range to synchronise, past and future
- Frequency of automatic syncs, including push-sync from Outlook
- Configurable proxy settings, or use Internet Explorer's
- Merge new events into existing on destination calendar
- Prompt on deletion of items
- Ability to obfuscate custom words for privacy/security
- Option to force items as public or private in target calendar
- Syncs recurring items properly as a series
- Can run unobtrusively in the system tray, with bubble notifications on sync
- Application can start on login, with delay if required

### Screenshots
![Screenshot1](docs/images/home_screen1.png)
![Screenshot2](docs/images/home_screen2.png)
![Screenshot3](docs/images/home_screen3.png)

<p align="right"><i>Previous <a href="https://outlookgooglecalendarsync.codeplex.com" target="_blank">Codeplex Project</a> site.</i></p>
