# PHP.earth exchange.

The PHP.earth exchange provides a means of bringing people and projects
together by encouraging collaboration. There are three main ways in which it
does this:

1. By providing an avenue by which project contributors, maintainers,
   advocates, et al can promote that they're actively seeking contributions
   from new contributors, whether it be by way of a quick "once over" by an
   additional set of eyes to look for bugs, possible improvements, ideas, and
   so forth, whether it be for creating new issues, for sending new pull
   requests, for writing reviews, audits, or otherwise.
2. By providing an avenue by which those looking for projects to contribute to,
   can find projects that are actively seeking contributions from new
   contributors, and which thus should be receptive to new contributors.
3. By encouraging collaboration between different people, across multiple
   different projects.

## How does it work?

How it works is actually really simple. :-)

### Listing a new project.

If you want to list a new project, search the repository first to ensure that
it hasn't already been listed before. After ensuring that it hasn't already
been listed before, [fork the repository](https://help.github.com/articles/fork-a-repo/)
to your own account.

After forking, find an appropriate category from the list below. Projects are
listed in different categories to keep everything more organised and easier to
find. If you don't see an appropriately listed category, you can use the
template to create a new category and add the new category to the category
list. Each category has a corresponding markdown file.

In your chosen category, use one of the already listed projects as an example
to add your own listing to the markdown file. Be sure to include the name of
the project, the address of the project repository, a description of the
project, and any other information relevant to the project, such as the types
of contributions you're looking for (in case you're looking for something very
specific).

After you've made your changes, send a [pull request](https://help.github.com/articles/creating-a-pull-request/)
back to this repository from your fork, and one of our team members will review
the pull request for merging.

Remember also, that the exchange operates on a "give and take" basis. Anyone is
welcome to list their projects, but if you're able to do so, please consider
also contributing back to other listed projects. If everyone operates on a
"take only" process (e.g., asking for help, but not offering anything in
return), then ultimately, nobody will end up benefitting at all.

#### Things which are NOT welcome:

- Anything illegal.
- Anything which violates copyright laws.
- Anything which violates human rights, dignity, freedom of expression, or
  human liberty, or which otherwise works against the betterment of humanity,
  or which is counterproductive towards our goal of being able to guarantee a
  welcoming, safe, inclusive, and harassment-free environment.

#### Things which ARE welcome:

Anything else. :-)

### Contributing to a project.

Firstly, find a category from the list below which matches the type of project
that you're wanting to contribute to. Click the link, and look through the
projects listed there.

Each listing should include any information that you'll need to begin
contributing towards that project. If it doesn't, go to the project address,
and check whether any contribution guidelines are included to learn more about
how to contribute towards that project.

Once you began contributing, you can sign your GitHub username as a contributor
to that project on its listing by forking this repository, adding your GitHub
username there, and sending a pull request back to this repository from your
fork.

It's as simple as that. :-)

## Categories.

- __[PHP projects.](/php.md)__
- [(A template to use for new categories)](/template.md)
