<?php
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: view.inc.php 3 2024-07-14 03:23:27Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/
include "includes/commons.inc.php";

//error_reporting(E_ALL ^E_WARNING ^E_NOTICE);
error_reporting(0);

$uid = (int) gpc('uid', 'GP', 0);
$token = trim(gpc('token', 'P', ''));
$uid = $uid ? $uid : (int) $_G['uid'];
$folder_id = (int) gpc('folder_id', 'P', 0);
$action = trim(gpc('action', 'P', ''));

$upload_log_fn = PHPDISK_ROOT . 'system/upload.error.php';

$server_oid = 0;//(int)get_server_oid();


if ($action == 'doupload') {
	//write_file($upload_log_fn,var_export($_POST,true).LF,'ab');
//write_file($upload_log_fn,var_export($_FILES,true).LF,'ab');
//exit;

	if ($token <> md5(md5($uid . $action . $settings['encrypt_key']))) {
		$str = $action . ' , token error!' . LF;
		write_file($upload_log_fn, '<?php exit;?>' . $str, 'ab');
		echo json_encode(array('success' => false, 'msg' => 'token error!'));
		exit;
	}

	if ($uid) {
		$set = DB::fetch_first("select settings from phpdisk_mini_myset where userid='$uid' limit 1");
		$myset = unserialize($set['settings']);
	}else{
		$str = $action . ' , UID error!' . LF;
		write_file($upload_log_fn, '<?php exit;?>' . $str, 'ab');
		echo json_encode(array('success' => false, 'msg' => 'uid error!'));
		exit;
	}

	$file = $_FILES['file'];

	$file_real_path = PHPDISK_ROOT . $settings['file_path'] . '/';
	$file_store_path = date('Y/m/d/');
	make_dir($file_real_path . $file_store_path);

	if (!is_utf8()) {
		$file['name'] = convert_str('utf-8', 'gbk', $file['name']);
	}
	$file_extension = get_extension($file['name']);
	$esp = strlen($file_extension) + 1;
	if ($file_extension) {
		$file_name = substr($file['name'], 0, strlen($file['name']) - $esp);
	} else {
		$file_name = $file['name'];
	}


	$file_real_name = md5(uniqid(mt_rand(), true) . microtime() . $uid);
	$file_ext = get_real_ext($file_extension);
	$dest_file = $file_real_path . $file_store_path . $file_real_name . $file_ext;

	if ($settings['max_file_size']) {
		$up_fileSingleSizeLimit = get_byte_value($settings['max_file_size']);
	} else {
		$up_fileSingleSizeLimit = get_byte_value('4g'); //default
	}

	if (!chk_extension_ok_h5($file_extension)) {
		echo json_encode(array('success' => false, 'msg' => $file_extension . lang('plugin/phpdisk_mini', 'file type not allow')));
		exit;
	}
	if ($file['size'] > $up_fileSingleSizeLimit) {
		echo json_encode(array('success' => false, 'msg' => lang('plugin/phpdisk_mini', 'your file too big') . get_size($up_fileSingleSizeLimit)));
		exit;
	}

	if (upload_file($file['tmp_name'], $dest_file)) {

		$ins = array(
			'file_name' => $file_name,
			'file_extension' => $file_extension,
			'file_key' => random(8),
			'file_description' => '',
			'file_store_path' => $file_store_path,
			'file_real_name' => $file_real_name,
			'file_size' => $file['size'],
			'file_time' => $timestamp,
			'in_share' => (int) $myset['upload_in_share'],
			'userid' => $uid,
			'folder_id' => $folder_id,
			'is_checked' => (int) $settings['share_to_check'] ? 0 : 1,
			'ip' => $onlineip,
		);
		DB::query("insert into phpdisk_mini_files set " . sql_array($ins) . "");
		$file_id = DB::insert_id();

		@unlink($file['tmp_name']);

		$a_downfile = $_G['siteurl'] . urr("plugin", "id=phpdisk_mini:view&file_id=$file_id");
		$ctn_str = lang('plugin/phpdisk_mini', 'file_name') . ': ' . $file['name'] . "\r\n" . lang('plugin/phpdisk_mini', 'file size') . ': ' . get_size($file['size']) . "\r\n" . lang('plugin/phpdisk_mini', 'file addr') . ': [url=' . $a_downfile . ']' . $a_downfile . "[/url]\r\n\r\n";
		$ctn_2 = str_replace(array('"', "'"), '_', $ctn_str);
		$ctn = str_replace(array('"', "'"), '_', str_ireplace("\r\n", '<br>', $ctn_str));
		//$rtn = 'true|' . $ctn . '|' . $ctn_2;
		$ctn = is_utf8() ? $ctn : iconv('gbk', 'utf-8', $ctn);
		$ctn_2 = is_utf8() ? $ctn_2 : iconv('gbk', 'utf-8', $ctn_2);

		echo json_encode(array('success' => true, 'dt' => array('ctn' => $ctn, 'ctn2' => $ctn_2, 'file_name' => $file['name'])));

	} else {
		$str = '<?php exit(); ?>' . $uid . "\t" . $action . "\t" . $file['name'] . "\t" . date('Y-m-d H:i:s') . LF;
		$error_log = PHPDISK_ROOT . 'system/upload_log.php';
		write_file($error_log, $str, 'ab');
		echo json_encode(array('success' => false, 'msg' => $file['name'] . lang('plugin/phpdisk_mini', 'upload failed')));
	}


	exit;


} else {
	die('[PHPDisk is running] No action');
}


?>