<?php

declare(strict_types=1);

/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link https://phpdoc.org
 */

namespace phpDocumentor\Descriptor\Tag;

use phpDocumentor\Descriptor\ArgumentDescriptor;
use phpDocumentor\Descriptor\Collection;
use phpDocumentor\Descriptor\TagDescriptor;

/**
 * @api
 * @package phpDocumentor\AST\Tags
 */
class MethodDescriptor extends TagDescriptor
{
    private string $methodName = '';

    /** @var Collection<ArgumentDescriptor> */
    private Collection $arguments;

    private ReturnDescriptor|null $response = null;

    private bool $static = false;

    private bool $hasReturnByReference = false;

    public function __construct(string $name)
    {
        parent::__construct($name);

        $this->arguments = Collection::fromClassString(ArgumentDescriptor::class);
    }

    public function setMethodName(string $methodName): void
    {
        $this->methodName = $methodName;
    }

    public function getMethodName(): string
    {
        return $this->methodName;
    }

    /** @param Collection<ArgumentDescriptor> $arguments */
    public function setArguments(Collection $arguments): void
    {
        $this->arguments = $arguments;
    }

    /** @return Collection<ArgumentDescriptor> */
    public function getArguments(): Collection
    {
        return $this->arguments;
    }

    public function setResponse(ReturnDescriptor|null $response): void
    {
        $this->response = $response;
    }

    public function getResponse(): ReturnDescriptor|null
    {
        return $this->response;
    }

    public function setStatic(bool $static): void
    {
        $this->static = $static;
    }

    public function isStatic(): bool
    {
        return $this->static;
    }

    public function setHasReturnByReference(bool $hasReturnByReference): void
    {
        $this->hasReturnByReference = $hasReturnByReference;
    }

    public function getHasReturnByReference(): bool
    {
        return $this->hasReturnByReference;
    }
}
