# php pack/unpack

## 什么是字节序

在不同的计算机体系结构中，对于数据(比特、字节、字)等的存储和传输机制有所不同，因而引发了计算机领域中一个潜在但是又很重要的问题，即通信双方交流的信息单元应该以什么样的顺序进行传送。
如果达不成一致的规则，计算机的通信与存储将会无法进行。目前在各种体系的计算机中通常采用的字节存储机制主要有两种：大端(Big-endian)和小端(Little-endian)。这里所说的大端和小端即是字节序。

### MSB和LSB

MSB 是Most Significant Bit/Byte的首字母缩写，通常译为最重要的位或最重要的字节。它通常用来表示在一个bit序列(如一个byte是8个bit组成的一个序列)或一个byte序列(如word是两个byte组成的一个序列)中对整个序列取值影响最大的那个bit/byte。

LSB 是Least Significant Bit/Byte的首字母缩写，通常译为最不重要的位或最不重要的字节。它通常用来表明在一个bit序列(如一个byte是8个bit组成的一个序列)或一个byte序列(如word是两个byte组成的一个序列)中对整个序列取值影响最小的那个bit/byte。

对于一个十六进制int类型整数 `0x12345678` 来说，`0x12` 就是MSB，`0x78` 就是LSB。
而对于`0x78`这个字节而言，它的二进制是 `01111000`，那么最左边的那个`0`就是MSB，最右边的那个`0`就是LSB。

### 大端序

大端序又叫 **网络字节序**。大端序规定高位字节在存储时放在低地址上，在传输时高位字节放在流的开始；低位字节在存储时放在高地址上，在传输时低位字节放在流的末尾。

### 小端序

小端序规定高位字节在存储时放在高地址上，在传输时高位字节放在流的末尾；低位字节在存储时放在低地址上，在传输时低位字节放在流的开始。

### 网络字节序

网络字节序是指大端序。TCP/IP都是采用网络字节序的方式，java也是使用大端序方式存储。

### 主机字节序

主机字节序代表本机的字节序。一般是小端序，但也有一些是大端序。

主机字节序用在协议描述中则是指小端序。

### 总结

字节序只针对于多字节类型的数据。

比如对于int类型整数`0x12345678`，它占有4个字节的存储空间，存储方式有大端`(0x12, 0x34, 0x56, 0x78)`和小端`(0x78, 0x56, 0x34, 0x12)`两种。
可以看到，在大端或小端的存储方式中，是以字节为单位的。所以对于单字节类型的数据，不存在字节序这个说法。

## pack 

```php
string pack ( string $format [, mixed $args [, mixed $... ]] )
```

```
a -- 将字符串空白以 NULL 字符填满
A -- 将字符串空白以 SPACE 字符 (空格) 填满
h -- 16进制字符串，低位在前以半字节为单位
H -- 16进制字符串，高位在前以半字节为单位
c -- 有符号字符
C -- 无符号字符
s -- 有符号短整数 (16位，主机字节序)
S -- 无符号短整数 (16位，主机字节序)
n -- 无符号短整数 (16位, 大端字节序)
v -- 无符号短整数 (16位, 小端字节序)
i -- 有符号整数 (依赖机器大小及字节序)
I -- 无符号整数 (依赖机器大小及字节序)
l -- 有符号长整数 (32位，主机字节序)
L -- 无符号长整数 (32位，主机字节序)
N -- 无符号长整数 (32位, 大端字节序)
V -- 无符号长整数 (32位, 小端字节序)
f -- 单精度浮点数 (依计算机的范围)
d -- 双精度浮点数 (依计算机的范围)
x -- 空字节
X -- 倒回一位
@ -- 填入 NULL 字符到绝对位置
```


## unpack 

```php
array unpack ( string $format , string $data )
```
