# PHP-PDFbox

PHP-PDFBox is a tiny library which acts as a wrapper facilitating the use of PDFBox [https://pdfbox.apache.org/](https://pdfbox.apache.org/) in PHP.

It provides a simple API for calling the pdfbox-app.jar. The library is currently restricted to functionality provided by PDFbox's command-line utilities. It currently supports PDFBox version 2.

PDFBox is published under the Apache License v2.0 and is described as "The Apache PDFBox® library is an open source Java tool for working with PDF documents."

## Installation

It is recommended to install PHP-PDFBox through
[Composer](http://getcomposer.org) :

```json
{
    "require": {
        "php-pdfbox/php-pdfbox": "^2.0"
    }
}
```
pdfbox-app.jar is included in the installation. You can/should verify the integrity of pdfbox-app.jar with the PGP signatures available at https://pdfbox.apache.org/download.html.

## Main API usage:

Basic usage can be done as follows:

```php
$file = new \Pdfbox\Processor\PdfFile(
    new Pdfbox(
        '/path/to/java',
        '/path/to/pdfbox-app.jar'
    );
);

// Convert pdf to text
echo $file->toText('test.pdf');
```
(Providing a Logger object is optional in v2.0.2+.)
To use with psr/log and a PSR-3 compliant logger, do something like:
```php
use Psr\Log\LoggerInterface;
use MyPSR3Logger;

class Foo
{
    private $logger;

    public function __construct(LoggerInterface $logger = null){
        $this->logger = $logger;
    }

    public function doPdfBox(){
        try {
            $file = new \Pdfbox\Processor\PdfFile(
                new Pdfbox(
                    '/path/to/java',
                    '/path/to/pdfbox-app.jar',
                    $this->logger;
                );
            );
            // Convert pdf to text
            echo $file->toText('test.pdf');
        } catch (Exception $e) {
            $this->logger->error($e->getMessage(), ['exception', $e->backtrace()]);
        }
    }
}
$myLogger = new MyPSR3Logger();
$foo = new Foo($myLogger);

```
See `examples/ConsoleLogger.php` for a standard PSR3 compliant logger class that can be be copied and adapted.

See `examples/*.php` for more examples.

## API Documentation

HTML Documentation generated by [phpDocumentor](https://phpdoc.org/) can be found in [`docs/api`](docs/api/index.html).

## License

PHP-Pdfbox is released under MIT License http://opensource.org/licenses/MIT

See LICENSE file for more information.
