# PyTorch Image Quality Manifesto

Our mission is to provide reliable and verified implementations of existing image quality assessment (IQA) metrics with readable, easy-to-understand, high-quality code. We value transparency, reproducibility, and accuracy in our implementations.

**Our goals are to:**
- Provide a comprehensive collection of state-of-the-art IQA metrics
- Verify the correctness of our implementations using standard datasets and metrics
- Ensure that our code is easy to read, understand, and use
- Maintain compatibility with the PyTorch ecosystem

We believe in the importance of maintaining the integrity of existing IQA metrics. Therefore, we do not modify existing metrics to boost their quality, even if these modifications are easy to implement. Instead, we focus on providing reliable and accurate implementations of the original metrics.

We encourage contributions from the community and strive to create a welcoming and inclusive environment for all. We welcome feedback, bug reports, and feature requests from users and contributors.

By using PyTorch Image Quality, you can trust that you are using high-quality, verified implementations of state-of-the-art IQA metrics.