/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij.aop.aspectj;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;
import se.expertsystem.intellij.PluginUtils;
import se.expertsystem.intellij.PostProcessCompiler;
import se.expertsystem.intellij.aop.aspectj.AspectFinder;
import se.expertsystem.intellij.aop.aspectj.AspectJProjectComponent;

public class AspectJWeaver
extends PostProcessCompiler {
    private static final Logger LOG = Logger.getInstance((String)AspectJWeaver.class.getName());
    private final AspectJProjectComponent projectComponent;

    public AspectJWeaver(AspectJProjectComponent projectComponent) {
        this.projectComponent = projectComponent;
    }

    public final FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext compileContext) {
        List items = this.getModuleTaggedProcessingItems(compileContext);
        LOG.debug("AspectJWeaver.getProcessingItems found " + items.size() + " items");
        return items.toArray(new FileProcessingCompiler.ProcessingItem[0]);
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext compileContext, FileProcessingCompiler.ProcessingItem[] processingItems) {
        compileContext.addMessage(CompilerMessageCategory.INFORMATION, "AspectJ: Weaving " + processingItems.length + " items(s)", null, -1, -1);
        LOG.info("AspectJ: Weaving " + processingItems.length + " item(s)...");
        Map filesPerModule = AspectJWeaver.sortItemsPerModule(processingItems);
        for (Map.Entry entry : filesPerModule.entrySet()) {
            Module module = (Module)entry.getKey();
            List files = (List)entry.getValue();
            this.weave(compileContext, module, files);
        }
        return processingItems;
    }

    private void weave(final CompileContext compileContext, final Module module, final List processingItems) {
        final ProgressIndicator progressIndicator = compileContext.getProgressIndicator();
        try {
            ActionRunner.runInsideReadAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                public void run() throws Exception {
                    LOG.debug("Searching for aspects in project");
                    BcelWorld world = AspectJWeaver.createWorld(module, compileContext);
                    world.setXnoInline(AspectJWeaver.this.projectComponent.isNoInline());
                    SortedMap aspectLocations = AspectJWeaver.this.projectComponent.getAspectLocations();
                    Set enabledAspects = AspectJWeaver.this.projectComponent.getEnabledAspects();
                    HashSet<String> disabledAspectLocations = new HashSet<String>();
                    for (Map.Entry entry : aspectLocations.entrySet()) {
                        String className = (String)entry.getKey();
                        String url = (String)entry.getValue();
                        if (enabledAspects.contains(className)) {
                            ReferenceType aspect = AspectFinder.readAspect(url, world);
                            if (aspect != null && aspect.isAspect()) {
                                world.getCrosscuttingMembersSet().addOrReplaceAspect((ResolvedType)aspect);
                                continue;
                            }
                            aspectLocations.remove(className);
                            continue;
                        }
                        disabledAspectLocations.add(url);
                    }
                    ArrayList<UnwovenClassFile> filesToWeave = new ArrayList<UnwovenClassFile>();
                    ArrayList<UnwovenClassFile> disabledAspectsToWeave = new ArrayList<UnwovenClassFile>();
                    Iterator iter = processingItems.iterator();
                    while (iter.hasNext()) {
                        File fileToWeave = VfsUtil.virtualToIoFile((VirtualFile)((FileProcessingCompiler.ProcessingItem)iter.next()).getFile());
                        byte[] bytes = FileUtil.readAsByteArray((File)fileToWeave);
                        UnwovenClassFile unwovenClassFile = new UnwovenClassFile(fileToWeave.getAbsolutePath(), bytes);
                        if (!disabledAspectLocations.contains(PluginUtils.toUrlString(fileToWeave))) {
                            filesToWeave.add(unwovenClassFile);
                            LOG.debug("Queue for weave: " + fileToWeave);
                            continue;
                        }
                        disabledAspectsToWeave.add(unwovenClassFile);
                        LOG.info("Aspect '" + fileToWeave + "' disabled, queued for separate weave");
                    }
                    BcelWeaver weaver = new BcelWeaver(world);
                    Map unwovenFiles = AspectJWeaver.addForWeaving(weaver, filesToWeave, compileContext);
                    int totalFiles = unwovenFiles.size();
                    LOG.debug("Weaving");
                    progressIndicator.setText2("AspectJ: Weaving module '" + module.getName() + "'");
                    progressIndicator.setIndeterminate(false);
                    WeaveRequestor weaveRequestor = new WeaveRequestor(unwovenFiles, aspectLocations, enabledAspects, compileContext, world, progressIndicator, totalFiles);
                    weaver.prepareForWeave();
                    weaver.weave((IClassFileProvider)new ClassFileProvider(weaveRequestor, filesToWeave));
                    if (!disabledAspectsToWeave.isEmpty()) {
                        world = AspectJWeaver.createWorld(module, compileContext);
                        weaver = new BcelWeaver(world);
                        totalFiles = disabledAspectsToWeave.size();
                        LOG.debug("Weaving disabled aspects: " + disabledAspectsToWeave);
                        progressIndicator.setText2("AspectJ: Weaving disabled aspects in module '" + module.getName() + "'");
                        progressIndicator.setIndeterminate(false);
                        unwovenFiles = AspectJWeaver.addForWeaving(weaver, disabledAspectsToWeave, compileContext);
                        weaveRequestor = new WeaveRequestor(unwovenFiles, aspectLocations, enabledAspects, compileContext, world, progressIndicator, totalFiles);
                        weaver.prepareForWeave();
                        weaver.weave((IClassFileProvider)new ClassFileProvider(weaveRequestor, disabledAspectsToWeave));
                    }
                    progressIndicator.setIndeterminate(true);
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            compileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
        }
    }

    private static BcelWorld createWorld(final Module module, final CompileContext compileContext) {
        BcelWorld world = new BcelWorld();
        world.setBehaveInJava5Way(PluginUtils.isJava5(module));
        AspectJWeaver.addClasspath(world, module);
        Module[] modules = PluginUtils.getProjectModules(module.getProject());
        for (int i = 0; i < modules.length; ++i) {
            List outputPaths = PluginUtils.getModuleOutputs(modules[i]);
            Iterator iter = outputPaths.iterator();
            while (iter.hasNext()) {
                world.addPath(((File)iter.next()).getAbsolutePath());
            }
        }
        world.setMessageHandler(new IMessageHandler(){
            private Set ignored = new HashSet();

            public boolean handleMessage(IMessage iMessage) throws AbortException {
                if (!this.isIgnoring(iMessage.getKind()) && (iMessage.isError() || iMessage.isWarning())) {
                    ISourceLocation sourceLocation;
                    CompilerMessageCategory category = iMessage.isError() ? CompilerMessageCategory.ERROR : CompilerMessageCategory.WARNING;
                    LOG.debug("iMessage.getMessage(): " + iMessage.getMessage());
                    LOG.debug("iMessage.getDetails(): " + iMessage.getDetails());
                    if (iMessage.isError()) {
                        LOG.debug(new Throwable("Stacktrace"));
                    }
                    if ((sourceLocation = iMessage.getSourceLocation()) != null) {
                        VirtualFile sourceFile = null;
                        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                        VirtualFile[] sourceRoots = rootManager.getSourceRoots();
                        for (int i = 0; i < sourceRoots.length; ++i) {
                            VirtualFile fileInSource = VfsUtil.findRelativeFile((String)sourceLocation.getSourceFile().getPath(), (VirtualFile)sourceRoots[i]);
                            if (fileInSource == null || !fileInSource.exists()) continue;
                            sourceFile = fileInSource;
                            break;
                        }
                        LOG.debug("sourceFile: " + sourceFile);
                        compileContext.addMessage(category, iMessage.getMessage(), sourceFile != null ? sourceFile.getUrl() : null, sourceLocation.getLine(), sourceLocation.getColumn());
                    } else {
                        compileContext.addMessage(category, iMessage.getMessage(), null, -1, -1);
                    }
                }
                return true;
            }

            public boolean isIgnoring(IMessage.Kind kind) {
                return this.ignored.contains(kind);
            }

            public void dontIgnore(IMessage.Kind kind) {
                this.ignored.remove(kind);
            }

            public void ignore(IMessage.Kind kind) {
                this.ignored.add(kind);
            }
        });
        return world;
    }

    private static void addClasspath(BcelWorld world, Module module) {
        try {
            List classpath = PluginUtils.getModuleClasspath(module, true);
            for (File cpEntry : classpath) {
                world.addPath(cpEntry.getAbsolutePath());
                LOG.debug(cpEntry + " added to weaver");
            }
        }
        catch (IOException ioex) {
            LOG.error((Throwable)ioex);
        }
    }

    private static Map addForWeaving(BcelWeaver weaver, List filesToWeave, CompileContext compileContext) {
        HashMap<String, UnwovenClassFile> unwovenFiles = new HashMap<String, UnwovenClassFile>();
        for (UnwovenClassFile unwovenClassFile : filesToWeave) {
            weaver.addClassFile(unwovenClassFile, false);
            if (unwovenFiles.put(unwovenClassFile.getClassName(), unwovenClassFile) == null) continue;
            LOG.error("Class already inserted " + unwovenClassFile.getClassName());
            compileContext.addMessage(CompilerMessageCategory.WARNING, "Cannot weave multiple classes with same name: " + unwovenClassFile.getClassName(), null, -1, -1);
        }
        return unwovenFiles;
    }

    public String getDescription() {
        return "AspectJ weaver";
    }

    private static class WeaveRequestor
    implements IWeaveRequestor {
        private final Map unwovenFiles;
        private final Map aspectLocations;
        private final Set enabledAspects;
        private final CompileContext compileContext;
        private final BcelWorld world;
        private final ProgressIndicator progressIndicator;
        private final int totalFiles;
        private int count = 0;

        public WeaveRequestor(Map unwovenFiles, Map aspectLocations, Set enabledAspects, CompileContext compileContext, BcelWorld world, ProgressIndicator progressIndicator, int totalFiles) {
            this.progressIndicator = progressIndicator;
            this.totalFiles = totalFiles;
            this.unwovenFiles = unwovenFiles;
            this.compileContext = compileContext;
            this.aspectLocations = aspectLocations;
            this.enabledAspects = enabledAspects;
            this.world = world;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void acceptResult(IUnwovenClassFile result) {
            PluginUtils.setProgress(this.progressIndicator, this.totalFiles, ++this.count);
            String className = result.getClassName();
            LOG.debug("Done weaving " + className + "; writing to disk.");
            this.progressIndicator.setText(className);
            UnwovenClassFile unwovenFile = (UnwovenClassFile)this.unwovenFiles.get(className);
            if (unwovenFile == null) {
                int dollarIndex = className.indexOf(36);
                if (dollarIndex == -1) throw new RuntimeException("Unwoven file not found for class " + className);
                String parentClassName = className.substring(0, dollarIndex);
                String parentFileName = ((UnwovenClassFile)this.unwovenFiles.get(parentClassName)).getFilename();
                String fileName = parentFileName.substring(0, parentFileName.indexOf(".class")) + '$' + className.substring(dollarIndex + 1) + ".class";
                this.writeResult(fileName, result);
                return;
            } else {
                JavaClass jc;
                ReferenceType type;
                if (result == unwovenFile) return;
                this.writeResult(unwovenFile.getFilename(), result);
                if (this.aspectLocations.containsKey(className) || !(type = AspectFinder.getResolvedType(jc = Utility.makeJavaClass((String)result.getFilename(), (byte[])result.getBytes()), this.world)).isAspect()) return;
                LOG.debug("Found new aspect: " + type.getName());
                this.aspectLocations.put(type.getName(), PluginUtils.toUrlString(new File(unwovenFile.getFilename())));
                this.enabledAspects.add(type.getName());
            }
        }

        private void writeResult(String fileName, IUnwovenClassFile result) {
            LOG.debug(result.getClassName() + " was woven, saving to " + fileName);
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                fos.write(result.getBytes());
                fos.flush();
                fos.close();
            }
            catch (IOException ioex) {
                LOG.error((Throwable)ioex);
                this.compileContext.addMessage(CompilerMessageCategory.ERROR, ioex.getMessage(), fileName, -1, -1);
            }
        }

        public void processingReweavableState() {
            this.progressIndicator.setText2("AspectJ: Processing reweavable state");
        }

        public void addingTypeMungers() {
            this.progressIndicator.setText2("AspectJ: Adding type munger");
        }

        public void weavingAspects() {
            this.progressIndicator.setText2("AspectJ: Weaving aspects");
        }

        public void weavingClasses() {
            this.progressIndicator.setText2("AspectJ: Weaving classes");
        }

        public void weaveCompleted() {
            this.progressIndicator.setText2("AspectJ: Done");
        }
    }

    private static class ClassFileProvider
    implements IClassFileProvider {
        private final WeaveRequestor weaveRequestor;
        private final List filesToWeave;

        public ClassFileProvider(WeaveRequestor weaveRequestor, List filesToWeave) {
            this.weaveRequestor = weaveRequestor;
            this.filesToWeave = filesToWeave;
        }

        public boolean isApplyAtAspectJMungersOnly() {
            return false;
        }

        public Iterator getClassFileIterator() {
            return this.filesToWeave.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return this.weaveRequestor;
        }
    }
}

