/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij.aop.aspectj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdom.Element;
import se.expertsystem.intellij.PostProcessProjectComponent;
import se.expertsystem.intellij.aop.aspectj.AspectJConfiguration;
import se.expertsystem.intellij.aop.aspectj.AspectJWeaver;

public class AspectJProjectComponent
extends PostProcessProjectComponent
implements Configurable {
    private static final Logger LOG = Logger.getInstance((String)AspectJProjectComponent.class.getName());
    private AspectJConfiguration configuration;
    private SortedMap aspectLocations = new TreeMap();
    private Set enabledAspects = new HashSet();
    private boolean noInline;

    public AspectJProjectComponent(Project project) {
        this.project = project;
        this.postCompiler = new AspectJWeaver(this);
    }

    public String getComponentName() {
        return AspectJProjectComponent.class.getName();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.changeTo(false);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Override
    public void changeTo(boolean activate) {
        super.changeTo(activate);
        if (this.isActivated && this.aspectLocations.isEmpty()) {
            Messages.showInfoMessage((String)"If aspects are not compiled by this project,\nyou must search for them in the project settings.", (String)"Search for aspects");
        }
    }

    @Override
    protected void configLoaded(boolean activated) {
        super.changeTo(activated);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        SortedMap knownAspects = this.getAspectLocations();
        List aspectElems = element.getChildren("aspect");
        for (Element aspectElem : aspectElems) {
            String className = aspectElem.getAttributeValue("className");
            knownAspects.put(className, aspectElem.getText());
            if (!"true".equals(aspectElem.getAttributeValue("enabled"))) continue;
            this.enabledAspects.add(className);
        }
        LOG.info("Aspects found in project workspace: " + knownAspects);
        LOG.info("Aspects enabled in project workspace: " + this.enabledAspects);
        super.readExternal(element);
        this.noInline = JDOMExternalizer.readBoolean((Element)element, (String)"noInline");
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.noInline) {
            JDOMExternalizer.write((Element)element, (String)"noInline", (boolean)this.noInline);
        }
        SortedMap knownAspects = this.getAspectLocations();
        LOG.info("Writing known aspects to project workspace: " + knownAspects);
        for (Map.Entry entry : knownAspects.entrySet()) {
            Element aspectElem = new Element("aspect");
            String className = (String)entry.getKey();
            aspectElem.setAttribute("className", className);
            aspectElem.setText((String)entry.getValue());
            if (this.enabledAspects.contains(className)) {
                aspectElem.setAttribute("enabled", "true");
            }
            element.addContent(aspectElem);
        }
    }

    public SortedMap getAspectLocations() {
        return this.aspectLocations;
    }

    public Set getEnabledAspects() {
        return this.enabledAspects;
    }

    public boolean isNoInline() {
        return this.noInline;
    }

    public String getDisplayName() {
        return "AspectJ weaver";
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("logo.gif"));
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.configuration = new AspectJConfiguration(this.project, this.isActivated, this.getAspectLocations(), this.enabledAspects);
        return this.configuration;
    }

    public boolean isModified() {
        return this.isActivated != this.configuration.isEnabled() || !this.aspectLocations.equals(this.configuration.getAspectLocations()) || !((Object)this.enabledAspects).equals(this.configuration.getEnabledAspects());
    }

    public void apply() {
        LOG.info("New configuration applied");
        super.changeTo(this.configuration.isEnabled());
        this.aspectLocations.clear();
        this.aspectLocations.putAll(this.configuration.getAspectLocations());
        this.enabledAspects.clear();
        this.enabledAspects.addAll(this.configuration.getEnabledAspects());
        LOG.debug("  aspectLocations: " + this.aspectLocations);
        LOG.debug("  enabledAspects: " + this.enabledAspects);
    }

    public void reset() {
        LOG.debug("Config reset");
    }

    public void disposeUIResources() {
        this.configuration = null;
    }
}

