/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij.aop.aspectj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.expertsystem.intellij.PluginUtils;
import se.expertsystem.intellij.aop.aspectj.AspectFinder;

public class AspectJConfiguration
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)AspectJConfiguration.class.getName());
    private boolean enabled;
    private final SortedMap aspectLocations = new TreeMap();
    private final Set enabledAspects = new HashSet();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public SortedMap getAspectLocations() {
        return this.aspectLocations;
    }

    public Set getEnabledAspects() {
        return this.enabledAspects;
    }

    public AspectJConfiguration(final Project project, boolean enabled, Map aspLocs, Set enbAsps) {
        this.enabled = enabled;
        this.aspectLocations.putAll(aspLocs);
        this.enabledAspects.addAll(enbAsps);
        this.setLayout(new BorderLayout());
        JCheckBox enabledBox = new JCheckBox("Enable weaving");
        enabledBox.setSelected(enabled);
        enabledBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AspectJConfiguration.this.enabled = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        this.add((Component)enabledBox, "North");
        JPanel middlePane = new JPanel();
        middlePane.setLayout(new BorderLayout());
        middlePane.setBorder(BorderFactory.createTitledBorder("Aspects to weave"));
        final JList<String> list = new JList<String>(this.getAspectArray());
        list.setCellRenderer(new CheckboxListCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = list.locationToIndex(e.getPoint());
                String className = AspectJConfiguration.this.getClassName(index);
                if (AspectJConfiguration.this.enabledAspects.contains(className)) {
                    AspectJConfiguration.this.enabledAspects.remove(className);
                } else {
                    AspectJConfiguration.this.enabledAspects.add(className);
                }
                Rectangle rect = list.getCellBounds(index, index);
                list.repaint(rect);
            }
        });
        middlePane.add((Component)new JScrollPane(list), "Center");
        this.add((Component)middlePane, "Center");
        JButton searchButton = new JButton("Search for aspects...");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.showInfoMessage((String)"Note! Aspects must be compiled before they are found.", (String)"Apsects must be compiled");
                PluginUtils.runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        SortedMap foundAspects = AspectFinder.findAspectLocations(project);
                        HashSet newAspects = new HashSet(foundAspects.keySet());
                        newAspects.removeAll(AspectJConfiguration.this.aspectLocations.keySet());
                        AspectJConfiguration.this.aspectLocations.clear();
                        AspectJConfiguration.this.aspectLocations.putAll(foundAspects);
                        AspectJConfiguration.this.enabledAspects.addAll(newAspects);
                        list.setListData(AspectJConfiguration.this.getAspectArray());
                        list.repaint();
                    }
                }, "Searching for aspects", true, project);
                LOG.debug("Aspects after search: " + AspectJConfiguration.this.aspectLocations);
            }
        });
        this.add((Component)searchButton, "South");
    }

    private String[] getAspectArray() {
        return this.aspectLocations.keySet().toArray(new String[0]);
    }

    private String getClassName(int row) {
        return this.getAspectArray()[row];
    }

    private class CheckboxListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private CheckboxListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String className = value.toString();
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setText(className);
            this.setSelected(AspectJConfiguration.this.enabledAspects.contains(className));
            return this;
        }
    }
}

