/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij.aop.aspectj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWorld;
import se.expertsystem.intellij.PluginUtils;

public abstract class AspectFinder {
    private static final Logger LOG = Logger.getInstance((String)AspectFinder.class.getName());

    static SortedMap findAspectLocations(Project project) {
        TreeMap aspectLocations = new TreeMap();
        Map foundAspects = AspectFinder.findAspects(project);
        for (ReferenceType aspectX : foundAspects.keySet()) {
            aspectLocations.put(aspectX.getName(), foundAspects.get(aspectX));
        }
        return aspectLocations;
    }

    private static Map findAspects(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        try {
            BcelWorld world = new BcelWorld();
            world.setBehaveInJava5Way(PluginUtils.isJava5(project));
            return AspectFinder.findAspects(modules, world);
        }
        catch (IOException ioex) {
            LOG.error((Throwable)ioex);
            return new HashMap();
        }
    }

    private static Map findAspects(Module[] modules, BcelWorld world) throws IOException {
        HashMap allAspects = new HashMap();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        HashSet filesToProcess = new HashSet();
        for (int i = 0; i < modules.length; ++i) {
            Module module = modules[i];
            List classpath = PluginUtils.getModuleClasspath(module, false);
            for (File file : classpath) {
                filesToProcess.add(file);
                world.addPath(file.getAbsolutePath());
            }
        }
        int noOfFiles = filesToProcess.size();
        int count = 0;
        progressIndicator.setIndeterminate(false);
        progressIndicator.setText("Searching for aspects");
        Iterator iter = filesToProcess.iterator();
        while (iter.hasNext()) {
            if (progressIndicator.isCanceled()) {
                return allAspects;
            }
            PluginUtils.setProgress(progressIndicator, noOfFiles, ++count);
            File file = (File)iter.next();
            progressIndicator.setText2("Looking for aspects in '" + file.getName() + "'");
            LOG.debug("Looking for aspects in " + file);
            allAspects.putAll(AspectFinder.findAspects(file, world));
        }
        progressIndicator.setIndeterminate(true);
        return allAspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map findAspects(File file, BcelWorld world) throws IOException {
        HashMap<ReferenceType, String> foundAspects;
        block15: {
            foundAspects = new HashMap<ReferenceType, String>();
            if (!file.exists()) break block15;
            if (file.isDirectory()) {
                File[] classFiles = FileUtil.listFiles((File)file, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".class");
                    }
                });
                for (int i = 0; i < classFiles.length; ++i) {
                    File classFile = classFiles[i];
                    try {
                        LOG.debug(classFile.getAbsolutePath());
                        ReferenceType type = AspectFinder.readAspect(classFile, world);
                        if (!type.isAspect() || type.isAbstract()) continue;
                        foundAspects.put(type, PluginUtils.toUrlString(classFile));
                        continue;
                    }
                    catch (ClassFormatException cfex) {
                        LOG.info((Throwable)cfex);
                    }
                }
            } else {
                ZipInputStream zis = null;
                try {
                    zis = new ZipInputStream(new FileInputStream(file));
                    while (true) {
                        ZipEntry zipEntry;
                        if ((zipEntry = zis.getNextEntry()) == null) {
                        }
                        if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class") || zipEntry.getName().equals("org/aspectj/lib/pointcuts/Pointcuts.class") || zipEntry.getName().equals("org/aspectj/lib/tracing/TraceJoinPointsBase.class")) continue;
                        LOG.debug(file.getAbsolutePath() + '/' + zipEntry.getName());
                        ReferenceType type = AspectFinder.resolveType(FileUtil.readAsByteArray((InputStream)zis), zipEntry.getName(), world);
                        zis.closeEntry();
                        if (!type.isAspect() || type.isAbstract()) continue;
                        String fileUrl = PluginUtils.toUrlString(file);
                        String jarUrl = VirtualFileManager.constructUrl((String)JarFileSystem.PROTOCOL, (String)fileUrl) + JarFileSystem.JAR_SEPARATOR + zipEntry.getName();
                        foundAspects.put(type, jarUrl);
                    }
                }
                catch (IOException ioex) {
                    LOG.error((Throwable)ioex);
                }
                catch (ClassFormatException cfex) {
                    LOG.info((Throwable)cfex);
                }
                finally {
                    if (zis != null) {
                        zis.close();
                    }
                }
            }
        }
        return foundAspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ReferenceType readAspect(String url, BcelWorld world) throws IOException {
        LOG.debug("protocol of " + url + ": " + VirtualFileManager.extractProtocol((String)url));
        if (JarFileSystem.PROTOCOL.equals(VirtualFileManager.extractProtocol((String)url))) {
            String path = url.substring((JarFileSystem.PROTOCOL + "://").length());
            int delimIndex = path.indexOf(JarFileSystem.JAR_SEPARATOR);
            String jarPath = path.substring(0, delimIndex);
            String entryName = path.substring(delimIndex + JarFileSystem.JAR_SEPARATOR.length());
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new FileInputStream(PluginUtils.toFile(jarPath)));
                while (true) {
                    ZipEntry zipEntry;
                    if ((zipEntry = zis.getNextEntry()) == null) {
                        ReferenceType referenceType = null;
                        return referenceType;
                    }
                    if (zipEntry.getName().equals(entryName)) {
                        ReferenceType type = AspectFinder.resolveType(FileUtil.readAsByteArray((InputStream)zis), zipEntry.getName(), world);
                        zis.closeEntry();
                        ReferenceType referenceType = type;
                        return referenceType;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException ioex) {
                LOG.error((Throwable)ioex);
                return null;
            }
            catch (ClassFormatException cfex) {
                LOG.info((Throwable)cfex);
                return null;
            }
            finally {
                if (zis != null) {
                    zis.close();
                }
            }
        }
        File classFile = PluginUtils.toFile(new URL(url));
        if (!classFile.exists()) return null;
        try {
            return AspectFinder.readAspect(classFile, world);
        }
        catch (ClassFormatException cfex) {
            LOG.info((Throwable)cfex);
            return null;
        }
    }

    private static ReferenceType readAspect(File classFile, BcelWorld world) throws IOException, ClassFormatException {
        byte[] bytes = FileUtil.readAsByteArray((File)classFile);
        String name = classFile.getAbsolutePath();
        ReferenceType type = AspectFinder.resolveType(bytes, name, world);
        return type;
    }

    private static ReferenceType resolveType(byte[] bytes, String name, BcelWorld world) throws IOException, ClassFormatException {
        ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), name);
        JavaClass jc = parser.parse();
        return AspectFinder.getResolvedType(jc, world);
    }

    static ReferenceType getResolvedType(JavaClass jc, BcelWorld world) {
        ReferenceType nameTypeX;
        String signature = UnresolvedType.forName((String)jc.getClassName()).getSignature();
        if (jc.isGeneric() && world.isInJava5Mode()) {
            nameTypeX = ReferenceType.fromTypeX((UnresolvedType)UnresolvedType.forRawTypeName((String)jc.getClassName()), (World)world);
            BcelObjectType ret = world.buildBcelDelegate(nameTypeX, jc, false, true);
            ReferenceType genericRefType = new ReferenceType(UnresolvedType.forGenericTypeSignature((String)signature, (String)ret.getDeclaredGenericSignature()), (World)world);
            nameTypeX.setDelegate((ReferenceTypeDelegate)ret);
            genericRefType.setDelegate((ReferenceTypeDelegate)ret);
            nameTypeX.setGenericType(genericRefType);
        } else {
            nameTypeX = new ReferenceType(signature, (World)world);
            world.buildBcelDelegate(nameTypeX, jc, false, true);
        }
        return nameTypeX;
    }
}

