/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Chunk;
import java.lang.reflect.Method;
import java.util.List;
import se.expertsystem.intellij.PostProcessCompiler;
import se.expertsystem.intellij.RecentlyCompiledSink;

public class WrappingCompiler
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)WrappingCompiler.class.getName());
    private final TranslatingCompiler realCompiler;

    public TranslatingCompiler getRealCompiler() {
        return this.realCompiler;
    }

    public WrappingCompiler(TranslatingCompiler realCompiler) {
        this.realCompiler = realCompiler;
    }

    public boolean isCompilableFile(VirtualFile virtualFile, CompileContext compileContext) {
        return this.realCompiler.isCompilableFile(virtualFile, compileContext);
    }

    public void compile(CompileContext compileContext, Chunk<Module> moduleChunk, VirtualFile[] virtualFiles, TranslatingCompiler.OutputSink sink) {
        RecentlyCompiledSink wrappedSink = new RecentlyCompiledSink(sink);
        this.realCompiler.compile(compileContext, moduleChunk, virtualFiles, (TranslatingCompiler.OutputSink)wrappedSink);
        List<RecentlyCompiledSink.CompiledItem> recentlyCompiled = PostProcessCompiler.getRecentlyCompiled(compileContext);
        recentlyCompiled.addAll(wrappedSink.getCompiledItems());
    }

    public String getDescription() {
        return "Wrapped " + this.realCompiler.getDescription();
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        try {
            Method m = this.realCompiler.getClass().getMethod("validateConfiguration", CompileScope.class);
            return (Boolean)m.invoke((Object)this.realCompiler, compileScope);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return false;
        }
    }

    public boolean validateConfiguration() {
        try {
            Method m = this.realCompiler.getClass().getMethod("validateConfiguration", null);
            return (Boolean)m.invoke((Object)this.realCompiler, null);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return false;
        }
    }
}

