/*
 * Decompiled with CFR 0.152.
 */
package se.expertsystem.intellij;

import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecentlyCompiledSink
implements TranslatingCompiler.OutputSink {
    private final TranslatingCompiler.OutputSink delegate;
    private final List<CompiledItem> compiledItems = new ArrayList<CompiledItem>();

    public RecentlyCompiledSink(TranslatingCompiler.OutputSink delegate) {
        this.delegate = delegate;
    }

    public void add(String outputRoot, Collection<TranslatingCompiler.OutputItem> items, VirtualFile[] filesToRecompile) {
        if (items != null && outputRoot != null) {
            for (TranslatingCompiler.OutputItem item : items) {
                if (item.getOutputPath() == null) continue;
                this.compiledItems.add(new CompiledItem(outputRoot, item.getOutputPath(), item.getSourceFile()));
            }
        }
        if (this.delegate != null) {
            this.delegate.add(outputRoot, items, filesToRecompile);
        }
    }

    public List<CompiledItem> getCompiledItems() {
        return this.compiledItems;
    }

    public static class CompiledItem {
        private final String outputRoot;
        private final String outputPath;
        private final VirtualFile sourceFile;

        private CompiledItem(String outputRoot, String outputPath, VirtualFile sourceFile) {
            this.outputRoot = outputRoot;
            this.outputPath = outputPath;
            this.sourceFile = sourceFile;
        }

        public String getOutputRoot() {
            return this.outputRoot;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public VirtualFile getSourceFile() {
            return this.sourceFile;
        }
    }
}

